/*
 * Decompiled with CFR 0.152.
 */
package com.sun.kvem.netmon.bluetooth;

import com.sun.kvem.environment.Debug;
import com.sun.kvem.netmon.SyntaxErrorException;
import java.io.DataInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Vector;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class DataElement {
    private static final Debug debug = Debug.create((Class)DataElement.class);
    private int type;
    private long longValue;
    private boolean booleanValue;
    private byte[] byteArrayValue;
    private String stringValue;
    private Vector vectorValue;
    public static final int NULL = 0;
    public static final int U_INT_1 = 8;
    public static final int U_INT_2 = 9;
    public static final int U_INT_4 = 10;
    public static final int U_INT_8 = 11;
    public static final int U_INT_16 = 12;
    public static final int INT_1 = 16;
    public static final int INT_2 = 17;
    public static final int INT_4 = 18;
    public static final int INT_8 = 19;
    public static final int INT_16 = 20;
    public static final int URL = 64;
    public static final int UUID = 24;
    public static final int BOOL = 40;
    public static final int STRING = 32;
    public static final int DATSEQ = 48;
    public static final int DATALT = 56;
    public static final int NETMON_STR = -1;
    public static final int NETMON_SEQ = -2;

    public DataElement() {
    }

    public DataElement(DataInputStream dataInputStream) throws IOException {
        this.type = dataInputStream.readInt();
        int n = 16;
        block0 : switch (this.type) {
            case 8: 
            case 9: 
            case 10: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                this.longValue = dataInputStream.readLong();
                break;
            }
            case 40: {
                this.booleanValue = dataInputStream.readBoolean();
                break;
            }
            case 11: {
                n = 8;
            }
            case 12: 
            case 20: {
                this.byteArrayValue = new byte[n];
                dataInputStream.readFully(this.byteArrayValue);
                break;
            }
            case -1: 
            case 0: {
                break;
            }
            case 24: 
            case 32: 
            case 64: {
                this.stringValue = dataInputStream.readUTF();
                break;
            }
            case 48: 
            case 56: {
                this.vectorValue = new Vector();
                while (true) {
                    DataElement dataElement = new DataElement(dataInputStream);
                    if (dataElement.type == -1) break block0;
                    this.vectorValue.addElement(dataElement);
                }
            }
        }
    }

    public String toString() {
        switch (this.type) {
            case 0: {
                return "NULL";
            }
            case -2: 
            case -1: {
                return this.stringValue;
            }
            case 32: {
                return "STRING: " + this.stringValue;
            }
            case 24: {
                return "UUID: " + this.uuidToString(this.stringValue);
            }
            case 64: {
                return "URL: " + this.stringValue;
            }
            case 40: {
                return this.booleanValue ? "True" : "False";
            }
            case 8: 
            case 9: 
            case 10: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                return "INTEGER: " + Long.toString(this.longValue) + " (" + this.getStringType() + ")";
            }
            case 11: 
            case 12: 
            case 20: {
                StringBuffer stringBuffer = new StringBuffer("INTEGER: 0x");
                for (int i = 0; i < this.byteArrayValue.length; ++i) {
                    int n = this.byteArrayValue[i] & 0xFF;
                    if (n < 16) {
                        stringBuffer.append("0");
                    }
                    stringBuffer.append(Long.toHexString(this.longValue));
                }
                return stringBuffer.toString();
            }
            case 48: {
                return "DATSEQ";
            }
            case 56: {
                return "DATALT";
            }
        }
        return "Unknown type: 0x" + Integer.toHexString(this.type);
    }

    private String getStringType() {
        switch (this.type) {
            case 8: {
                return "U_INT_1";
            }
            case 9: {
                return "U_INT_2";
            }
            case 10: {
                return "U_INT_4";
            }
            case 16: {
                return "INT_1";
            }
            case 17: {
                return "INT_2";
            }
            case 18: {
                return "INT_4";
            }
            case 19: {
                return "INT_8";
            }
        }
        return null;
    }

    private String uuidToString(String string) {
        int n;
        int n2 = string.length();
        if (n2 < 25) {
            return string;
        }
        String string2 = string.substring(n2 - 24, n2);
        if (!string2.equals("00001000800000805F9B34FB")) {
            return string;
        }
        String string3 = string.substring(0, n2 - 24);
        try {
            n = Integer.parseInt(string3, 16);
        }
        catch (NumberFormatException numberFormatException) {
            return string;
        }
        switch (n) {
            case 1: {
                return "SDP (0x0001)";
            }
            case 3: {
                return "RFCOMM (0x0003)";
            }
            case 8: {
                return "OBEX (0x0008)";
            }
            case 12: {
                return "HTTP (0x000C)";
            }
            case 256: {
                return "L2CAP (0x0100)";
            }
            case 15: {
                return "BNEP (0x000F)";
            }
            case 4353: {
                return "Serial Port (0x1101)";
            }
            case 4096: {
                return "ServiceDiscoveryServerServiceClassID (0x1000)";
            }
            case 4097: {
                return "BrowseGroupDescriptorServiceClassID (0x1001)";
            }
            case 4098: {
                return "PublicBrowseGroup (0x1002)";
            }
            case 4357: {
                return "OBEX Object Push Profile (0x1105)";
            }
            case 4358: {
                return "OBEX File Transfer Profile (0x1106)";
            }
            case 4373: {
                return "Personal Area Networking User (0x1115)";
            }
            case 4374: {
                return "Network Access Point (0x1116)";
            }
            case 4375: {
                return "Group Network (0x1117)";
            }
        }
        return string;
    }

    public Vector getVector() {
        return this.vectorValue;
    }

    public int getDataType() {
        return this.type;
    }

    public void writeXML(String string, FileOutputStream fileOutputStream) throws IOException {
        fileOutputStream.write((string + "<DataElement>\n").getBytes("UTF-8"));
        fileOutputStream.write((string + "\t<String>" + this + "</String>\n").getBytes("UTF-8"));
        if (this.vectorValue != null) {
            for (int i = 0; i < this.vectorValue.size(); ++i) {
                DataElement dataElement = (DataElement)this.vectorValue.elementAt(i);
                dataElement.writeXML(string + "\t", fileOutputStream);
            }
        }
        fileOutputStream.write((string + "</DataElement>\n").getBytes("UTF-8"));
    }

    public void readXML(Node node) throws SyntaxErrorException {
        NodeList nodeList = node.getChildNodes();
        int n = nodeList.getLength();
        this.type = -1;
        for (int i = 0; i < n; ++i) {
            Node node2 = nodeList.item(i);
            if (!node2.hasChildNodes()) continue;
            String string = node2.getNodeName();
            String string2 = node2.getFirstChild().getNodeValue();
            try {
                if (string.equals("String")) {
                    this.stringValue = string2;
                    continue;
                }
                if (string.equals("DataElement")) {
                    this.type = -2;
                    if (this.vectorValue == null) {
                        this.vectorValue = new Vector();
                    }
                    DataElement dataElement = new DataElement();
                    dataElement.readXML(node2);
                    this.vectorValue.addElement(dataElement);
                    continue;
                }
                debug.println(2, "Unknown key: {0}", (Object)string);
                continue;
            }
            catch (NumberFormatException numberFormatException) {
                throw new SyntaxErrorException(numberFormatException);
            }
        }
    }
}

