/*
 * Decompiled with CFR 0.152.
 */
package com.sun.kvem.netmon.bluetooth;

import com.sun.kvem.environment.Debug;
import com.sun.kvem.netmon.MsgFilterCriteria;
import com.sun.kvem.netmon.SyntaxErrorException;
import com.sun.kvem.netmon.bluetooth.BluetoothHandler;
import com.sun.kvem.netmon.bluetooth.Notifier;
import com.sun.kvem.netmon.bluetooth.ServiceRecord;
import com.sun.kvem.netmon.stream.StreamChunk;
import com.sun.kvem.netmon.util.Writer;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Date;
import java.util.Enumeration;
import java.util.Properties;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class BluetoothNotifier
extends BluetoothHandler
implements Notifier {
    private static final Debug debug = Debug.create((Class)BluetoothNotifier.class);
    private ServiceRecord rec;

    public StreamChunk newChunk() {
        return null;
    }

    public void updateServiceRecord(ServiceRecord serviceRecord) {
        this.rec = serviceRecord;
    }

    public ServiceRecord getServiceRecord() {
        return this.rec;
    }

    public void setEndDateAndComplete() {
        this.endDate = new Date();
        this.setComplete(true);
    }

    public void writeXML(String string, FileOutputStream fileOutputStream) throws IOException {
        fileOutputStream.write((string + "<" + this.getClassSuffix() + ">\n").getBytes("UTF-8"));
        fileOutputStream.write((string + "\t<StartDate>" + this.startDate.getTime() + "</StartDate>\n").getBytes("UTF-8"));
        fileOutputStream.write((string + "\t<EndDate>" + (this.endDate == null ? -1L : this.endDate.getTime()) + "</EndDate>\n").getBytes("UTF-8"));
        fileOutputStream.write((string + "\t<Complete>" + this.complete + "</Complete>\n").getBytes("UTF-8"));
        fileOutputStream.write((string + "\t<Properties>\n").getBytes("UTF-8"));
        Enumeration<Object> enumeration = this.props.keys();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            String string3 = this.props.getProperty(string2);
            fileOutputStream.write((string + "\t\t<" + string2 + ">" + Writer.encodeXML(string3) + "</" + string2 + ">\n").getBytes("UTF-8"));
        }
        fileOutputStream.write((string + "\t</Properties>\n").getBytes("UTF-8"));
        this.rec.writeXML(string + "\t", fileOutputStream);
        fileOutputStream.write((string + "</" + this.getClassSuffix() + ">\n").getBytes("UTF-8"));
    }

    public void readXML(Node node) throws SyntaxErrorException {
        NodeList nodeList = node.getChildNodes();
        int n = nodeList.getLength();
        for (int i = 0; i < n; ++i) {
            Node node2 = nodeList.item(i);
            if (!node2.hasChildNodes()) continue;
            String string = node2.getNodeName();
            String string2 = node2.getFirstChild().getNodeValue();
            try {
                if (string.equals("StartDate")) {
                    this.startDate = new Date(Long.parseLong(string2));
                    continue;
                }
                if (string.equals("EndDate")) {
                    this.endDate = new Date(Long.parseLong(string2));
                    continue;
                }
                if (string.equals("Complete")) {
                    this.complete = Boolean.valueOf(string2);
                    continue;
                }
                if (string.equals("Properties")) {
                    this.readProperties(node2);
                    continue;
                }
                if (string.equals("ServiceRecord")) {
                    this.rec = new ServiceRecord();
                    this.rec.readXML(node2);
                    continue;
                }
                debug.println(2, "Unknown key: {0}", (Object)string);
                continue;
            }
            catch (NumberFormatException numberFormatException) {
                throw new SyntaxErrorException(numberFormatException);
            }
        }
    }

    public boolean complyWith(MsgFilterCriteria msgFilterCriteria) {
        Properties properties = msgFilterCriteria.getProperties();
        String string = properties.getProperty("URL", "");
        return this.getURL().toLowerCase().indexOf(string.toLowerCase()) >= 0;
    }

    public String getType() {
        return "notif" + super.getType();
    }
}

