/*
 * Decompiled with CFR 0.152.
 */
package com.sun.kvem.netmon.bluetooth;

import com.sun.kvem.environment.Debug;
import com.sun.kvem.netmon.MsgListener;
import com.sun.kvem.netmon.bluetooth.BluetoothMsgProducer;
import java.util.Vector;

public final class BluetoothMsgReceiver {
    private static final Debug debug = Debug.create((Class)BluetoothMsgReceiver.class);
    private static Vector listeners = new Vector();
    private static Vector producers = new Vector();

    public static int notifierConnect(String string, long l) {
        debug.println(2, "BluetoothMsgReceiver.notifierConnect");
        BluetoothMsgProducer bluetoothMsgProducer = new BluetoothMsgProducer(string, l);
        producers.add(bluetoothMsgProducer);
        bluetoothMsgProducer.newNotifier();
        return producers.size() - 1;
    }

    public static void updateServiceRecord(int n, byte[] byArray) {
        debug.println(2, "BluetoothMsgReceiver.updateServiceRecord");
        BluetoothMsgProducer bluetoothMsgProducer = (BluetoothMsgProducer)producers.get(n);
        bluetoothMsgProducer.updateServiceRecord(byArray);
    }

    public static void notifierDisconnect(int n) {
        debug.println(2, "BluetoothMsgReceiver.notifierDisconnect");
        BluetoothMsgProducer bluetoothMsgProducer = (BluetoothMsgProducer)producers.get(n);
        bluetoothMsgProducer.close();
    }

    public static int connect(String string, long l) {
        debug.println(2, "BluetoothMsgReceiver.connect");
        BluetoothMsgProducer bluetoothMsgProducer = new BluetoothMsgProducer(string, l);
        bluetoothMsgProducer.addMsgListener(listeners);
        producers.add(bluetoothMsgProducer);
        return producers.size() - 1;
    }

    public static void disconnect(int n) {
        debug.println(2, "BluetoothMsgReceiver.disconnect");
        BluetoothMsgProducer bluetoothMsgProducer = (BluetoothMsgProducer)producers.get(n);
        bluetoothMsgProducer.close();
    }

    public static void read(int n, byte[] byArray) {
        debug.println(2, "BluetoothMsgReceiver.read");
        BluetoothMsgProducer bluetoothMsgProducer = (BluetoothMsgProducer)producers.get(n);
        bluetoothMsgProducer.addData(1, new String(byArray));
    }

    public static void write(int n, byte[] byArray) {
        debug.println(2, "BluetoothMsgReceiver.write");
        BluetoothMsgProducer bluetoothMsgProducer = (BluetoothMsgProducer)producers.get(n);
        bluetoothMsgProducer.addData(0, new String(byArray));
    }

    public static void addMsgListener(MsgListener msgListener) {
        debug.println(2, "BluetoothMsgReceiver.addMsgListener");
        listeners.addElement(msgListener);
    }

    public static void removeMsgListener(MsgListener msgListener) {
        debug.println(2, "BluetoothMsgReceiver.removeMsgListener");
        listeners.removeElement(msgListener);
    }

    public static Vector getListeners() {
        return listeners;
    }
}

