/*
 * Decompiled with CFR 0.152.
 */
package com.sun.kvem.netmon.bluetooth;

import com.sun.kvem.environment.Debug;
import com.sun.kvem.netmon.bluetooth.BluetoothMsgReceiver;
import com.sun.kvem.netmon.bluetooth.BluetoothNotifier;
import com.sun.kvem.netmon.bluetooth.BluetoothStreamMessage;
import com.sun.kvem.netmon.bluetooth.Notifier;
import com.sun.kvem.netmon.bluetooth.ServiceRecord;
import com.sun.kvem.netmon.obex.ObexMsgReceiver;
import com.sun.kvem.netmon.stream.StreamMessage;
import com.sun.kvem.netmon.stream.StreamMsgProducer;
import java.io.IOException;

public final class BluetoothMsgProducer
extends StreamMsgProducer {
    private static final Debug debug = Debug.create((Class)BluetoothMsgProducer.class);
    private Notifier notifier;
    private boolean isBTGOEP;
    private String url;
    private long groupid;

    public BluetoothMsgProducer(String string, long l) {
        super(string, l);
        debug.println(2, "BluetoothMsgProducer.constructor");
        if (string.startsWith("btgoep:")) {
            this.isBTGOEP = true;
        }
        this.url = string;
        this.groupid = l;
    }

    public void newNotifier() {
        if (this.isBTGOEP) {
            this.addMsgListener(ObexMsgReceiver.getListeners());
            debug.println(2, "BluetoothMsgProducer.newNotifier: isGoep");
            this.notifier = new com.sun.kvem.netmon.obex.BluetoothNotifier();
            this.notifier.setProperties(this.props);
            this.notifier.setGroup(this.groupid);
            this.post(this.notifier);
            this.notifier.fireMsgUpdateEvent(this.notifier, true);
        } else {
            this.addMsgListener(BluetoothMsgReceiver.getListeners());
            debug.println(2, "BluetoothMsgProducer.newNotifier: notGoep");
            this.notifier = new BluetoothNotifier();
            this.notifier.setProperties(this.props);
            this.notifier.setGroup(this.groupid);
            this.post(this.notifier);
            this.notifier.fireMsgUpdateEvent(this.notifier, true);
        }
    }

    public void updateServiceRecord(byte[] byArray) {
        debug.println(2, "BluetoothMsgProducer.updateServiceRecord");
        try {
            ServiceRecord serviceRecord = ServiceRecord.parseServiceRecord(byArray);
            this.notifier.updateServiceRecord(serviceRecord);
            this.notifier.fireMsgUpdateEvent(this.notifier, true);
        }
        catch (IOException iOException) {
            debug.exception(2, (Throwable)iOException);
        }
    }

    public void close() {
        debug.println(2, "BluetoothMsgProducer.close");
        super.close();
        if (this.notifier != null) {
            this.notifier.setEndDateAndComplete();
        }
    }

    public StreamMessage newMessage() {
        debug.println(2, "BluetoothMsgProducer.newMessage");
        return new BluetoothStreamMessage(this.props);
    }
}

