/*
 * Decompiled with CFR 0.152.
 */
package com.sun.kvem.mma;

import com.sun.kvem.environment.Debug;
import com.sun.kvem.midp.MIDP;
import java.io.DataInputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Hashtable;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.FloatControl;
import javax.sound.sampled.SourceDataLine;

public class WavBridge {
    private static Debug debug = Debug.create((Class)WavBridge.class);
    private static float log10tobaseE = (float)Math.log(10.0);
    private static int CHUNK_SIZE = 32000;
    private static Hashtable playersHash = new Hashtable(2);
    static /* synthetic */ Class class$javax$sound$sampled$SourceDataLine;

    public static int realize(int n) {
        WavPlayer wavPlayer = new WavPlayer(n);
        if (wavPlayer.port > 0) {
            playersHash.put(new Integer(n), wavPlayer);
        }
        return wavPlayer.port;
    }

    public static boolean open(int n, int n2, int n3, int n4, int n5) {
        boolean bl = false;
        Object v = playersHash.get(new Integer(n));
        if (v != null) {
            WavPlayer wavPlayer = (WavPlayer)v;
            bl = wavPlayer.open(n2, n3, n4, n5);
        }
        return bl;
    }

    private static void remove(int n) {
        Object v = playersHash.get(new Integer(n));
        if (v != null) {
            playersHash.remove(v);
            v = null;
        }
    }

    public static String getTempDir() {
        return System.getProperty("java.io.tmpdir");
    }

    public static int common(int n, int n2, int n3) {
        Object v = playersHash.get(new Integer(n));
        if (v == null) {
            return 0;
        }
        WavPlayer wavPlayer = (WavPlayer)v;
        return wavPlayer.common(n2, n3);
    }

    public static void delete(int n) {
        Object v = playersHash.get(new Integer(n));
        if (v != null) {
            WavPlayer wavPlayer = (WavPlayer)v;
            wavPlayer.delete();
        }
    }

    public static boolean close(int n) {
        Object v = playersHash.get(new Integer(n));
        if (v == null) {
            return false;
        }
        WavPlayer wavPlayer = (WavPlayer)v;
        return wavPlayer.close();
    }

    public static boolean closeRecording(int n) {
        Object v = playersHash.get(new Integer(n));
        if (v == null) {
            return false;
        }
        WavPlayer wavPlayer = (WavPlayer)v;
        return wavPlayer.closeRecording();
    }

    public static void drain(int n) {
        Object v = playersHash.get(new Integer(n));
        if (v != null) {
            WavPlayer wavPlayer = (WavPlayer)v;
            wavPlayer.drain();
        }
    }

    public static void flush(int n) {
        Object v = playersHash.get(new Integer(n));
        if (v != null) {
            WavPlayer wavPlayer = (WavPlayer)v;
            wavPlayer.flush();
        }
    }

    public static void pause(int n) {
        Object v = playersHash.get(new Integer(n));
        if (v != null) {
            WavPlayer wavPlayer = (WavPlayer)v;
            wavPlayer.pause();
        }
    }

    public static void resume(int n) {
        Object v = playersHash.get(new Integer(n));
        if (v != null) {
            WavPlayer wavPlayer = (WavPlayer)v;
            wavPlayer.resumePlayback();
        }
    }

    public static void record(int n, int n2) {
        Object v = playersHash.get(new Integer(n));
        if (v != null) {
            WavPlayer wavPlayer = (WavPlayer)v;
            wavPlayer.record(n2);
        }
    }

    public static int volumecontrol(int n, int n2) {
        Object v = playersHash.get(new Integer(n));
        if (v == null) {
            return 0;
        }
        WavPlayer wavPlayer = (WavPlayer)v;
        return wavPlayer.volumecontrol(n2);
    }

    public static boolean setFileName(int n, String string) {
        Object v = playersHash.get(new Integer(n));
        if (v == null) {
            return false;
        }
        WavPlayer wavPlayer = (WavPlayer)v;
        return wavPlayer.setFileName(string);
    }

    public static boolean seek(int n, int n2) {
        Object v = playersHash.get(new Integer(n));
        if (v == null) {
            return false;
        }
        WavPlayer wavPlayer = (WavPlayer)v;
        return wavPlayer.seek(n2);
    }

    public static byte[] read(int n, int n2, int n3) {
        Object v = playersHash.get(new Integer(n));
        if (v == null) {
            return null;
        }
        WavPlayer wavPlayer = (WavPlayer)v;
        return wavPlayer.read(n2, n3);
    }

    static /* synthetic */ int access$1500() {
        return CHUNK_SIZE;
    }

    static final class WavPlayer
    extends Thread {
        private AudioFormat audioFormat;
        private SourceDataLine line;
        private float minVolDB;
        private float maxVolDB;
        private float minVol;
        private float maxVol;
        private float slope;
        private FloatControl gainControl;
        private File file;
        private RandomAccessFile raf;
        private byte[] localBuffer = new byte[WavBridge.access$1500()];
        private boolean opened = false;
        private boolean closed = false;
        private ServerSocket serverSocket = null;
        private Socket clientSocket = null;
        private DataInputStream in;
        private OutputStream out;
        private int port;
        private boolean recordError = false;
        private int recordRequested = 0;
        private int bufferSize;
        private int instance;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        WavPlayer(int n) {
            this.instance = n;
            try {
                this.serverSocket = new ServerSocket(0);
                this.port = this.serverSocket.getLocalPort();
            }
            catch (Exception exception) {
            }
            finally {
                if (this.port <= 0) {
                    this.cleanup();
                }
            }
        }

        private boolean open(int n, int n2, int n3, int n4) {
            if (this.opened) {
                return true;
            }
            this.bufferSize = n4;
            boolean bl = n2 == 16;
            this.audioFormat = new AudioFormat(n, n2, n3, bl, false);
            DataLine.Info info = new DataLine.Info(class$javax$sound$sampled$SourceDataLine == null ? (class$javax$sound$sampled$SourceDataLine = WavBridge.class$("javax.sound.sampled.SourceDataLine")) : class$javax$sound$sampled$SourceDataLine, this.audioFormat);
            try {
                this.line = (SourceDataLine)AudioSystem.getLine(info);
                this.line.open(this.audioFormat);
                this.gainControl = (FloatControl)this.line.getControl(FloatControl.Type.MASTER_GAIN);
                if (this.gainControl != null) {
                    this.minVolDB = this.gainControl.getMinimum();
                    this.maxVolDB = this.gainControl.getMaximum();
                    this.minVol = (float)Math.pow(10.0, this.minVolDB / 20.0f);
                    this.maxVol = (float)Math.pow(10.0, this.maxVolDB / 20.0f);
                    this.slope = (this.maxVol - this.minVol) / 100.0f;
                }
                this.startline();
            }
            catch (Exception exception) {
                this.cleanup();
                System.err.println(exception.getMessage());
                return false;
            }
            this.opened = true;
            this.start();
            return true;
        }

        public void run() {
            try {
                this.clientSocket = this.serverSocket.accept();
                this.in = new DataInputStream(this.clientSocket.getInputStream());
                this.out = this.clientSocket.getOutputStream();
                byte[] byArray = new byte[this.bufferSize];
                while (!this.closed) {
                    int n = this.in.readInt();
                    this.in.readFully(byArray, 0, n);
                    int n2 = this.write(byArray, 0, n);
                    this.out.write(n2);
                }
                try {
                    if (this.out != null) {
                        this.out.close();
                        this.out = null;
                    }
                }
                catch (Exception exception) {}
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        private void cleanup() {
        }

        private int common(int n, int n2) {
            switch (n) {
                case 6: {
                    if (this.line != null) {
                        return this.line.getFramePosition();
                    }
                    return 0;
                }
            }
            return 0;
        }

        private void startline() {
            if (this.line != null) {
                this.line.start();
            }
        }

        private void delete() {
            if (this.file != null && !this.file.delete()) {
                System.err.println("Unable to delete file " + this.file.getName());
            }
            this.raf = null;
            this.file = null;
        }

        private boolean closeRecording() {
            try {
                if (this.raf != null) {
                    this.raf.close();
                }
            }
            catch (Exception exception) {
                return false;
            }
            this.raf = null;
            this.file = null;
            return true;
        }

        private boolean close() {
            this.closeRecording();
            boolean bl = true;
            if (this.line != null) {
                this.line.close();
                this.line = null;
            }
            try {
                if (this.in != null) {
                    this.in.close();
                    this.in = null;
                }
            }
            catch (Exception exception) {
                bl = false;
            }
            this.closed = true;
            this.opened = false;
            try {
                if (this.clientSocket != null) {
                    this.clientSocket.close();
                    this.clientSocket = null;
                }
            }
            catch (Exception exception) {
                bl = false;
            }
            try {
                if (this.serverSocket != null) {
                    this.serverSocket.close();
                    this.serverSocket = null;
                }
            }
            catch (Exception exception) {
                bl = false;
            }
            this.audioFormat = null;
            this.gainControl = null;
            this.localBuffer = null;
            WavBridge.remove(this.instance);
            if (MIDP.IS_SUNOS) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {
                    debug.exception(1, (Throwable)interruptedException);
                    debug;
                    Debug.warning((String)interruptedException.toString());
                }
            }
            return bl;
        }

        private void drain() {
            if (this.line != null) {
                this.line.drain();
            }
        }

        private void flush() {
            if (this.line != null) {
                this.line.flush();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void pause() {
            if (this.line != null) {
                this.line.stop();
                WavPlayer wavPlayer = this;
                synchronized (wavPlayer) {
                    try {
                        this.wait(100L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
        }

        private void resumePlayback() {
            this.startline();
        }

        private int volumecontrol(int n) {
            if (this.gainControl != null) {
                if (n < 0) {
                    int n2 = (int)((Math.pow(10.0, this.gainControl.getValue() / 20.0f) - (double)this.minVol) / (double)this.slope);
                    return n2;
                }
                float f = (float)(20.0 * Math.log(this.minVol + this.slope * (float)n) / (double)log10tobaseE);
                this.gainControl.setValue(f);
                return n;
            }
            return 0;
        }

        private boolean setFileName(String string) {
            try {
                this.file = new File(string);
                this.raf = new RandomAccessFile(this.file, "rw");
                this.raf.setLength(0L);
                return true;
            }
            catch (Exception exception) {
                debug.exception(1, (Throwable)exception);
                debug;
                Debug.warning((String)exception.toString());
                return false;
            }
        }

        private boolean seek(int n) {
            try {
                this.raf.seek(n);
                return true;
            }
            catch (IOException iOException) {
                debug.exception(1, (Throwable)iOException);
                debug;
                Debug.warning((String)iOException.toString());
                return false;
            }
        }

        private byte[] read(int n, int n2) {
            if (this.raf != null) {
                try {
                    while (true) {
                        int n3;
                        if ((n3 = this.raf.read(this.localBuffer, n, n2)) == n2) {
                            return this.localBuffer;
                        }
                        if (n3 == -1) {
                            return null;
                        }
                        n += n3;
                        n2 -= n3;
                    }
                }
                catch (IOException iOException) {
                    debug.exception(1, (Throwable)iOException);
                    debug;
                    Debug.warning((String)iOException.toString());
                    return null;
                }
            }
            return null;
        }

        private void record(int n) {
            this.recordRequested = n;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private int write(byte[] byArray, int n, int n2) {
            int n3 = 0;
            int n4 = this.recordRequested;
            try {
                boolean bl = !this.recordError && n4 > 0;
                int n5 = n2;
                while (n5 > 0) {
                    int n6 = n4 != 2 ? this.line.write(byArray, n, n5) : n5;
                    if (n6 > 0) {
                        if (bl && this.raf != null) {
                            try {
                                this.raf.write(byArray, n, n6);
                            }
                            catch (IOException iOException) {
                                System.err.println("WavBridge: IOException recording. call close");
                                n3 -= 2;
                                this.recordError = true;
                                this.closeRecording();
                            }
                        }
                        n5 -= n6;
                        n += n6;
                        continue;
                    }
                    if (this.line.isActive()) continue;
                    int n7 = 0;
                    return n7;
                }
            }
            catch (Exception exception) {
                debug.exception(1, (Throwable)exception);
                debug;
                Debug.warning((String)exception.toString());
                n3 = -1;
            }
            finally {
                n4 = 0;
            }
            return n3;
        }
    }
}

