/*
 * Decompiled with CFR 0.152.
 */
package com.sun.kvem.mma;

import com.sun.kvem.Screen;
import com.sun.kvem.midp.GraphicsBridge;
import com.sun.kvem.midp.MIDP;
import com.sun.kvem.midp.WidgetManager;
import com.sun.kvem.mma.DataSource;
import com.sun.kvem.mma.LCDUIRenderer;
import com.sun.kvem.mma.VideoBridge2;
import com.sun.kvem.mma.VideoScreenBridge;
import com.sun.media.content.video.mpeg.MpxPlayer;
import java.awt.Rectangle;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.net.Socket;
import javax.media.Clock;
import javax.media.ControllerErrorEvent;
import javax.media.ControllerEvent;
import javax.media.ControllerListener;
import javax.media.Duration;
import javax.media.EndOfMediaEvent;
import javax.media.GainControl;
import javax.media.MediaLocator;
import javax.media.Player;
import javax.media.Renderer;
import javax.media.ResourceUnavailableEvent;
import javax.media.StopAtTimeEvent;
import javax.media.Time;
import javax.media.control.FramePositioningControl;
import javax.media.control.TrackControl;
import javax.media.format.VideoFormat;
import javax.media.protocol.ContentDescriptor;
import javax.media.renderer.VideoRenderer;

final class VideoPlayer
implements ControllerListener {
    public static final int timeOut = 30000;
    static WidgetManager widgetManager = WidgetManager.getInstance();
    private boolean failed;
    private Player player;
    private DataSource source;
    private boolean visible = false;
    private String widget;
    private boolean isCurrent = true;
    private LCDUIRenderer renderer;
    private SettableTime time;
    private SettableTime framePosTime;
    private GainControl gainControl;
    private FramePositioningControl framePositionControl;
    private int videoWidth = -1;
    private int videoHeight;
    private String contentType;
    private long contentLength;
    private int bufferSize;
    private boolean eom = false;
    private Socket clientSocket = null;
    private InputStream in;
    private DataOutputStream eventOut;
    private int instance;
    private int currentRate = 100000;
    static final int END_OF_MEDIA = -1;
    static final int STOPPED_AT_TIME = -2;
    static final int ERROR = -3;
    static final Time timeZero = new Time(0L);
    private static Class managerC;
    private String extension = null;
    private long durationNano = -1L;
    private boolean fullScreen = false;
    private static Rectangle displayBounds;
    private WidgetManager.Listener l;
    private boolean menuUp = false;

    VideoPlayer(int n, String string, long l, int n2) {
        this.instance = n;
        this.contentType = string;
        this.contentLength = l;
        this.bufferSize = n2;
        this.l = new WidgetManager.Listener(){

            public void widgetChanged(String string, String string2, String string3, String string4) {
                if (VideoPlayer.this.renderer != null && VideoPlayer.this.widget != null) {
                    if (VideoPlayer.this.widget.startsWith(":")) {
                        VideoPlayer.this.isCurrent = string2.indexOf(VideoPlayer.this.widget) != -1;
                    } else {
                        VideoPlayer.this.isCurrent = string2.equals(VideoPlayer.this.widget);
                    }
                    VideoPlayer.this.renderer.setEnabled(VideoPlayer.this.isCurrent, VideoPlayer.this.fullScreen);
                }
            }
        };
        WidgetManager.getInstance().addListener(this.l);
    }

    boolean init() {
        try {
            this.clientSocket = VideoBridge2.serverSocket.accept();
            this.in = this.clientSocket.getInputStream();
            if (this.contentType.equals("video/mpeg")) {
                this.extension = "mpeg";
            } else if (!this.contentType.equals("content/unknown")) {
                try {
                    managerC = Class.forName("javax.media.Manager");
                    Class<?> clazz = Class.forName("com.sun.media.MimeManager");
                    Method method = clazz.getMethod("getDefaultExtension", String.class);
                    Object object = method.invoke(null, this.contentType);
                    this.extension = (String)object;
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            this.source = new DataSource(this.in, this.contentType, this.contentLength, this.bufferSize, this.extension);
            this.eventOut = new DataOutputStream(this.clientSocket.getOutputStream());
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }

    boolean realize() {
        try {
            Method method;
            this.source.waitUntilDataAvailable();
            this.renderer = new LCDUIRenderer();
            if (this.contentType.equals("video/mpeg")) {
                this.player = new MpxPlayer(this.source.getFileName(), (VideoRenderer)this.renderer);
                this.player.setSource((javax.media.protocol.DataSource)this.source);
            } else if (this.extension != null) {
                try {
                    method = managerC.getMethod("getVersion", null);
                    Object object = method.invoke(null, null);
                    Class<?> clazz = Class.forName("javax.media.Processor");
                    Method method2 = clazz.getMethod("configure", null);
                    Method method3 = clazz.getMethod("getTrackControls", null);
                    Method method4 = clazz.getMethod("setContentDescriptor", ContentDescriptor.class);
                    MediaLocator mediaLocator = new MediaLocator("file:" + this.source.getFileName());
                    Method method5 = managerC.getMethod("createProcessor", MediaLocator.class);
                    Object object2 = method5.invoke(null, mediaLocator);
                    method2.invoke(object2, null);
                    Thread.currentThread();
                    Thread.sleep(3000L);
                    object = method3.invoke(object2, null);
                    if (object != null) {
                        TrackControl[] trackControlArray = (TrackControl[])object;
                        int n = trackControlArray.length;
                        for (int i = 0; i < n; ++i) {
                            if (!(trackControlArray[i].getFormat() instanceof VideoFormat)) continue;
                            trackControlArray[i].setRenderer((Renderer)this.renderer);
                        }
                    }
                    method4.invoke(object2, new Object[]{null});
                    this.player = (Player)object2;
                }
                catch (Throwable throwable) {
                    return false;
                }
            }
            this.player.addControllerListener((ControllerListener)this);
            this.failed = false;
            this.player.realize();
            for (int i = 30000; this.player.getState() != 300 && !this.failed && i > 0; i -= 100) {
                Thread.currentThread();
                Thread.sleep(100L);
            }
            if (this.player.getState() != 300) {
                return false;
            }
            this.renderer.setBounds(VideoBridge2.faceBounds);
            this.renderer.setPlayer(this.player);
            this.videoWidth = this.renderer.getSourceWidth();
            this.videoHeight = this.renderer.getSourceHeight();
            this.time = new SettableTime(0L);
            this.gainControl = this.player.getGainControl();
            method = this.player.getControl("javax.media.control.FramePositioningControl");
            if (method instanceof FramePositioningControl) {
                this.framePositionControl = (FramePositioningControl)method;
            }
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }

    boolean prefetch() {
        if (this.player == null) {
            return false;
        }
        try {
            this.failed = false;
            this.player.prefetch();
            for (int i = 30000; this.player.getState() != 500 && !this.failed && i > 0; i -= 100) {
                Thread.currentThread();
                Thread.sleep(100L);
            }
            return this.player.getState() == 500;
        }
        catch (Exception exception) {
            return false;
        }
    }

    boolean start() {
        if (this.player == null) {
            return false;
        }
        if (this.eom) {
            this.eom = false;
            this.player.setMediaTime(timeZero);
        }
        this.player.start();
        return true;
    }

    boolean stop() {
        if (this.player == null) {
            return false;
        }
        this.player.stop();
        return true;
    }

    boolean deallocate() {
        if (this.player == null) {
            return false;
        }
        this.player.stop();
        this.player.setMediaTime(timeZero);
        return true;
    }

    boolean close() {
        boolean bl = true;
        if (this.l != null) {
            WidgetManager.getInstance().removeListener(this.l);
        }
        if (this.player != null) {
            this.player.removeControllerListener((ControllerListener)this);
            if (this.player.getState() == 600) {
                this.player.stop();
            }
            if (this.player.getState() == 500) {
                this.player.deallocate();
            }
            this.player.close();
            this.player = null;
        } else {
            bl = false;
        }
        if (this.renderer != null) {
            this.renderer.close();
            this.renderer = null;
        }
        if (this.source != null) {
            this.source.close();
            this.source = null;
        }
        this.time = null;
        this.framePosTime = null;
        this.gainControl = null;
        this.framePositionControl = null;
        try {
            if (this.in != null) {
                this.in.close();
                this.in = null;
            }
        }
        catch (IOException iOException) {
            bl = false;
        }
        try {
            if (this.clientSocket != null) {
                this.clientSocket.close();
                this.clientSocket = null;
            }
        }
        catch (IOException iOException) {
            bl = false;
        }
        try {
            if (this.eventOut != null) {
                this.eventOut.close();
                this.eventOut = null;
            }
        }
        catch (IOException iOException) {
            bl = false;
        }
        VideoBridge2.remove(this.instance);
        if (this.widget != null) {
            VideoBridge2.widgetHash.remove(this.widget);
        }
        return bl;
    }

    long setMediaTime(long l) {
        if (this.player == null) {
            return -1L;
        }
        this.time.set(l);
        this.player.setMediaTime((Time)this.time);
        return this.getMediaTime();
    }

    long getMediaTime() {
        if (this.player == null) {
            return 0L;
        }
        Time time = this.player.getMediaTime();
        if (time != Time.TIME_UNKNOWN) {
            long l = time.getNanoseconds();
            if (l > this.durationNano && this.durationNano != -1L) {
                l = this.durationNano;
            }
            return l;
        }
        return -1L;
    }

    long getDuration() {
        if (this.player == null) {
            return -1L;
        }
        if (this.durationNano < 0L) {
            Time time = this.player.getDuration();
            if (time == Duration.DURATION_UNBOUNDED || time == Duration.DURATION_UNKNOWN) {
                return -1L;
            }
            this.durationNano = time.getNanoseconds();
        }
        return this.durationNano;
    }

    public void controllerUpdate(ControllerEvent controllerEvent) {
        if (this.eventOut == null) {
            return;
        }
        try {
            if (controllerEvent instanceof ResourceUnavailableEvent) {
                this.failed = true;
            } else if (controllerEvent instanceof EndOfMediaEvent) {
                this.eom = true;
                this.eventOut.writeInt(-1);
                int n = (int)((double)this.getMediaTime() / 1000000.0);
                this.eventOut.writeLong((long)n * 1000L);
            } else if (controllerEvent instanceof StopAtTimeEvent) {
                this.eventOut.writeInt(-2);
                this.eventOut.writeLong(((StopAtTimeEvent)controllerEvent).getMediaTime().getNanoseconds() / 1000L);
            } else if (controllerEvent instanceof ControllerErrorEvent) {
                this.eventOut.writeInt(-3);
                this.eventOut.writeLong(0L);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    void setMute(boolean bl) {
        if (this.gainControl != null) {
            this.gainControl.setMute(bl);
        }
    }

    boolean isMuted() {
        if (this.gainControl != null) {
            return this.gainControl.getMute();
        }
        return false;
    }

    int setLevel(int n) {
        if (this.gainControl != null) {
            return (int)(this.gainControl.setLevel((float)n / 100.0f) * 100.0f);
        }
        return 0;
    }

    int getLevel() {
        if (this.gainControl != null) {
            return (int)(this.gainControl.getLevel() * 100.0f);
        }
        return 0;
    }

    int getRate() {
        return this.currentRate;
    }

    int setRate(int n) {
        if (this.player != null) {
            float f = (float)n / 100000.0f;
            float f2 = this.player.setRate(f);
            this.currentRate = n == 100000 ? n : (int)(f2 * 100000.0f);
        }
        return this.currentRate;
    }

    void setStopTime(long l) {
        if (this.player != null) {
            if (l != Long.MAX_VALUE) {
                if ((MIDP.IS_LINUX || MIDP.IS_SUNOS) && l < 1000000L) {
                    l = 1000000L;
                }
                this.player.setStopTime(new Time(l * 1000L));
            } else {
                this.player.setStopTime(Clock.RESET);
            }
        }
    }

    int getStopTimeMilliSec() {
        Time time;
        long l;
        if (this.player != null && (l = (time = this.player.getStopTime()).getNanoseconds()) != Clock.RESET.getNanoseconds()) {
            return (int)(l / 1000000L);
        }
        return -1;
    }

    void showMenu() {
        this.menuUp = true;
        if (this.renderer != null) {
            this.renderer.setEnabled(false, this.fullScreen);
        }
    }

    void initDisplayMode(int n, String string) {
        this.widget = string;
        if (this.renderer == null) {
            return;
        }
        if (VideoScreenBridge.matchesCurrentWidget(this.widget)) {
            this.renderer.setEnabled(true, this.fullScreen);
        }
    }

    int getSourceWidth() {
        return this.videoWidth;
    }

    int getSourceHeight() {
        return this.videoHeight;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int setBounds(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        boolean bl;
        boolean bl2 = n7 == VideoPlayer.displayBounds.width && n8 == GraphicsBridge.screenHeight && n5 == 0 && n6 == 0;
        boolean bl3 = bl = bl2 != this.fullScreen || this.menuUp;
        if (bl) {
            this.menuUp = false;
            if (!bl2 && this.fullScreen) {
                Screen screen = GraphicsBridge.screen;
                synchronized (screen) {
                    GraphicsBridge.getClippedGraphics(0, null).clearRect(0, 0, VideoBridge2.faceBounds.width, VideoBridge2.faceBounds.height);
                }
            }
            GraphicsBridge.grabFullScreen(bl2);
        }
        this.fullScreen = bl2;
        if (this.renderer != null) {
            this.renderer.setBounds(n, n2, n3, n4, n5, n6, n7, n8);
        }
        return 1;
    }

    void setVisible(boolean bl) {
        this.visible = bl;
        if (!bl) {
            this.menuUp = true;
        }
        if (this.renderer != null) {
            this.renderer.setVisible(bl, this.fullScreen);
        }
    }

    int[] getRGBSnapshot() {
        if (this.renderer != null) {
            return this.renderer.getRGB();
        }
        return null;
    }

    int seek(int n) {
        if (this.framePositionControl != null) {
            return this.framePositionControl.seek(n);
        }
        return -1;
    }

    int skip(int n) {
        if (this.framePositionControl != null) {
            return this.framePositionControl.skip(n);
        }
        return 0;
    }

    int mapFrameToTime(int n) {
        if (this.framePositionControl != null) {
            Time time = this.framePositionControl.mapFrameToTime(n);
            return time != null && time != FramePositioningControl.TIME_UNKNOWN ? (int)(time.getNanoseconds() / 1000000L) : -1;
        }
        return -1;
    }

    int mapTimeToFrame(long l) {
        if (this.framePositionControl != null) {
            if (this.framePosTime != null) {
                this.framePosTime.set(l * 1000L);
            } else {
                this.framePosTime = new SettableTime(l * 1000L);
            }
            int n = this.framePositionControl.mapTimeToFrame((Time)this.framePosTime);
            return n != Integer.MAX_VALUE ? n : -1;
        }
        return -1;
    }

    static {
        displayBounds = VideoBridge2.displayBounds;
    }

    class SettableTime
    extends Time {
        SettableTime(long l) {
            super(l);
        }

        void set(long l) {
            this.nanoseconds = l;
        }
    }
}

