/*
 * Decompiled with CFR 0.152.
 */
package com.sun.kvem.mma;

import com.sun.kvem.Screen;
import com.sun.kvem.midp.GraphicsBridge;
import com.sun.kvem.mma.LCDUIRenderer;
import com.sun.kvem.mma.VideoPlayer;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.net.ServerSocket;
import java.util.Hashtable;

public class VideoBridge2 {
    static Screen screen;
    static Rectangle faceBounds;
    static Rectangle displayBounds;
    private static Hashtable playersHash;
    static Hashtable widgetHash;
    static ServerSocket serverSocket;
    static int port;

    public static int getPort() {
        return port;
    }

    public static int open(int n, String string, long l, int n2) {
        if (port > 0) {
            VideoPlayer videoPlayer = new VideoPlayer(n, string, l, n2);
            playersHash.put(new Integer(n), videoPlayer);
        }
        return port;
    }

    static void remove(int n) {
        Integer n2 = new Integer(n);
        Object v = playersHash.get(n2);
        if (v != null) {
            Object v2 = playersHash.remove(n2);
            v = null;
        }
    }

    public static boolean init(int n) {
        Object v = playersHash.get(new Integer(n));
        if (v == null) {
            return false;
        }
        VideoPlayer videoPlayer = (VideoPlayer)v;
        return videoPlayer.init();
    }

    public static boolean realize(int n) {
        Object v = playersHash.get(new Integer(n));
        if (v == null) {
            return false;
        }
        VideoPlayer videoPlayer = (VideoPlayer)v;
        return videoPlayer.realize();
    }

    public static boolean prefetch(int n) {
        Object v = playersHash.get(new Integer(n));
        if (v == null) {
            return false;
        }
        VideoPlayer videoPlayer = (VideoPlayer)v;
        return videoPlayer.prefetch();
    }

    public static boolean start(int n) {
        Object v = playersHash.get(new Integer(n));
        if (v == null) {
            return false;
        }
        VideoPlayer videoPlayer = (VideoPlayer)v;
        return videoPlayer.start();
    }

    public static boolean stop(int n) {
        Object v = playersHash.get(new Integer(n));
        if (v == null) {
            return false;
        }
        VideoPlayer videoPlayer = (VideoPlayer)v;
        return videoPlayer.stop();
    }

    public static boolean deallocate(int n) {
        Object v = playersHash.get(new Integer(n));
        if (v == null) {
            return false;
        }
        VideoPlayer videoPlayer = (VideoPlayer)v;
        return videoPlayer.deallocate();
    }

    public static boolean close(int n) {
        Object v = playersHash.get(new Integer(n));
        if (v == null) {
            return false;
        }
        VideoPlayer videoPlayer = (VideoPlayer)v;
        return videoPlayer.close();
    }

    public static long setMediaTime(int n, long l) {
        Object v = playersHash.get(new Integer(n));
        if (v == null) {
            return -1L;
        }
        VideoPlayer videoPlayer = (VideoPlayer)v;
        return videoPlayer.setMediaTime(l);
    }

    public static int setMediaTimeMilliSeconds(int n, long l) {
        Object v = playersHash.get(new Integer(n));
        if (v == null) {
            return -1;
        }
        VideoPlayer videoPlayer = (VideoPlayer)v;
        return (int)((double)videoPlayer.setMediaTime(l * 1000L) / 1000000.0);
    }

    public static long getMediaTime(int n) {
        Object v = playersHash.get(new Integer(n));
        if (v == null) {
            return -1L;
        }
        VideoPlayer videoPlayer = (VideoPlayer)v;
        return videoPlayer.getMediaTime();
    }

    public static int getMediaTimeMilliSeconds(int n) {
        Object v = playersHash.get(new Integer(n));
        if (v == null) {
            return -1;
        }
        VideoPlayer videoPlayer = (VideoPlayer)v;
        long l = videoPlayer.getMediaTime();
        if (l != -1L) {
            return (int)((double)l / 1000000.0);
        }
        return -1;
    }

    public static long getDuration(int n) {
        Object v = playersHash.get(new Integer(n));
        if (v == null) {
            return -1L;
        }
        VideoPlayer videoPlayer = (VideoPlayer)v;
        return videoPlayer.getDuration();
    }

    public static int getDurationMilliSeconds(int n) {
        long l = VideoBridge2.getDuration(n);
        if (l != -1L) {
            l = (int)((double)l / 1000000.0);
        }
        return (int)l;
    }

    public static void setMute(int n, boolean bl) {
        Object v = playersHash.get(new Integer(n));
        if (v != null) {
            VideoPlayer videoPlayer = (VideoPlayer)v;
            videoPlayer.setMute(bl);
        }
    }

    public static boolean isMuted(int n) {
        Object v = playersHash.get(new Integer(n));
        if (v != null) {
            VideoPlayer videoPlayer = (VideoPlayer)v;
            return videoPlayer.isMuted();
        }
        return false;
    }

    public static int setLevel(int n, int n2) {
        Object v = playersHash.get(new Integer(n));
        if (v != null) {
            VideoPlayer videoPlayer = (VideoPlayer)v;
            return videoPlayer.setLevel(n2);
        }
        return 0;
    }

    public static int getLevel(int n) {
        Object v = playersHash.get(new Integer(n));
        if (v != null) {
            VideoPlayer videoPlayer = (VideoPlayer)v;
            return videoPlayer.getLevel();
        }
        return 0;
    }

    public static void setStopTime(int n, long l) {
        Object v = playersHash.get(new Integer(n));
        if (v != null) {
            VideoPlayer videoPlayer = (VideoPlayer)v;
            videoPlayer.setStopTime(l);
        }
    }

    public static int getStopTimeMilliSec(int n) {
        Object v = playersHash.get(new Integer(n));
        if (v != null) {
            VideoPlayer videoPlayer = (VideoPlayer)v;
            return videoPlayer.getStopTimeMilliSec();
        }
        return -1;
    }

    static void showMenu(String string) {
        Object v = widgetHash.get(string);
        if (v != null) {
            VideoPlayer videoPlayer = (VideoPlayer)v;
            videoPlayer.showMenu();
        }
    }

    public static boolean initDisplayMode(int n, int n2, String string) {
        Object v = playersHash.get(new Integer(n));
        if (v == null) {
            return false;
        }
        VideoPlayer videoPlayer = (VideoPlayer)v;
        videoPlayer.initDisplayMode(n2, string);
        if (string.startsWith("Canvas")) {
            widgetHash.put(string, videoPlayer);
        }
        return true;
    }

    public static void setVisible(int n, boolean bl) {
        Object v = playersHash.get(new Integer(n));
        if (v != null) {
            VideoPlayer videoPlayer = (VideoPlayer)v;
            videoPlayer.setVisible(bl);
        }
    }

    public static int[] getRGBSnapshot(int n) {
        Object v = playersHash.get(new Integer(n));
        if (v != null) {
            VideoPlayer videoPlayer = (VideoPlayer)v;
            return videoPlayer.getRGBSnapshot();
        }
        return null;
    }

    public static int getMaxRate(int n) {
        return 200000;
    }

    public static int getMinRate(int n) {
        return 100000;
    }

    public static int getRate(int n) {
        Object v = playersHash.get(new Integer(n));
        if (v != null) {
            VideoPlayer videoPlayer = (VideoPlayer)v;
            return videoPlayer.getRate();
        }
        return 100000;
    }

    public static int setRate(int n, int n2) {
        Object v = playersHash.get(new Integer(n));
        if (v != null) {
            int n3 = VideoBridge2.getMinRate(n);
            int n4 = VideoBridge2.getMaxRate(n);
            if (n2 < n3) {
                n2 = n3;
            } else if (n2 > n4) {
                n2 = n4;
            }
            VideoPlayer videoPlayer = (VideoPlayer)v;
            return videoPlayer.setRate(n2);
        }
        return 100000;
    }

    public static int seek(int n, int n2) {
        Object v = playersHash.get(new Integer(n));
        if (v != null) {
            VideoPlayer videoPlayer = (VideoPlayer)v;
            return videoPlayer.seek(n2);
        }
        return -1;
    }

    public static int skip(int n, int n2) {
        Object v = playersHash.get(new Integer(n));
        if (v != null) {
            VideoPlayer videoPlayer = (VideoPlayer)v;
            return videoPlayer.skip(n2);
        }
        return 0;
    }

    public static int mapFrameToTime(int n, int n2) {
        Object v = playersHash.get(new Integer(n));
        if (v != null) {
            VideoPlayer videoPlayer = (VideoPlayer)v;
            return videoPlayer.mapFrameToTime(n2);
        }
        return -1;
    }

    public static int mapTimeToFrame(int n, long l) {
        Object v = playersHash.get(new Integer(n));
        if (v != null) {
            VideoPlayer videoPlayer = (VideoPlayer)v;
            return videoPlayer.mapTimeToFrame(l);
        }
        return -1;
    }

    public static int getWidth(int n) {
        Object v = playersHash.get(new Integer(n));
        if (v != null) {
            return ((VideoPlayer)v).getSourceWidth();
        }
        return -1;
    }

    public static int getHeight(int n) {
        Object v = playersHash.get(new Integer(n));
        if (v != null) {
            return ((VideoPlayer)v).getSourceHeight();
        }
        return -1;
    }

    public static int setBounds(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9) {
        Object v = playersHash.get(new Integer(n));
        if (v != null) {
            return ((VideoPlayer)v).setBounds(n2, n3, n4, n5, n6, n7, n8, n9);
        }
        return 0;
    }

    static {
        playersHash = new Hashtable(2);
        widgetHash = new Hashtable(2);
        serverSocket = null;
        port = -1;
        GraphicsBridge.initialize();
        screen = GraphicsBridge.screen;
        faceBounds = screen.getFaceBoundsInComponent();
        displayBounds = screen.getDisplayBoundsInFace();
        LCDUIRenderer.setLCDUIComponent(screen.getComponent());
        Dimension dimension = screen.getFaceSize();
        Dimension dimension2 = screen.getDisplaySize();
        try {
            serverSocket = new ServerSocket(0);
            port = serverSocket.getLocalPort();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

