/*
 * Decompiled with CFR 0.152.
 */
package com.sun.kvem.mma;

import javax.sound.midi.MidiChannel;
import javax.sound.midi.MidiSystem;
import javax.sound.midi.MidiUnavailableException;
import javax.sound.midi.Synthesizer;

class ToneThread
extends Thread {
    private static Synthesizer synth;
    private static MidiChannel[] channels;
    private static boolean supported;
    private int note;
    private int volume;
    private int duration;

    ToneThread(int n, int n2, int n3) {
        this.note = n;
        this.volume = n2;
        this.duration = n3;
    }

    public void run() {
        if (!supported) {
            return;
        }
        try {
            if (!synth.isOpen()) {
                synth.open();
            }
        }
        catch (MidiUnavailableException midiUnavailableException) {
            return;
        }
        channels[15].programChange(73);
        channels[15].noteOn(this.note, this.volume);
        try {
            ToneThread.sleep(this.duration);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        channels[15].noteOff(this.note, this.volume);
    }

    static {
        try {
            synth = MidiSystem.getSynthesizer();
            channels = synth.getChannels();
            supported = channels != null && channels.length >= 16;
        }
        catch (Exception exception) {
            synth = null;
        }
    }
}

