/*
 * Decompiled with CFR 0.152.
 */
package com.sun.kvem.mma;

import com.sun.kvem.mma.MidiStream;
import com.sun.kvem.mma.ToneThread;
import java.io.BufferedInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Hashtable;
import javax.sound.midi.InvalidMidiDataException;
import javax.sound.midi.MetaEventListener;
import javax.sound.midi.MetaMessage;
import javax.sound.midi.MidiChannel;
import javax.sound.midi.MidiEvent;
import javax.sound.midi.MidiSystem;
import javax.sound.midi.Receiver;
import javax.sound.midi.Sequence;
import javax.sound.midi.Sequencer;
import javax.sound.midi.ShortMessage;
import javax.sound.midi.Synthesizer;
import javax.sound.midi.Track;

public class MMAMidiBridge {
    private static Hashtable playersHash = new Hashtable(2);
    private static final boolean DEBUG = false;
    private static final int META_EVENT_END_OF_MEDIA = 47;
    private static MMAMidiBridge bridge = new MMAMidiBridge();
    private static final float pitchFactor = 4.09575f;
    private static ServerSocket serverSocket = null;
    private static int port = 0;
    private static final int END_OF_MEDIA = -1;
    static final int TONE_CHANNEL = 15;

    public static int getPort() {
        return port;
    }

    public static boolean init(int n) {
        if (port > 0) {
            MIDIPlayer mIDIPlayer = new MIDIPlayer();
            playersHash.put(new Integer(n), mIDIPlayer);
            return mIDIPlayer.init();
        }
        return false;
    }

    public static int common(int n, int n2, int n3, int n4) {
        Object v = playersHash.get(new Integer(n));
        if (v == null) {
            return -1;
        }
        MIDIPlayer mIDIPlayer = (MIDIPlayer)v;
        return mIDIPlayer.common(n2, n3, n4);
    }

    public static int getPitch(int n) {
        Object v = playersHash.get(new Integer(n));
        if (v == null) {
            return 0;
        }
        MIDIPlayer mIDIPlayer = (MIDIPlayer)v;
        return mIDIPlayer.getPitch();
    }

    public static int LongMsg(int n, byte[] byArray, int n2, int n3) {
        Object v = playersHash.get(new Integer(n));
        if (v == null) {
            return -1;
        }
        MIDIPlayer mIDIPlayer = (MIDIPlayer)v;
        return mIDIPlayer.LongMsg(byArray, n2, n3);
    }

    public static int createSequence(int n, byte[] byArray, int n2) {
        Object v = playersHash.get(new Integer(n));
        if (v == null) {
            return 2;
        }
        MIDIPlayer mIDIPlayer = (MIDIPlayer)v;
        return mIDIPlayer.createSequence(byArray, n2);
    }

    public static int createSequence2(int n, int[] nArray, int n2, int n3, int n4) {
        Object v = playersHash.get(new Integer(n));
        if (v == null) {
            return -1;
        }
        MIDIPlayer mIDIPlayer = (MIDIPlayer)v;
        return mIDIPlayer.createSequence2(nArray, n2, n3, n4);
    }

    public static int prefetch(int n) {
        Object v = playersHash.get(new Integer(n));
        if (v == null) {
            return 2;
        }
        MIDIPlayer mIDIPlayer = (MIDIPlayer)v;
        return mIDIPlayer.prefetch();
    }

    public static int start(int n) {
        Object v = playersHash.get(new Integer(n));
        if (v == null) {
            return -1;
        }
        MIDIPlayer mIDIPlayer = (MIDIPlayer)v;
        return mIDIPlayer.start();
    }

    public static void stop(int n) {
        Object v = playersHash.get(new Integer(n));
        if (v != null) {
            MIDIPlayer mIDIPlayer = (MIDIPlayer)v;
            mIDIPlayer.stop();
        }
    }

    public static void deallocate(int n) {
        Object v = playersHash.get(new Integer(n));
        if (v != null) {
            MIDIPlayer mIDIPlayer = (MIDIPlayer)v;
            mIDIPlayer.deallocate();
        }
    }

    public static int setMediaTime(int n, int n2) {
        Object v = playersHash.get(new Integer(n));
        if (v == null) {
            return 0;
        }
        MIDIPlayer mIDIPlayer = (MIDIPlayer)v;
        return mIDIPlayer.setMediaTime(n2);
    }

    public static int getMediaTime(int n) {
        Object v = playersHash.get(new Integer(n));
        if (v == null) {
            return 0;
        }
        MIDIPlayer mIDIPlayer = (MIDIPlayer)v;
        return mIDIPlayer.getMediaTime();
    }

    public static int getDuration(int n) {
        Object v = playersHash.get(new Integer(n));
        if (v == null) {
            return 0;
        }
        MIDIPlayer mIDIPlayer = (MIDIPlayer)v;
        return mIDIPlayer.getDuration();
    }

    public static boolean close(int n) {
        Object v = playersHash.get(new Integer(n));
        if (v == null) {
            return false;
        }
        MIDIPlayer mIDIPlayer = (MIDIPlayer)v;
        return mIDIPlayer.close();
    }

    public static int playTone(int n, int n2, int n3) {
        new ToneThread(n, n2, n3).start();
        return 1;
    }

    static {
        try {
            serverSocket = new ServerSocket(0);
            port = serverSocket.getLocalPort();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    static final class MIDIPlayer
    implements MetaEventListener {
        private Socket clientSocket = null;
        private DataOutputStream out;
        private Sequencer sequencer;
        private Synthesizer synthesizer;
        private Synthesizer synth;
        private Receiver receiver;
        private Sequence sequence;
        private ShortMessage midism;
        private long duration = 0L;
        private long mediaTime = 0L;
        private boolean eom = false;
        private boolean started = false;
        private int volume = 100;
        private boolean onOnPastEom = false;
        MidiChannel[] channels = null;
        private int pitch = 0;

        MIDIPlayer() {
        }

        boolean init() {
            try {
                this.clientSocket = serverSocket.accept();
                this.out = new DataOutputStream(this.clientSocket.getOutputStream());
                this.sequencer = MidiSystem.getSequencer();
                this.synth = MidiSystem.getSynthesizer();
                this.receiver = this.synth.getReceiver();
                this.synthesizer = (Synthesizer)((Object)this.sequencer);
            }
            catch (Exception exception) {
                return false;
            }
            return true;
        }

        int common(int n, int n2, int n3) {
            int n4 = 1;
            n = 1;
            try {
                if (this.sequencer == null || this.synthesizer == null || this.receiver == null) {
                    return -1;
                }
                if (n != 0) {
                    switch (n2) {
                        case 1: {
                            if (this.midism == null) {
                                this.midism = new ShortMessage();
                            }
                            this.midism.setMessage(n3 & 0xFF, (n3 & 0xFF00) >> 8, (n3 & 0xFF0000) >> 16);
                            this.receiver.send(this.midism, -1L);
                            break;
                        }
                        case 11: {
                            n4 = n3;
                            this.volume = n3;
                            this.setVolume();
                            break;
                        }
                        case 12: {
                            n4 = this.synthesizer.getMaxPolyphony();
                            break;
                        }
                        case 110: {
                            n4 = (int)this.sequencer.getTickPosition();
                            break;
                        }
                        case 111: {
                            this.sequencer.setTickPosition(n3);
                            n4 = (int)this.sequencer.getTickPosition();
                            break;
                        }
                        case 120: {
                            n4 = (int)this.sequencer.getTempoInBPM();
                            break;
                        }
                        case 121: {
                            this.sequencer.setTempoInBPM(n3);
                            n4 = (int)this.sequencer.getTempoInBPM();
                            break;
                        }
                        case 130: {
                            if (this.sequencer == null || this.sequencer.getTempoFactor() == 0.0f) {
                                n4 = 100000;
                                break;
                            }
                            n4 = (int)((double)(this.sequencer.getTempoFactor() * 100000.0f) + 0.5);
                            break;
                        }
                        case 131: {
                            if (this.sequencer == null) {
                                n4 = 100000;
                                break;
                            }
                            this.sequencer.setTempoFactor((float)n3 / 100000.0f);
                            n4 = (int)((double)(this.sequencer.getTempoFactor() * 100000.0f) + 0.5);
                            break;
                        }
                        case 140: {
                            n4 = this.getPitch();
                            break;
                        }
                        case 141: {
                            int n5;
                            int n6;
                            if (this.synthesizer == null) {
                                n4 = 0;
                                break;
                            }
                            if (n3 >= 2000) {
                                n3 = 2000;
                                n6 = 16383;
                            } else if (n3 <= -2000) {
                                n3 = -2000;
                                n6 = 0;
                            } else if (n3 == 0) {
                                n6 = 8192;
                            } else {
                                n6 = (int)((double)((float)(n3 + 2000) * 4.09575f) + 0.5);
                                if (n6 < 0) {
                                    n6 = 0;
                                } else if (n6 > 16383) {
                                    n6 = 16383;
                                }
                            }
                            if (this.channels == null) {
                                this.channels = this.synthesizer.getChannels();
                            }
                            for (n5 = 0; n5 < this.channels.length; ++n5) {
                                this.channels[n5].allNotesOff();
                            }
                            for (n5 = 0; n5 < this.channels.length; ++n5) {
                                if (n5 == 9) continue;
                                this.channels[n5].setPitchBend(n6);
                            }
                            n4 = this.pitch = n3;
                        }
                    }
                }
            }
            catch (Exception exception) {
                return -1;
            }
            return n4;
        }

        int getPitch() {
            return this.pitch;
        }

        private void setVolume() {
            if (this.channels == null) {
                this.channels = this.synthesizer.getChannels();
            }
            int n = (int)((float)this.volume / 100.0f * 127.0f);
            for (int i = 0; i < this.channels.length; ++i) {
                this.channels[i].controlChange(7, n);
            }
        }

        int LongMsg(byte[] byArray, int n, int n2) {
            ShortMessage shortMessage = new ShortMessage();
            try {
                this.common(1, 0, 0);
                for (int i = n; i < n + n2; i += 3) {
                    shortMessage.setMessage(byArray[i] & 0xFF, byArray[i + 1] & 0xFF, byArray[i + 2] & 0xFF);
                    this.receiver.send(shortMessage, -1L);
                }
                return n2;
            }
            catch (Exception exception) {
                return -1;
            }
        }

        int createSequence(byte[] byArray, int n) {
            this.eom = false;
            this.duration = 0L;
            this.volume = 100;
            this.started = false;
            this.onOnPastEom = false;
            this.mediaTime = 0L;
            MidiStream midiStream = new MidiStream(byArray, n);
            BufferedInputStream bufferedInputStream = new BufferedInputStream(midiStream);
            try {
                this.sequence = MidiSystem.getSequence(bufferedInputStream);
                this.duration = this.sequence.getMicrosecondLength();
                return 0;
            }
            catch (Exception exception) {
                return 2;
            }
        }

        int createSequence2(int[] nArray, int n, int n2, int n3) {
            try {
                this.eom = false;
                this.duration = 0L;
                this.volume = 100;
                this.started = false;
                this.onOnPastEom = false;
                this.mediaTime = 0L;
                this.common(1, 0, 0);
                Sequence sequence = new Sequence(0.0f, n3 / (int)(120.0 / (double)n2));
                Track track = sequence.createTrack();
                boolean bl = true;
                for (int i = 0; i < n; i += 2) {
                    int n4 = nArray[i + 1] & 0xFF;
                    if (n4 == 0) continue;
                    int n5 = (nArray[i + 1] & 0xFF0000) >> 16;
                    int n6 = (nArray[i + 1] & 0xFF00) >> 8;
                    this.midism = new ShortMessage();
                    this.midism.setMessage(n4, n6, n5);
                    MidiEvent midiEvent = new MidiEvent(this.midism, nArray[i]);
                    track.add(midiEvent);
                }
                this.sequence = sequence;
                this.duration = sequence.getMicrosecondLength();
                return n;
            }
            catch (Exception exception) {
                return -1;
            }
        }

        int prefetch() {
            try {
                if (!this.sequencer.isOpen()) {
                    this.sequencer.open();
                    this.sequencer.addMetaEventListener(this);
                }
                if (!this.synth.isOpen()) {
                    this.synth.open();
                }
            }
            catch (Exception exception) {
                return 2;
            }
            if (this.sequence == null) {
                this.setVolume();
                return 0;
            }
            if (this.sequencer != null) {
                try {
                    this.sequencer.stop();
                    this.sequencer.setSequence(this.sequence);
                    this.sequencer.setMicrosecondPosition(0L);
                    this.setVolume();
                }
                catch (InvalidMidiDataException invalidMidiDataException) {
                    return 3;
                }
            }
            return 0;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        int start() {
            if (this.eom) {
                this.eom = false;
                this.setMediaTime(0);
            }
            MMAMidiBridge mMAMidiBridge = bridge;
            synchronized (mMAMidiBridge) {
                this.started = true;
                this.sequencer.start();
                this.common(1, 11, this.volume);
                if (!this.onOnPastEom) {
                    this.mediaTime = -1L;
                }
            }
            return 0;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void stop() {
            this.sequencer.stop();
            MMAMidiBridge mMAMidiBridge = bridge;
            synchronized (mMAMidiBridge) {
                this.started = false;
            }
        }

        void deallocate() {
            try {
                if (this.sequencer != null) {
                    Thread.sleep(200L);
                    this.sequencer.stop();
                    Thread.sleep(200L);
                    this.sequencer.close();
                }
                this.duration = 0L;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        int setMediaTime(int n) {
            MMAMidiBridge mMAMidiBridge = bridge;
            synchronized (mMAMidiBridge) {
                this.onOnPastEom = false;
                boolean bl = this.started;
                if (this.started) {
                    this.stop();
                }
                if (this.sequencer != null) {
                    this.sequencer.setMicrosecondPosition(n);
                    if (n == 0) {
                        this.mediaTime = 0L;
                    } else if (this.duration > 0L && (long)n >= this.duration) {
                        this.mediaTime = this.duration;
                        this.onOnPastEom = true;
                    } else {
                        this.mediaTime = this.sequencer.getMicrosecondPosition();
                        if (this.mediaTime == 0L && n > 0) {
                            this.mediaTime = n;
                        }
                    }
                } else {
                    this.mediaTime = 0L;
                }
                int n2 = (int)this.mediaTime;
                if (bl) {
                    this.start();
                }
                this.common(1, 11, this.volume);
                return n2;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        int getMediaTime() {
            if (this.eom && this.mediaTime == -1L) {
                return (int)this.duration;
            }
            MMAMidiBridge mMAMidiBridge = bridge;
            synchronized (mMAMidiBridge) {
                if (this.mediaTime != -1L) {
                    return (int)this.mediaTime;
                }
                if (this.sequencer != null) {
                    int n = (int)this.sequencer.getMicrosecondPosition();
                    if (n < 25000) {
                        n = 0;
                    }
                    return n;
                }
                return 0;
            }
        }

        int getDuration() {
            return (int)this.duration;
        }

        public void meta(MetaMessage metaMessage) {
            try {
                if (metaMessage.getType() == 47) {
                    this.eom = true;
                    this.started = false;
                    if (this.out != null) {
                        this.out.writeInt(-1);
                        this.out.writeLong(this.sequencer.getMicrosecondLength());
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        boolean close() {
            boolean bl = true;
            try {
                if (this.out != null) {
                    this.out.close();
                    this.out = null;
                }
            }
            catch (IOException iOException) {
                bl = false;
            }
            try {
                if (this.clientSocket != null) {
                    this.clientSocket.close();
                    this.clientSocket = null;
                }
            }
            catch (IOException iOException) {
                bl = false;
            }
            this.sequencer = null;
            this.synthesizer = null;
            if (this.receiver != null) {
                this.receiver.close();
            }
            this.receiver = null;
            if (this.synth != null) {
                this.synth.close();
            }
            this.synth = null;
            if (this.channels != null) {
                for (int i = 0; i < this.channels.length; ++i) {
                    this.channels[i] = null;
                }
            }
            this.channels = null;
            this.sequence = null;
            return bl;
        }
    }
}

