/*
 * Decompiled with CFR 0.152.
 */
package com.sun.kvem.mma;

import com.sun.kvem.Screen;
import com.sun.kvem.midp.GraphicsBridge;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.image.MemoryImageSource;
import java.awt.image.SinglePixelPackedSampleModel;
import javax.media.Buffer;
import javax.media.Control;
import javax.media.Format;
import javax.media.Player;
import javax.media.ResourceUnavailableException;
import javax.media.format.RGBFormat;
import javax.media.format.VideoFormat;
import javax.media.renderer.VideoRenderer;

public class LCDUIRenderer
implements VideoRenderer {
    private static final String name = "LCDUI Renderer";
    protected RGBFormat inputFormat;
    protected RGBFormat supportedRGB;
    protected Format[] supportedFormats;
    protected MemoryImageSource sourceImage;
    protected Image destImage;
    protected Buffer lastBuffer = null;
    protected int inWidth = 0;
    protected int inHeight = 0;
    private static Component component;
    protected Rectangle reqBounds = null;
    protected Rectangle bounds = new Rectangle();
    protected boolean started = false;
    protected int sourceX;
    protected int sourceY;
    protected int sourceW;
    protected int sourceH;
    protected int destX;
    protected int destY;
    protected int destW;
    protected int destH;
    private BufferedImage img;
    private boolean enabled = false;
    private boolean visible = false;
    private Player player;
    public static final int bMask = 255;
    public static final int gMask = 65280;
    public static final int rMask = 0xFF0000;

    public LCDUIRenderer() {
        this.supportedRGB = new RGBFormat(null, -1, [I.class, -1.0f, 32, 0xFF0000, 65280, 255, 1, -1, 0, -1);
        this.supportedFormats = new VideoFormat[1];
        this.supportedFormats[0] = this.supportedRGB;
    }

    void setPlayer(Player player) {
        this.player = player;
    }

    public boolean isLightWeight() {
        return true;
    }

    int getSourceWidth() {
        return this.sourceW;
    }

    int getSourceHeight() {
        return this.sourceH;
    }

    public Object[] getControls() {
        return new Control[0];
    }

    public Object getControl(String string) {
        try {
            Class<?> clazz = Class.forName(string);
            Object[] objectArray = this.getControls();
            for (int i = 0; i < objectArray.length; ++i) {
                if (!clazz.isInstance(objectArray[i])) continue;
                return objectArray[i];
            }
            return null;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public String getName() {
        return name;
    }

    public void open() throws ResourceUnavailableException {
        this.sourceImage = null;
        this.destImage = null;
        this.lastBuffer = null;
    }

    public void reset() {
    }

    public synchronized void close() {
        this.enabled = false;
        if (this.lastBuffer != null) {
            Object object = this.lastBuffer.getData();
            object = null;
            this.lastBuffer = null;
            this.sourceImage = null;
            this.destImage = null;
            this.inputFormat = null;
            this.supportedRGB = null;
            this.reqBounds = null;
            this.bounds = null;
            this.img = null;
            if (this.supportedFormats != null) {
                this.supportedFormats[0] = null;
                this.supportedFormats = null;
            }
        }
    }

    public void start() {
        this.started = true;
    }

    public void stop() {
        this.started = false;
    }

    public Format[] getSupportedInputFormats() {
        return this.supportedFormats;
    }

    public Format setInputFormat(Format format) {
        if (this.inputFormat == null) {
            this.inputFormat = (RGBFormat)format;
            Dimension dimension = this.inputFormat.getSize();
            this.inWidth = dimension.width;
            this.inHeight = dimension.height;
            this.sourceW = this.inWidth;
            this.sourceH = this.inHeight;
            this.destW = this.inWidth;
            this.destH = this.inHeight;
        } else {
            this.inputFormat = (RGBFormat)format;
        }
        if (this.inputFormat instanceof VideoFormat) {
            this.img = new BufferedImage(this.inputFormat.getSize().width, this.inputFormat.getSize().height, 1);
        }
        return format;
    }

    synchronized void setEnabled(boolean bl, boolean bl2) {
        this.enabled = bl;
        if (this.enabled && this.visible && this.player != null) {
            if (bl2) {
                GraphicsBridge.grabFullScreen(bl2);
            }
            if (this.player.getState() == 500) {
                this.refresh(bl2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void setBounds(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        this.sourceX = n;
        this.sourceY = n2;
        this.sourceW = n3;
        this.sourceH = n4;
        this.destX = n5;
        this.destY = n6;
        this.destW = n7;
        this.destH = n8;
        if (this.visible && this.enabled) {
            Screen screen = GraphicsBridge.screen;
            synchronized (screen) {
                if (this.img != null) {
                    GraphicsBridge.getClippedGraphics(0, null).drawImage(this.img, this.destX, this.destY, this.destX + this.destW, this.destY + this.destH, this.sourceX, this.sourceY, this.sourceX + this.sourceW, this.sourceY + this.sourceH, component);
                }
            }
        }
    }

    synchronized void setVisible(boolean bl, boolean bl2) {
        this.visible = bl;
        if (!this.visible) {
            GraphicsBridge.getClippedGraphics(0, null).clearRect(this.destX, this.destY, this.destX + this.destW, this.destY + this.destH);
            GraphicsBridge.refresh(this.destX, this.destY, this.destW, this.destH);
        } else if (this.enabled) {
            this.refresh(bl2);
            GraphicsBridge.refresh(this.destX, this.destY, this.destW, this.destH);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized int process(Buffer buffer) {
        if (component == null) {
            return 1;
        }
        Format format = buffer.getFormat();
        if (format == null) {
            return 1;
        }
        if (!(format == this.inputFormat && buffer.getFormat().equals((Object)this.inputFormat) || this.setInputFormat(format) == null)) {
            return 1;
        }
        Object object = buffer.getData();
        if (!(object instanceof int[])) {
            return 1;
        }
        if (!this.enabled || !this.visible) {
            return 0;
        }
        VideoFormat videoFormat = (VideoFormat)format;
        Screen screen = GraphicsBridge.screen;
        synchronized (screen) {
            if (this.img == null) {
                this.img = new BufferedImage(videoFormat.getSize().width, videoFormat.getSize().height, 1);
            }
            if (this.destW > 0) {
                this.img.setRGB(0, 0, videoFormat.getSize().width, videoFormat.getSize().height, (int[])object, 0, videoFormat.getSize().width);
            }
            if (this.reqBounds == null) {
                this.bounds = component.getBounds();
                this.bounds.x = 0;
                this.bounds.y = 0;
            } else {
                this.bounds = this.reqBounds;
            }
            if (this.destW > 0) {
                if (component != null) {
                    GraphicsBridge.getClippedGraphics(0, null).drawImage(this.img, this.destX, this.destY, this.destX + this.destW, this.destY + this.destH, this.sourceX, this.sourceY, this.sourceX + this.sourceW, this.sourceY + this.sourceH, component);
                } else {
                    return 1;
                }
            }
            if (this.enabled && this.visible) {
                GraphicsBridge.refresh(this.destX, this.destY, this.destW, this.destH);
            }
        }
        return 0;
    }

    private synchronized void refresh(boolean bl) {
        if (this.img != null && component != null) {
            GraphicsBridge.getClippedGraphics(0, null).drawImage(this.img, this.destX, this.destY, this.destX + this.destW, this.destY + this.destH, this.sourceX, this.sourceY, this.sourceW, this.sourceH, component);
        }
    }

    static void setLCDUIComponent(Component component) {
        LCDUIRenderer.component = component;
    }

    public Component getComponent() {
        return component;
    }

    public boolean setComponent(Component component) {
        return false;
    }

    public void setBounds(Rectangle rectangle) {
        this.reqBounds = rectangle;
    }

    public Rectangle getBounds() {
        return this.reqBounds;
    }

    int getInWidth() {
        return this.inWidth;
    }

    int getInHeight() {
        return this.inHeight;
    }

    int[] getRGB() {
        if (this.img != null) {
            return this.img.getRGB(0, 0, this.img.getWidth(), this.img.getHeight(), null, 0, ((SinglePixelPackedSampleModel)this.img.getSampleModel()).getScanlineStride());
        }
        return null;
    }
}

