/*
 * Decompiled with CFR 0.152.
 */
package com.sun.kvem.mma;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.util.Random;
import javax.media.Duration;
import javax.media.Time;
import javax.media.protocol.ContentDescriptor;
import javax.media.protocol.FileTypeDescriptor;
import javax.media.protocol.PullDataSource;
import javax.media.protocol.PullSourceStream;
import javax.media.protocol.Seekable;

public class DataSource
extends PullDataSource {
    private String contentType;
    private long contentLength;
    private DataStream[] streams = new DataStream[1];
    private static Random random = new Random();
    private static String tempPrefix;
    private File file;
    private String extension;

    DataSource(InputStream inputStream, String string, long l, int n, String string2) throws IOException {
        this.contentType = ContentDescriptor.mimeTypeToPackageName((String)string);
        this.contentLength = l;
        this.extension = "." + string2;
        this.streams[0] = new DataStream(inputStream, n);
    }

    String getFileName() {
        return this.file.getAbsolutePath();
    }

    public PullSourceStream[] getStreams() {
        return this.streams;
    }

    void waitUntilDataAvailable() {
        this.streams[0].waitUntilDataAvailable();
    }

    public Time getDuration() {
        return Duration.DURATION_UNBOUNDED;
    }

    public void start() throws IOException {
    }

    public void stop() throws IOException {
    }

    public void connect() throws IOException {
    }

    public void disconnect() {
    }

    public String getContentType() {
        return this.contentType;
    }

    public Object[] getControls() {
        return new Object[0];
    }

    public Object getControl(String string) {
        return null;
    }

    private String getTempFileName() {
        return "mmawtk_" + random.nextInt();
    }

    void close() {
        if (this.streams[0] != null) {
            this.streams[0].close();
            this.streams[0] = null;
        }
    }

    public final class DataStream
    implements PullSourceStream,
    Seekable,
    Runnable {
        private InputStream in;
        private int port;
        private boolean waiting = false;
        private RandomAccessFile raf;
        private int totalRead = 0;
        private long readPos = 0L;
        private long writePos = 0L;
        private boolean cached = false;
        private byte[] data;

        DataStream(InputStream inputStream, int n) throws IOException {
            this.in = inputStream;
            this.data = new byte[n];
            try {
                DataSource.this.file = File.createTempFile(DataSource.this.getTempFileName(), DataSource.this.extension);
                DataSource.this.file.deleteOnExit();
                this.raf = new RandomAccessFile(DataSource.this.file, "rw");
                Thread thread = new Thread(this);
                thread.setPriority(10);
                new Thread(this).start();
            }
            catch (Exception exception) {
                System.err.println(exception.getMessage());
                this.cleanup();
                throw new IOException("Unable to create input stream for PullDataSource");
            }
        }

        public ContentDescriptor getContentDescriptor() {
            return new FileTypeDescriptor(DataSource.this.contentType);
        }

        public long getContentLength() {
            return DataSource.this.contentLength;
        }

        public boolean endOfStream() {
            return false;
        }

        public boolean willReadBlock() {
            return false;
        }

        public Object[] getControls() {
            return new Object[0];
        }

        public Object getControl(String string) {
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                do {
                    if (this.in == null) {
                        return;
                    }
                    int n = this.in.read(this.data);
                    if (n <= 0) break;
                    this.write(this.data, 0, n);
                    this.totalRead += n;
                } while ((long)this.totalRead < DataSource.this.contentLength);
                DataStream dataStream = this;
                synchronized (dataStream) {
                    this.cached = true;
                    try {
                        if (this.raf != null) {
                            this.raf.close();
                            this.raf = null;
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    this.notify();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void waitUntilDataAvailable() {
            DataStream dataStream = this;
            synchronized (dataStream) {
                while (!this.cached) {
                    try {
                        this.wait(250L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        }

        public synchronized int read(byte[] byArray, int n, int n2) throws IOException {
            this.raf.seek(this.readPos);
            int n3 = n2;
            while (n3 > 0) {
                int n4 = this.raf.read(byArray, n, n3);
                if (n4 == -1) {
                    int n5 = n2 - n3;
                    return n5 > 0 ? n5 : -1;
                }
                this.readPos += (long)n4;
                n3 -= n4;
                n += n4;
            }
            return n2;
        }

        private synchronized boolean write(byte[] byArray, int n, int n2) {
            try {
                this.raf.seek(this.writePos);
                this.raf.write(byArray, n, n2);
                this.writePos += (long)n2;
                if (this.waiting) {
                    this.notify();
                }
                return true;
            }
            catch (Exception exception) {
                return false;
            }
        }

        public synchronized long canSeek(long l) {
            try {
                while (l >= this.writePos) {
                    this.waiting = true;
                    try {
                        this.wait(1000L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
                this.waiting = false;
                this.raf.seek(l);
                this.readPos = l;
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return this.readPos;
        }

        public synchronized long seek(long l) {
            try {
                if (this.cached && l >= this.writePos) {
                    this.raf.seek(this.writePos);
                    return this.writePos;
                }
                while (l >= this.writePos) {
                    this.waiting = true;
                    try {
                        this.wait(1000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    if (!this.cached || l < this.writePos) continue;
                    this.raf.seek(this.writePos);
                    return this.writePos;
                }
                this.waiting = false;
                this.raf.seek(l);
                this.readPos = l;
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return this.readPos;
        }

        public synchronized long tell() {
            return this.readPos;
        }

        public boolean isRandomAccess() {
            return true;
        }

        private void cleanup() {
            try {
                if (this.raf != null) {
                    this.raf.close();
                    this.raf = null;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            DataSource.this.file = null;
        }

        private void close() {
            try {
                if (this.raf != null) {
                    this.raf.close();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (DataSource.this.file != null) {
                DataSource.this.file.delete();
            }
            try {
                if (this.in != null) {
                    this.in.close();
                    this.in = null;
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

