/*
 * Decompiled with CFR 0.152.
 */
package com.sun.kvem.mma;

import java.io.IOException;
import java.io.OutputStream;
import java.net.ServerSocket;
import java.net.Socket;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.TargetDataLine;

public class AudioCapture {
    private static ServerSocket serverSocket = null;
    private Socket clientSocket = null;
    private OutputStream out;
    private TargetDataLine line;
    private AudioFormat audioFormat;
    private static AudioCapture capture = new AudioCapture();
    private static int port = 0;
    private byte[] buf = new byte[32000];

    private AudioCapture() {
    }

    public static int getPort() {
        return port;
    }

    public static boolean open(int n, int n2, int n3, int n4) {
        return capture.openDevice(n, n2, n3, n4);
    }

    public static int command(int n, int n2) {
        return capture.doCommand(n, n2);
    }

    public static int read(int n) {
        return capture.readFromDevice(n);
    }

    private boolean openDevice(int n, int n2, int n3, int n4) {
        try {
            this.clientSocket = serverSocket.accept();
            this.out = this.clientSocket.getOutputStream();
            boolean bl = n2 == 16;
            this.audioFormat = new AudioFormat(n, n2, n3, bl, false);
            DataLine.Info info = new DataLine.Info(TargetDataLine.class, this.audioFormat);
            this.line = (TargetDataLine)AudioSystem.getLine(info);
            this.line.open(this.audioFormat, 64000);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    private int doCommand(int n, int n2) {
        int n3 = 0;
        if (this.line != null) {
            n3 = 1;
            switch (n) {
                case 1: {
                    this.line.start();
                    break;
                }
                case 2: {
                    this.line.stop();
                    this.line.flush();
                    break;
                }
                case 3: {
                    this.line.close();
                    this.line = null;
                    try {
                        this.clientSocket.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    this.clientSocket = null;
                    try {
                        this.out.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    this.out = null;
                    break;
                }
                default: {
                    n3 = 0;
                }
            }
        }
        return n3;
    }

    private int readFromDevice(int n) {
        if (this.line == null) {
            return 0;
        }
        if (this.buf.length < n) {
            this.buf = new byte[n];
        }
        final int n2 = this.line.read(this.buf, 0, n);
        new Thread(){

            public void run() {
                try {
                    AudioCapture.this.out.write(AudioCapture.this.buf, 0, n2);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }.start();
        return n2;
    }

    static {
        try {
            serverSocket = new ServerSocket(0);
            port = serverSocket.getLocalPort();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

