/*
 * Decompiled with CFR 0.152.
 */
package com.sun.kvem.midp.io.j2se.wma.server;

import com.sun.kvem.environment.Debug;
import com.sun.kvem.environment.PropertiesFile;
import com.sun.kvem.environment.ToolkitDirs;
import com.sun.kvem.midp.io.j2se.wma.common.DatagramRecord;
import com.sun.kvem.midp.io.j2se.wma.server.ControlHandler;
import com.sun.kvem.util.ToolkitResources;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Random;
import java.util.Vector;

public class WMAServer {
    private static Debug debug = Debug.create((Class)WMAServer.class);
    public static final int MAX_GUARANTEED_RECEIVABLE_SEGMENTS = 3;
    public static final int WAIT_FOR_SWITCH_TO_LAUNCH_DELAY_MS = 5000;
    private static final int INITIAL_INCOMING_QUEUE_SIZE = 256;
    public static final int POLL_FOR_DEATH_TIMEOUT_MS = 6000;
    public static final String STAT_FILE_NAME = ToolkitDirs.LIB + "WMAServer.ports";
    private static String cbsTunnelPort = "24680";
    private static File emulatorPropertiesLocation = new File(ToolkitDirs.LIB, "emulator.properties");
    private static int controlPort;
    private static ServerSocket controlSocket;
    private static boolean timeToDie;
    private static long lastPingTime;
    private static long nextPhoneNumber;
    private static HashMap clientPorts;
    private static HashMap clientTypes;
    private static boolean checkSegments;
    private static final int BUFFER_SIZE = 1500;
    private static DatagramSocket receiveSocket;
    private static int receivePort;
    private static DatagramSocket ackSocket;
    private static int ackPort;
    private static byte[] receiveBuffer;
    private static Vector queue;
    private static Vector timeStampQueue;
    private static Thread controller;
    private static Thread receiver;
    private static Thread router;
    private static long packetDelayMS;
    private static double randomPacketLoss;
    private static HashMap multipartCache;
    private static WMAServer wmaS;
    private static final Random cookieGenerator;
    static final Hashtable cookieToMonitorMap;

    static synchronized boolean isTimeToDie() {
        if (controller.isDaemon()) {
            return false;
        }
        if (timeToDie && lastPingTime != 0L && System.currentTimeMillis() - lastPingTime < 6000L) {
            return false;
        }
        return timeToDie;
    }

    static synchronized void flagTimeToDie() {
        controller.setDaemon(true);
        timeToDie = true;
    }

    public static synchronized void notifyOfPing() {
        lastPingTime = System.currentTimeMillis();
    }

    private WMAServer(Properties properties) throws Exception {
        Object object;
        debug.println(4, "WMAServer: constructing.");
        WMAServer.refreshFromProperties(properties);
        debug.println(3, "cbsTunnelPort: " + cbsTunnelPort);
        String string = properties.getProperty("com.sun.kvem.midp.io.j2se.wma.server.TrafficPort");
        int n = 0;
        if (string != null && string.length() > 0) {
            n = Integer.parseInt(string);
        } else {
            object = new DatagramSocket();
            n = ((DatagramSocket)object).getLocalPort();
            ((DatagramSocket)object).close();
        }
        receiveSocket = new DatagramSocket(n);
        receivePort = receiveSocket.getLocalPort();
        debug.println(2, "WMAServer: listening for Datagrams on port " + receivePort);
        receiveBuffer = new byte[1500];
        n = 0;
        object = properties.getProperty("com.sun.kvem.midp.io.j2se.wma.server.ControlPort");
        if (object != null && ((String)object).length() > 0) {
            n = Integer.parseInt((String)object);
        } else {
            DatagramSocket datagramSocket = new DatagramSocket();
            n = datagramSocket.getLocalPort();
            datagramSocket.close();
        }
        this.initializeController(n);
        this.initializeTrafficHandler();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializeController(int n) throws Exception {
        if (controlPort == 0) {
            debug.println(3, "WMAServer: initializing Control port.");
            controlPort = n;
            debug.println(3, "WMAServer: control port is " + controlPort);
            controlSocket = new ServerSocket(controlPort);
            controlSocket.setSoTimeout(6000);
            controller = new Thread((Runnable)new Controller(), "Controller");
            controller.setDaemon(false);
            controller.start();
            File file = new File(STAT_FILE_NAME);
            file.delete();
            String string = String.valueOf(controlPort) + ':' + String.valueOf(receivePort) + '\n';
            file.createNewFile();
            file.deleteOnExit();
            FileWriter fileWriter = new FileWriter(file);
            try {
                fileWriter.write(string);
            }
            finally {
                fileWriter.close();
            }
        }
    }

    private void initializeTrafficHandler() throws Exception {
        debug.println(4, "WMAServer: initializing DatagramReader.");
        receiver = new Thread((Runnable)new DatagramReader(), "DatagramReader");
        receiver.setDaemon(true);
        receiver.start();
        debug.println(4, "WMAServer: initializing DatagramRouter.");
        router = new Thread((Runnable)new DatagramRouter(), "DatagramRouter");
        router.setDaemon(true);
        router.start();
    }

    public static int getReceivePort() {
        return receivePort;
    }

    public static String generatePhoneNumber() {
        return "+" + String.valueOf(WMAServer.getNextPhoneNumber());
    }

    public static synchronized boolean registerClient(String string) {
        debug.println(3, "Attempting to register client " + string);
        String string2 = string;
        string2 = string.charAt(0) == '+' ? string.substring(1) : "+" + string;
        if (clientPorts.containsKey(string) || clientPorts.containsKey(string2)) {
            debug.println(2, "Failed to register client " + string);
            return false;
        }
        clientPorts.put(string, null);
        debug.println(3, "Successfully registered client " + string);
        return true;
    }

    public static synchronized String registerClient() {
        debug.println(3, "Attempting to register client and generate a phone number.");
        String string = WMAServer.generatePhoneNumber();
        debug.println(3, "Generated: " + string);
        WMAServer.registerClient(string);
        return string;
    }

    public static synchronized void unregisterClient(String string) {
        debug.println(3, "Unregistering client " + string);
        clientPorts.remove(string);
        clientTypes.remove(string);
        if (clientPorts.size() == 0) {
            WMAServer.flagTimeToDie();
        }
    }

    public static synchronized void setClientPort(String string, int n) {
        debug.println(4, "Setting client " + string + " port to " + n);
        clientPorts.put(string, new Integer(n));
    }

    public static synchronized int getClientPort(String string) {
        Integer n = (Integer)clientPorts.get(string);
        if (n == null && (n = string.charAt(0) == '+' ? (Integer)clientPorts.get(string.substring(1)) : (Integer)clientPorts.get("+" + string)) == null) {
            throw new IllegalArgumentException("No registered client " + string);
        }
        return n;
    }

    public static synchronized void setClientType(String string, int n) {
        debug.println(4, "Setting client " + string + " type to " + n);
        clientTypes.put(string, new Integer(n));
    }

    public static synchronized int getClientType(String string) {
        Integer n = (Integer)clientTypes.get(string);
        if (n == null && (n = string.charAt(0) == '+' ? (Integer)clientTypes.get(string.substring(1)) : (Integer)clientTypes.get("+" + string)) == null) {
            throw new IllegalArgumentException("No registered client " + string);
        }
        return n;
    }

    public static synchronized long peekNextPhoneNumber() {
        return nextPhoneNumber;
    }

    public static synchronized long getNextPhoneNumber() {
        long l;
        String string;
        String string2;
        do {
            ++nextPhoneNumber;
            string2 = String.valueOf(l);
            string = "+" + string2;
        } while (clientPorts.containsKey(string2) || clientPorts.containsKey(string));
        return l;
    }

    private static String getDestinationPhoneNumber(DatagramRecord datagramRecord) {
        int n;
        String string = datagramRecord.getHeader("Address");
        if (string == null) {
            return null;
        }
        String string2 = string.substring(6);
        if (string2.charAt(0) != '+') {
            string2 = "+" + string2;
        }
        if ((n = string2.indexOf(58)) != -1) {
            string2 = string2.substring(0, n);
        }
        return string2;
    }

    private static void sendPacket(DatagramPacket datagramPacket, int n) throws Exception {
        datagramPacket.setPort(n);
        receiveSocket.send(datagramPacket);
        debug.println(4, "Packet sent.");
    }

    private static synchronized void sendMessage(DatagramPacket datagramPacket, String string) throws Exception {
        debug.println(2, "Sending message to \"" + string + "\"");
        int n = WMAServer.getClientPort(string);
        int n2 = WMAServer.getClientType(string);
        if (n2 == 1) {
            throw new NullPointerException("Client " + string + " cannot receive messages.");
        }
        WMAServer.sendPacket(datagramPacket, n);
    }

    private static synchronized String getClientNumberForPort(int n) {
        Iterator iterator = clientPorts.keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            if ((Integer)clientPorts.get(string) != n) continue;
            return string;
        }
        return null;
    }

    static void checkSegmentation(DatagramRecord datagramRecord) {
        String string;
        if (checkSegments && (string = datagramRecord.getHeader("Content-Type")) != null && (string.equals("text") || string.equals("binary"))) {
            int n = 0;
            String string2 = datagramRecord.getHeader("Segments");
            if (string2 != null) {
                try {
                    n = Integer.parseInt(string2);
                    if (n > 3) {
                        System.out.println(ToolkitResources.getString((String)"WMA_SEGMENTS_WARNING"));
                        checkSegments = false;
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    debug.exception(1, (Throwable)numberFormatException);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void routeMultipartSegment(DatagramRecord datagramRecord, DatagramPacket datagramPacket) throws Exception {
        int n;
        Object object;
        Object object2;
        String string = datagramRecord.getHeader("Date");
        debug.println(4, "Routing Multipart packet sent at " + string);
        Object[] objectArray = (Object[])multipartCache.get(string);
        if (objectArray == null) {
            debug.println(4, "No previous packets with this timestamp.");
            objectArray = new Object[]{null, new ArrayList()};
            multipartCache.put(string, objectArray);
        }
        DatagramRecord datagramRecord2 = (DatagramRecord)objectArray[0];
        debug.println(4, "Previous DGRec has size of: " + (datagramRecord2 != null ? datagramRecord2.getHeader("Total-Size") : " nothing"));
        ArrayList arrayList = (ArrayList)objectArray[1];
        debug.println(4, "There are " + arrayList.size() + " packets already waiting.");
        arrayList.add(datagramPacket);
        boolean bl = datagramRecord.addData(datagramRecord2);
        if (!bl) {
            objectArray[0] = datagramRecord;
            debug.println(4, "Still expecting more packets.");
            return;
        }
        debug.println(4, "That's the whole thing. Parsing...");
        multipartCache.remove(string);
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(datagramRecord.getData());
        DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);
        HashSet<String> hashSet = new HashSet<String>();
        ArrayList<Integer> arrayList2 = new ArrayList<Integer>();
        String string2 = null;
        try {
            dataInputStream.readUTF();
            String string3 = dataInputStream.readUTF();
            object2 = dataInputStream.readUTF();
            while (string3 != null && !string3.equals("nEntries")) {
                if (string3.equals("To") || string3.equals("Cc") || string3.equals("Bcc")) {
                    int n2 = -2;
                    while (n2 != -1) {
                        int n3 = ((String)object2).indexOf("; ", n2 + 2);
                        object = null;
                        object = n3 == -1 ? ((String)object2).substring(n2 + 2) : ((String)object2).substring(n2 + 2, n3);
                        n2 = n3;
                        try {
                            if (WMAServer.getClientType((String)object) == 1) {
                                debug.println(2, "Client " + (String)object + " is send-only. Dropping MMS to him.");
                                continue;
                            }
                            int n4 = WMAServer.getClientPort((String)object);
                            hashSet.add((String)object);
                            arrayList2.add(new Integer(n4));
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            debug.println(2, "only sending MMS to GATEWAY once, for address: " + (String)object);
                            string2 = object;
                        }
                    }
                }
                string3 = dataInputStream.readUTF();
                object2 = dataInputStream.readUTF();
            }
            dataInputStream.close();
            byteArrayInputStream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (string2 != null) {
            try {
                int n5 = WMAServer.getClientPort(".Default Gateway.");
                hashSet.add(string2);
                arrayList2.add(new Integer(n5));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                debug.println(2, "No gateway. Not sending MMS to {0} or any other non-local addresses", string2);
            }
        }
        if ((n = hashSet.size()) == 0) {
            debug.println(2, "No destinations to send MMS to.");
            return;
        }
        if (arrayList.size() == 1) {
            debug.println(2, "Sending MMS without acks: 1 packet");
            for (int i = 0; i < n; ++i) {
                try {
                    WMAServer.sendPacket((DatagramPacket)arrayList.get(0), (Integer)arrayList2.get(i));
                    continue;
                }
                catch (Exception exception) {
                    debug.println(2, "Sending only packet of MMS caught this:");
                    debug.exception(1, (Throwable)exception);
                }
            }
            return;
        }
        object2 = AckNotifier.class;
        synchronized (object2) {
            if (ackSocket == null) {
                try {
                    ackSocket = new DatagramSocket();
                    ackPort = ackSocket.getLocalPort();
                    Thread thread = new Thread(new AckNotifier());
                    thread.setDaemon(true);
                    thread.start();
                }
                catch (SocketException socketException) {
                    debug.println(1, "No ACK of MMS packets because: ");
                    debug.exception(1, (Throwable)socketException);
                }
            }
        }
        object2 = String.valueOf(cookieGenerator.nextInt());
        int[] nArray = new int[]{0};
        cookieToMonitorMap.put(object2, nArray);
        Thread thread = new Thread(new AcknowledgingSender(arrayList2, arrayList, nArray, (String)object2));
        thread.setDaemon(true);
        thread.start();
        object = new Thread(new ZerothPacketSender(arrayList2, (DatagramPacket)arrayList.get(0), (String)object2));
        ((Thread)object).setDaemon(true);
        ((Thread)object).start();
    }

    static void routeMessage(DatagramPacket datagramPacket) throws Exception {
        DatagramRecord datagramRecord = new DatagramRecord();
        datagramRecord.parseData(datagramPacket.getData(), datagramPacket.getLength());
        debug.println(4, "received packet length: " + datagramPacket.getLength());
        debug.println(3, "received record: {0}", (Object)datagramRecord.toString());
        debug.println(4, "Record's data len: " + datagramRecord.getData().length);
        String string = datagramRecord.getHeader("Content-Type");
        if (string.equals("multipart")) {
            WMAServer.routeMultipartSegment(datagramRecord, datagramPacket);
            return;
        }
        if (Math.random() >= randomPacketLoss) {
            int n;
            String string2 = WMAServer.getDestinationPhoneNumber(datagramRecord);
            if (string2 == null) {
                WMAServer.broadcastCBS(datagramRecord);
                return;
            }
            String string3 = WMAServer.getClientNumberForPort(datagramPacket.getPort());
            if (string3 != null && (n = WMAServer.getClientType(string3)) == 2) {
                debug.println(2, "Got a message from client " + string3 + " who does not have permission to send messages.");
                throw new Exception("Client " + string3 + " should not be sending messages. Dropping message.");
            }
            WMAServer.checkSegmentation(datagramRecord);
            debug.println(3, "sending Message record: " + datagramRecord.toString());
            WMAServer.routeMessageTo(datagramPacket, string2);
        } else {
            debug.println(2, "Dropped a packet randomly.");
        }
    }

    private static void routeMessageTo(DatagramPacket datagramPacket, String string) throws Exception {
        try {
            WMAServer.sendMessage(datagramPacket, string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            debug.println(3, "No client with phone number " + string + " can receive messages, trying gateway...");
            try {
                WMAServer.sendMessage(datagramPacket, ".Default Gateway.");
            }
            catch (IllegalArgumentException illegalArgumentException2) {
                debug.println(3, "No gateway through which undeliverable messages can be routed. Dropping message.");
            }
        }
    }

    private static void broadcastCBS(DatagramRecord datagramRecord) throws Exception {
        debug.println(3, "It's a CBS message.");
        datagramRecord.setHeader("Address", cbsTunnelPort);
        byte[] byArray = datagramRecord.getFormattedData();
        debug.println(3, "Sending this CBS message: " + datagramRecord.toString());
        DatagramPacket datagramPacket = new DatagramPacket(byArray, byArray.length, InetAddress.getLocalHost(), receivePort);
        Iterator iterator = clientTypes.keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            if ((Integer)clientTypes.get(string) == 1) continue;
            int n = WMAServer.getClientPort(string);
            datagramPacket.setPort(n);
            receiveSocket.send(datagramPacket);
            debug.println(3, "Sent CBS to " + string);
        }
    }

    public static synchronized String[] getAddressableClients() {
        String[] stringArray;
        Iterator iterator = clientTypes.keySet().iterator();
        Vector<String[]> vector = new Vector<String[]>();
        while (iterator.hasNext()) {
            stringArray = (String[])iterator.next();
            if ((Integer)clientTypes.get(stringArray) == 1) continue;
            vector.addElement(stringArray);
        }
        stringArray = null;
        if (!vector.isEmpty()) {
            stringArray = vector.toArray(new String[0]);
        }
        return stringArray;
    }

    public static void launch(boolean bl) throws Exception {
        Object object;
        Comparable<StringBuffer> comparable;
        debug.println(1, "Launching server...");
        String string = null;
        if (!bl) {
            comparable = new StringBuffer();
            object = System.getProperty("os.name").toLowerCase();
            if (!((String)object).startsWith("windows")) {
                String string2 = "/usr/bin/nohup";
                File file = new File(string2);
                if (file.exists()) {
                    ((StringBuffer)comparable).append(string2);
                } else {
                    ((StringBuffer)comparable).append("nohup");
                }
                ((StringBuffer)comparable).append(' ');
            }
            ((StringBuffer)comparable).append(System.getProperty("java.home"));
            ((StringBuffer)comparable).append(File.separator);
            ((StringBuffer)comparable).append("bin");
            ((StringBuffer)comparable).append(File.separator);
            ((StringBuffer)comparable).append("java -classpath ");
            ((StringBuffer)comparable).append(ToolkitDirs.LIB);
            ((StringBuffer)comparable).append("kvem.jar");
            ((StringBuffer)comparable).append(File.pathSeparator);
            ((StringBuffer)comparable).append(System.getProperty("java.class.path"));
            ((StringBuffer)comparable).append(" -Dkvem.home=");
            ((StringBuffer)comparable).append(System.getProperty("kvem.home"));
            ((StringBuffer)comparable).append(" com.sun.kvem.midp.io.j2se.wma.server.WMAServer");
            if (!((String)object).startsWith("windows")) {
                ((StringBuffer)comparable).append(" > /dev/null");
            }
            string = ((StringBuffer)comparable).toString();
        }
        comparable = new File(STAT_FILE_NAME);
        ((File)comparable).delete();
        if (bl) {
            debug.println(1, "Launching WMAServer in same VM");
            object = new Thread(new Runnable(){

                public void run() {
                    WMAServer.makeServer();
                }
            });
            ((Thread)object).setDaemon(true);
            ((Thread)object).start();
        } else {
            debug.println(1, "Launching WMAServer in new VM");
            debug.println(2, "Executing: " + string);
            Runtime.getRuntime().exec(string);
        }
    }

    private static void refreshFromProperties(Properties properties) {
        String string;
        String string2;
        debug.println(3, "Refreshing properties from emulator.properties");
        String string3 = properties.getProperty("wma.server.deliveryDelayMS");
        if (string3 != null && string3.length() > 0) {
            try {
                packetDelayMS = Integer.parseInt(string3);
            }
            catch (NumberFormatException numberFormatException) {
                debug.println(2, "NFE for property wma.server.deliveryDelayMS");
                debug.exception(2, (Throwable)numberFormatException);
            }
        }
        if ((string2 = properties.getProperty("wma.server.percentFragmentLoss")) != null && string2.length() > 0) {
            try {
                randomPacketLoss = (double)Integer.parseInt(string2) / 100.0;
            }
            catch (NumberFormatException numberFormatException) {
                debug.println(2, "NFE for property wma.server.percentFragmentLoss");
                debug.exception(2, (Throwable)numberFormatException);
            }
        }
        if ((string = properties.getProperty("wma.server.firstAssignedPhoneNumber")) != null && string.length() > 0) {
            if (string.charAt(0) == '+') {
                string = string.substring(1);
            }
            try {
                nextPhoneNumber = Long.parseLong(string);
            }
            catch (NumberFormatException numberFormatException) {
                debug.println(2, "NFE for property wma.server.firstAssignedPhoneNumber");
                debug.exception(2, (Throwable)numberFormatException);
            }
        }
        debug.println(3, "packetDelayMS: " + packetDelayMS);
        debug.println(3, "randomPacketLoss: " + randomPacketLoss);
        debug.println(3, "nextPhoneNumber: " + nextPhoneNumber);
    }

    private static void makeServer() {
        Properties properties = null;
        try {
            properties = new PropertiesFile(emulatorPropertiesLocation).getPropertiesList();
        }
        catch (IOException iOException) {
            Debug.warning((String)"Unable to load emulator.properties");
            properties = System.getProperties();
        }
        try {
            wmaS = new WMAServer(properties);
        }
        catch (Exception exception) {
            debug.exception(1, (Throwable)exception);
        }
    }

    public static void main(String[] stringArray) {
        debug = stringArray.length == 0 || !"-verbose".equals(stringArray[0]) ? Debug.create((Class)WMAServer.class) : Debug.create((int)4);
        debug.println(3, "Entered main of WMAServer.");
        try {
            URL[] uRLArray = new URL[]{new File(System.getProperty("kvem.home") + File.separator + "wtklib" + File.separator + "kvem.jar").toURL(), new File(System.getProperty("kvem.home") + File.separator + "wtklib" + File.separator + "kenv.zip").toURL()};
            URLClassLoader uRLClassLoader = new URLClassLoader(uRLArray);
            Class<?> clazz = uRLClassLoader.loadClass("com.sun.kvem.midp.io.j2se.wma.client.WMAClient");
            Method method = clazz.getMethod("ensureServerIsPresent", null);
            method.invoke(null, null);
        }
        catch (MalformedURLException malformedURLException) {
            malformedURLException.printStackTrace();
        }
        catch (ClassNotFoundException classNotFoundException) {
            classNotFoundException.printStackTrace();
        }
        catch (NoSuchMethodException noSuchMethodException) {
            noSuchMethodException.printStackTrace();
        }
        catch (IllegalAccessException illegalAccessException) {
            illegalAccessException.printStackTrace();
        }
        catch (InvocationTargetException invocationTargetException) {
            invocationTargetException.printStackTrace();
        }
        try {
            Thread.currentThread();
            Thread.sleep(5000L);
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
        debug.println(4, "WMAServer: Got to the end of main().");
    }

    static {
        File file = new File(ToolkitDirs.API + "internal.config");
        try {
            PropertiesFile propertiesFile = new PropertiesFile(file);
            String string = propertiesFile.getProperty("com.sun.midp.io.j2me.sms.CBSPort");
            if (string != null && string.length() > 0) {
                cbsTunnelPort = string;
            }
        }
        catch (IOException iOException) {
            Debug.warning((String)"Couldn't read internal.config");
        }
        controlPort = 0;
        timeToDie = false;
        lastPingTime = 0L;
        nextPhoneNumber = 5550000L;
        clientPorts = new HashMap();
        clientTypes = new HashMap();
        checkSegments = true;
        ackSocket = null;
        ackPort = 0;
        queue = null;
        timeStampQueue = null;
        controller = null;
        receiver = null;
        router = null;
        packetDelayMS = 0L;
        randomPacketLoss = 0.0;
        multipartCache = new HashMap();
        wmaS = null;
        cookieGenerator = new Random();
        cookieToMonitorMap = new Hashtable();
    }

    static class ZerothPacketSender
    implements Runnable {
        private ArrayList ports;
        private DatagramPacket packet;
        private String cookie;

        ZerothPacketSender(ArrayList arrayList, DatagramPacket datagramPacket, String string) {
            this.ports = arrayList;
            this.packet = datagramPacket;
            this.cookie = string;
        }

        public void run() {
            debug.println(3, "ZerothPacketSender starting...");
            try {
                Thread.sleep(200L);
                int n = this.ports.size();
                for (int i = 0; i < n; ++i) {
                    int n2 = (Integer)this.ports.get(i);
                    AcknowledgingSender.sendPacketPlusAck(this.packet, n2, this.cookie);
                }
            }
            catch (Exception exception) {
                debug.exception(1, (Throwable)exception);
            }
            debug.println(3, "ZerothPacketSender done.");
        }
    }

    static class AcknowledgingSender
    implements Runnable {
        private ArrayList ports;
        private ArrayList packets;
        private int[] monitor;
        private String cookie;
        private Map portToPacketNumMap;

        AcknowledgingSender(ArrayList arrayList, ArrayList arrayList2, int[] nArray, String string) {
            this.ports = arrayList;
            this.packets = arrayList2;
            this.monitor = nArray;
            this.cookie = string;
            this.portToPacketNumMap = new HashMap();
            Integer n = new Integer(1);
            int n2 = arrayList.size();
            for (int i = 0; i < n2; ++i) {
                Integer n3 = (Integer)arrayList.get(i);
                this.portToPacketNumMap.put(n3, n);
            }
            debug.println(2, "AcknowledgingSender to {0} recipients with {1} packets", n2, arrayList2.size());
            debug.println(2, "Cookie is {0}", (Object)string);
        }

        static void sendPacketPlusAck(DatagramPacket datagramPacket, int n, String string) {
            boolean bl = false;
            DatagramRecord datagramRecord = new DatagramRecord();
            try {
                datagramRecord.parseData(datagramPacket.getData(), datagramPacket.getLength());
                datagramRecord.setHeader("Ack-Port", String.valueOf(ackPort));
                datagramRecord.setHeader("Ack-Cookie", string);
                byte[] byArray = datagramRecord.getFormattedData();
                DatagramPacket datagramPacket2 = new DatagramPacket(byArray, byArray.length, InetAddress.getLocalHost(), receivePort);
                debug.println(3, "Sending packet to port {0}", n);
                WMAServer.sendPacket(datagramPacket2, n);
            }
            catch (Exception exception) {
                debug.exception(3, (Throwable)exception);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            int n = this.packets.size();
            int[] nArray = this.monitor;
            synchronized (this.monitor) {
                while (this.portToPacketNumMap.size() > 0) {
                    while (this.monitor[0] == 0) {
                        try {
                            this.monitor.wait();
                        }
                        catch (InterruptedException interruptedException) {
                            debug.exception(1, (Throwable)interruptedException);
                        }
                    }
                    Integer n2 = new Integer(this.monitor[0]);
                    int n3 = (Integer)this.portToPacketNumMap.get(n2);
                    debug.println(3, "Notified for port {0} up to packet {1}", (Object)n2, n3);
                    if (n3 < n - 1) {
                        debug.println(3, "Sending next packet with ack.");
                        AcknowledgingSender.sendPacketPlusAck((DatagramPacket)this.packets.get(n3), n2, this.cookie);
                        this.portToPacketNumMap.put(n2, new Integer(n3 + 1));
                    } else {
                        debug.println(3, "Last packet. No ack.");
                        try {
                            WMAServer.sendPacket((DatagramPacket)this.packets.get(n3), n2);
                        }
                        catch (Exception exception) {
                            debug.println(3, "Sending last packet caught: " + exception);
                        }
                        this.portToPacketNumMap.remove(n2);
                    }
                    this.monitor[0] = 0;
                }
                // ** MonitorExit[var2_2] (shouldn't be in output)
                debug.println(2, "Completed AcknowledgingSender with cookie {0}", (Object)this.cookie);
                return;
            }
        }
    }

    static class AckNotifier
    implements Runnable {
        AckNotifier() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        public void run() {
            while (true) {
                try {
                    while (true) {
                        int[] nArray;
                        byte[] byArray = new byte[40];
                        DatagramPacket datagramPacket = new DatagramPacket(byArray, byArray.length);
                        ackSocket.receive(datagramPacket);
                        byte[] byArray2 = datagramPacket.getData();
                        String string = new String(byArray2);
                        int n = string.indexOf("\n");
                        String string2 = string.substring(4, n);
                        debug.println(3, "Received ACK for cookie " + string2);
                        int[] nArray2 = nArray = (int[])cookieToMonitorMap.get(string2);
                        // MONITORENTER : nArray
                        nArray[0] = datagramPacket.getPort();
                        nArray.notify();
                        // MONITOREXIT : nArray2
                    }
                }
                catch (Exception exception) {
                    debug.exception(1, (Throwable)exception);
                    continue;
                }
                break;
            }
        }
    }

    static class Controller
    implements Runnable {
        Controller() {
            debug.println(4, "Controller Thread: constructing.");
        }

        public void run() {
            debug.println(4, "Controller Thread: running.");
            int n = 1;
            while (!WMAServer.isTimeToDie()) {
                try {
                    Socket socket = controlSocket.accept();
                    try {
                        Properties properties = new PropertiesFile(emulatorPropertiesLocation).getPropertiesList();
                        WMAServer.refreshFromProperties(properties);
                    }
                    catch (IOException iOException) {
                        debug;
                        Debug.warning((String)"Unable to load emulator.properties");
                    }
                    Thread thread = new Thread((Runnable)new ControlHandler(socket), String.valueOf(n++));
                    thread.setDaemon(true);
                    thread.start();
                }
                catch (Throwable throwable) {}
            }
            debug.println(2, "WMA server is no longer accepting new connections.");
        }
    }

    static class DatagramRouter
    implements Runnable {
        DatagramRouter() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (!WMAServer.isTimeToDie()) {
                DatagramPacket datagramPacket = null;
                long l = 0L;
                Vector vector = queue;
                synchronized (vector) {
                    while (queue.size() == 0) {
                        try {
                            queue.wait();
                            if (!WMAServer.isTimeToDie()) continue;
                            return;
                        }
                        catch (InterruptedException interruptedException) {
                        }
                    }
                    datagramPacket = (DatagramPacket)queue.elementAt(0);
                    queue.removeElementAt(0);
                    l = (Long)timeStampQueue.elementAt(0);
                    timeStampQueue.removeElementAt(0);
                }
                long l2 = l + packetDelayMS;
                long l3 = l2 - System.currentTimeMillis();
                if (l3 > 1L) {
                    try {
                        Thread.currentThread();
                        Thread.sleep(l3);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                try {
                    WMAServer.routeMessage(datagramPacket);
                }
                catch (Exception exception) {
                    debug.exception(2, (Throwable)exception);
                }
            }
            debug.println(2, "WMA server is no longer routing datagrams now.");
        }
    }

    static class DatagramReader
    implements Runnable {
        DatagramReader() {
            queue = new Vector(256);
            timeStampQueue = new Vector(256);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            debug.println(4, "DatagramReader: run called.");
            try {
                while (!WMAServer.isTimeToDie()) {
                    byte[] byArray = new byte[1500];
                    DatagramPacket datagramPacket = new DatagramPacket(byArray, byArray.length);
                    receiveSocket.receive(datagramPacket);
                    debug.println(4, "WMAServer received a DG packet.");
                    Vector vector = queue;
                    synchronized (vector) {
                        queue.addElement(datagramPacket);
                        timeStampQueue.addElement(new Long(System.currentTimeMillis()));
                        queue.notify();
                    }
                }
            }
            catch (Exception exception) {
                debug.exception(2, (Throwable)exception);
            }
            debug.println(2, "WMA Server has stopped listening for datagrams now.");
        }
    }
}

