/*
 * Decompiled with CFR 0.152.
 */
package com.sun.kvem.midp.io.j2se.wma.server;

import com.sun.kvem.environment.Debug;
import com.sun.kvem.midp.io.j2se.wma.server.WMAServer;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.Socket;

class ControlHandler
implements Runnable {
    private static Debug debug = Debug.create((Class)ControlHandler.class);
    private Socket clientSocket;
    private BufferedReader input;
    private OutputStream output;
    private int clientType;
    private String phoneNumber;

    public void debugPrint(String string) {
        debug.println(3, "ControlHandler on Thread " + Thread.currentThread().getName() + " (" + this.phoneNumber + ") : " + string);
    }

    ControlHandler(Socket socket) throws Exception {
        this.debugPrint("ControlHandler: constructing.");
        this.clientSocket = socket;
        this.input = new BufferedReader(new InputStreamReader(this.clientSocket.getInputStream()));
        this.output = this.clientSocket.getOutputStream();
        this.clientType = 0;
        this.phoneNumber = null;
    }

    public void run() {
        this.debugPrint("ControlHandler's run called.");
        try {
            this.handleClient();
        }
        catch (Exception exception) {
            this.debugPrint("run caught " + exception);
            debug.exception(3, (Throwable)exception);
        }
        this.debugPrint("Ending ControlHandler.");
    }

    private void handleClient() throws Exception {
        this.debugPrint("Handling client...");
        String string = this.input.readLine();
        if (string.equals("PingWMAServer")) {
            this.debugPrint("Got a ping.");
            WMAServer.notifyOfPing();
            this.output.write("pong\n".getBytes());
            return;
        }
        this.clientType = Integer.parseInt(string);
        if (this.clientType == 1 || this.clientType == 2 || this.clientType == 3 || this.clientType == 4) {
            this.debugPrint("client type is: " + this.clientType);
            this.output.write("OK\n".getBytes());
            if (this.negotiatePhoneNumber()) {
                this.negotiatePorts();
                WMAServer.setClientType(this.phoneNumber, this.clientType);
                this.handleLiveClient();
            }
        } else {
            this.debugPrint("requested unsupported client type: " + string);
            this.output.write("HUH?\n".getBytes());
        }
    }

    public boolean negotiatePhoneNumber() throws Exception {
        boolean bl = true;
        this.debugPrint("negotiating phone number");
        this.phoneNumber = this.input.readLine();
        this.debugPrint("Phone number read: " + this.phoneNumber);
        String string = null;
        string = this.phoneNumber.equals("unspecified") ? (this.phoneNumber = WMAServer.registerClient()) : (!(bl = WMAServer.registerClient(this.phoneNumber)) ? "NA +" + String.valueOf(WMAServer.peekNextPhoneNumber()) : "OK");
        this.debugPrint("Sending to client: " + string);
        this.output.write(string.getBytes());
        this.output.write("\n".getBytes());
        return bl;
    }

    public void negotiatePorts() throws Exception {
        this.debugPrint("Negotiating ports.");
        try {
            String string = this.input.readLine();
            this.debugPrint("Read client's port : " + string);
            WMAServer.setClientPort(this.phoneNumber, Integer.parseInt(string));
        }
        catch (Exception exception) {
            WMAServer.unregisterClient(this.phoneNumber);
            throw exception;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleLiveClient() throws Exception {
        this.debugPrint("Handling client.");
        try {
            while (true) {
                this.debugPrint("Waiting for client's command...");
                String string = this.input.readLine();
                this.debugPrint("Command: " + string);
                if (string.equals("NEWNUM")) {
                    this.changePhoneNumber();
                    continue;
                }
                if (string.equals("GETLISTENERS")) {
                    this.sendListeners();
                    continue;
                }
                if (string.equals("BYE")) break;
            }
        }
        finally {
            WMAServer.unregisterClient(this.phoneNumber);
        }
    }

    private void changePhoneNumber() throws Exception {
        if (this.phoneNumber.equals(".Default Gateway.")) {
            this.debugPrint("Gateway client illegally asked to change phone number");
            this.output.write("BAD\n".getBytes());
            return;
        }
        String string = this.phoneNumber;
        this.debugPrint("Sending READY to client...");
        this.output.write("READY\n".getBytes());
        this.negotiatePhoneNumber();
        if (this.phoneNumber != string) {
            WMAServer.setClientPort(this.phoneNumber, WMAServer.getClientPort(string));
            WMAServer.unregisterClient(string);
        }
    }

    private void sendListeners() throws Exception {
        if (this.clientType != 4) {
            this.debugPrint("Non-console client " + this.phoneNumber + " illegally asked for a client list.");
            this.output.write("-1\n".getBytes());
            return;
        }
        String[] stringArray = WMAServer.getAddressableClients();
        int n = 0;
        if (stringArray != null) {
            n = stringArray.length;
        }
        this.output.write(String.valueOf(n).getBytes());
        this.output.write("\n".getBytes());
        if (n > 0) {
            for (int i = 0; i < n; ++i) {
                this.output.write(stringArray[i].getBytes());
                this.output.write("\n".getBytes());
            }
        }
    }
}

