/*
 * Decompiled with CFR 0.152.
 */
package com.sun.kvem.midp.io.j2se.wma.common.parse;

public class MMSAddress {
    public static final int INVALID_ADDRESS = -1;
    public static final int EMAIL = 0;
    public static final int GLOBAL_PHONE_NUMBER = 1;
    public static final int IPV4 = 2;
    public static final int IPV6 = 3;
    public static final int SHORTCODE = 4;
    public static final int APP_ID = 5;
    public String address;
    public String appId;
    public int type;

    private static boolean hex(char c) {
        return MMSAddress.digit(c) || c >= 'A' && c <= 'F';
    }

    private static boolean alpha(char c) {
        return c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z';
    }

    private static boolean digit(char c) {
        return c >= '0' && c <= '9';
    }

    static boolean parsePhoneNumber(String string, int n, MMSAddress mMSAddress) {
        int n2 = string.length();
        if (n < 0 || n >= n2) {
            return false;
        }
        int n3 = n;
        char c = string.charAt(n);
        if (c == '+' && n2 == ++n) {
            return false;
        }
        int n4 = 0;
        while (n < n2 && MMSAddress.digit(c = string.charAt(n))) {
            ++n4;
            ++n;
        }
        if (n4 == 0) {
            return false;
        }
        if (n == n2) {
            mMSAddress.set(string.substring(n3), null, 1);
            return true;
        }
        if (c == ':') {
            mMSAddress.set(string.substring(n3, n), null, 1);
            return MMSAddress.parseApplicationId(string, n, mMSAddress);
        }
        return false;
    }

    static boolean parseIpv4(String string, int n, MMSAddress mMSAddress) {
        int n2 = string.length();
        if (n <= 0 || n >= n2) {
            return false;
        }
        int n3 = n;
        for (int i = 1; i < 5; ++i) {
            char c;
            int n4;
            for (n4 = 0; n4 < 3 && n < n2 && MMSAddress.digit(c = string.charAt(n)); ++n, ++n4) {
            }
            if (n4 == 0 || n4 == 3 && ((string.charAt(n - 3) - 48) * 10 + (string.charAt(n - 2) - 48)) * 10 + (string.charAt(n - 1) - 48) > 255) {
                return false;
            }
            if (n == n2) {
                if (i == 4) {
                    mMSAddress.set(string.substring(n3), null, 2);
                    return true;
                }
                return false;
            }
            c = string.charAt(n);
            if (c == ':') {
                mMSAddress.set(string.substring(n3, n), null, 2);
                return MMSAddress.parseApplicationId(string, n, mMSAddress);
            }
            if (c != '.') {
                return false;
            }
            ++n;
        }
        return false;
    }

    static boolean parseIpv6(String string, int n, MMSAddress mMSAddress) {
        int n2 = string.length();
        if (n <= 0 || n >= n2) {
            return false;
        }
        int n3 = n;
        for (int i = 1; i < 9; ++i) {
            char c;
            int n4;
            for (n4 = 0; n4 < 4 && n < n2 && MMSAddress.hex(c = string.charAt(n)); ++n, ++n4) {
            }
            if (n4 == 0) {
                return false;
            }
            if (n == n2) {
                if (i == 8) {
                    mMSAddress.set(string.substring(n3), null, 3);
                    return true;
                }
                return false;
            }
            c = string.charAt(n);
            if (c == ':') {
                if (i == 8) {
                    mMSAddress.set(string.substring(n3, n), null, 3);
                    return MMSAddress.parseApplicationId(string, n, mMSAddress);
                }
            } else {
                return false;
            }
            ++n;
        }
        return false;
    }

    static boolean parseShortCode(String string, int n, MMSAddress mMSAddress) {
        int n2 = string.length();
        if (n > n2) {
            return false;
        }
        if (n == n2) {
            return false;
        }
        int n3 = n;
        while (n < string.length()) {
            char c = string.charAt(n);
            if (!MMSAddress.digit(c) && !MMSAddress.alpha(c)) {
                return false;
            }
            ++n;
        }
        mMSAddress.set(string.substring(n3), null, 4);
        return true;
    }

    static boolean parseApplicationId(String string, int n, MMSAddress mMSAddress) {
        int n2 = string.length();
        if (n <= 0 || n >= n2 || n2 - n > 33 || n2 - n < 2 || string.charAt(n) != ':') {
            return false;
        }
        int n3 = ++n;
        int n4 = 0;
        while (n < n2) {
            char c = string.charAt(n);
            n4 = 0;
            while (n < n2 && ((c = string.charAt(n)) == '_' || MMSAddress.digit(c) || MMSAddress.alpha(c))) {
                ++n;
                ++n4;
            }
            if (n == n2) {
                if (mMSAddress.type == -1) {
                    mMSAddress.set(null, string.substring(n3), 5);
                } else {
                    mMSAddress.setAppid(string.substring(n3));
                }
                return true;
            }
            if (n4 == 0 || c != '.') {
                return false;
            }
            ++n;
        }
        return false;
    }

    private static boolean specials(char c) {
        return c == '(' || c == ')' || c == '<' || c == '>' || c == '@' || c == ',' || c == ';' || c == ':' || c == '\\' || c == '\"' || c == '.' || c == '[' || c == ']';
    }

    private static boolean isChar(char c) {
        return c >= '\u0000' && c <= '\u007f';
    }

    private static boolean asciiControl(char c) {
        return c >= '\u0000' && c <= '\u001f';
    }

    private static boolean atomChar(char c) {
        return c <= '\u007f' && c > ' ' && !MMSAddress.specials(c);
    }

    private static int linearWhiteSpaceSeq(String string, int n, int n2) {
        while (n < n2) {
            char c = string.charAt(n);
            if (c != ' ' && c != '\t') {
                if (c == '\r') {
                    if (n == n2 - 1 || string.charAt(n + 1) != '\n') {
                        return n;
                    }
                    ++n;
                } else {
                    return n;
                }
            }
            ++n;
        }
        return n;
    }

    static boolean parseEmail(String string, int n, MMSAddress mMSAddress) {
        int n2 = string.length();
        if (n <= 0 || n >= n2) {
            return false;
        }
        int n3 = n;
        if (string.charAt(n2 - 1) == ';') {
            if ((n = MMSAddress.isPhrase(string, n, n2 - 1)) <= 0) {
                return false;
            }
            if (n >= n2 - 1 || string.charAt(n) != ':') {
                return false;
            }
            if (++n == n2 - 1) {
                mMSAddress.set(string.substring(n3), null, 0);
                return true;
            }
            if ((n = MMSAddress.isMailbox(string, n, n2 - 1)) <= 0) {
                return false;
            }
            while (n < n2 - 1) {
                if (n >= n2 - 2 && string.charAt(n) != ',') {
                    return false;
                }
                if ((n = MMSAddress.isMailbox(string, n + 1, n2 - 1)) > 0) continue;
                return false;
            }
            if (n == n2 - 1) {
                mMSAddress.set(string.substring(n3), null, 0);
                return true;
            }
            return false;
        }
        if (MMSAddress.isMailbox(string, n, n2) == n2) {
            mMSAddress.set(string.substring(n3), null, 0);
            return true;
        }
        return false;
    }

    private static int isMailbox(String string, int n, int n2) {
        if (n2 > string.length()) {
            n2 = string.length();
        }
        if (n >= n2) {
            return -1;
        }
        int n3 = n;
        if ((n = MMSAddress.isLocalAtDomain(string, n3, n2)) > 0) {
            return n;
        }
        n = n3;
        if (string.charAt(n) != '<' && (n = MMSAddress.isPhrase(string, n3, n2)) < 0) {
            return -1;
        }
        if (n == n2 || string.charAt(n) != '<') {
            return -1;
        }
        if (++n == n2) {
            return -1;
        }
        boolean bl = false;
        while (string.charAt(n) == '@') {
            bl = true;
            if ((n = MMSAddress.isDomain(string, n + 1, n2)) < 0) {
                return -1;
            }
            if (n == n2) {
                return -1;
            }
            if (string.charAt(n) == ':') break;
            while (string.charAt(n) == ',') {
                if (++n != n2 && string.charAt(n) != ':') continue;
                return -1;
            }
        }
        if (bl) {
            if (n == n2 || string.charAt(n) != ':') {
                return -1;
            }
            ++n;
        }
        if ((n = MMSAddress.isLocalAtDomain(string, n, n2)) <= 0) {
            return -1;
        }
        if (n < n2 && string.charAt(n) == '>') {
            return n + 1;
        }
        return -1;
    }

    private static int isLocalPart(String string, int n, int n2) {
        return MMSAddress.isSequenceOfAtomAndText(string, n, n2, '\"', '\"', true);
    }

    private static int isPhrase(String string, int n, int n2) {
        return MMSAddress.isSequenceOfAtomAndText(string, n, n2, '\"', '\"', false);
    }

    private static int isDomain(String string, int n, int n2) {
        return MMSAddress.isSequenceOfAtomAndText(string, n, n2, '[', ']', true);
    }

    private static int isSequenceOfAtomAndText(String string, int n, int n2, char c, char c2, boolean bl) {
        if (n >= string.length()) {
            return -1;
        }
        if (n2 > string.length()) {
            n2 = string.length();
        }
        boolean bl2 = false;
        boolean bl3 = false;
        int n3 = n;
        while (n < n2) {
            char c3 = string.charAt(n);
            if (c3 == c) {
                if (c == c2) {
                    bl2 = !bl2;
                } else {
                    if (bl2) {
                        return -1;
                    }
                    bl2 = true;
                }
                bl3 = true;
            } else if (c3 == c2) {
                if (!bl2) {
                    return -1;
                }
                bl2 = false;
            } else if (c3 == '\\') {
                if (!bl2 || n == n2 - 1) {
                    return -1;
                }
                if (!MMSAddress.alpha(c3 = string.charAt(++n))) {
                    return -1;
                }
            } else if (bl && c3 == '.') {
                if (n == n3 || n - n3 > 0 && string.charAt(n - 1) == '.') {
                    return -1;
                }
            } else if (bl2) {
                if (c3 == ' ' || c3 == '\t' || c3 == '\r') {
                    if ((n = MMSAddress.linearWhiteSpaceSeq(string, n, n2)) < 0) {
                        return -1;
                    }
                    --n;
                }
            } else {
                if (!MMSAddress.atomChar(c3)) break;
                bl3 = true;
            }
            ++n;
        }
        if (bl2 || !bl3 || bl && n > n3 && string.charAt(n - 1) == '.') {
            return -1;
        }
        return n;
    }

    private static int isLocalAtDomain(String string, int n, int n2) {
        if (n2 > string.length()) {
            n2 = string.length();
        }
        if (n >= n2) {
            return -1;
        }
        if ((n = MMSAddress.isLocalPart(string, n, n2)) <= 0) {
            return -1;
        }
        if (n == n2 || string.charAt(n) != '@') {
            return -1;
        }
        return MMSAddress.isDomain(string, ++n, n2);
    }

    public static MMSAddress getParsedMMSAddress(String string) {
        return MMSAddress.getParsedMMSAddress(string, null);
    }

    public static MMSAddress getParsedMMSAddress(String string, MMSAddress mMSAddress) {
        if (string == null || !string.startsWith("mms://")) {
            return null;
        }
        if (mMSAddress == null) {
            mMSAddress = new MMSAddress();
        }
        if (MMSAddress.parsePhoneNumber(string, 6, mMSAddress) || MMSAddress.parseIpv4(string, 6, mMSAddress) || MMSAddress.parseIpv6(string, 6, mMSAddress) || MMSAddress.parseEmail(string, 6, mMSAddress) || MMSAddress.parseShortCode(string, 6, mMSAddress) || MMSAddress.parseApplicationId(string, 6, mMSAddress)) {
            return mMSAddress;
        }
        return null;
    }

    MMSAddress() {
        this.clear();
    }

    MMSAddress(String string, String string2, int n) {
        this.set(string, string2, n);
    }

    void clear() {
        this.appId = null;
        this.address = null;
        this.type = -1;
    }

    void set(String string, String string2, int n) {
        this.address = string;
        this.appId = string2;
        this.type = n;
    }

    void setAppid(String string) {
        this.appId = string;
    }

    String getMMSAddressString() {
        if (this.type == -1 || this.address == null && this.appId == null) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer("mms://");
        if (this.address != null) {
            stringBuffer.append(this.address);
        }
        if (this.appId != null) {
            stringBuffer.append(":").append(this.appId);
        }
        return stringBuffer.toString();
    }
}

