/*
 * Decompiled with CFR 0.152.
 */
package com.sun.kvem.midp.io.j2se.wma.common;

import java.io.ByteArrayOutputStream;

public class TextEncoder {
    protected static final byte[] chars7Bit = new byte[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 95, 96, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 127};
    protected static final byte[] escaped7BitChars = new byte[]{20, 40, 41, 47, 60, 61, 62, 64, 101};
    protected static final char[] charsUCS2 = new char[]{'@', '\u00a3', '$', '\u00a5', '\u00e8', '\u00e9', '\u00f9', '\u00ec', '\u00f2', '\u00c7', '\n', '\u00d8', '\u00f8', '\r', '\u00c5', '\u00e5', '\u0394', '_', '\u03a6', '\u0393', '\u039b', '\u03a9', '\u03a0', '\u03a8', '\u03a3', '\u0398', '\u039e', '\u001b', '\u00c6', '\u00e6', '\u00df', '\u00c9', ' ', '!', '\"', '#', '\u00a4', '%', '&', '\'', '(', ')', '*', '+', ',', '-', '.', '/', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', ':', ';', '<', '=', '>', '?', '\u00a1', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', '\u00c4', '\u00d6', '\u00d1', '\u00dc', '\u00a7', '\u00bf', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '\u00e4', '\u00f6', '\u00f1', '\u00fc', '\u00e0'};
    protected static final char[] escapedUCS2 = new char[]{'^', '{', '}', '\\', '[', '~', ']', '|', '\u20ac'};

    public static byte[] encode(byte[] byArray) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(byArray.length);
        for (int i = 0; i < byArray.length; i += 2) {
            int n;
            int n2;
            for (n2 = 0; n2 < charsUCS2.length; ++n2) {
                if (byArray[i] != charsUCS2[n2] >> 8 || byArray[i + 1] != (charsUCS2[n2] & 0xFF)) continue;
                byteArrayOutputStream.write(chars7Bit[n2]);
                break;
            }
            if (n2 != charsUCS2.length) continue;
            for (n = 0; n < escapedUCS2.length; ++n) {
                if (byArray[i] != escapedUCS2[n] >> 8 || byArray[i + 1] != (escapedUCS2[n] & 0xFF)) continue;
                byteArrayOutputStream.write(27);
                byteArrayOutputStream.write(escaped7BitChars[n]);
                break;
            }
            if (n != escapedUCS2.length) continue;
            return null;
        }
        return byteArrayOutputStream.toByteArray();
    }

    public static byte[] decode(byte[] byArray) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(byArray.length * 2);
        block0: for (int i = 0; i < byArray.length; ++i) {
            int n;
            if (byArray[i] == 27) {
                ++i;
                for (n = 0; n < escaped7BitChars.length; ++n) {
                    if (byArray[i] != escaped7BitChars[n]) continue;
                    byteArrayOutputStream.write(escapedUCS2[n] >> 8);
                    byteArrayOutputStream.write(escapedUCS2[n] & 0xFF);
                    continue block0;
                }
                continue;
            }
            for (n = 0; n < chars7Bit.length; ++n) {
                if (byArray[i] != chars7Bit[n]) continue;
                byteArrayOutputStream.write(charsUCS2[n] >> 8);
                byteArrayOutputStream.write(charsUCS2[n] & 0xFF);
                continue block0;
            }
        }
        return byteArrayOutputStream.toByteArray();
    }

    public static String toString(byte[] byArray) {
        char[] cArray = new char[byArray.length / 2];
        for (int i = 0; i < byArray.length; i += 2) {
            cArray[i / 2] = (char)((byArray[i] << 8) + (byArray[i + 1] & 0xFF));
        }
        return new String(cArray);
    }

    public static byte[] toByteArray(String string) {
        char[] cArray = string.toCharArray();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(string.length());
        for (int i = 0; i < cArray.length; ++i) {
            byteArrayOutputStream.write(cArray[i] >> 8);
            byteArrayOutputStream.write(cArray[i] & 0xFF);
        }
        return byteArrayOutputStream.toByteArray();
    }
}

