/*
 * Decompiled with CFR 0.152.
 */
package com.sun.kvem.midp.io.j2se.wma.client;

import com.sun.kvem.Device;
import com.sun.kvem.Screen;
import com.sun.kvem.environment.Debug;
import com.sun.kvem.midp.io.j2se.wma.client.PhoneNumberNotAvailableException;
import com.sun.kvem.midp.io.j2se.wma.client.WMAClient;
import com.sun.kvem.util.ToolkitResources;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;

public class WMAClientBridge {
    private static final Debug debug = Debug.create((Class)WMAClientBridge.class);
    private static WMAClient wmaClient = null;

    public static byte[] initializeWMASupport() {
        String string = "";
        if (Device.getProperty("dont_launch_wma_server") == null) {
            if (wmaClient == null) {
                try {
                    String string2 = null;
                    string2 = Device.getProperty("wma.client.phoneNumber");
                    if ("".equals(string2)) {
                        string2 = null;
                    }
                    wmaClient = new WMAClient(string2, 3);
                    try {
                        wmaClient.connect();
                    }
                    catch (PhoneNumberNotAvailableException phoneNumberNotAvailableException) {
                        wmaClient = new WMAClient(null, 3);
                        wmaClient.connect();
                        Object[] objectArray = new Object[]{phoneNumberNotAvailableException.getRequestedNumber(), wmaClient.getPhoneNumber()};
                        System.out.println(ToolkitResources.format((String)"WMA_INIT_PHONE_NUMBER_NA", (Object[])objectArray));
                    }
                    String string3 = wmaClient.getPhoneNumber();
                    WMAClientBridge.addPhoneNumToDeviceWindowTitle(string3);
                    string = String.valueOf(wmaClient.getClientTrafficPort()) + '\n' + String.valueOf(wmaClient.getServerTrafficPort()) + '\n' + string3;
                }
                catch (Exception exception) {
                    debug.exception(1, (Throwable)exception);
                    System.err.println(ToolkitResources.getString((String)"WMA_INIT_FAILED"));
                }
            }
        } else {
            debug.println(2, "Got the flag to skip launching WMA Server.");
        }
        debug.println(3, "Returning from WMAClientBridge: " + string);
        return string.getBytes();
    }

    private static void addPhoneNumToDeviceWindowTitle(String string) {
        if (Device.getBooleanProperty("kvem.webemulator", false)) {
            return;
        }
        Screen screen = Screen.getInstance();
        JFrame jFrame = (JFrame)SwingUtilities.getAncestorOfClass(JFrame.class, screen.getComponent());
        String string2 = jFrame.getTitle();
        String string3 = string + " - " + string2;
        jFrame.setTitle(string3);
    }

    public static boolean getWeLaunchedServer() {
        return wmaClient == null ? false : wmaClient.getWeLaunchedServer();
    }

    public static void cleanupWMASupport() {
        if (wmaClient != null) {
            debug.println(2, "Calling unregister from server via bridge");
            try {
                wmaClient.unregisterFromServer();
            }
            catch (Exception exception) {
                debug.exception(1, (Throwable)exception);
            }
        }
    }

    public static boolean ensureWMAServerIsPresent() {
        return wmaClient.ensureServerIsPresent();
    }
}

