/*
 * Decompiled with CFR 0.152.
 */
package com.sun.kvem.midp.io.j2se.wma.client;

import com.sun.kvem.environment.Debug;
import com.sun.kvem.midp.io.j2se.wma.Message;
import com.sun.kvem.midp.io.j2se.wma.MultipartMessage;
import com.sun.kvem.midp.io.j2se.wma.WMAMessage;
import com.sun.kvem.midp.io.j2se.wma.client.PhoneNumberNotAvailableException;
import com.sun.kvem.midp.io.j2se.wma.common.DatagramRecord;
import com.sun.kvem.midp.io.j2se.wma.common.parse.MMSAddress;
import com.sun.kvem.midp.io.j2se.wma.server.WMAServer;
import com.sun.kvem.util.ToolkitResources;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.List;
import java.util.Vector;

public class WMAClient {
    private static Debug debug = Debug.create((Class)WMAClient.class);
    public static final int CONNECT_TIMEOUT_MS = 1000;
    public static final int CONNECTION_ATTEMPTS = 5;
    private static final int BUFFER_SIZE = 1500;
    public static final int[] SMS_RESTRICTED_PORTS = new int[]{2805, 2923, 2948, 2949, 5502, 5503, 5508, 5511, 5512, 9200, 9201, 9202, 9203, 9207, 49996, 49999};
    private static final InetAddress wmaServerHost = WMAClient.initializeLocalHost();
    private static final int SERVER_IS_DEAD = 0;
    private static final int SERVER_IS_ALIVE = 1;
    private static final int SERVER_ALREADY_LAUNCHING = 2;
    private static File fileLock = null;
    public static final String GATEWAY_PHONE_NUMBER = ".Default Gateway.";
    public static final int SEND_ONLY = 1;
    public static final int RECEIVE_ONLY = 2;
    public static final int SEND_AND_RECEIVE = 3;
    private static final int CONSOLE_CLIENT = 4;
    private String phoneNumber;
    private int clientType;
    private int controlPort;
    private Socket connection;
    private BufferedReader input;
    private OutputStream output;
    private int clientTrafficPort;
    private int serverTrafficPort;
    private DatagramSocket trafficSocket;
    private Thread receiver;
    private List queue;
    private MessageListener listener;
    private boolean weLaunchedServer;

    private static InetAddress initializeLocalHost() {
        InetAddress inetAddress = null;
        try {
            inetAddress = InetAddress.getLocalHost();
        }
        catch (UnknownHostException unknownHostException) {
            System.err.println("WMAClient: localhost has no IP address: " + unknownHostException);
        }
        return inetAddress;
    }

    public static void pingServer() throws IOException {
        debug.println(3, "Pinging Server...");
        int[] nArray = WMAClient.getServerStatusFileValues();
        Socket socket = new Socket(wmaServerHost, nArray[0]);
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(socket.getInputStream()));
        OutputStream outputStream = socket.getOutputStream();
        debug.println(4, "Sending ping now.");
        outputStream.write("PingWMAServer\n".getBytes());
        String string = bufferedReader.readLine();
        bufferedReader.close();
        outputStream.close();
        socket.close();
        debug.println(4, "Got response: \"" + string + '\"');
        if (!string.equals("pong")) {
            throw new IOException("Not a WMA Server.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int[] getServerStatusFileValues() throws IOException {
        debug.println(2, "Reading server ports from status file...");
        BufferedReader bufferedReader = new BufferedReader(new FileReader(WMAServer.STAT_FILE_NAME));
        try {
            String string = bufferedReader.readLine();
            int n = string.indexOf(58);
            String string2 = string.substring(0, n);
            String string3 = string.substring(n + 1);
            int[] nArray = new int[]{Integer.parseInt(string2), Integer.parseInt(string3)};
            return nArray;
        }
        finally {
            bufferedReader.close();
        }
    }

    private static void releaseInterprocessLock() {
        debug.println(3, "Cleaning up interprocess lock...");
        if (!fileLock.delete()) {
            // empty if block
        }
        fileLock = null;
    }

    private static int getServerStatus() {
        Object object;
        int n = 2;
        boolean bl = false;
        try {
            object = WMAServer.STAT_FILE_NAME + ".lock";
            debug.println(2, "WMA lockfile: " + (String)object);
            fileLock = new File((String)object);
            bl = fileLock.createNewFile();
        }
        catch (IOException iOException) {
            debug.println(3, "Failed to create new lockfile: " + iOException);
        }
        if (bl) {
            fileLock.deleteOnExit();
            debug.println(3, "Successfully created lockfile.");
            object = new File(WMAServer.STAT_FILE_NAME);
            if (((File)object).canRead()) {
                try {
                    WMAClient.pingServer();
                    WMAClient.releaseInterprocessLock();
                    n = 1;
                }
                catch (IOException iOException) {
                    n = 0;
                }
            } else {
                n = 0;
            }
        }
        debug.println(2, "Server status is " + (n == 0 ? "DEAD" : (n == 1 ? "ALIVE" : "LAUNCHING ALREADY")));
        return n;
    }

    public static boolean ensureServerIsPresent() {
        debug.println(2, "Ensuring WMA server is present");
        int n = WMAClient.getServerStatus();
        boolean bl = false;
        if (n == 1) {
            return bl;
        }
        File file = new File(WMAServer.STAT_FILE_NAME);
        if (n == 0) {
            debug.println(2, "Launching the server...");
            try {
                WMAServer.launch(true);
                bl = true;
            }
            catch (Exception exception) {
                debug.exception(1, (Throwable)exception);
                System.err.println(ToolkitResources.getString((String)"WMA_INIT_FAILED"));
            }
            boolean bl2 = false;
            int n2 = 100;
            for (int i = 0; i < 5000; i += n2) {
                try {
                    Thread.currentThread();
                    Thread.sleep(n2);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (!file.exists()) continue;
                bl2 = true;
                break;
            }
            if (bl2) {
                try {
                    Thread.currentThread();
                    Thread.sleep(n2);
                }
                catch (InterruptedException interruptedException) {}
            } else {
                System.err.println(ToolkitResources.getString((String)"WMA_INIT_FAILED"));
            }
            WMAClient.releaseInterprocessLock();
        } else if (n == 2) {
            try {
                WMAClient.pingServer();
                debug.println(2, "WMA server found!");
            }
            catch (IOException iOException) {
                debug.println(2, "Waiting for WMA message routing server to activate...");
                int n3 = 100;
                for (int i = 0; i < 5000; i += n3) {
                    try {
                        Thread.currentThread();
                        Thread.sleep(n3);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    if (!file.exists()) continue;
                    debug.println(2, "WMA server found!");
                    break;
                }
                debug.println(2, "WMA Server was not detected.");
            }
        }
        return bl;
    }

    public WMAClient(String string, int n) {
        this.phoneNumber = string;
        this.clientType = n;
        this.controlPort = 0;
        this.connection = null;
        this.input = null;
        this.output = null;
        this.clientTrafficPort = 0;
        this.serverTrafficPort = 0;
        this.trafficSocket = null;
        this.receiver = null;
        this.listener = null;
        this.weLaunchedServer = false;
        if (string != null && string.equals(GATEWAY_PHONE_NUMBER) && (n == 1 || n == 4)) {
            throw new IllegalArgumentException("Gateway must be a receive-only or a send-and-receive client");
        }
    }

    public String getPhoneNumber() {
        return this.phoneNumber;
    }

    public int getClientType() {
        return this.clientType;
    }

    public int getControlPort() {
        return this.controlPort;
    }

    public int getClientTrafficPort() {
        return this.clientTrafficPort;
    }

    public int getServerTrafficPort() {
        return this.serverTrafficPort;
    }

    public void setMessageListener(MessageListener messageListener) {
        this.listener = messageListener;
        if (this.listener != null && this.connection != null) {
            this.setupTrafficSocket();
            this.setupReceiver();
        }
    }

    public MessageListener getMessageListener() {
        return this.listener;
    }

    public void connect() throws IOException, PhoneNumberNotAvailableException {
        try {
            this.weLaunchedServer = WMAClient.ensureServerIsPresent();
            int[] nArray = WMAClient.getServerStatusFileValues();
            this.controlPort = nArray[0];
            this.serverTrafficPort = nArray[1];
            debug.println(1, "Attempting to connect to WMA Server...");
            this.connection = new Socket(wmaServerHost, this.controlPort);
            this.input = new BufferedReader(new InputStreamReader(this.connection.getInputStream()));
            this.output = this.connection.getOutputStream();
            this.negotiateConnection();
            if (this.listener != null) {
                this.setupTrafficSocket();
                this.setupReceiver();
            }
        }
        catch (IOException iOException) {
            debug.println(2, "ensuring lock file is gone in process of exception handling.");
            String string = WMAServer.STAT_FILE_NAME + ".lock";
            new File(string).delete();
            throw iOException;
        }
    }

    private void negotiateConnection() throws IOException, PhoneNumberNotAvailableException {
        this.negotiateClientType();
        this.negotiatePhoneNumber();
        this.negotiatePorts();
    }

    private void negotiateClientType() throws IOException {
        debug.println(3, "Sending client type: " + this.clientType);
        this.output.write(String.valueOf(this.clientType).getBytes());
        this.output.write("\n".getBytes());
        String string = this.input.readLine();
        debug.println(3, "Got response of client type request: " + string);
        if (!string.equals("OK")) {
            throw new UnsupportedOperationException("Switch does not support the client type " + this.clientType);
        }
    }

    private void negotiatePhoneNumber() throws IOException, PhoneNumberNotAvailableException {
        if (this.phoneNumber == null) {
            this.phoneNumber = "unspecified";
        } else if (this.phoneNumber.charAt(0) != '+') {
            this.phoneNumber = "+" + this.phoneNumber;
        }
        debug.println(3, "Sending phone number: " + this.phoneNumber);
        this.output.write(this.phoneNumber.getBytes());
        this.output.write("\n".getBytes());
        debug.println(3, "Reading phone number response...");
        String string = this.input.readLine();
        debug.println(3, "Response: " + string);
        if (string.substring(0, 2).equals("NA")) {
            throw new PhoneNumberNotAvailableException(this.phoneNumber, string.substring(3));
        }
        if (!string.equals("OK")) {
            this.phoneNumber = string;
        }
    }

    private void negotiatePorts() throws IOException {
        if (this.clientType != 1) {
            DatagramSocket datagramSocket = new DatagramSocket();
            this.clientTrafficPort = datagramSocket.getLocalPort();
            datagramSocket.close();
        }
        debug.println(3, "Sending our listen port: " + this.clientTrafficPort);
        this.output.write(String.valueOf(this.clientTrafficPort).getBytes());
        this.output.write("\n".getBytes());
    }

    boolean getWeLaunchedServer() {
        return this.weLaunchedServer;
    }

    private synchronized void setupTrafficSocket() {
        if (this.trafficSocket == null) {
            debug.println(3, "Opening Datagram traffic socket on port: " + this.clientTrafficPort);
            try {
                this.trafficSocket = new DatagramSocket(this.clientTrafficPort);
            }
            catch (IOException iOException) {
                debug.exception(3, (Throwable)iOException);
                throw new RuntimeException("Could not open datagram connection on port " + this.clientTrafficPort);
            }
        }
    }

    private synchronized void setupReceiver() {
        if (this.receiver == null) {
            this.receiver = new Thread(new DatagramReader());
            this.receiver.start();
        }
    }

    int multipartNumberOfSegments(MultipartMessage multipartMessage) {
        int n = 7;
        byte[] byArray = null;
        try {
            byArray = multipartMessage.getAsByteArray();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (byArray == null) {
            return 1;
        }
        int n2 = 1200;
        int n3 = byArray.length < n2 ? 1 : (byArray.length + (n2 -= n) - 1) / n2;
        return n3;
    }

    public int numberOfSegments(WMAMessage wMAMessage) {
        if (wMAMessage instanceof MultipartMessage) {
            return this.multipartNumberOfSegments((MultipartMessage)wMAMessage);
        }
        Message message = (Message)wMAMessage;
        byte[] byArray = message.getData();
        String string = message.getToAddress();
        boolean bl = message.isText();
        String string2 = message.getTextEncoding();
        boolean bl2 = bl && string2.equals("gsm7bit");
        int n = 0;
        int n2 = string.indexOf(":");
        if ((n2 = string.indexOf(":", n2 + 1)) != -1) {
            n = bl2 ? 7 : 6;
        }
        int n3 = bl ? 8 : 7;
        int n4 = (bl2 ? 160 : 140) - n;
        int n5 = byArray.length < n4 ? 1 : (byArray.length + (n4 -= n3) - 1) / n4;
        return n5;
    }

    private void multipartSend(MultipartMessage multipartMessage) throws IOException {
        DatagramRecord datagramRecord = new DatagramRecord();
        long l = System.currentTimeMillis();
        int n = 0;
        int n2 = 50;
        int n3 = 1200;
        byte[] byArray = multipartMessage.getAsByteArray();
        int n4 = byArray.length < n3 ? 1 : (byArray.length + (n3 -= n2) - 1) / n3;
        String string = multipartMessage.getReplyToApplicationID();
        String string2 = multipartMessage.getApplicationID();
        int n5 = byArray.length;
        for (int i = 0; i < n4; ++i) {
            datagramRecord.setHeader("Date", String.valueOf(l));
            if (string2 != null) {
                datagramRecord.setHeader("Address", "mms://:" + string2);
            } else {
                datagramRecord.setHeader("Address", "mms://:");
            }
            if (string == null) {
                datagramRecord.setHeader("SenderAddress", "mms://" + this.phoneNumber);
            } else {
                datagramRecord.setHeader("SenderAddress", "mms://" + this.phoneNumber + ":" + string);
            }
            datagramRecord.setHeader("Content-Type", "multipart");
            datagramRecord.setHeader("Content-Length", String.valueOf(byArray.length));
            datagramRecord.setHeader("Segments", String.valueOf(n4));
            if (n4 > 1) {
                n = i * n3;
                n5 = i < n4 - 1 ? n3 : byArray.length - n3 * i;
                datagramRecord.setHeader("Fragment", String.valueOf(i));
                datagramRecord.setHeader("Fragment-Size", String.valueOf(n5));
                datagramRecord.setHeader("Fragment-Offset", String.valueOf(n));
            }
            byte[] byArray2 = new byte[n5];
            System.arraycopy(byArray, n, byArray2, 0, n5);
            datagramRecord.setData(byArray2);
            byte[] byArray3 = datagramRecord.getFormattedData();
            DatagramPacket datagramPacket = new DatagramPacket(byArray3, byArray3.length, wmaServerHost, this.serverTrafficPort);
            this.trafficSocket.send(datagramPacket);
        }
    }

    public void send(WMAMessage wMAMessage) throws IOException {
        if (this.clientType == 2) {
            throw new IllegalStateException("Receive-only client cannot send messages.");
        }
        this.validityCheck(wMAMessage);
        this.setupTrafficSocket();
        debug.println(3, "WMAClient sending: " + wMAMessage.toString());
        if (wMAMessage instanceof MultipartMessage) {
            this.multipartSend((MultipartMessage)wMAMessage);
            return;
        }
        Message message = (Message)wMAMessage;
        byte[] byArray = message.getData();
        String string = message.getToAddress();
        boolean bl = message.isSMS();
        boolean bl2 = message.isText();
        String string2 = message.getTextEncoding();
        boolean bl3 = bl2 && string2.equals("gsm7bit");
        long l = message.getSendTime();
        if (l == 0L && bl) {
            l = System.currentTimeMillis();
            message.setSendTime(l);
        }
        int n = 0;
        int n2 = string.indexOf(":");
        if ((n2 = string.indexOf(":", n2 + 1)) != -1) {
            n = bl3 ? 7 : 6;
        }
        int n3 = bl2 ? 8 : 7;
        int n4 = (bl3 ? 160 : 140) - n;
        int n5 = byArray.length < n4 ? 1 : (byArray.length + (n4 -= n3) - 1) / n4;
        if (n5 > 1 && message.getFragmentNum() != -1) {
            throw new IllegalArgumentException("Message fragment is too big");
        }
        if (byArray.length > 255 * n4) {
            throw new IllegalArgumentException("Message requires more than 255 fragments");
        }
        if (n5 == 1) {
            byte[] byArray2 = message.getRawData();
            DatagramPacket datagramPacket = new DatagramPacket(byArray2, byArray2.length, wmaServerHost, this.serverTrafficPort);
            this.trafficSocket.send(datagramPacket);
            return;
        }
        int n6 = byArray.length;
        int n7 = 0;
        String string3 = bl2 ? "text" : "binary";
        String string4 = String.valueOf(l);
        String string5 = String.valueOf(byArray.length);
        String string6 = String.valueOf(n5);
        for (int i = 0; i < n5; ++i) {
            DatagramRecord datagramRecord = new DatagramRecord();
            datagramRecord.setHeader("Date", string4);
            datagramRecord.setHeader("SenderAddress", message.getFromAddress());
            if (bl2) {
                datagramRecord.setHeader("Text-Encoding", string2);
            }
            if (bl) {
                datagramRecord.setHeader("Address", string);
            } else {
                datagramRecord.setHeader("CBSAddress", string);
            }
            datagramRecord.setHeader("Content-Type", string3);
            datagramRecord.setHeader("Content-Length", string5);
            datagramRecord.setHeader("Segments", string6);
            n6 = i < n5 - 1 ? n4 : byArray.length - n7;
            datagramRecord.setHeader("Fragment", String.valueOf(i));
            datagramRecord.setHeader("Fragment-Size", String.valueOf(n6));
            datagramRecord.setHeader("Fragment-Offset", String.valueOf(n7));
            byte[] byArray3 = new byte[n6];
            System.arraycopy(byArray, n7, byArray3, 0, n6);
            datagramRecord.setData(byArray3);
            byte[] byArray4 = datagramRecord.getFormattedData();
            DatagramPacket datagramPacket = new DatagramPacket(byArray4, byArray4.length, wmaServerHost, this.serverTrafficPort);
            this.trafficSocket.send(datagramPacket);
            n7 += n4;
        }
    }

    private void multipartValidityCheck(MultipartMessage multipartMessage) {
        Vector<String> vector;
        block7: {
            vector = new Vector<String>();
            String[] stringArray = multipartMessage.getAddresses("to");
            boolean bl = false;
            boolean bl2 = false;
            int n = 0;
            String string = null;
            while (true) {
                if (stringArray == null || n >= stringArray.length) {
                    if (!bl) {
                        bl = true;
                        stringArray = multipartMessage.getAddresses("cc");
                        n = 0;
                        continue;
                    }
                    if (!bl2) {
                        bl2 = true;
                        stringArray = multipartMessage.getAddresses("bcc");
                        n = 0;
                        continue;
                    }
                    break block7;
                }
                String string2 = stringArray[n++];
                vector.add(string2);
                MMSAddress mMSAddress = MMSAddress.getParsedMMSAddress(string2);
                if (mMSAddress == null || mMSAddress.type == -1 || mMSAddress.type == 5) {
                    throw new IllegalArgumentException("Invalid MMS address: " + string2);
                }
                if (string == null) {
                    string = mMSAddress.appId;
                    continue;
                }
                if (mMSAddress.appId != null && !string.equals(mMSAddress.appId)) break;
            }
            throw new IllegalArgumentException("Only one Application-ID can be specified per message.");
        }
        if (vector.size() == 0) {
            throw new IllegalArgumentException("no to, cc, or bcc addresses");
        }
    }

    private void validityCheck(WMAMessage wMAMessage) {
        if (wMAMessage instanceof MultipartMessage) {
            this.multipartValidityCheck((MultipartMessage)wMAMessage);
            return;
        }
        Message message = (Message)wMAMessage;
        String string = message.getToAddress();
        boolean bl = false;
        boolean bl2 = false;
        if (string != null) {
            bl = string.startsWith("sms://");
            bl2 = string.startsWith("cbs://");
        }
        if (!bl && !bl2) {
            throw new IllegalArgumentException("Invalid address: does not begin with sms:// or cbs://");
        }
        int n = string.lastIndexOf(58);
        if (n != -1) {
            int n2;
            int n3 = -1;
            String string2 = null;
            string2 = n != 3 ? string.substring(6, n) : string.substring(6);
            if (bl) {
                if (string2.length() == 0) {
                    throw new IllegalArgumentException("Invalid send address");
                }
                n2 = 0;
                int n4 = string2.length();
                char c = '\u0000';
                if (n4 > 0) {
                    c = string2.charAt(0);
                    if (c == '+') {
                        n2 = 1;
                    }
                    for (int i = n2; i < string2.length(); ++i) {
                        c = string2.charAt(i);
                        if ('0' <= c && c <= '9') continue;
                        throw new IllegalArgumentException("Host format: contains non-numbers in address");
                    }
                }
            } else if (string2 != null && string2.length() > 0) {
                throw new IllegalArgumentException("CBS message should not have a phone number in the address");
            }
            if (n != 3) {
                try {
                    n3 = Integer.parseInt(string.substring(n + 1));
                }
                catch (NumberFormatException numberFormatException) {
                    throw new IllegalArgumentException("Port format: port is not an int");
                }
                if (n3 > 65535) {
                    throw new IllegalArgumentException("Port is above maximum range of 65535");
                }
            }
            if (bl) {
                for (n2 = 0; n2 < SMS_RESTRICTED_PORTS.length; ++n2) {
                    if (n3 != SMS_RESTRICTED_PORTS[n2]) continue;
                    throw new SecurityException("SMS port not allowed");
                }
            } else if (message.getSendTime() != 0L) {
                throw new IllegalArgumentException("CBS message should not have a timestamp.");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Message receiveOneFragment() throws IOException {
        if (this.clientType == 1) {
            throw new IllegalStateException("Send-only client cannot receive messages.");
        }
        this.setupTrafficSocket();
        this.setupReceiver();
        DatagramPacket datagramPacket = null;
        Object object = this.queue;
        synchronized (object) {
            while (this.queue.size() == 0) {
                try {
                    this.queue.wait();
                    if (this.connection != null) continue;
                    throw new InterruptedIOException("connection closed");
                }
                catch (InterruptedException interruptedException) {
                }
            }
            datagramPacket = (DatagramPacket)this.queue.get(0);
            this.queue.remove(0);
        }
        object = new DatagramRecord();
        ((DatagramRecord)object).parseData(datagramPacket.getData(), datagramPacket.getLength());
        debug.println(3, "WMAClient received fragment: {0} ", (Object)((DatagramRecord)object).toString());
        String string = ((DatagramRecord)object).getHeader("Ack-Port");
        String string2 = ((DatagramRecord)object).getHeader("Ack-Cookie");
        if (string != null && string2 != null) {
            int n = 0;
            try {
                n = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            if (n != 0) {
                String string3 = "ACK:" + string2 + "\n";
                byte[] byArray = string3.getBytes();
                DatagramPacket datagramPacket2 = new DatagramPacket(byArray, byArray.length, wmaServerHost, 0);
                datagramPacket2.setPort(n);
                this.trafficSocket.send(datagramPacket2);
                debug.println(4, "Ack sent for cookie" + string2 + " from " + this.phoneNumber);
            }
        }
        return new Message((DatagramRecord)object);
    }

    public WMAMessage receive() throws IOException {
        Message message = null;
        Message message2 = null;
        while (true) {
            if ((message2 = this.receiveOneFragment()).isFragmented()) {
                debug.println(3, "Message is fragmented...");
                if (message2.addPreviousFragment(message)) {
                    debug.println(3, "Last fragment received.");
                    break;
                }
            } else {
                debug.println(3, "Complete message received.");
                break;
            }
            debug.println(3, "Expecting more fragments...");
            message = message2;
        }
        if (message2.getUnderlyingRecord().getHeader("Content-Type").equals("multipart")) {
            debug.println(3, "Message is multipart message");
            byte[] byArray = message2.getData();
            MultipartMessage multipartMessage = MultipartMessage.createFromByteArray(byArray);
            multipartMessage.setSendTime(Long.parseLong(message2.getUnderlyingRecord().getHeader("Date")));
            multipartMessage.setFromAddress(message2.getUnderlyingRecord().getHeader("SenderAddress"));
            return multipartMessage;
        }
        debug.println(3, "Message is SMS.");
        return message2;
    }

    public String[] getKnownReceivers() throws IOException {
        this.output.write("GETLISTENERS\n".getBytes());
        String string = this.input.readLine();
        int n = Integer.parseInt(string);
        if (n < 1) {
            return new String[0];
        }
        String[] stringArray = new String[n];
        for (int i = 0; i < n; ++i) {
            stringArray[i] = this.input.readLine();
        }
        return stringArray;
    }

    public void unregisterFromServer() throws IOException {
        if (this.trafficSocket != null) {
            this.trafficSocket.close();
            this.trafficSocket = null;
        }
        if (this.connection != null) {
            this.input.close();
            this.output.close();
            this.connection.close();
            this.connection = null;
        }
    }

    private class DatagramReader
    implements Runnable {
        DatagramReader() {
            WMAClient.this.queue = new Vector(256);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            debug.println(3, "Listening for traffic on port " + WMAClient.this.clientTrafficPort);
            while (WMAClient.this.trafficSocket != null) {
                try {
                    byte[] byArray = new byte[1500];
                    DatagramPacket datagramPacket = new DatagramPacket(byArray, byArray.length);
                    try {
                        WMAClient.this.trafficSocket.receive(datagramPacket);
                    }
                    catch (SocketException socketException) {
                        return;
                    }
                    Object object = WMAClient.this.queue;
                    synchronized (object) {
                        WMAClient.this.queue.add(datagramPacket);
                        WMAClient.this.queue.notify();
                    }
                    if (WMAClient.this.listener == null) continue;
                    object = new DatagramRecord();
                    ((DatagramRecord)object).parseData(datagramPacket.getData(), datagramPacket.getLength());
                    if (!((DatagramRecord)object).getHeader("Segments").equals("1") && !((DatagramRecord)object).getHeader("Fragment").equals("0")) continue;
                    new Thread(new Runnable(this){
                        private final /* synthetic */ DatagramReader this$1;
                        {
                            this.this$1 = datagramReader;
                        }

                        public void run() {
                            WMAClient.access$400(DatagramReader.access$500(this.this$1)).notifyIncomingMessage(DatagramReader.access$500(this.this$1));
                        }
                    }).start();
                }
                catch (InterruptedIOException interruptedIOException) {
                    break;
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
            debug.println(3, "Done listening on traffic port (but it's still open!): " + WMAClient.this.clientTrafficPort);
        }

        static /* synthetic */ WMAClient access$500(DatagramReader datagramReader) {
            return datagramReader.WMAClient.this;
        }
    }

    public static class MessageListenerAdapter
    implements MessageListener {
        public void notifyIncomingMessage(WMAClient wMAClient) {
        }
    }

    public static interface MessageListener {
        public void notifyIncomingMessage(WMAClient var1);
    }
}

