/*
 * Decompiled with CFR 0.152.
 */
package com.sun.kvem.midp.io.j2se.wma;

import com.sun.kvem.midp.io.j2se.wma.MessagePart;
import com.sun.kvem.midp.io.j2se.wma.SizeExceededException;
import com.sun.kvem.midp.io.j2se.wma.WMAMessage;
import com.sun.kvem.midp.io.j2se.wma.common.parse.MMSAddress;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Vector;

public class MultipartMessage
implements WMAMessage {
    public static final String FROM = "from";
    public static final String TO = "to";
    public static final String CC = "cc";
    public static final String BCC = "bcc";
    long sendTime;
    String fromAddress;
    Vector to;
    Vector cc;
    Vector bcc;
    Vector parts;
    String startContentID;
    String subject;
    String[] headerValues;
    String applicationID;
    String replyToApplicationID;
    static final String[] ALLOWED_HEADER_FIELDS = new String[]{"X-Mms-Delivery-Time", "X-Mms-Priority"};
    static final String[] DEFAULT_HEADER_VALUES = new String[]{null, "Normal"};
    static final String[] KNOWN_HEADER_FIELDS = new String[]{"X-Mms-Message-Type", "X-Mms-Transaction-ID", "X-Mms-MMS-Version", "X-Mms-Content-Type", "X-Mms-Subject", "X-Mms-From", "X-Mms-To", "X-Mms-CC", "X-Mms-BCC"};
    static final int MAX_TOTAL_SIZE = 30730;
    static final String STREAM_SIGNATURE = "application/vnd.wap.mms-message";

    public MultipartMessage(String string) {
        this.fromAddress = string;
        this.to = new Vector();
        this.cc = new Vector();
        this.bcc = new Vector();
        this.parts = new Vector();
        this.startContentID = null;
        this.subject = null;
        this.applicationID = null;
        this.replyToApplicationID = null;
        this.setupHeaderFields();
    }

    public void fixupReceivedMessageAddresses(String string, String string2) {
        String string3 = string2;
        String string4 = string2;
        if (string3.charAt(0) == '+') {
            string3 = string3.substring(1);
        } else if (string4.charAt(0) != '+') {
            string4 = "+" + string4;
        }
        Vector vector = this.to;
        for (int i = 0; i < 2; ++i) {
            int n = vector.size();
            for (int j = 0; j < n; ++j) {
                String string5 = (String)vector.elementAt(j);
                MMSAddress mMSAddress = MMSAddress.getParsedMMSAddress(string5);
                if (mMSAddress == null || !string3.equals(mMSAddress.address) && !string4.equals(mMSAddress.address)) continue;
                --n;
                vector.removeElementAt(j);
                --j;
            }
            vector = this.cc;
        }
        if (string != null) {
            String string6 = string;
            this.to.insertElementAt(string6, 0);
            this.fromAddress = string6;
            MMSAddress mMSAddress = MMSAddress.getParsedMMSAddress(string6);
            this.applicationID = mMSAddress.appId;
        } else {
            this.applicationID = null;
        }
    }

    Vector getAddressList(String string) {
        String string2 = string.toLowerCase();
        if (string2.equals(TO)) {
            return this.to;
        }
        if (string2.equals(CC)) {
            return this.cc;
        }
        if (string2.equals(BCC)) {
            return this.bcc;
        }
        throw new IllegalArgumentException("Address type is not 'to', 'cc', or 'bcc'");
    }

    MMSAddress checkValidAddress(String string) throws IllegalArgumentException {
        MMSAddress mMSAddress = MMSAddress.getParsedMMSAddress(string);
        if (mMSAddress == null || mMSAddress.type == -1 || mMSAddress.type == 5) {
            throw new IllegalArgumentException("Invalid destination address: " + string);
        }
        return mMSAddress;
    }

    void checkApplicationID(String string) throws IllegalArgumentException {
        if (this.applicationID != null) {
            if (!this.applicationID.equals(string)) {
                throw new IllegalArgumentException("Only one Application-ID can be specified per message.");
            }
        } else {
            this.applicationID = string;
        }
    }

    static boolean isKnownHeaderField(String string) {
        String string2 = string.toLowerCase();
        for (int i = 0; i < KNOWN_HEADER_FIELDS.length; ++i) {
            if (!string2.equals(KNOWN_HEADER_FIELDS[i].toLowerCase())) continue;
            return true;
        }
        return false;
    }

    void setupHeaderFields() {
        this.headerValues = new String[ALLOWED_HEADER_FIELDS.length];
        for (int i = 0; i < DEFAULT_HEADER_VALUES.length; ++i) {
            this.headerValues[i] = DEFAULT_HEADER_VALUES[i];
        }
    }

    static int getHeaderFieldIndex(String string) {
        String string2 = string.toLowerCase();
        for (int i = 0; i < ALLOWED_HEADER_FIELDS.length; ++i) {
            if (!string2.equals(ALLOWED_HEADER_FIELDS[i].toLowerCase())) continue;
            return i;
        }
        return -1;
    }

    boolean isAllowedToAccessHeaderField(String string) {
        return MultipartMessage.getHeaderFieldIndex(string) != -1;
    }

    static void checkHeaderValue(int n, String string) {
        switch (n) {
            case 0: {
                try {
                    Long.parseLong(string);
                    return;
                }
                catch (NumberFormatException numberFormatException) {
                    break;
                }
            }
            case 1: {
                String string2 = string.toLowerCase();
                if (!string2.equals("normal") && !string2.equals("high") && !string2.equals("low")) break;
                return;
            }
            default: {
                throw new Error("Unknown headerIndex: " + n);
            }
        }
        throw new IllegalArgumentException("Illegal value for header " + ALLOWED_HEADER_FIELDS[n] + ": " + string);
    }

    public void setFromAddress(String string) {
        this.fromAddress = string;
        MMSAddress mMSAddress = this.checkValidAddress(string);
        String string2 = mMSAddress.appId;
        this.setReplyToApplicationID(string2);
    }

    public String getFromAddress() {
        return this.fromAddress;
    }

    public void setReplyToApplicationID(String string) {
        int n;
        if (string != null && string.length() == 0) {
            string = null;
        }
        this.replyToApplicationID = string;
        String string2 = ":" + string;
        if (this.fromAddress != null && (n = this.fromAddress.lastIndexOf(string2)) != -1) {
            this.fromAddress = this.fromAddress.substring(0, n);
        }
    }

    public String getReplyToApplicationID() {
        return this.replyToApplicationID;
    }

    public void setApplicationID(String string) {
        if (string != null && string.length() == 0) {
            string = null;
        }
        this.checkApplicationID(string);
    }

    public String getApplicationID() {
        return this.applicationID;
    }

    public void setSendTime(long l) {
        this.sendTime = l;
    }

    public long getSendTime() {
        return this.sendTime;
    }

    public boolean addAddress(String string, String string2) {
        Vector vector;
        if (string2 == null) {
            return false;
        }
        MMSAddress mMSAddress = this.checkValidAddress(string2);
        String string3 = mMSAddress.appId;
        if (string3 != null) {
            this.checkApplicationID(string3);
        }
        if (!(vector = this.getAddressList(string)).contains(string2)) {
            vector.addElement(string2);
            return true;
        }
        return false;
    }

    public void addMessagePart(MessagePart messagePart) throws SizeExceededException {
        String string = messagePart.getContentID();
        int n = 0;
        int n2 = this.parts.size();
        for (int i = 0; i < n2; ++i) {
            MessagePart messagePart2 = (MessagePart)this.parts.elementAt(i);
            if (string.equals(messagePart2.getContentID())) {
                throw new IllegalArgumentException("Cannot add duplicate content-id: " + string);
            }
            n += messagePart2.getLength();
        }
        if (n + messagePart.getLength() > 30730) {
            throw new SizeExceededException("Adding this MessagePart would exceed max size of 30730 bytes");
        }
        this.parts.addElement(messagePart);
    }

    public String getAddress() {
        String string = null;
        if (this.getSendTime() == 0L) {
            if (this.to.size() > 0) {
                string = (String)this.to.elementAt(0);
            }
        } else {
            string = this.fromAddress;
        }
        return string;
    }

    public String[] getAddresses(String string) {
        if (string.toLowerCase().equals(FROM)) {
            if (this.fromAddress == null) {
                return null;
            }
            return new String[]{this.fromAddress};
        }
        Vector vector = this.getAddressList(string);
        int n = vector.size();
        if (n == 0) {
            return null;
        }
        Object[] objectArray = new String[n];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public String getHeader(String string) {
        if (string == null) {
            throw new IllegalArgumentException("headerField must not be null");
        }
        if (this.isAllowedToAccessHeaderField(string)) {
            int n = MultipartMessage.getHeaderFieldIndex(string);
            if (n != -1) {
                return this.headerValues[n];
            }
            throw new Error("Allowed to access field but it has no index");
        }
        if (MultipartMessage.isKnownHeaderField(string)) {
            throw new SecurityException("cannot access restricted header field " + string);
        }
        throw new IllegalArgumentException("Unknown header field: " + string);
    }

    public MessagePart getMessagePart(String string) {
        if (string == null) {
            throw new NullPointerException("contentID must not be null");
        }
        int n = this.parts.size();
        for (int i = 0; i < n; ++i) {
            MessagePart messagePart = (MessagePart)this.parts.elementAt(i);
            if (!string.equals(messagePart.getContentID())) continue;
            return messagePart;
        }
        return null;
    }

    public MessagePart[] getMessageParts() {
        int n = this.parts.size();
        if (n == 0) {
            return null;
        }
        Object[] objectArray = new MessagePart[n];
        this.parts.copyInto(objectArray);
        return objectArray;
    }

    public String getStartContentId() {
        return this.startContentID;
    }

    public String getSubject() {
        return this.subject;
    }

    private boolean cleanupAppID() throws IllegalStateException {
        Vector vector = this.to;
        boolean bl = false;
        boolean bl2 = false;
        int n = 0;
        boolean bl3 = false;
        while (true) {
            String string;
            MMSAddress mMSAddress;
            if (n >= vector.size()) {
                if (!bl) {
                    bl = true;
                    vector = this.cc;
                    n = 0;
                    continue;
                }
                if (bl2) break;
                bl2 = true;
                vector = this.bcc;
                n = 0;
                continue;
            }
            if ((mMSAddress = MMSAddress.getParsedMMSAddress(string = (String)vector.elementAt(n++))) == null || mMSAddress.type == -1 || mMSAddress.type == 5) {
                throw new IllegalStateException("Invalid MMS address: " + string);
            }
            String string2 = mMSAddress.appId;
            if (string2 == null || !string2.equals(this.applicationID)) continue;
            bl3 = true;
        }
        return bl3;
    }

    public boolean removeAddress(String string, String string2) {
        Vector vector = this.getAddressList(string);
        boolean bl = vector.removeElement(string2);
        if (!this.cleanupAppID()) {
            this.applicationID = null;
        }
        return bl;
    }

    public void removeAddresses() {
        this.to.removeAllElements();
        this.cc.removeAllElements();
        this.bcc.removeAllElements();
        this.applicationID = null;
    }

    public void removeAddresses(String string) {
        Vector vector = this.getAddressList(string);
        vector.removeAllElements();
        if (!this.cleanupAppID()) {
            this.applicationID = null;
        }
    }

    public boolean removeMessagePart(MessagePart messagePart) {
        if (messagePart == null) {
            throw new NullPointerException("part must not be null");
        }
        if (messagePart.getContentID().equals(this.startContentID)) {
            this.startContentID = null;
        }
        return this.parts.removeElement(messagePart);
    }

    public boolean removeMessagePartId(String string) {
        if (string == null) {
            throw new NullPointerException("contentID must not be null");
        }
        int n = this.parts.size();
        for (int i = 0; i < n; ++i) {
            MessagePart messagePart = (MessagePart)this.parts.elementAt(i);
            if (!string.equals(messagePart.getContentID())) continue;
            if (string.equals(this.startContentID)) {
                this.startContentID = null;
            }
            this.parts.removeElementAt(i);
            return true;
        }
        return false;
    }

    public boolean removeMessagePartLocation(String string) {
        if (string == null) {
            throw new NullPointerException("contentLocation must not be null");
        }
        int n = this.parts.size();
        boolean bl = false;
        for (int i = 0; i < n; ++i) {
            MessagePart messagePart = (MessagePart)this.parts.elementAt(i);
            if (!string.equals(messagePart.getContentLocation())) continue;
            if (messagePart.getContentID().equals(this.startContentID)) {
                this.startContentID = null;
            }
            this.parts.removeElementAt(i);
            --n;
            --i;
            bl = true;
        }
        return bl;
    }

    public void setAddress(String string) {
        if (string != null) {
            this.addAddress(TO, string);
        }
    }

    public void setHeader(String string, String string2) {
        if (this.isAllowedToAccessHeaderField(string)) {
            int n = MultipartMessage.getHeaderFieldIndex(string);
            if (n != -1) {
                if (string2 != null) {
                    MultipartMessage.checkHeaderValue(n, string2);
                }
                this.headerValues[n] = string2;
                return;
            }
            throw new Error("allowed to access field but it has no index");
        }
        if (MultipartMessage.isKnownHeaderField(string)) {
            throw new SecurityException("Cannot access restricted header field: " + string);
        }
        throw new IllegalArgumentException("Unknown header field: " + string);
    }

    public void setStartContentId(String string) {
        if (string != null && this.getMessagePart(string) == null) {
            throw new IllegalArgumentException("Unknown contentId: " + string);
        }
        this.startContentID = string;
    }

    public void setSubject(String string) {
        if (string != null && string.length() > 40) {
            throw new IllegalArgumentException("Subject exceeds 40 chars");
        }
        this.subject = string;
    }

    static String getDevicePortionOfAddress(String string) throws IllegalArgumentException {
        MMSAddress mMSAddress = MMSAddress.getParsedMMSAddress(string);
        if (mMSAddress == null || mMSAddress.address == null) {
            throw new IllegalArgumentException("MMS Address has no device portion");
        }
        return mMSAddress.address;
    }

    static void writeVector(DataOutputStream dataOutputStream, Vector vector, boolean bl) throws IOException {
        StringBuffer stringBuffer = new StringBuffer();
        int n = vector.size();
        String string = null;
        if (n > 0) {
            string = (String)vector.elementAt(0);
            if (bl) {
                string = MultipartMessage.getDevicePortionOfAddress(string);
            }
            stringBuffer.append(string);
        }
        for (int i = 1; i < n; ++i) {
            stringBuffer.append("; ");
            string = (String)vector.elementAt(i);
            if (bl) {
                string = MultipartMessage.getDevicePortionOfAddress(string);
            }
            stringBuffer.append(string);
        }
        dataOutputStream.writeUTF(stringBuffer.toString());
    }

    static void readVector(DataInputStream dataInputStream, Vector vector, boolean bl) throws IOException {
        String string = dataInputStream.readUTF();
        int n = -2;
        String string2 = "";
        if (bl) {
            string2 = "mms://";
        }
        while (n != -1) {
            int n2 = string.indexOf("; ", n + 2);
            String string3 = null;
            string3 = n2 == -1 ? string2 + string.substring(n + 2) : string2 + string.substring(n + 2, n2);
            vector.addElement(string3);
            n = n2;
        }
    }

    static void writeMessagePart(DataOutputStream dataOutputStream, MessagePart messagePart) throws IOException {
        String string;
        dataOutputStream.writeUTF("Content-Type");
        StringBuffer stringBuffer = new StringBuffer(messagePart.getMIMEType());
        String string2 = messagePart.getContentLocation();
        if (string2 != null) {
            stringBuffer.append("; name=\"");
            stringBuffer.append(string2);
            stringBuffer.append("\"");
        }
        dataOutputStream.writeUTF(stringBuffer.toString());
        String string3 = messagePart.getContentID();
        if (string3 != null) {
            dataOutputStream.writeUTF("Content-ID");
            dataOutputStream.writeUTF(string3);
        }
        if ((string = messagePart.getEncoding()) != null) {
            dataOutputStream.writeUTF("Encoding");
            dataOutputStream.writeUTF(string);
        }
        dataOutputStream.writeUTF("Content-Length");
        dataOutputStream.writeInt(messagePart.getLength());
        dataOutputStream.writeUTF("Content");
        dataOutputStream.write(messagePart.getContent());
    }

    static MessagePart createMessagePart(DataInputStream dataInputStream) throws IOException {
        String string = dataInputStream.readUTF();
        String string2 = dataInputStream.readUTF();
        string = dataInputStream.readUTF();
        String string3 = null;
        if (string.equals("Content-ID")) {
            string3 = dataInputStream.readUTF();
            string = dataInputStream.readUTF();
        }
        String string4 = null;
        if (string.equals("Encoding")) {
            string4 = dataInputStream.readUTF();
            string = dataInputStream.readUTF();
        }
        int n = dataInputStream.readInt();
        byte[] byArray = new byte[n];
        string = dataInputStream.readUTF();
        dataInputStream.readFully(byArray);
        String string5 = string2;
        String string6 = null;
        int n2 = string2.indexOf(59);
        if (n2 != -1 && string2.substring(n2).startsWith("; name=\"")) {
            string6 = string2.substring(n2 + 8, string2.length() - 1);
            string5 = string2.substring(0, n2);
        }
        return new MessagePart(byArray, string5, string3, string6, string4);
    }

    public byte[] getAsByteArray() throws IOException {
        long l;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        dataOutputStream.writeUTF(STREAM_SIGNATURE);
        dataOutputStream.writeUTF("X-Mms-Message-Type");
        dataOutputStream.writeUTF("m-send-req");
        dataOutputStream.writeUTF("X-Mms-Transaction-ID");
        dataOutputStream.writeUTF(String.valueOf(this.getSendTime()));
        dataOutputStream.writeUTF("X-Mms-Version");
        dataOutputStream.writeUTF("1.0");
        for (int i = 0; i < ALLOWED_HEADER_FIELDS.length; ++i) {
            String string = this.headerValues[i];
            if (string == null) continue;
            dataOutputStream.writeUTF(ALLOWED_HEADER_FIELDS[i]);
            dataOutputStream.writeUTF(string);
        }
        if (this.fromAddress != null) {
            dataOutputStream.writeUTF("From");
            dataOutputStream.writeUTF(MultipartMessage.getDevicePortionOfAddress(this.fromAddress));
        }
        if (this.to.size() != 0) {
            dataOutputStream.writeUTF("To");
            MultipartMessage.writeVector(dataOutputStream, this.to, true);
        }
        if (this.cc.size() != 0) {
            dataOutputStream.writeUTF("Cc");
            MultipartMessage.writeVector(dataOutputStream, this.cc, true);
        }
        if (this.bcc.size() != 0) {
            dataOutputStream.writeUTF("Bcc");
            MultipartMessage.writeVector(dataOutputStream, this.bcc, true);
        }
        if ((l = this.getSendTime()) != 0L) {
            dataOutputStream.writeUTF("Date");
            dataOutputStream.writeUTF(String.valueOf(l));
        }
        if (this.subject != null) {
            dataOutputStream.writeUTF("Subject");
            dataOutputStream.writeUTF(this.subject);
        }
        dataOutputStream.writeUTF("Content-Type");
        Vector<String> vector = new Vector<String>();
        if (this.startContentID != null) {
            vector.addElement("application/vnd.wap.multipart.related");
        } else {
            vector.addElement("application/vnd.wap.multipart.mixed");
        }
        if (this.startContentID != null) {
            vector.addElement("start = <" + this.startContentID + ">");
            vector.addElement("type = " + this.getMessagePart(this.startContentID).getMIMEType());
        }
        if (this.applicationID != null) {
            vector.addElement("Application-ID = " + this.applicationID);
        }
        if (this.replyToApplicationID != null) {
            vector.addElement("Reply-To-Application-ID = " + this.replyToApplicationID);
        }
        MultipartMessage.writeVector(dataOutputStream, vector, false);
        dataOutputStream.writeUTF("nEntries");
        int n = this.parts.size();
        dataOutputStream.writeUTF(String.valueOf(n));
        for (int i = 0; i < n; ++i) {
            MessagePart messagePart = (MessagePart)this.parts.elementAt(i);
            MultipartMessage.writeMessagePart(dataOutputStream, messagePart);
        }
        dataOutputStream.close();
        byte[] byArray = byteArrayOutputStream.toByteArray();
        byteArrayOutputStream.close();
        return byArray;
    }

    public static MultipartMessage createFromByteArray(byte[] byArray) throws IOException {
        String string;
        int n;
        String string2;
        int n2;
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);
        String string3 = dataInputStream.readUTF();
        if (!string3.equals(STREAM_SIGNATURE)) {
            throw new IOException("invalid data format");
        }
        for (int i = 0; i < 6; ++i) {
            dataInputStream.readUTF();
        }
        String[] stringArray = new String[ALLOWED_HEADER_FIELDS.length];
        String string4 = dataInputStream.readUTF();
        while ((n2 = MultipartMessage.getHeaderFieldIndex(string4)) != -1) {
            stringArray[n2] = dataInputStream.readUTF();
            string4 = dataInputStream.readUTF();
        }
        String string5 = null;
        if (string4.equals("From")) {
            string5 = "mms://" + dataInputStream.readUTF();
            string4 = dataInputStream.readUTF();
        }
        Vector vector = new Vector();
        if (string4.equals("To")) {
            MultipartMessage.readVector(dataInputStream, vector, true);
            string4 = dataInputStream.readUTF();
        }
        Vector vector2 = new Vector();
        if (string4.equals("Cc")) {
            MultipartMessage.readVector(dataInputStream, vector2, true);
            string4 = dataInputStream.readUTF();
        }
        Vector vector3 = new Vector();
        if (string4.equals("Bcc")) {
            MultipartMessage.readVector(dataInputStream, vector3, true);
            string4 = dataInputStream.readUTF();
        }
        long l = 0L;
        if (string4.equals("Date")) {
            string2 = dataInputStream.readUTF();
            try {
                l = Long.parseLong(string2);
            }
            catch (NumberFormatException numberFormatException) {
                l = 0L;
            }
            string4 = dataInputStream.readUTF();
        }
        string2 = null;
        if (string4.equals("Subject")) {
            string2 = dataInputStream.readUTF();
            string4 = dataInputStream.readUTF();
        }
        String string6 = null;
        String string7 = null;
        String string8 = null;
        Vector vector4 = new Vector();
        MultipartMessage.readVector(dataInputStream, vector4, false);
        int n3 = vector4.size();
        for (n = 0; n < n3; ++n) {
            string = (String)vector4.elementAt(n);
            if (string.startsWith("start = <")) {
                string6 = string.substring(9);
                string6 = string6.substring(0, string6.length() - 1);
                continue;
            }
            if (string.startsWith("Application-ID = ")) {
                string7 = string.substring(17);
                continue;
            }
            if (!string.startsWith("Reply-To-Application-ID = ")) continue;
            string8 = string.substring(26);
        }
        string4 = dataInputStream.readUTF();
        n = 0;
        string = dataInputStream.readUTF();
        try {
            n = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            n = 0;
        }
        Vector<MessagePart> vector5 = new Vector<MessagePart>();
        for (int i = 0; i < n; ++i) {
            vector5.addElement(MultipartMessage.createMessagePart(dataInputStream));
        }
        dataInputStream.close();
        byteArrayInputStream.close();
        MultipartMessage multipartMessage = new MultipartMessage(string5);
        multipartMessage.setSendTime(l);
        multipartMessage.headerValues = stringArray;
        multipartMessage.subject = string2;
        multipartMessage.startContentID = string6;
        multipartMessage.to = vector;
        multipartMessage.cc = vector2;
        multipartMessage.parts = vector5;
        multipartMessage.applicationID = string7;
        multipartMessage.replyToApplicationID = string8;
        return multipartMessage;
    }
}

