/*
 * Decompiled with CFR 0.152.
 */
package com.sun.kvem.midp.io.j2se.wma;

import com.sun.kvem.midp.io.j2se.wma.SizeExceededException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;

public class MessagePart {
    public static final int MAX_PART_SIZE_BYTES = 30720;
    static final int BUFFER_SIZE = 2048;
    byte[] content;
    String contentID;
    String contentLocation;
    String encoding;
    String mimeType;
    static final char US_ASCII_LOWEST_VALID_CHAR = ' ';
    static final char US_ASCII_VALID_BIT_MASK = '\u007f';

    void construct(byte[] byArray, int n, int n2, String string, String string2, String string3, String string4) throws SizeExceededException {
        if (n2 > 30720) {
            throw new SizeExceededException("InputStream data exceeds 30720 byte MessagePart size limit");
        }
        if (string == null) {
            throw new IllegalArgumentException("mimeType must be specified");
        }
        MessagePart.checkContentID(string2);
        MessagePart.checkContentLocation(string3);
        if (n2 < 0) {
            throw new IllegalArgumentException("length must be >= 0");
        }
        if (byArray != null && n + n2 > byArray.length) {
            throw new IllegalArgumentException("offset + length exceeds contents length");
        }
        if (n < 0) {
            throw new IllegalArgumentException("offset must be >= 0");
        }
        MessagePart.checkEncodingScheme(string4);
        if (byArray != null) {
            this.content = new byte[n2];
            System.arraycopy(byArray, n, this.content, 0, n2);
        }
        this.mimeType = string;
        this.contentID = string2;
        this.contentLocation = string3;
        this.encoding = string4;
    }

    public MessagePart(byte[] byArray, int n, int n2, String string, String string2, String string3, String string4) throws SizeExceededException {
        this.construct(byArray, n, n2, string, string2, string3, string4);
    }

    public MessagePart(byte[] byArray, String string, String string2, String string3, String string4) throws SizeExceededException {
        this.construct(byArray, 0, byArray == null ? 0 : byArray.length, string, string2, string3, string4);
    }

    public MessagePart(InputStream inputStream, String string, String string2, String string3, String string4) throws IOException, SizeExceededException {
        byte[] byArray = new byte[]{};
        if (inputStream != null) {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            byte[] byArray2 = new byte[2048];
            int n = 0;
            while ((n = inputStream.read(byArray2)) != -1) {
                byteArrayOutputStream.write(byArray2, 0, n);
            }
            byArray = byteArrayOutputStream.toByteArray();
        }
        this.construct(byArray, 0, byArray.length, string, string2, string3, string4);
    }

    public byte[] getContent() {
        if (this.content == null) {
            return null;
        }
        byte[] byArray = new byte[this.content.length];
        System.arraycopy(this.content, 0, byArray, 0, this.content.length);
        return byArray;
    }

    public InputStream getContentAsStream() {
        if (this.content == null) {
            return new ByteArrayInputStream(new byte[0]);
        }
        return new ByteArrayInputStream(this.content);
    }

    public String getContentID() {
        return this.contentID;
    }

    public String getContentLocation() {
        return this.contentLocation;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public int getLength() {
        return this.content == null ? 0 : this.content.length;
    }

    public String getMIMEType() {
        return this.mimeType;
    }

    static void checkContentID(String string) throws IllegalArgumentException {
        if (string == null) {
            throw new IllegalArgumentException("contentId must be specified");
        }
        if (string.length() > 100) {
            throw new IllegalArgumentException("contentId exceeds 100 char limit");
        }
        if (MessagePart.containsNonUSASCII(string)) {
            throw new IllegalArgumentException("contentId must not contain non-US-ASCII characters");
        }
    }

    static void checkContentLocation(String string) throws IllegalArgumentException {
        if (string != null) {
            if (MessagePart.containsNonUSASCII(string)) {
                throw new IllegalArgumentException("contentLocation must not contain non-US-ASCII characters");
            }
            if (string.length() > 100) {
                throw new IllegalArgumentException("contentLocation exceeds 100 char limit");
            }
        }
    }

    static void checkEncodingScheme(String string) throws IllegalArgumentException {
    }

    static boolean containsNonUSASCII(String string) {
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (c >= ' ' && c == (c & 0x7F)) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        return this.contentLocation;
    }
}

