/*
 * Decompiled with CFR 0.152.
 */
package com.sun.kvem.midp.io.j2se.wma;

import com.sun.kvem.midp.io.j2se.wma.WMAMessage;
import com.sun.kvem.midp.io.j2se.wma.common.DatagramRecord;
import com.sun.kvem.midp.io.j2se.wma.common.TextEncoder;
import java.io.IOException;

public class Message
implements WMAMessage {
    public static final String UCS2_ENCODING = "ucs2";
    public static final String GSM7BIT_ENCODING = "gsm7bit";
    DatagramRecord record;

    public Message(byte[] byArray) {
        if (byArray == null) {
            throw new NullPointerException();
        }
        this.record = new DatagramRecord();
        this.record.setData(byArray);
        this.record.setHeader("Content-Type", "binary");
        this.record.setHeader("Content-Length", String.valueOf(byArray.length));
        this.record.setHeader("Segments", "1");
    }

    public Message(String string) {
        if (string == null) {
            throw new NullPointerException();
        }
        this.record = new DatagramRecord();
        byte[] byArray = TextEncoder.toByteArray(string);
        byte[] byArray2 = TextEncoder.encode(byArray);
        if (byArray2 != null) {
            byArray = byArray2;
            this.record.setHeader("Text-Encoding", GSM7BIT_ENCODING);
        } else {
            this.record.setHeader("Text-Encoding", UCS2_ENCODING);
        }
        this.record.setData(byArray);
        this.record.setHeader("Content-Type", "text");
        this.record.setHeader("Content-Length", String.valueOf(byArray.length));
        this.record.setHeader("Segments", "1");
    }

    public Message(DatagramRecord datagramRecord) {
        this.record = datagramRecord;
    }

    public DatagramRecord getUnderlyingRecord() {
        return this.record;
    }

    public void setFromAddress(String string) {
        if (this.isSMS()) {
            this.record.setHeader("SenderAddress", string);
        }
    }

    public String getFromAddress() {
        if (this.isSMS()) {
            return this.record.getHeader("SenderAddress");
        }
        return null;
    }

    public void setToAddress(String string) {
        if (string.startsWith("cbs://")) {
            this.record.setHeader("CBSAddress", string);
        } else {
            this.record.setHeader("Address", string);
        }
    }

    public String getToAddress() {
        String string = this.record.getHeader("CBSAddress");
        if (string == null) {
            string = this.record.getHeader("Address");
        }
        return string;
    }

    public void setFromPort(int n) {
        String string = this.getFromAddress();
        if (string != null) {
            int n2 = string.lastIndexOf(58);
            if (n2 > 5) {
                this.setFromAddress(string.substring(0, n2) + n);
            } else {
                this.setFromAddress(string + ":" + n);
            }
        }
    }

    public int getFromPort() {
        int n;
        String string = this.getFromAddress();
        if (string != null && (n = string.lastIndexOf(58)) > 5) {
            return Integer.parseInt(string.substring(n + 1));
        }
        return -1;
    }

    public void setToPort(int n) {
        String string = this.getToAddress();
        if (string != null) {
            int n2 = string.lastIndexOf(58);
            if (n2 > 5) {
                this.setToAddress(string.substring(0, n2) + n);
            } else {
                this.setToAddress(string + ":" + n);
            }
        }
    }

    public int getToPort() {
        int n;
        String string = this.getToAddress();
        if (string != null && (n = string.lastIndexOf(58)) > 5) {
            return Integer.parseInt(string.substring(n + 1));
        }
        return -1;
    }

    public byte[] getData() {
        return this.record.getData();
    }

    public void setSendTime(long l) {
        if (this.isSMS()) {
            this.record.setHeader("Date", String.valueOf(l));
        }
    }

    public long getSendTime() {
        String string;
        if (this.isSMS() && (string = this.record.getHeader("Date")) != null) {
            return Long.parseLong(string);
        }
        return 0L;
    }

    public boolean isText() {
        return this.record.getHeader("Content-Type").equals("text");
    }

    public boolean isSMS() {
        return this.record.getHeader("CBSAddress") == null;
    }

    public boolean isFragmented() {
        return this.getNumSegments() != 1;
    }

    public boolean addPreviousFragment(Message message) throws IOException {
        DatagramRecord datagramRecord = null;
        if (message != null) {
            datagramRecord = message.record;
        }
        return this.record.addData(datagramRecord);
    }

    public void setTextEncoding(String string) {
        if (!string.equals(UCS2_ENCODING) && !string.equals(GSM7BIT_ENCODING)) {
            throw new IllegalArgumentException("Encoding " + string + " is not supported");
        }
        this.record.setHeader("Content-Type", "text");
        this.record.setHeader("Text-Encoding", string);
    }

    public String getTextEncoding() {
        return this.record.getHeader("Text-Encoding");
    }

    public void setContentLength(int n) {
        this.record.setHeader("Fragment-Size", this.record.getHeader("Content-Length"));
        this.record.setHeader("Content-Length", String.valueOf(n));
    }

    public int getContentLength() {
        String string = this.record.getHeader("Content-Length");
        return Integer.parseInt(string);
    }

    public void setNumSegments(int n) {
        this.record.setHeader("Segments", String.valueOf(n));
    }

    public int getNumSegments() {
        String string = this.record.getHeader("Segments");
        return Integer.parseInt(string);
    }

    public void setFragmentNum(int n) {
        this.record.setHeader("Fragment", String.valueOf(n));
    }

    public int getFragmentNum() {
        String string = this.record.getHeader("Fragment");
        if (string != null) {
            return Integer.parseInt(string);
        }
        return -1;
    }

    public void setFragmentSize(int n) {
        this.record.setHeader("Fragment-Size", String.valueOf(n));
    }

    public int getFragmentSize() {
        String string = this.record.getHeader("Fragment-Size");
        if (string != null) {
            return Integer.parseInt(string);
        }
        return 0;
    }

    public void setFragmentOffset(int n) {
        this.record.setHeader("Fragment-Offset", String.valueOf(n));
    }

    public int getFragmentOffset() {
        String string = this.record.getHeader("Fragment-Offset");
        if (string != null) {
            return Integer.parseInt(string);
        }
        return 0;
    }

    public byte[] getRawData() {
        return this.record.getFormattedData();
    }

    public String toString() {
        if (this.isText()) {
            String string;
            String string2 = this.getTextEncoding();
            if (string2 == null || string2.equals(UCS2_ENCODING)) {
                string = TextEncoder.toString(this.getData());
            } else {
                byte[] byArray = TextEncoder.decode(this.getData());
                string = TextEncoder.toString(byArray);
            }
            return string;
        }
        byte[] byArray = this.getData();
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < byArray.length; ++i) {
            int n;
            if (i % 16 != 0) {
                stringBuffer.append(" ");
            }
            if ((n = byArray[i] & 0xFF) < 16) {
                stringBuffer.append("0");
            }
            stringBuffer.append(Integer.toHexString(n).toUpperCase());
            if (i % 16 != 15) continue;
            stringBuffer.append("\n");
        }
        return stringBuffer.toString();
    }
}

