/*
 * Decompiled with CFR 0.152.
 */
package com.sun.kvem.midp;

import com.sun.kvem.DeviceEventManager;
import com.sun.kvem.environment.Debug;
import com.sun.kvem.midp.CommandManager;
import com.sun.kvem.midp.WidgetManager;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;

public class TextManager {
    private static final TextManager instance = new TextManager();
    private boolean textInputActive = false;
    private static final Debug debug = Debug.create((Class)TextManager.class);

    protected TextManager() {
        WidgetManager.Listener listener = new WidgetManager.Listener(){

            public void widgetChanged(String string, String string2, String string3, String string4) {
                TextManager.this.textInputActive = string2.equals("TextBox") || string4.equals("TextField");
            }
        };
        WidgetManager.getInstance().addListener(listener);
    }

    public static TextManager getInstance() {
        return instance;
    }

    public boolean keyPressed(int n, InputEvent inputEvent) {
        if (!CommandManager.canUseScreen()) {
            return false;
        }
        debug.println(2, "Key {0} pressed, AWT event is {1}", n, (Object)inputEvent);
        if (inputEvent instanceof KeyEvent) {
            KeyEvent keyEvent = (KeyEvent)inputEvent;
            if (this.textInputActive && keyEvent.getKeyChar() != '\uffff') {
                debug.println(3, "Consuming {0}", (Object)keyEvent);
                return true;
            }
        }
        return false;
    }

    public boolean keyReleased(int n, InputEvent inputEvent) {
        if (!CommandManager.canUseScreen()) {
            return false;
        }
        debug.println(2, "Key {0} released, AWT event is {1}", n, (Object)inputEvent);
        if (inputEvent instanceof KeyEvent) {
            KeyEvent keyEvent = (KeyEvent)inputEvent;
            if (this.textInputActive && keyEvent.getKeyChar() != '\uffff') {
                debug.println(3, "Consuming {0}", (Object)keyEvent);
                return true;
            }
        }
        return false;
    }

    public boolean keyTyped(char c, InputEvent inputEvent) {
        KeyEvent keyEvent = (KeyEvent)inputEvent;
        int n = keyEvent.getKeyCode();
        debug.println(2, "Key {0} typed, AWT event is {1}", n, (Object)inputEvent);
        if (c != '\n') {
            debug.println(3, "Sending key-typed event for {0}", (int)c);
            int[] nArray = new int[]{9, c, 0, 0};
            DeviceEventManager.getInstance().queueEvent(nArray);
            return true;
        }
        return false;
    }
}

