/*
 * Decompiled with CFR 0.152.
 */
package com.sun.kvem.midp;

import com.sun.kvem.Device;
import com.sun.kvem.environment.Debug;
import com.sun.kvem.environment.DevicePropertyManager;
import com.sun.kvem.midp.AlertType;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.URL;
import java.util.Properties;
import javax.sound.midi.InvalidMidiDataException;
import javax.sound.midi.MidiSystem;
import javax.sound.midi.Sequence;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Clip;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.LineUnavailableException;

class SoundAlert
extends AlertType {
    private static final String[] PROPERTY_ALERT = new String[]{null, "alert.info.sound", "alert.warning.sound", "alert.error.sound", "alert.alarm.sound", "alert.confirmation.sound", "vibrator.sound"};
    private static final String PROPERTY_ALERT_DEFAULT = "alert.default.sound";
    private String soundFileName;
    private Sequence sequence;
    private byte[] clipData;
    private AudioFormat clipFormat;
    private Clip clip;
    private static final Debug debug = Debug.create((Class)SoundAlert.class);
    private static boolean audioLineAvailable = true;
    private volatile boolean soundRunning = false;
    private long duration = 0L;
    private boolean durationChanged = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SoundAlert(int n) {
        try {
            this.soundFileName = Device.getProperty(PROPERTY_ALERT[n], Device.getProperty(PROPERTY_ALERT_DEFAULT));
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
        AudioInputStream audioInputStream = null;
        boolean bl = false;
        if (this.soundFileName == null) {
            bl = true;
        }
        URL uRL = null;
        if (!bl) {
            uRL = DevicePropertyManager.getResource((Properties)Device.getProperties(), (String)this.soundFileName);
            try {
                audioInputStream = AudioSystem.getAudioInputStream(uRL);
                debug.println(1, "Sound: Loaded sampled file {0}", (Object)uRL.toExternalForm());
            }
            catch (IOException iOException) {
                Debug.warning((String)("Sound " + uRL.toExternalForm() + " does not exist"));
                bl = true;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (!bl && audioInputStream == null) {
            try {
                this.sequence = MidiSystem.getSequence(uRL);
                debug.println(1, "Sound: loaded MIDI file");
            }
            catch (InvalidMidiDataException invalidMidiDataException) {
                Debug.warning((String)("'" + this.soundFileName + "' is not valid audio or MIDI file"));
                bl = true;
            }
            catch (Exception exception) {
                Debug.warning((String)("'" + this.soundFileName + "' is not valid audio or MIDI file"));
                bl = true;
            }
        }
        if (!bl && audioInputStream != null) {
            try {
                this.clipFormat = audioInputStream.getFormat();
                if (!this.clipFormat.getEncoding().equals(AudioFormat.Encoding.PCM_SIGNED) && !this.clipFormat.getEncoding().equals(AudioFormat.Encoding.PCM_UNSIGNED)) {
                    this.clipFormat = new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, this.clipFormat.getSampleRate(), 16, this.clipFormat.getChannels(), 2 * this.clipFormat.getChannels(), this.clipFormat.getSampleRate(), false);
                    audioInputStream = AudioSystem.getAudioInputStream(this.clipFormat, audioInputStream);
                    this.clipFormat = audioInputStream.getFormat();
                }
                DataLine.Info info = new DataLine.Info(Clip.class, this.clipFormat);
                if (audioInputStream.getFrameLength() != -1L) {
                    int n2 = (int)(audioInputStream.getFrameLength() * (long)this.clipFormat.getFrameSize());
                    this.clipData = new byte[n2];
                    int n3 = 0;
                    int n4 = 0;
                    do {
                        if ((n4 = audioInputStream.read(this.clipData, n3, n2 - n3)) <= 0) continue;
                        n3 += n4;
                    } while (n3 < n2 && n4 > 0);
                } else {
                    ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                    byte[] byArray = new byte[4096];
                    int n5 = 0;
                    while ((n5 = audioInputStream.read(byArray, 0, byArray.length)) > 0) {
                        byteArrayOutputStream.write(byArray, 0, n5);
                    }
                    this.clipData = byteArrayOutputStream.toByteArray();
                }
                this.clip = (Clip)AudioSystem.getLine(info);
                audioLineAvailable = true;
            }
            catch (LineUnavailableException lineUnavailableException) {
                if (audioLineAvailable) {
                    Debug.warning((String)"Cannot access audio system");
                    audioLineAvailable = false;
                }
                bl = true;
            }
            catch (Exception exception) {
                debug.exception(1, (Throwable)exception);
                System.err.println(exception);
                bl = true;
            }
            finally {
                try {
                    audioInputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
        if (bl) {
            this.close();
            this.setDefaultSound();
        }
    }

    public boolean playAlert() {
        if (this.sequence != null) {
            return this.playMidi();
        }
        if (this.clip != null) {
            return this.playSampled();
        }
        return false;
    }

    public synchronized void setDuration(int n) {
        this.duration = n;
        this.durationChanged = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean playMidi() {
        boolean bl;
        long l = 0L;
        Object object = this;
        synchronized (object) {
            if (this.soundRunning) {
                return false;
            }
            if (this.duration > 0L) {
                l = System.currentTimeMillis() + this.duration;
                this.durationChanged = false;
            }
            this.soundRunning = true;
        }
        if (this.sequence == null) return false;
        object = null;
        try {
            object = MidiSystem.getSequencer();
            object.open();
            object.setSequence(this.sequence);
            block16: do {
                object.setMicrosecondPosition(0L);
                object.start();
                try {
                    Thread.sleep(100L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                while (object.isRunning()) {
                    SoundAlert soundAlert = this;
                    synchronized (soundAlert) {
                        if (this.durationChanged) {
                            l = System.currentTimeMillis() + this.duration;
                            this.durationChanged = false;
                        }
                    }
                    if (l > 0L && System.currentTimeMillis() > l) continue block16;
                    try {
                        Thread.sleep(100L);
                    }
                    catch (Exception exception) {
                        // empty catch block
                        continue block16;
                    }
                }
            } while (System.currentTimeMillis() < l);
            object.stop();
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.soundRunning = false;
            bl = true;
            Object var7_11 = null;
            if (object == null) return bl;
            if (this.soundRunning) return bl;
        }
        catch (Exception exception) {
            try {
                debug.exception(1, (Throwable)exception);
                this.soundRunning = false;
                Object var7_12 = null;
                if (object == null) return false;
                if (this.soundRunning) return false;
            }
            catch (Throwable throwable) {
                Object var7_13 = null;
                if (object == null || this.soundRunning) throw throwable;
                object.close();
                throw throwable;
            }
            object.close();
            return false;
        }
        object.close();
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean playSampled() {
        boolean bl;
        block21: {
            if (this.clip == null) return false;
            if (this.clipData == null) return false;
            if (this.clipFormat == null) return false;
            long l = 0L;
            try {
                boolean bl2;
                try {
                    SoundAlert soundAlert = this;
                    synchronized (soundAlert) {
                        if (this.soundRunning) {
                            bl = false;
                            // MONITOREXIT @DISABLED, blocks:[0, 1, 20, 7] lbl11 : MonitorExitStatement: MONITOREXIT : var3_2
                            Object var8_9 = null;
                            if (this.clip == null) return bl;
                            if (this.soundRunning) return bl;
                            break block21;
                        }
                        if (!this.clip.isOpen()) {
                            this.clip.open(this.clipFormat, this.clipData, 0, this.clipData.length);
                            if (this.duration > 0L) {
                                l = System.currentTimeMillis() + this.duration;
                                this.durationChanged = false;
                            }
                        }
                        this.soundRunning = true;
                    }
                    block14: do {
                        this.clip.setFramePosition(0);
                        this.clip.start();
                        try {
                            Thread.sleep(100L);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        while (this.clip.isActive()) {
                            soundAlert = this;
                            synchronized (soundAlert) {
                                if (this.durationChanged) {
                                    l = System.currentTimeMillis() + this.duration;
                                    this.durationChanged = false;
                                }
                                if (l > 0L && System.currentTimeMillis() > l) continue block14;
                            }
                            try {
                                Thread.sleep(100L);
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                                continue block14;
                            }
                        }
                    } while (System.currentTimeMillis() < l);
                    this.clip.stop();
                    this.soundRunning = false;
                    bl2 = true;
                    Object var8_10 = null;
                    if (this.clip == null) return bl2;
                    if (this.soundRunning) return bl2;
                }
                catch (LineUnavailableException lineUnavailableException) {
                    if (audioLineAvailable) {
                        Debug.warning((String)"Cannot access audio system");
                        audioLineAvailable = false;
                    }
                    this.soundRunning = false;
                    Object var8_11 = null;
                    if (this.clip == null) return false;
                    if (this.soundRunning) return false;
                    this.clip.close();
                    return false;
                }
                catch (Exception exception) {
                    debug.exception(1, (Throwable)exception);
                    this.soundRunning = false;
                    Object var8_12 = null;
                    if (this.clip == null) return false;
                    if (this.soundRunning) return false;
                    this.clip.close();
                    return false;
                }
                this.clip.close();
                return bl2;
            }
            catch (Throwable throwable) {
                Object var8_13 = null;
                if (this.clip == null) throw throwable;
                if (this.soundRunning) throw throwable;
                this.clip.close();
                throw throwable;
            }
        }
        this.clip.close();
        return bl;
    }

    private void setDefaultSound() {
    }

    public void close() {
        if (this.clip != null && this.clip.isOpen()) {
            this.clip.close();
        }
        this.sequence = null;
        this.clip = null;
        this.clipData = null;
        this.clipFormat = null;
    }
}

