/*
 * Decompiled with CFR 0.152.
 */
package com.sun.kvem.midp;

import com.sun.kvem.midp.FileConnEventGenPanel;
import com.sun.kvem.util.ActionReflector;
import com.sun.kvem.util.StateCondition;
import com.sun.kvem.util.StateController;
import com.sun.kvem.util.ToolkitResources;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class RootMountName {
    private final JDialog dialog;
    private final JTextField fileSystemInput = new JTextField();
    private String newRootName;

    public RootMountName(JFrame jFrame, final File file) {
        this.dialog = new JDialog((Frame)jFrame, true);
        String string = ToolkitResources.getString((String)"FILE_CONN.REQUEST_DLG_TITLE");
        String string2 = ToolkitResources.getString((String)"FILE_CONN.REQUEST_DLG_MSG");
        this.dialog.setTitle(string);
        JLabel jLabel = new JLabel(string2);
        jLabel.setLabelFor(this.fileSystemInput);
        Box box = new Box(0);
        box.add(jLabel);
        box.add(Box.createGlue());
        box.add(Box.createHorizontalStrut(5));
        box.add(this.fileSystemInput);
        this.dialog.getContentPane().add(box);
        String string3 = ToolkitResources.getString((String)"OK");
        String string4 = ToolkitResources.getString((String)"CANCEL");
        JButton jButton = new JButton(string3);
        jButton.setToolTipText(ToolkitResources.getString((String)"OK_HELP"));
        jButton.setMnemonic(ToolkitResources.getString((String)"OK_SHORTCUT").charAt(0));
        JButton jButton2 = new JButton(string4);
        jButton2.setToolTipText(ToolkitResources.getString((String)"CANCEL_HELP"));
        jButton2.setMnemonic(ToolkitResources.getString((String)"CANCEL_SHORTCUT").charAt(0));
        jButton.setActionCommand("ok");
        jButton2.setActionCommand("cancel");
        jButton.setEnabled(false);
        StateCondition stateCondition = new StateCondition(){

            public boolean enable(Component component, DocumentEvent documentEvent) {
                return RootMountName.this.isValidRoot(file, RootMountName.this.fileSystemInput.getText());
            }
        };
        this.fileSystemInput.getDocument().addDocumentListener((DocumentListener)new StateController((Component)jButton, stateCondition));
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout(2));
        jPanel.add(jButton);
        jPanel.add(jButton2);
        this.dialog.getContentPane().add("South", jPanel);
        ActionReflector actionReflector = new ActionReflector((Object)this);
        jButton.addActionListener((ActionListener)actionReflector);
        jButton2.addActionListener((ActionListener)actionReflector);
        this.fileSystemInput.setActionCommand("ok");
        this.fileSystemInput.addActionListener((ActionListener)actionReflector);
        this.dialog.pack();
        Rectangle rectangle = jFrame.getBounds();
        Point point = new Point(rectangle.x + rectangle.width / 2, rectangle.y + rectangle.height / 2);
        Dimension dimension = this.dialog.getSize();
        this.dialog.setLocation(point.x - dimension.width / 2, point.y - dimension.height / 2);
    }

    public void ok() {
        this.newRootName = this.fileSystemInput.getText();
        this.dialog.setVisible(false);
    }

    public void cancel() {
        this.newRootName = null;
        this.dialog.setVisible(false);
    }

    public String getNewRootName() {
        this.newRootName = null;
        this.dialog.setVisible(true);
        return this.newRootName;
    }

    private boolean isValidRoot(File file, String string) {
        if (string == null) {
            return false;
        }
        if (FileConnEventGenPanel.isMountedRoot(string)) {
            return false;
        }
        int n = string.length();
        if (string.endsWith("/") || string.endsWith(File.separator)) {
            string = string.substring(0, --n);
        }
        if (n == 0) {
            return false;
        }
        if (string.indexOf(File.separatorChar) != -1 || string.indexOf("/") != -1) {
            return false;
        }
        File file2 = new File(file, string);
        if (file2.exists() && !file2.isDirectory()) {
            return false;
        }
        try {
            file = file.getCanonicalFile();
            return file2.getCanonicalFile().getParentFile().equals(file);
        }
        catch (IOException iOException) {
            return false;
        }
    }
}

