/*
 * Decompiled with CFR 0.152.
 */
package com.sun.kvem.midp;

import com.sun.kvem.environment.Debug;
import com.sun.kvem.environment.EmulResource;
import com.sun.kvem.environment.ToolkitDirs;
import com.sun.kvem.util.PathUtils;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.StringTokenizer;

public class ResourceBridge {
    private static final Debug debug = Debug.create((Class)ResourceBridge.class);
    private static ResourceBundle bundle;
    private static EmulResource resource;

    public static synchronized ResourceBundle getBundle() {
        if (bundle == null) {
            Locale locale = Locale.getDefault();
            ResourceBridge.loadResourceBundle(locale.toString());
        }
        return bundle;
    }

    public static boolean loadResourceBundle(String string) {
        Object object;
        String[] stringArray;
        debug.println(1, "Attempting to load for {0}", (Object)string);
        Locale locale = Locale.getDefault();
        if (string != null) {
            stringArray = new StringTokenizer(string, "_");
            object = stringArray.nextToken();
            if (!stringArray.hasMoreTokens()) {
                locale = new Locale((String)object);
            } else {
                String string2 = stringArray.nextToken();
                if (!stringArray.hasMoreTokens()) {
                    locale = new Locale((String)object, string2);
                } else {
                    String string3 = stringArray.nextToken();
                    locale = new Locale((String)object, string2, string3);
                }
            }
        }
        debug.println(1, "Locale is {0}", (Object)locale);
        stringArray = new String[]{ToolkitDirs.LIB};
        object = PathUtils.createClassLoader((String[])stringArray);
        try {
            bundle = ResourceBundle.getBundle("ME_I18N", locale, (ClassLoader)object);
            resource = (EmulResource)((ClassLoader)object).loadClass("Resource_" + string).newInstance();
            resource.setBundle(bundle);
        }
        catch (ClassNotFoundException classNotFoundException) {
            debug.exception(1, (Throwable)classNotFoundException);
        }
        catch (InstantiationException instantiationException) {
            debug.exception(1, (Throwable)instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            debug.exception(1, (Throwable)illegalAccessException);
        }
        catch (MissingResourceException missingResourceException) {
            debug.exception(1, (Throwable)missingResourceException);
        }
        return bundle != null;
    }

    public static String getString(String string) {
        String string2 = string.replace(' ', '_');
        string2 = string2.replace(':', '_');
        if (string.indexOf("\n") == -1) {
            try {
                return ResourceBridge.getBundle().getString(string2);
            }
            catch (MissingResourceException missingResourceException) {
                debug.println(1, "Couldn't find text for resource {0}", (Object)string);
                debug.println(1, "tKey = {0}", (Object)string2);
            }
        } else {
            StringTokenizer stringTokenizer = new StringTokenizer(string2, "\n");
            String string3 = null;
            try {
                StringBuffer stringBuffer = new StringBuffer();
                while (stringTokenizer.hasMoreTokens()) {
                    string3 = stringTokenizer.nextToken();
                    stringBuffer.append(ResourceBridge.getBundle().getString(string3));
                    stringBuffer.append("\n");
                }
                stringBuffer.setLength(stringBuffer.length() - 1);
                return stringBuffer.toString();
            }
            catch (MissingResourceException missingResourceException) {
                Debug.warning((String)("Resource " + string + " has line breaks in it. " + "Missing text for portion '" + string3 + "'"));
            }
        }
        return string;
    }

    public static boolean isLocalizedAMPMafterTime() {
        if (resource != null) {
            return resource.isLocalizedAMPMafterTime();
        }
        return true;
    }

    public static int getLocalizedFirstDayOfWeek() {
        if (resource != null) {
            return resource.getLocalizedFirstDayOfWeek();
        }
        return 1;
    }

    public static String getLocalizedDateTimeString(String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8) {
        if (resource != null) {
            return resource.getLocalizedDateTimeString(string, string2, string3, string4, string5, string6, string7, string8);
        }
        return null;
    }

    public static String getLocalizedTimeString(String string, String string2, String string3, String string4) {
        if (resource != null) {
            return resource.getLocalizedTimeString(string, string2, string3, string4);
        }
        return null;
    }

    public static String getLocalizedDateString(String string, String string2, String string3, String string4) {
        if (resource != null) {
            return resource.getLocalizedDateString(string, string2, string3, string4);
        }
        return null;
    }
}

