/*
 * Decompiled with CFR 0.152.
 */
package com.sun.kvem.midp;

import com.sun.kvem.Device;
import com.sun.kvem.DeviceEventManager;
import com.sun.kvem.Screen;
import com.sun.kvem.environment.Debug;
import com.sun.kvem.midp.MIDP;
import com.sun.kvem.midp.MIDPKeyboardHandler;
import java.awt.event.InputEvent;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

public class QwertyKeyboardHandler
implements MIDPKeyboardHandler {
    private static final Debug debug = Debug.create((Class)QwertyKeyboardHandler.class);
    private boolean capsMode = false;
    private Map characterToKeyCodeMap = new HashMap();
    private final KeyMapping KEY_MAPPING_BASE = new KeyMapping();
    private final KeyMapping KEY_MAPPING_SHIFT = new KeyMapping();
    private final KeyMapping KEY_MAPPING_ALT = new KeyMapping();
    private KeyMapping[] KEY_MAPPINGS = new KeyMapping[]{this.KEY_MAPPING_BASE, this.KEY_MAPPING_SHIFT, this.KEY_MAPPING_ALT};
    private KeyMapping keyMapping = this.KEY_MAPPING_BASE;
    private static final String KEY_BACK_SPACE = "BACK_SPACE";
    private static final String KEY_ALT = "ALT";
    private static final String KEY_SHIFT = "SHIFT";
    private static final String KEY_CAPS_LOCK = "CAPS_LOCK";
    private static final String KEY_MODECHANGE = "MODECHANGE";
    private static final String KEY_POWER = "POWER";
    private static final String KEY_END = "END";
    private static final String SUSPEND = "SUSPEND";
    private static final String RESUME = "RESUME";
    private static final String KEY_UP = "UP";
    private static final String KEY_DOWN = "DOWN";
    private static final String KEY_LEFT = "LEFT";
    private static final String KEY_RIGHT = "RIGHT";
    private static final String KEY_SELECT = "SELECT";
    private static final String KEY_ENTER = "ENTER";
    private static final String KEY_MENU = "MENU";
    private static final String KEY_BACK = "BACK";
    private static final String KEY_HELP = "HELP";
    private static final String KEY_SPACE = "SPACE";
    private static final String SOFT1 = "SOFT1";
    private static final String SOFT2 = "SOFT2";
    private static final String SOFT3 = "SOFT3";
    private static final String SOFT4 = "SOFT4";
    private static final String[] keyNames = new String[]{"A", "B", "C", "D", "E", "F", "G", "H", "I", "J", "K", "L", "M", "N", "O", "P", "Q", "R", "S", "T", "U", "V", "W", "X", "Y", "Z", "ENTER", "BACK_SPACE", "SHIFT", "POWER", "END", "ALT", "SELECT", "UP", "DOWN", "LEFT", "RIGHT", "MENU", "HELP", "BACK", "SPACE", "MODECHANGE", "1", "2", "3", "4", "5", "6", "7", "8", "9", "0", "F1", "F2", "F3", "F4", "F5", "F6", "F7", "F8", "F9", "F10", "F11", "F12", "SOFT1", "SOFT2", "SOFT3", "SOFT4", "USER1", "USER2", "USER3", "USER4", "USER5", "USER6", "USER7", "USER8", "USER9", "USER10", "SUSPEND", "RESUME"};
    private static final int[] midpKeyCodes = new int[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 42, 35, -1, -2, -3, -4, -5, -6, -7, -8, -10, -11, -12};
    private Object[][] specialKeys = new Object[][]{{"ALT", new AltKey("ALT")}, {"SHIFT", new ShiftKey("SHIFT")}, {"CAPS_LOCK", new CapsLockKey("CAPS_LOCK")}, {"MODECHANGE", new CharKey("MODECHANGE")}, {"POWER", new PowerKey("POWER")}, {"SUSPEND", new SuspendKey("SUSPEND")}, {"RESUME", new ResumeKey("RESUME")}, {"UP", new SpecialCharacterKey("UP", -1)}, {"DOWN", new SpecialCharacterKey("DOWN", -2)}, {"LEFT", new SpecialCharacterKey("LEFT", -3)}, {"RIGHT", new SpecialCharacterKey("RIGHT", -4)}, {"SELECT", new SpecialCharacterKey("SELECT", -5)}, {"SOFT1", new SpecialCharacterKey("SOFT1", -6)}, {"SOFT2", new SpecialCharacterKey("SOFT2", -7)}, {"SOFT3", new SpecialCharacterKey("SOFT3", -20)}, {"SOFT4", new SpecialCharacterKey("SOFT4", -21)}, {"ENTER", new CharacterKey("ENTER", 10)}, {"BACK_SPACE", new CharacterKey("BACK_SPACE", 8)}, {"SPACE", new CharacterKey("SPACE", 32)}, {"END", new CharacterKey("END", 13)}};
    private static final int GAME_KEY_NONE = 0;
    private static final int GAME_KEY_UP = 1;
    private static final int GAME_KEY_DOWN = 6;
    private static final int GAME_KEY_LEFT = 2;
    private static final int GAME_KEY_RIGHT = 5;
    private static final int GAME_KEY_SELECT = 8;
    private static final int GAME_KEY_A = 9;
    private static final int GAME_KEY_B = 10;
    private static final int GAME_KEY_C = 11;
    private static final int GAME_KEY_D = 12;
    private static final String GAME_KEY_NAME_UP = "up";
    private static final String GAME_KEY_NAME_DOWN = "down";
    private static final String GAME_KEY_NAME_LEFT = "left";
    private static final String GAME_KEY_NAME_RIGHT = "right";
    private static final String GAME_KEY_NAME_SELECT = "select";
    private static final String GAME_KEY_NAME_A = "a";
    private static final String GAME_KEY_NAME_B = "b";
    private static final String GAME_KEY_NAME_C = "c";
    private static final String GAME_KEY_NAME_D = "d";
    private static final String GAME_KEY_DEFAULT_UP = "UP";
    private static final String GAME_KEY_DEFAULT_DOWN = "DOWN";
    private static final String GAME_KEY_DEFAULT_LEFT = "LEFT";
    private static final String GAME_KEY_DEFAULT_RIGHT = "RIGHT";
    private static final String GAME_KEY_DEFAULT_SELECT = "SELECT";
    private static final String GAME_KEY_DEFAULT_A = "A";
    private static final String GAME_KEY_DEFAULT_B = "B";
    private static final String GAME_KEY_DEFAULT_C = "C";
    private static final String GAME_KEY_DEFAULT_D = "D";
    private static final String SYSTEM_KEY_NAME_POWER = "power";
    private static final String SYSTEM_KEY_NAME_SEND = "send";
    private static final String SYSTEM_KEY_NAME_END = "end";
    private static final String SYSTEM_KEY_NAME_CLEAR = "clear";
    private static final String SYSTEM_KEY_DEFAULT_POWER = "POWER";
    private static final String SYSTEM_KEY_DEFAULT_SEND = "SELECT";
    private static final String SYSTEM_KEY_DEFAULT_END = "END";
    private static final String SYSTEM_KEY_DEFAULT_CLEAR = "BACK_SPACE";
    private static final int SYSTEM_KEY_NONE = 0;
    private static final int SYSTEM_KEY_POWER = 1;
    private static final int SYSTEM_KEY_SEND = 2;
    private static final int SYSTEM_KEY_END = 3;
    private static final int SYSTEM_KEY_CLEAR = 4;
    private static final int KEY_CODE_UP = -1;
    private static final int KEY_CODE_DOWN = -2;
    private static final int KEY_CODE_LEFT = -3;
    private static final int KEY_CODE_RIGHT = -4;
    private static final int KEY_CODE_SELECT = -5;
    private static final int KEY_CODE_END = 13;
    private Map keyCodeToGameActionMap;
    private Map keyCodeToSystemKeyMap;
    static /* synthetic */ Class class$java$awt$event$MouseEvent;

    private void updateMode() {
        String string = "off";
        if (this.keyMapping == this.KEY_MAPPING_BASE) {
            string = this.capsMode ? "ABC" : "abc";
        } else if (this.keyMapping == this.KEY_MAPPING_SHIFT) {
            string = "ABC";
        } else if (this.keyMapping == this.KEY_MAPPING_ALT) {
            string = "123";
        }
        debug.println(2, "Text input state = {0}", (Object)string);
        Screen.getInstance().setIconState("inmode", string);
    }

    private void clearMode() {
        Screen.getInstance().setIconState("inmode", "off");
    }

    private synchronized KeyMapping getKeyMapping() {
        return this.keyMapping;
    }

    private synchronized void setKeyMapping(KeyMapping keyMapping) {
        this.keyMapping = keyMapping;
        this.updateMode();
    }

    public boolean keyPressed(int n, InputEvent inputEvent) {
        debug.println(3, "InputEvent {0}", (Object)inputEvent);
        return this.getKeyMapping().keyPressed(n, inputEvent);
    }

    public boolean keyReleased(int n, InputEvent inputEvent) {
        return this.getKeyMapping().keyReleased(n);
    }

    public boolean keyTyped(char c, InputEvent inputEvent) {
        return false;
    }

    public String[] getKeyNames() {
        return (String[])keyNames.clone();
    }

    public int getKeyCode(String string) {
        int n = Arrays.binarySearch(keyNames, string);
        debug.println(3, "Key name {0} maps to {1}", (Object)string, n);
        return n;
    }

    public String getKeyName(int n) {
        return keyNames[n];
    }

    public QwertyKeyboardHandler() {
        for (int i = 0; i < this.KEY_MAPPINGS.length; ++i) {
            this.setUpMapping(this.KEY_MAPPINGS[i], i);
        }
    }

    private Key makeSpecialKey(String string) {
        string = string.intern();
        for (int i = 0; i < this.specialKeys.length; ++i) {
            if (string != this.specialKeys[i][0]) continue;
            return (Key)this.specialKeys[i][1];
        }
        return null;
    }

    private void setUpMapping(KeyMapping keyMapping, int n) {
        debug.println(2, "Creating key map for state {0}", n);
        for (int i = 0; i < keyNames.length; ++i) {
            Object object;
            String string;
            Key key = this.makeSpecialKey(keyNames[i]);
            if (key == null && (string = Device.getProperty((String)(object = "keyboard.handler.qwerty." + keyNames[i]))) != null) {
                int n2 = n * 2 + 1;
                for (int j = 0; j < string.length() - 1; ++j) {
                    if (string.charAt(j) != '\'' || j > 0 && string.charAt(j - 1) == '\\' || --n2 != 0) continue;
                    char c = string.charAt(j + 1);
                    key = new CharacterKey(keyNames[i], c);
                }
            }
            if (key == null) continue;
            debug.println(3, "  {0}. Mapped key {1}", i, (Object)key);
            keyMapping.setKeyForCode(i, key);
            if (!(key instanceof CharacterKey)) continue;
            object = (CharacterKey)key;
            this.characterToKeyCodeMap.put(new Integer(((CharacterKey)object).getChar()), new Integer(i));
        }
    }

    public String getInputMethodHandlerClassName() {
        return "com.sun.midp.lcdui.EmulInputMethodHandler";
    }

    private void fillGameActionMap(String string, String string2, int n) {
        int n2 = this.getKeyCode(Device.getProperty("game." + string, string2));
        debug.println(3, "  {0} -> {1}", n2, (Object)string);
        this.keyCodeToGameActionMap.put(new Integer(n2), new Integer(n));
    }

    private synchronized void setUpGameActions() {
        if (this.keyCodeToGameActionMap == null) {
            debug.println(2, "Set up game actions");
            this.keyCodeToGameActionMap = new HashMap();
            this.fillGameActionMap(GAME_KEY_NAME_UP, "UP", 1);
            this.fillGameActionMap(GAME_KEY_NAME_DOWN, "DOWN", 6);
            this.fillGameActionMap(GAME_KEY_NAME_LEFT, "LEFT", 2);
            this.fillGameActionMap(GAME_KEY_NAME_RIGHT, "RIGHT", 5);
            this.fillGameActionMap(GAME_KEY_NAME_SELECT, "SELECT", 8);
            this.fillGameActionMap(GAME_KEY_NAME_A, GAME_KEY_DEFAULT_A, 9);
            this.fillGameActionMap(GAME_KEY_NAME_B, GAME_KEY_DEFAULT_B, 10);
            this.fillGameActionMap(GAME_KEY_NAME_C, GAME_KEY_DEFAULT_C, 11);
            this.fillGameActionMap(GAME_KEY_NAME_D, GAME_KEY_DEFAULT_D, 12);
        }
    }

    private void fillSystemKeyMap(String string, String string2, int n) {
        int n2 = this.getKeyCode(Device.getProperty("system_key." + string, string2));
        debug.println(3, "  {0} -> {1}", n2, (Object)string);
        this.keyCodeToSystemKeyMap.put(new Integer(n2), new Integer(n));
    }

    private synchronized void setUpSystemKeys() {
        if (this.keyCodeToSystemKeyMap == null) {
            debug.println(2, "Set up system key codes");
            this.keyCodeToSystemKeyMap = new HashMap();
            this.fillSystemKeyMap(SYSTEM_KEY_NAME_POWER, "POWER", 1);
            this.fillSystemKeyMap(SYSTEM_KEY_NAME_SEND, "SELECT", 2);
            this.fillSystemKeyMap(SYSTEM_KEY_NAME_CLEAR, "BACK_SPACE", 4);
            this.fillSystemKeyMap(SYSTEM_KEY_NAME_END, "END", 3);
        }
    }

    private String gameActionToName(int n) {
        switch (n) {
            case 1: {
                return GAME_KEY_NAME_UP;
            }
            case 6: {
                return GAME_KEY_NAME_DOWN;
            }
            case 2: {
                return GAME_KEY_NAME_LEFT;
            }
            case 5: {
                return GAME_KEY_NAME_RIGHT;
            }
            case 8: {
                return GAME_KEY_NAME_SELECT;
            }
            case 9: {
                return GAME_KEY_NAME_A;
            }
            case 10: {
                return GAME_KEY_NAME_B;
            }
            case 11: {
                return GAME_KEY_NAME_C;
            }
            case 12: {
                return GAME_KEY_NAME_D;
            }
        }
        return null;
    }

    public int getKeyCodeForGameAction(int n) {
        String string = this.gameActionToName(n);
        if (string == null) {
            throw new IllegalArgumentException("No such game action " + n);
        }
        String string2 = "game." + string;
        String string3 = string.toUpperCase();
        String string4 = Device.getProperty(string2, string3);
        int n2 = this.getKeyCode(string4);
        return n2;
    }

    public int getGameActionForKeyCode(int n) {
        this.setUpGameActions();
        Integer n2 = (Integer)this.keyCodeToGameActionMap.get(new Integer(n));
        if (n2 == null) {
            debug.println(3, "No game action for key code {0}", n);
            return 0;
        }
        debug.println(3, "Key code {0} has game action {1}", n, (Object)n2);
        return n2;
    }

    public int getSystemKeyForKeyCode(int n) {
        this.setUpSystemKeys();
        Integer n2 = (Integer)this.keyCodeToSystemKeyMap.get(new Integer(n));
        if (n2 == null) {
            debug.println(3, "No system key for key code {0}", n);
            return 0;
        }
        debug.println(3, "Key code {0} has system key {1}", n, (Object)n2);
        return n2;
    }

    public int getHandlerCodeForMIDPCode(int n) {
        Integer n2 = (Integer)this.characterToKeyCodeMap.get(new Integer(n));
        if (n2 == null) {
            debug.println(3, "No emulator key code for MIDP code {0}", n);
            throw new IllegalArgumentException("No key matching MIDP code " + n);
        }
        debug.println(3, "MIDP key code {0} -> emulator code {1}", n, (Object)n2);
        return n2;
    }

    public int getMIDPCodeForHandlerCode(int n) {
        class MIDPCodeFinder {
            MIDPCodeFinder() {
            }

            int search(KeyMapping keyMapping, int n) {
                Key key = keyMapping.getKeyForCode(n);
                if (key instanceof CharacterKey) {
                    CharacterKey characterKey = (CharacterKey)key;
                    int n2 = characterKey.getChar();
                    if (Arrays.binarySearch(midpKeyCodes, n2) != -1) {
                        return n2;
                    }
                }
                return 0;
            }

            int search(KeyMapping[] keyMappingArray, int n) {
                for (int i = 0; i < keyMappingArray.length; ++i) {
                    int n2 = this.search(keyMappingArray[i], n);
                    if (n2 == 0) continue;
                    return n2;
                }
                return 0;
            }
        }
        MIDPCodeFinder mIDPCodeFinder = new MIDPCodeFinder();
        int n2 = mIDPCodeFinder.search(this.KEY_MAPPINGS, n);
        if (n2 == 0) {
            debug.println(3, "No MIDP key code for emulator code {0}", n);
            throw new IllegalArgumentException("Key code " + n + " has no equivalent in MIDP");
        }
        debug.println(3, "Emulator key code {0} -> MIDP code {1}", n, n2);
        return n2;
    }

    static {
        Arrays.sort(keyNames);
        for (int i = 0; i < keyNames.length; ++i) {
            QwertyKeyboardHandler.keyNames[i] = keyNames[i].intern();
        }
        Arrays.sort(midpKeyCodes);
    }

    private static class KeyMapping {
        private Map keys = new HashMap();

        private KeyMapping() {
        }

        Key getKeyForCode(int n) {
            return (Key)this.keys.get(new Integer(n));
        }

        void setKeyForCode(int n, Key key) {
            this.keys.put(new Integer(n), key);
        }

        boolean keyPressed(int n, InputEvent inputEvent) {
            Key key = this.getKeyForCode(n);
            debug.println(3, "Received keyPressed {0}, changed to {1}", n, (Object)key);
            if (key == null) {
                debug.println(2, "Ignoring key press: null");
                return false;
            }
            debug.println(2, "Key pressed: {0}", (Object)key);
            if (inputEvent.getClass() == (class$java$awt$event$MouseEvent == null ? (class$java$awt$event$MouseEvent = QwertyKeyboardHandler.class$("java.awt.event.MouseEvent")) : class$java$awt$event$MouseEvent)) {
                key.type();
            } else {
                key.press();
            }
            return true;
        }

        boolean keyReleased(int n) {
            Key key = this.getKeyForCode(n);
            if (key == null) {
                debug.println(2, "Ignoring key release: null");
                return false;
            }
            debug.println(2, "Key released: {0}", (Object)key);
            key.release();
            return true;
        }
    }

    private class SuspendKey
    extends Key {
        SuspendKey(String string) {
            super(string);
        }

        void press() {
            Debug debug = debug;
            debug;
            debug.println(1, "Sending suspend event");
            MIDP.injectPauseEvent(1);
        }

        void release() {
        }

        void repeat() {
        }
    }

    private class ResumeKey
    extends Key {
        ResumeKey(String string) {
            super(string);
        }

        void press() {
            Debug debug = debug;
            debug;
            debug.println(1, "Sending resume event");
            MIDP.injectPauseEvent(2);
        }

        void release() {
        }

        void repeat() {
        }
    }

    private class PowerKey
    extends Key {
        PowerKey(String string) {
            super(string);
        }

        void press() {
        }

        void release() {
            Debug debug = debug;
            debug;
            debug.println(1, "Sending power off event");
            int[] nArray = new int[]{11, 3, 0, 0};
            DeviceEventManager.getInstance().queueEvent(nArray);
        }

        void repeat() {
        }
    }

    private class AltLockKey
    extends Key {
        KeyMapping oldState;

        AltLockKey(String string) {
            super(string);
            this.oldState = null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void press() {
            QwertyKeyboardHandler qwertyKeyboardHandler = QwertyKeyboardHandler.this;
            synchronized (qwertyKeyboardHandler) {
                KeyMapping keyMapping = QwertyKeyboardHandler.this.getKeyMapping();
                Debug debug = debug;
                debug;
                debug.println(1, "changing key mapping");
                if (keyMapping == QwertyKeyboardHandler.this.KEY_MAPPING_ALT) {
                    QwertyKeyboardHandler.this.setKeyMapping(this.oldState);
                } else {
                    this.oldState = keyMapping;
                    QwertyKeyboardHandler.this.setKeyMapping(QwertyKeyboardHandler.this.KEY_MAPPING_ALT);
                }
            }
        }

        void release() {
        }

        void repeat() {
        }
    }

    private class AltKey
    extends Key {
        KeyMapping oldState;

        AltKey(String string) {
            super(string);
            this.oldState = null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void press() {
            QwertyKeyboardHandler qwertyKeyboardHandler = QwertyKeyboardHandler.this;
            synchronized (qwertyKeyboardHandler) {
                KeyMapping keyMapping;
                this.oldState = keyMapping = QwertyKeyboardHandler.this.getKeyMapping();
                QwertyKeyboardHandler.this.setKeyMapping(QwertyKeyboardHandler.this.KEY_MAPPING_ALT);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void release() {
            QwertyKeyboardHandler qwertyKeyboardHandler = QwertyKeyboardHandler.this;
            synchronized (qwertyKeyboardHandler) {
                QwertyKeyboardHandler.this.setKeyMapping(this.oldState);
            }
        }

        void repeat() {
        }
    }

    private class CharKey
    extends Key {
        CharKey(String string) {
            super(string);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void press() {
            QwertyKeyboardHandler qwertyKeyboardHandler = QwertyKeyboardHandler.this;
            synchronized (qwertyKeyboardHandler) {
                KeyMapping keyMapping = QwertyKeyboardHandler.this.getKeyMapping();
                if (keyMapping == QwertyKeyboardHandler.this.KEY_MAPPING_BASE || keyMapping == QwertyKeyboardHandler.this.KEY_MAPPING_SHIFT) {
                    QwertyKeyboardHandler.this.setKeyMapping(QwertyKeyboardHandler.this.KEY_MAPPING_ALT);
                } else {
                    QwertyKeyboardHandler.this.setKeyMapping(QwertyKeyboardHandler.this.KEY_MAPPING_BASE);
                }
            }
        }

        void release() {
        }

        void repeat() {
        }
    }

    private class CapsLockKey
    extends Key {
        CapsLockKey(String string) {
            super(string);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void press() {
            QwertyKeyboardHandler qwertyKeyboardHandler = QwertyKeyboardHandler.this;
            synchronized (qwertyKeyboardHandler) {
                QwertyKeyboardHandler.this.capsMode = !QwertyKeyboardHandler.this.capsMode;
                QwertyKeyboardHandler.this.updateMode();
            }
        }

        void release() {
        }

        void repeat() {
        }
    }

    private class ShiftKey
    extends Key {
        ShiftKey(String string) {
            super(string);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void press() {
            QwertyKeyboardHandler qwertyKeyboardHandler = QwertyKeyboardHandler.this;
            synchronized (qwertyKeyboardHandler) {
                KeyMapping keyMapping = QwertyKeyboardHandler.this.getKeyMapping();
                if (keyMapping == QwertyKeyboardHandler.this.KEY_MAPPING_BASE || keyMapping == QwertyKeyboardHandler.this.KEY_MAPPING_ALT) {
                    QwertyKeyboardHandler.this.setKeyMapping(QwertyKeyboardHandler.this.KEY_MAPPING_SHIFT);
                } else {
                    QwertyKeyboardHandler.this.setKeyMapping(QwertyKeyboardHandler.this.KEY_MAPPING_BASE);
                }
            }
        }

        void release() {
        }

        void repeat() {
        }
    }

    private class SpecialCharacterKey
    extends CharacterKey {
        SpecialCharacterKey(String string, int n) {
            super(string, n);
        }

        void type() {
            this.press();
        }
    }

    private class CharacterKey
    extends Key {
        private final int c;

        CharacterKey(String string, int n) {
            super(string);
            this.c = n;
        }

        int getChar() {
            char c;
            if (QwertyKeyboardHandler.this.capsMode && this.c > 0 && Character.isLetter(c = (char)this.c) && Character.isLowerCase(c)) {
                return Character.toUpperCase(c);
            }
            return this.c;
        }

        void type() {
            this.press();
            int[] nArray = new int[]{9, this.getChar(), 0, 0};
            DeviceEventManager.getInstance().queueEvent(nArray);
        }

        void press() {
            int[] nArray = new int[]{0, this.getChar(), 0, 0};
            DeviceEventManager.getInstance().queueEvent(nArray);
        }

        void release() {
            int[] nArray = new int[]{1, this.getChar(), 0, 0};
            DeviceEventManager.getInstance().queueEvent(nArray);
        }

        void repeat() {
            int[] nArray = new int[]{2, this.getChar(), 0, 0};
            DeviceEventManager.getInstance().queueEvent(nArray);
        }

        public String toString() {
            String string = this.getClass().getName();
            int n = Math.max(string.lastIndexOf(36), string.lastIndexOf(46));
            string = string.substring(Math.max(n, 0));
            return string + "[" + this.name + ", " + this.c + "]";
        }

        public boolean equals(Object object) {
            if (object == null || !(object instanceof CharacterKey)) {
                return false;
            }
            CharacterKey characterKey = (CharacterKey)object;
            return characterKey.c == this.c && super.equals(characterKey);
        }

        public int hashCode() {
            return this.c;
        }
    }

    private abstract class Key {
        protected boolean pressed;
        protected final String name;

        protected Key(String string) {
            this.name = string;
        }

        abstract void press();

        abstract void release();

        abstract void repeat();

        void type() {
            this.press();
        }

        public String toString() {
            return "Key[" + this.name + "]";
        }

        public boolean equals(Object object) {
            if (object == null || !object.getClass().equals(this.getClass())) {
                return false;
            }
            Key key = (Key)object;
            return key.name.equals(this.name);
        }
    }
}

