/*
 * Decompiled with CFR 0.152.
 */
package com.sun.kvem.midp;

import com.sun.kvem.Device;
import com.sun.kvem.environment.Debug;

class PNGProcessor {
    private static final Debug debug = Debug.create((Class)PNGProcessor.class);
    private static byte[] PNGsig = new byte[]{-119, 80, 78, 71, 13, 10, 26, 10};
    private static byte[] IDAT = new byte[]{73, 68, 65, 84};
    private static byte[] IEND = new byte[]{73, 69, 78, 68};
    private static byte[] tRNS = new byte[]{116, 82, 78, 83};
    private final int sizeLen = 4;
    private final int nameLen = 4;
    private final int crcLen = 4;
    private static final String ENABLE_TRANSPARENCY = "enablePNGtransparency";

    PNGProcessor() {
    }

    public boolean isPNGImage(byte[] byArray) {
        if (byArray.length < PNGsig.length) {
            return false;
        }
        return PNGProcessor.compare(byArray, 0, PNGsig, 0, PNGsig.length);
    }

    public boolean includesIEND(byte[] byArray, int n) {
        int n2 = PNGsig.length + n;
        try {
            while (true) {
                int n3 = PNGProcessor.getInt(byArray, n2) + 4 + 4 + 4;
                if (debug.level(2)) {
                    debug.println(2, "Found chunk {0}, size {1}", (Object)new String(byArray, n2 + 4, 4), n3);
                }
                if (PNGProcessor.compare(IEND, 0, byArray, n2 + 4, 4)) {
                    debug.println(1, "IEND chunk found");
                    return true;
                }
                n2 += n3;
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            return false;
        }
    }

    public int remove_tRNS(byte[] byArray) {
        if (Device.getBooleanProperty(ENABLE_TRANSPARENCY, true)) {
            return 0;
        }
        int n = PNGsig.length;
        try {
            while (true) {
                int n2 = PNGProcessor.getInt(byArray, n) + 4 + 4 + 4;
                if (debug.level(2)) {
                    debug.println(2, "Found chunk {0}, size {1}", (Object)new String(byArray, n + 4, 4), n2);
                }
                if (PNGProcessor.compare(IDAT, 0, byArray, n + 4, 4)) {
                    debug.println(1, "tRNS not found");
                    return 0;
                }
                if (PNGProcessor.compare(tRNS, 0, byArray, n + 4, 4)) {
                    System.arraycopy(byArray, 0, byArray, n2, n);
                    debug.println(1, "tRNS found and removed");
                    return n2;
                }
                n += n2;
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            return 0;
        }
    }

    private static int getInt(byte[] byArray, int n) {
        return (byArray[n] & 0xFF) << 24 | (byArray[n + 1] & 0xFF) << 16 | (byArray[n + 2] & 0xFF) << 8 | byArray[n + 3] & 0xFF;
    }

    protected static boolean compare(byte[] byArray, int n, byte[] byArray2, int n2, int n3) {
        for (int i = 0; i < n3; ++i) {
            if (byArray[n + i] == byArray2[n2 + i]) continue;
            return false;
        }
        return true;
    }
}

