/*
 * Decompiled with CFR 0.152.
 */
package com.sun.kvem.midp;

import com.sun.kvem.Device;
import com.sun.kvem.KeyboardManager;
import com.sun.kvem.Screen;
import com.sun.kvem.environment.Debug;
import java.util.Set;
import java.util.StringTokenizer;

public class MenuKeys {
    private static final Debug debug = Debug.create((Class)MenuKeys.class);
    public static final String UP = "up";
    public static final String DOWN = "down";
    public static final String SELECT = "select";
    public static final String ACTIVATE = "activate";
    public static final String DEFAULT_UP = "UP";
    public static final String DEFAULT_DOWN = "DOWN";
    public static final String DEFAULT_LEFT = "LEFT";
    public static final String DEFAULT_RIGHT = "RIGHT";
    public static final String DEFAULT_SELECT = "SELECT";
    public static final String DEFAULT_ACTIVATE = "MENU";
    public static final String DEFAULT_END = "END";
    public int up = this.getMenuKey("up", null, "UP");
    public int down = this.getMenuKey("down", null, "DOWN");
    public int left = this.getMenuKey("up", null, "LEFT");
    public int right = this.getMenuKey("down", null, "RIGHT");
    public int select = this.getMenuKey("select", null, "SELECT");
    public int activate;
    public int end = this.getMenuKey(null, null, "END");
    private static final String COMMAND_MENU_PREFIX = "command.menu.";
    private static int[] softButtonKeys;

    public MenuKeys() {
        debug.println(3, "{0}", (Object)this.toString());
    }

    public static boolean isSoftButton(int n) {
        return MenuKeys.getSoftButtonIndexFromKeyCode(n) != -1;
    }

    public static int getSoftButtonIndexFromKeyCode(int n) {
        for (int i = 0; i < softButtonKeys.length; ++i) {
            if (softButtonKeys[i] != n) continue;
            return i;
        }
        return -1;
    }

    public static int getSoftButtonKeyCodeFromIndex(int n) {
        return KeyboardManager.getInstance().getKeyboardHandler().getKeyCode("SOFT" + (n + 1));
    }

    public int getMenuKey(String string, Set set, int n) {
        return this.getPreferredKey(string, set, n);
    }

    private int getMenuKey(String string, Set set, String string2) {
        int n = KeyboardManager.getInstance().getKeyboardHandler().getKeyCode(string2);
        return this.getMenuKey(string, set, n);
    }

    public int getPreferredKey(String string, Set set, int n) {
        String string2 = Device.getProperty(COMMAND_MENU_PREFIX + string);
        if (string2 != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string2, " \t,;:");
            while (stringTokenizer.hasMoreTokens()) {
                String string3 = stringTokenizer.nextToken();
                int n2 = KeyboardManager.getInstance().getKeyboardHandler().getKeyCode(string3);
                Integer n3 = new Integer(n2);
                if (set != null && set.contains(n3)) continue;
                return n2;
            }
        }
        return n;
    }

    public String toString() {
        return "MenuKeys[up=" + this.up + "," + DOWN + "=" + this.down + "," + SELECT + "=" + this.select + "," + ACTIVATE + "=" + this.activate + "]";
    }

    static {
        int n = Screen.getInstance().getSoftButtonCount();
        softButtonKeys = new int[n];
        for (int i = 0; i < softButtonKeys.length; ++i) {
            MenuKeys.softButtonKeys[i] = MenuKeys.getSoftButtonKeyCodeFromIndex(i);
        }
    }
}

