/*
 * Decompiled with CFR 0.152.
 */
package com.sun.kvem.midp;

import com.sun.kvem.environment.Debug;
import com.sun.kvem.midp.AlertType;

public class MediaBridge {
    private static final Debug debug = Debug.create((Class)MediaBridge.class);
    private static AlertType ALERT_INFO = null;
    private static AlertType ALERT_WARNING = null;
    private static AlertType ALERT_ERROR = null;
    private static AlertType ALERT_ALARM = null;
    private static AlertType ALERT_CONFIRMATION = null;
    private static AlertType VIBRATION = null;

    public static boolean playAlertSound(int n) {
        debug.println(2, "Play alert sound type {0}", n);
        AlertType alertType = MediaBridge.getAlert(n);
        if (alertType != null) {
            return alertType.playAlert();
        }
        return false;
    }

    public static void emuPlayAlertSound(final int n) {
        debug.println(2, "emuPlay alert sound type {0}", n);
        new Thread(){

            public void run() {
                MediaBridge.playAlertSound(n);
            }
        }.start();
    }

    public static boolean playVibrationSound(int n) {
        debug.println(2, "Play vibration sound for {0} ms", n);
        final AlertType alertType = MediaBridge.getAlert(6);
        if (alertType != null) {
            if (n != 0) {
                alertType.setDuration(n);
                new Thread(){

                    public void run() {
                        alertType.playAlert();
                    }
                }.start();
            } else {
                alertType.setDuration(n);
            }
            return true;
        }
        return false;
    }

    public static void cleanBridge() {
        debug.trace(2);
        if (ALERT_INFO != null) {
            ALERT_INFO.close();
        }
        if (ALERT_WARNING != null) {
            ALERT_WARNING.close();
        }
        if (ALERT_ERROR != null) {
            ALERT_ERROR.close();
        }
        if (ALERT_ALARM != null) {
            ALERT_ALARM.close();
        }
        if (ALERT_CONFIRMATION != null) {
            ALERT_CONFIRMATION.close();
        }
        if (VIBRATION != null) {
            VIBRATION.close();
        }
    }

    private static synchronized AlertType getAlert(int n) {
        switch (n) {
            case 1: {
                if (ALERT_INFO == null) {
                    ALERT_INFO = AlertType.getAlert(n);
                }
                return ALERT_INFO;
            }
            case 2: {
                if (ALERT_WARNING == null) {
                    ALERT_WARNING = AlertType.getAlert(n);
                }
                return ALERT_WARNING;
            }
            case 3: {
                if (ALERT_ERROR == null) {
                    ALERT_ERROR = AlertType.getAlert(n);
                }
                return ALERT_ERROR;
            }
            case 4: {
                if (ALERT_ALARM == null) {
                    ALERT_ALARM = AlertType.getAlert(n);
                }
                return ALERT_ALARM;
            }
            case 5: {
                if (ALERT_CONFIRMATION == null) {
                    ALERT_CONFIRMATION = AlertType.getAlert(n);
                }
                return ALERT_CONFIRMATION;
            }
            case 6: {
                if (VIBRATION == null) {
                    VIBRATION = AlertType.getAlert(n);
                }
                return VIBRATION;
            }
        }
        debug.println(2, "No sound for type {0}", n);
        return null;
    }
}

