/*
 * Decompiled with CFR 0.152.
 */
package com.sun.kvem.midp;

import com.sun.kvem.environment.Debug;
import com.sun.kvem.environment.EmulatorConfiguration;
import com.sun.kvem.environment.ProfileConfiguration;
import com.sun.kvem.environment.ProfileEnvironment;
import com.sun.kvem.environment.ToolkitDirs;
import java.beans.PropertyVetoException;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.lang.reflect.Method;
import java.net.ConnectException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Properties;
import javax.swing.JOptionPane;

public class Main {
    private static final String JAR_URL = "MIDlet-Jar-URL";
    private static Debug debug = Debug.create((Class)Main.class);
    private static int testsRun = 0;
    private static ClassLoader toolbarClassLoader = null;

    private static void syntax_and_quit() {
        System.err.println("Syntax: com.sun.kvem.midp.Main <device_name> <class> | -descriptor <jad>");
        System.exit(1);
    }

    private static boolean checkVMVersion() {
        String string = System.getProperty("java.class.version");
        debug.println(3, "Java API version {0}", (Object)string);
        double d = Double.valueOf(string);
        if (d < 47.0) {
            String string2 = System.getProperty("java.vm.version");
            debug.println(1, "Java VM version {0} is too old", (Object)string2);
            System.err.println(Main.format("WRONG_JDK_VERSION", string2));
            try {
                Class.forName("javax.swing.JOptionPane");
                String string3 = Main.format("WRONG_JDK_VERSION", string2);
                JOptionPane.showMessageDialog(null, string3, "Error", 0);
            }
            catch (ClassNotFoundException classNotFoundException) {
                System.err.println("Cannot find Swing classes");
            }
            return false;
        }
        return true;
    }

    private static Class getToolbarClass(String string) throws ClassNotFoundException {
        try {
            try {
                return Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                if (toolbarClassLoader == null) {
                    debug.println(2, "Loading {0}", (Object)string);
                    String string2 = ToolkitDirs.LIB + "ktools.zip";
                    URL uRL = Main.fileToURL(new File(string2));
                    toolbarClassLoader = new URLClassLoader(new URL[]{uRL});
                }
                return toolbarClassLoader.loadClass(string);
            }
        }
        catch (Throwable throwable) {
            if (debug.level(1)) {
                debug.println(1, "Could not load class {0}: {1}", (Object)string, (Object)throwable);
                throwable.printStackTrace();
            }
            throw new ClassNotFoundException(string);
        }
    }

    private static URL fileToURL(File file) throws MalformedURLException {
        try {
            return file.toURL();
        }
        catch (NoSuchMethodError noSuchMethodError) {
            String string = file.getAbsolutePath().replace(File.separatorChar, '/');
            String string2 = "file://";
            return new URL(string2 + string);
        }
    }

    private static String format(String string, String string2) {
        try {
            Class clazz = Main.getToolbarClass("com.sun.kvem.toolbar.ToolbarResources");
            Class[] classArray = new Class[]{String.class, Object.class};
            Method method = clazz.getMethod("format", classArray);
            Object[] objectArray = new Object[]{string, string2};
            return (String)method.invoke(null, objectArray);
        }
        catch (Exception exception) {
            if (debug.level(1)) {
                debug.println(1, "Error using {0}:\n  {1}", (Object)"com.sun.kvem.toolbar.ToolbarResources", (Object)exception);
                exception.printStackTrace();
            }
            System.err.println("Cannot load resource manager");
            return string;
        }
    }

    public static void main(String[] stringArray) {
        block15: {
            debug.println(2, "argv = {0}", (Object)stringArray);
            if (!Main.checkVMVersion()) {
                debug.println(2, "Java API is out-of-date; exiting");
                System.exit(1);
            }
            if (stringArray.length < 2) {
                Main.syntax_and_quit();
            }
            Main.initializeEnvironment();
            ProfileEnvironment profileEnvironment = new ProfileEnvironment();
            ProfileEnvironment.setSynchronousMode((boolean)true);
            ProfileConfiguration profileConfiguration = (ProfileConfiguration)profileEnvironment.createConfiguration();
            Main.setDevice(stringArray[0], profileConfiguration);
            try {
                boolean bl = Boolean.getBoolean("kvem.autotest");
                if (bl && stringArray[1].equals("-autotest")) {
                    debug.println(3, "Starting AWT threads");
                    URL uRL = null;
                    try {
                        String string = null;
                        if (stringArray.length == 3) {
                            string = stringArray[2];
                        } else if (stringArray.length == 4 && stringArray[2].equals("-transient")) {
                            string = stringArray[3];
                        } else {
                            Main.syntax_and_quit();
                        }
                        uRL = new URL(string);
                    }
                    catch (MalformedURLException malformedURLException) {
                        System.err.println("Not a valid test URL:\n" + malformedURLException);
                    }
                    debug.println(2, "JAD URL is {0}", (Object)uRL);
                    boolean bl2 = true;
                    while (bl2) {
                        boolean bl3 = testsRun == 0;
                        bl2 = Main.runTest(profileEnvironment, profileConfiguration, uRL, bl3);
                        debug.println(2, "{0} tests run", testsRun);
                    }
                    break block15;
                }
                String[] stringArray2 = new String[stringArray.length - 1];
                System.arraycopy(stringArray, 1, stringArray2, 0, stringArray.length - 1);
                for (int i = 0; i < stringArray2.length; ++i) {
                    if (!stringArray2[i].equals("-autotest")) continue;
                    profileConfiguration.setJamMode("autotest");
                    break;
                }
                ProfileEnvironment.start((EmulatorConfiguration)profileConfiguration, (String[])stringArray2);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        try {
            System.exit(0);
        }
        catch (IllegalThreadStateException illegalThreadStateException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean runTest(ProfileEnvironment profileEnvironment, ProfileConfiguration profileConfiguration, URL uRL, boolean bl) throws IOException {
        String[] stringArray;
        Object object;
        byte[] byArray = null;
        boolean bl2 = false;
        int n = 1;
        while (!bl2) {
            try {
                byArray = Main.getURLData(uRL);
                bl2 = true;
            }
            catch (ConnectException connectException) {
                if (bl && n == 1) {
                    System.err.println("Cannot connect to " + uRL);
                    try {
                        Thread.sleep(2000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    return true;
                }
                debug.println(2, "No more tests");
                return false;
            }
            catch (FileNotFoundException fileNotFoundException) {
                if (n == 3) {
                    debug.println(2, "No JAD file found; stopping test run");
                    return false;
                }
                debug.println(2, "No JAD file found; trying again");
                try {
                    Thread.sleep(2000L);
                }
                catch (InterruptedException interruptedException) {}
            }
            catch (IOException iOException) {
                System.err.println(iOException);
                iOException.printStackTrace();
                System.exit(1);
            }
            ++n;
        }
        if (byArray.length == 0) {
            debug.println(2, "Empty JAD file; stopping test run");
            return false;
        }
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        Properties properties = new Properties();
        try {
            properties.load(byteArrayInputStream);
        }
        catch (IOException iOException) {
            System.err.println("Malformed JAD file:\n");
            System.err.println(new String(byArray));
            System.exit(1);
        }
        URL uRL2 = null;
        try {
            object = properties.getProperty(JAR_URL);
            uRL2 = new URL(uRL, (String)object);
        }
        catch (NullPointerException nullPointerException) {
            System.err.println("Malformed JAD file:\n");
            System.err.println(new String(byArray));
            System.err.println("\nNo JAR file defined");
            System.exit(1);
        }
        catch (MalformedURLException malformedURLException) {
            System.err.println("Malformed JAD file:\n");
            System.err.println(new String(byArray));
            System.err.println("\nJAR file reference is not a valid URL");
            System.exit(1);
        }
        properties.setProperty(JAR_URL, uRL2.toExternalForm());
        object = File.createTempFile("J2MEWTK", ".jad");
        FileWriter fileWriter = new FileWriter((File)object);
        PrintWriter printWriter = new PrintWriter(fileWriter);
        try {
            stringArray = properties.keys();
            while (stringArray.hasMoreElements()) {
                String string = (String)stringArray.nextElement();
                String string2 = properties.getProperty(string);
                printWriter.println(string + ": " + string2);
            }
        }
        finally {
            printWriter.close();
        }
        debug.println(3, "JAD = {0}", (Object)properties);
        stringArray = new String[]{"-transient", Main.fileToURLText((File)object)};
        debug.println(3, "Running emulator, argv = {0}", (Object)stringArray);
        ProfileEnvironment.start((EmulatorConfiguration)profileConfiguration, (String[])stringArray);
        ++testsRun;
        debug.println(3, "Emulator returned");
        return true;
    }

    private static void initializeEnvironment() {
        String string = ToolkitDirs.BIN + "kwrapper";
        Main.checkPathProperty("lime.loader", string);
    }

    private static String correctPath(String string) {
        return string.replace('/', File.separatorChar).replace('\\', File.separatorChar);
    }

    private static String checkPathProperty(String string, String string2) {
        String string3;
        if (string2 != null) {
            Main.checkProperty(string, string2);
        }
        if ((string3 = System.getProperty(string)) != null) {
            string3 = Main.correctPath(string3);
            string3 = new File(string3).getAbsolutePath();
            System.getProperties().put(string, string3);
            debug.println(2, "Set system property {0} = {1}", (Object)string, (Object)string2);
        }
        return string3;
    }

    private static void checkProperty(String string, String string2) {
        String string3 = System.getProperty(string);
        if (string3 == null) {
            debug.println(2, "Adding to system properties:\n  {0} = {1}", (Object)string, (Object)string2);
            System.getProperties().put(string, string2);
        } else {
            debug.println(3, "System property {0} exists", (Object)string);
        }
    }

    private static void setDevice(String string, ProfileConfiguration profileConfiguration) {
        int n;
        String[] stringArray = profileConfiguration.getDeviceList();
        for (n = 0; stringArray != null && n < stringArray.length; ++n) {
            if (!stringArray[n].equals(string)) continue;
            try {
                debug.println(2, "Setting the device to {0}", (Object)string);
                profileConfiguration.setDeviceName(string);
            }
            catch (PropertyVetoException propertyVetoException) {
                // empty catch block
            }
            return;
        }
        System.err.println("Specified device template not found: " + string);
        if (stringArray != null && stringArray.length != 0) {
            System.err.println("Avaliable templates are:");
            for (n = 0; n < stringArray.length; ++n) {
                System.out.println(stringArray[n]);
            }
            System.exit(1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static byte[] getURLData(URL uRL) throws IOException {
        byte[] byArray;
        debug.println(2, "Downloading URL {0}", (Object)uRL);
        InputStream inputStream = uRL.openStream();
        BufferedInputStream bufferedInputStream = null;
        ByteArrayOutputStream byteArrayOutputStream = null;
        try {
            bufferedInputStream = new BufferedInputStream(inputStream);
            byteArrayOutputStream = new ByteArrayOutputStream();
            byte[] byArray2 = new byte[4096];
            try {
                int n;
                while ((n = bufferedInputStream.read(byArray2)) != -1) {
                    byteArrayOutputStream.write(byArray2, 0, n);
                }
            }
            catch (EOFException eOFException) {
                // empty catch block
            }
            debug.println(3, "Read {0} bytes", byteArrayOutputStream.size());
            byArray = byteArrayOutputStream.toByteArray();
            Object var7_8 = null;
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            try {
                if (bufferedInputStream != null) {
                    bufferedInputStream.close();
                }
            }
            finally {
                if (byteArrayOutputStream != null) {
                    byteArrayOutputStream.close();
                }
            }
            throw throwable;
        }
        try {
            if (bufferedInputStream != null) {
                bufferedInputStream.close();
            }
        }
        finally {
            if (byteArrayOutputStream != null) {
                byteArrayOutputStream.close();
            }
        }
        return byArray;
    }

    private static String fileToURLText(File file) throws MalformedURLException {
        String string = file.toURL().toExternalForm();
        if (!string.startsWith("file://")) {
            string = "file://" + string.substring("file:/".length());
        }
        return string;
    }
}

