/*
 * Decompiled with CFR 0.152.
 */
package com.sun.kvem.midp;

import com.sun.kvem.Device;
import com.sun.kvem.DeviceEventManager;
import com.sun.kvem.EMDevice;
import com.sun.kvem.KVMBridge;
import com.sun.kvem.KVMDeviceInterface;
import com.sun.kvem.KeyboardManager;
import com.sun.kvem.environment.Debug;
import com.sun.kvem.environment.DevicePropertyManager;
import com.sun.kvem.environment.Emulator;
import com.sun.kvem.environment.Resources;
import com.sun.kvem.environment.ToolkitDirs;
import com.sun.kvem.extension.DefaultExtensionManager;
import com.sun.kvem.extension.EmulatorEvent;
import com.sun.kvem.extension.EventMulticaster;
import com.sun.kvem.extension.ExtensionModule;
import com.sun.kvem.extension.ExtensionModuleManager;
import com.sun.kvem.extension.ModuleFinder;
import com.sun.kvem.midp.DeviceBridge;
import com.sun.kvem.midp.EventBridge;
import com.sun.kvem.midp.ExternalEventGeneratorWin;
import com.sun.kvem.midp.MIDP;
import com.sun.kvem.midp.MIDPKeyboardHandler;
import com.sun.kvem.midp.MediaBridge;
import com.sun.kvem.midp.TextManager;
import com.sun.kvem.pim.PIMBridge;
import com.sun.kvem.util.AboutDialog;
import com.sun.kvem.util.ActionImpl;
import com.sun.kvem.util.FileUtils;
import com.sun.kvem.util.StringArrayUtils;
import com.sun.kvem.util.ToolkitResources;
import com.sun.kvem.util.WindowUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.Locale;
import java.util.Properties;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;

public class MIDP
implements Emulator {
    private static DeviceFrame frame;
    private static Semaphore done;
    private static int rc;
    private static Debug debug;
    private static final int TIMEOUT = 3000;
    private static EMDevice deviceView;
    private EventMulticaster multicaster = new EventMulticaster();
    private StorageManager storageManager;
    private static JDialog aboutDialog;
    private static boolean isWebEmulator;
    public static final String INCOMING_EXLUDE = "incoming.call.exclude";
    public static final String OS_NAME = "os.name";
    public static final boolean IS_LINUX;
    public static final boolean IS_SUNOS;
    private static ActionImpl midletMenuAction;
    private static ActionImpl eventGenAction;
    private static ActionImpl pauseAction;
    private static ActionImpl resumeAction;
    private static ActionImpl currentAction;
    private static ActionImpl exitAction;
    private static ActionImpl helpMenuAction;
    private static ActionImpl aboutAction;
    private static final int STATE_INIT = 0;
    private static final int STATE_IN_SESSION = 1;
    private static final int STATE_IN_EXECUTION = 2;
    private static final int STATE_IN_MIDLET = 3;
    private int programState = 0;
    private static int MIDLET_CURRENT_PAUSE_RESUME_STATE;

    private static void openEventGenUI() {
        ExternalEventGeneratorWin externalEventGeneratorWin = ExternalEventGeneratorWin.getWindow();
        ((Frame)externalEventGeneratorWin).setTitle(frame.getTitle());
        WindowUtils.placeNextTo((Window)externalEventGeneratorWin, (Window)frame);
        externalEventGeneratorWin.setVisible(true);
    }

    public static void injectPauseEvent(int n) {
        if (isWebEmulator) {
            return;
        }
        if (n != MIDLET_CURRENT_PAUSE_RESUME_STATE) {
            EventBridge.injectEvent(11, n, 0, 0);
            deviceView.setActive(n == 2);
            MIDP.frame.updateMenuBar(n);
        }
    }

    private void createExtensions(Properties properties) {
        File file;
        boolean bl = Boolean.valueOf(properties.getProperty("kvem.profiler.enable"));
        if (bl) {
            try {
                file = File.createTempFile("jprof", ".prf");
                file.deleteOnExit();
                properties.setProperty("kvem.profiler.outfile", file.getAbsolutePath());
            }
            catch (IOException iOException) {
                System.err.println("Profiler error: Temporary file could not be created");
            }
        }
        file = new ModuleFinder(this.getClass().getClassLoader());
        DefaultExtensionManager defaultExtensionManager = new DefaultExtensionManager();
        this.multicaster.addEmulatorListener(defaultExtensionManager.getEventMulticaster());
        ExtensionModule[] extensionModuleArray = file.createModules((ExtensionModuleManager)defaultExtensionManager);
        for (int i = 0; i < extensionModuleArray.length; ++i) {
            extensionModuleArray[i].setProperties(properties);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int run(final Properties properties, final String[] stringArray) {
        Runtime.getRuntime().gc();
        debug.println(2, "{0} KBytes free memory", (int)(Runtime.getRuntime().freeMemory() / 1024L));
        debug.println(1, "Running the emulator");
        debug.println(3, "Properties = {0}", (Object)properties);
        this.createExtensions(properties);
        this.setProgramState(1);
        KVMBridge.getBridge().setKVMDeviceInterface(new KVMInterface());
        Device.setProperties(properties);
        isWebEmulator = Device.getBooleanProperty("kvem.webemulator", false);
        aboutAction = isWebEmulator ? new ActionImpl(ToolkitResources.getString((String)"WEBEMUL_ABOUT"), (int)ToolkitResources.getString((String)"ABOUT_SHORTCUT").charAt(0), ToolkitResources.getString((String)"WEBEMUL_ABOUT")) : new ActionImpl(ToolkitResources.getString((String)"EMULATOR_ABOUT"), (int)ToolkitResources.getString((String)"ABOUT_SHORTCUT").charAt(0), ToolkitResources.getString((String)"EMULATOR_ABOUT"));
        String string = properties.getProperty("kvm.executable.path");
        final String string2 = DevicePropertyManager.getResourceFile((Properties)properties, (String)string).toString();
        Thread thread = new Thread("KVM Executor"){

            public void run() {
                debug.println(4, "argv = {0}", (Object)stringArray);
                String[] stringArray4 = MIDP.this.addTracingFlags(stringArray);
                debug.println(4, "xArgv = {0}", (Object)stringArray4);
                String[] stringArray2 = MIDP.this.prepareWrapperArgv(properties);
                debug.println(4, "wrapperArgv = {0}", (Object)stringArray2);
                String[] stringArray3 = StringArrayUtils.concatenate((String[])stringArray2, (String[])stringArray4);
                debug.println(1, "Running the KVM, argv = {0}", (Object)stringArray3);
                rc = KVMBridge.getBridge().runKVM(string2, stringArray3);
                debug.println(1, "KVM returned {0}", rc);
                done.signal();
            }
        };
        Object object = KVMBridge.getBridge().getLimeLock();
        synchronized (object) {
            thread.start();
            String string3 = properties.getProperty("kvem.device.name");
            frame = new DeviceFrame(string3);
        }
        debug.println(1, "Waiting for the application to end");
        object = properties.getProperty("jammode", "");
        debug.println(4, "JAM mode = {0}", object);
        if (!(((String)object).equals("list") || ((String)object).equals("install") || ((String)object).equals("storageNames") || ((String)object).equals("remove"))) {
            frame.setVisible(true);
            deviceView.requestFocus();
        }
        done.waitFor();
        debug.println(1, "Closing down");
        KVMBridge.getBridge().stopKVM();
        frame.setVisible(false);
        this.setProgramState(0);
        ExternalEventGeneratorWin.terminate();
        frame.dispose();
        this.storageManager.cleanup();
        Runtime.getRuntime().gc();
        return rc;
    }

    private String[] addTracingFlags(String[] stringArray) {
        String[][] stringArrayArray = new String[][]{{"kvem.trace.allocation", "-tracememoryallocation"}, {"kvem.trace.gc", "-tracegarbagecollection"}, {"kvem.trace.gc.verbose", "-tracegarbagecollectionverbose"}, {"kvem.trace.class", "-traceclassloading"}, {"kvem.trace.class.verbose", "-traceclassloadingverbose"}, {"kvem.trace.verifier", "-traceverifier"}, {"kvem.trace.stackmaps", "-tracestackmaps"}, {"kvem.trace.bytecodes", "-tracebytecodes"}, {"kvem.trace.calls", "-tracemethodcalls"}, {"kvem.trace.calls.verbose", "-tracemethodcallsverbose"}, {"kvem.trace.frames", "-traceframes"}, {"kvem.trace.stackchunks", "-tracestackchunks"}, {"kvem.trace.exceptions", "-traceexceptions"}, {"kvem.trace.events", "-traceevents"}, {"kvem.trace.threading", "-tracethreading"}, {"kvem.trace.monitors", "-tracemonitors"}, {"kvem.trace.networking", "-tracenetworking"}, {"kvem.trace.all", "-traceall"}};
        ArrayList<String> arrayList = new ArrayList<String>(Arrays.asList(stringArray));
        for (int i = 0; i < stringArrayArray.length; ++i) {
            if (!Device.getBooleanProperty(stringArrayArray[i][0], false)) continue;
            arrayList.add(stringArrayArray[i][1]);
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    private String[] prepareWrapperArgv(Properties properties) {
        String string;
        String string2;
        String string3;
        String string4;
        String string5;
        String string6;
        MIDPKeyboardHandler mIDPKeyboardHandler = (MIDPKeyboardHandler)KeyboardManager.getInstance().getKeyboardHandler();
        String[] stringArray = new String[]{"-Dcom.sun.midp.lcdui.eventHandler=com.sun.midp.lcdui.EmulEventHandler", "-Dcom.sun.midp.lcdui.inputMethodHandler=" + mIDPKeyboardHandler.getInputMethodHandlerClassName()};
        LinkedList<String> linkedList = new LinkedList<String>(Arrays.asList(stringArray));
        String string7 = System.getProperty("http.proxyHost");
        String string8 = properties.getProperty("http.proxyHost", string7);
        String string9 = System.getProperty("http.proxyPort");
        String string10 = properties.getProperty("http.proxyPort", string9);
        if (string8 != null && !string8.equals("")) {
            linkedList.add("-Dcom.sun.midp.io.http.proxy=" + string8.trim() + ":" + string10.trim());
        }
        String string11 = System.getProperty("https.proxyHost");
        String string12 = properties.getProperty("https.proxyHost", string11);
        String string13 = System.getProperty("https.proxyPort");
        String string14 = properties.getProperty("https.proxyPort", string13);
        if (string12 != null && !string12.equals("")) {
            linkedList.add("-Dmicroedition.http_proxy=" + string12.trim() + ":" + string14.trim());
        }
        if ((string6 = properties.getProperty("http.version", "HTTP/1.1").trim()) != null && !string6.equals("")) {
            if (string6.equals("HTTP/1.0")) {
                linkedList.add("-Dcom.sun.midp.io.http.use_chunks=false");
            } else if (string6.equals("HTTP/1.1")) {
                linkedList.add("-Dcom.sun.midp.io.http.use_chunks=true");
            } else {
                System.out.println("Unsupported HTTP version - " + string6 + ". Using default.");
            }
            if (string8 != null && !string8.equals("") || string12 != null && !string12.equals("") || string6.equals("HTTP/1.0")) {
                linkedList.add("-Dcom.sun.midp.io.http.force_non_persistent=true");
            } else {
                linkedList.add("-Dcom.sun.midp.io.http.force_non_persistent=false");
            }
        }
        if ((string5 = properties.getProperty("heap.size")) != null && !string5.equals("")) {
            linkedList.add("-heapsize");
            linkedList.add(string5 + "kB");
        }
        if ("".equals(properties.getProperty("jammode"))) {
            boolean bl;
            boolean bl2 = Boolean.valueOf(properties.getProperty("kvem.memory.monitor.enable"));
            if (bl2) {
                linkedList.add("-monitormemory");
            }
            if ((bl = Boolean.valueOf(properties.getProperty("kvem.profiler.enable")).booleanValue()) && (string4 = properties.getProperty("kvem.profiler.outfile")) != null && !string4.equals("")) {
                linkedList.add("-jprof");
                linkedList.add(string4);
            }
        }
        if ((string3 = properties.getProperty("jammode")) != null && string3.startsWith("http://")) {
            linkedList.add("-Dams.url=" + string3);
        }
        if ((string2 = properties.getProperty("storage.root")) == null || string2.equals("")) {
            string2 = this.manageStorage(properties.getProperty("kvem.device.name"));
            properties.setProperty("storage.root", string2);
        } else {
            this.storageManager = new UserSpecifiedStorageManager();
        }
        linkedList.add("-Dsystem.storage_root=" + string2);
        System.out.println(MessageFormat.format(ToolkitResources.getString((String)"USING_STORAGE_ROOT"), string2));
        PIMBridge.setStorageRoot(string2);
        this.ensureRootFileSystemExists(string2);
        string4 = properties.getProperty("storage.size");
        if (string4 != null && !string4.equals("")) {
            try {
                int n = Integer.parseInt(string4);
                linkedList.add("-Dsystem.jam_space=" + n * 1024);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        Locale locale = Locale.getDefault();
        debug.println(3, "Default locale is {0}", (Object)locale);
        String string15 = Resources.getResources().getProperty("microedition.locale", locale.toString());
        debug.println(3, "KTools locale is {0}", (Object)string15);
        string15 = properties.getProperty("microedition.locale", string15);
        string15 = string15.replace('_', '-');
        linkedList.add("-Dmicroedition.locale=" + string15);
        byte[] byArray = new byte[1];
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        InputStreamReader inputStreamReader = new InputStreamReader(byteArrayInputStream);
        String string16 = inputStreamReader.getEncoding();
        debug.println(3, "Default encoding is {0}", (Object)string16);
        String string17 = Resources.getResources().getProperty("microedition.encoding", string16);
        debug.println(3, "KTools encoding is {0}", (Object)string17);
        string17 = properties.getProperty("microedition.encoding", string17);
        if (string17 != null) {
            linkedList.add("-Dmicroedition.encoding=" + string17);
        }
        linkedList.add("-Dmmapi_enabled=true");
        debug.println(3, "make sure jamMode is {0}", (Object)string3);
        String string18 = properties.getProperty("security.domain");
        if (!(string18 == null || string18.equals("") || string3 == null || string3.startsWith("http") || string3.startsWith("empty") || string3.startsWith("run"))) {
            linkedList.add("-domain");
            linkedList.add(string18);
        }
        if ((string = properties.getProperty("wma.client.phoneNumber")) != null && string.length() > 0) {
            linkedList.add("-Dwma.client.phoneNumber=" + string);
        }
        linkedList.add("-Dfile.separator=" + File.separatorChar);
        return linkedList.toArray(stringArray);
    }

    private void setProgramState(int n) {
        if (n > this.programState) {
            if (n - this.programState > 1) {
                this.setProgramState(this.programState + 1);
                this.setProgramState(n);
                return;
            }
            switch (n) {
                case 1: {
                    this.sendStateEvent(1);
                    break;
                }
                case 2: {
                    this.sendStateEvent(3);
                    break;
                }
                case 3: {
                    this.sendStateEvent(5);
                }
            }
        } else if (this.programState > n) {
            if (this.programState - n > 1) {
                this.setProgramState(this.programState - 1);
                this.setProgramState(n);
                return;
            }
            switch (n) {
                case 0: {
                    this.sendStateEvent(2);
                    break;
                }
                case 1: {
                    this.sendStateEvent(4);
                    break;
                }
                case 2: {
                    this.sendStateEvent(6);
                }
            }
        }
        this.programState = n;
    }

    private String manageStorage(String string) {
        String string2 = string;
        String string3 = ToolkitDirs.APPDB + string;
        new File(string3).mkdir();
        String string4 = string3 + File.separator + "in.use";
        File file = new File(string4);
        try {
            if (file.createNewFile()) {
                this.storageManager = new StatefulStorageManager(string4);
                file.deleteOnExit();
            } else {
                String string5 = "temp." + string + String.valueOf(System.currentTimeMillis());
                String string6 = ToolkitDirs.APPDB + string5;
                new File(string6).mkdir();
                this.storageManager = new StatelessStorageManager(string6);
                string2 = string5;
            }
        }
        catch (IOException iOException) {
            debug.exception(1, (Throwable)iOException);
        }
        return string2;
    }

    private void sendStateEvent(int n) {
        EmulatorEvent emulatorEvent = new EmulatorEvent((Object)this, n);
        this.multicaster.dispatchEvent(emulatorEvent);
    }

    private void ensureRootFileSystemExists(String string) {
        File file = new File(ToolkitDirs.APPDB, string + File.separator + "filesystem");
        String[] stringArray = file.list();
        if (stringArray == null || stringArray.length == 0) {
            new File(file, "root1").mkdirs();
        }
    }

    static {
        done = new Semaphore(0);
        rc = 0;
        debug = Debug.create((Class)MIDP.class);
        IS_LINUX = System.getProperty(OS_NAME, "").indexOf("Linux") != -1;
        IS_SUNOS = System.getProperty(OS_NAME, "").indexOf("SunOS") != -1;
        midletMenuAction = new ActionImpl(ToolkitResources.getString((String)"MIDLET.MIDLET"), (int)ToolkitResources.getString((String)"MIDLET.MIDLET_SHORTCUT").charAt(0), ToolkitResources.getString((String)"MIDLET.MIDLET_TOOLTIP"));
        eventGenAction = new ActionImpl(ToolkitResources.getString((String)"MIDLET.EVENT_GEN"), (int)ToolkitResources.getString((String)"MIDLET.EVENT_GEN_SHORTCUT").charAt(0), ToolkitResources.getString((String)"MIDLET.EVENT_GEN_TOOLTIP"));
        pauseAction = new ActionImpl(ToolkitResources.getString((String)"MIDLET.PAUSE"), (int)ToolkitResources.getString((String)"MIDLET.PAUSE_SHORTCUT").charAt(0), ToolkitResources.getString((String)"MIDLET.PAUSE_TOOLTIP"));
        resumeAction = new ActionImpl(ToolkitResources.getString((String)"MIDLET.RESUME"), (int)ToolkitResources.getString((String)"MIDLET.RESUME_SHORTCUT").charAt(0), ToolkitResources.getString((String)"MIDLET.RESUME_TOOLTIP"));
        currentAction = pauseAction;
        exitAction = new ActionImpl(ToolkitResources.getString((String)"MIDLET.EXIT"), (int)ToolkitResources.getString((String)"MIDLET.EXIT_SHORTCUT").charAt(0), ToolkitResources.getString((String)"MIDLET.EXIT_TOOLTIP"));
        helpMenuAction = new ActionImpl(ToolkitResources.getString((String)"HELP"), (int)ToolkitResources.getString((String)"HELP_SHORTCUT").charAt(0), ToolkitResources.getString((String)"HELP"));
        MIDLET_CURRENT_PAUSE_RESUME_STATE = 2;
    }

    private static class Semaphore {
        int state;

        Semaphore(int n) {
            this.state = n;
        }

        synchronized void waitFor() {
            while (this.state == 0) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
            --this.state;
        }

        synchronized void signal() {
            ++this.state;
            this.notifyAll();
        }
    }

    static class UserSpecifiedStorageManager
    extends StorageManager {
        UserSpecifiedStorageManager() {
            debug.println(2, "making UserSpecifiedStorageManager");
        }

        void cleanup() {
            debug.println(2, "cleanup for UserSpecifiedStorageManager, doing nothing.");
        }
    }

    static class StatelessStorageManager
    extends StorageManager {
        private String storageDirName;

        StatelessStorageManager(String string) {
            debug.println(2, "making StatelessStorageManager for temporary storage dir " + string);
            this.storageDirName = string;
        }

        void cleanup() {
            File file = new File(this.storageDirName);
            if (FileUtils.deleteDir((File)file)) {
                debug.println(2, "removed stateless directory " + this.storageDirName);
            } else {
                debug.println(2, "Failed to remove stateless directory " + this.storageDirName);
            }
        }
    }

    static class StatefulStorageManager
    extends StorageManager {
        private String lockFileName;

        StatefulStorageManager(String string) {
            debug.println(2, "making StatefulStorageManager on lockFile " + string);
            this.lockFileName = string;
        }

        void cleanup() {
            if (new File(this.lockFileName).delete()) {
                debug.println(2, "removed statful lock " + this.lockFileName);
            } else {
                debug.println(2, "Failed to remove lock " + this.lockFileName);
            }
        }
    }

    public static abstract class StorageManager {
        public static final String LOCK_FILE_NAME = "in.use";
        public static final String STATELESS_DIR_PREFIX = "temp.";

        StorageManager() {
        }

        abstract void cleanup();

        public static void cleanupAll() {
            debug.println(2, "Cleaning all storage directories...");
            File file = new File(ToolkitDirs.APPDB);
            String[] stringArray = file.list();
            for (int i = 0; i < stringArray.length; ++i) {
                String string = stringArray[i];
                File file2 = new File(file, string);
                if (!file2.isDirectory()) continue;
                if (string.startsWith(STATELESS_DIR_PREFIX)) {
                    debug.println(2, "removing stateless dir " + string);
                    FileUtils.deleteDir((File)file2);
                    file2.delete();
                    continue;
                }
                File file3 = new File(file2, LOCK_FILE_NAME);
                if (!file3.delete()) continue;
                debug.println(2, "removed lock file from directory " + string);
            }
        }
    }

    class KVMInterface
    implements KVMDeviceInterface {
        KVMInterface() {
        }

        public void initializeWindowSystem() {
            debug.println(1, "Open window");
            deviceView.setActive(true);
            MIDP.this.setProgramState(2);
            TextManager.getInstance();
        }

        public void finalizeWindowSystem() {
            debug.println(1, "Close window");
            frame.setVisible(false);
            frame.dispose();
            this.cleanBridges();
        }

        private void cleanBridges() {
            debug.println(1, "Cleaning up bridge classes");
            MediaBridge.cleanBridge();
            DeviceBridge.cleanBridge();
        }
    }

    static class DeviceFrame
    extends JFrame {
        private JMenu midletMenu;

        DeviceFrame(String string) {
            this.setDefaultCloseOperation(0);
            this.addWindowListener(new WindowAdapter(this){
                private final /* synthetic */ DeviceFrame this$0;
                {
                    this.this$0 = deviceFrame;
                }

                public void windowClosing(WindowEvent windowEvent) {
                    Object object;
                    try {
                        object = Class.forName("com.sun.kvem.midp.io.j2se.wma.client.WMAClientBridge");
                        Method method = ((Class)object).getMethod("getWeLaunchedServer", null);
                        Boolean bl = (Boolean)method.invoke(null, null);
                        if (bl.booleanValue()) {
                            MIDP.access$500().println(2, "We launched it.");
                        }
                        MIDP.access$500().println(2, "Calling bridge to unregister from WMA server");
                        Method method2 = ((Class)object).getMethod("cleanupWMASupport", null);
                        method2.invoke(null, null);
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                    }
                    catch (NoSuchMethodException noSuchMethodException) {
                    }
                    catch (IllegalAccessException illegalAccessException) {
                    }
                    catch (InvocationTargetException invocationTargetException) {
                        // empty catch block
                    }
                    MIDP.access$500().println(1, "Window closing");
                    object = new int[]{11, 3, 0, 0};
                    DeviceEventManager.getInstance().queueEvent(object);
                    ExternalEventGeneratorWin.terminate();
                    new Thread(this, "KVM Shutdown"){
                        private final /* synthetic */ 1 this$1;
                        {
                            this.this$1 = var1_1;
                            super(string);
                        }

                        public void run() {
                            try {
                                Thread.sleep(3000L);
                                MIDP.access$500().println(1, "Forcing the KVM to shut down");
                                MIDP.access$600().signal();
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                        }
                    }.start();
                }
            });
            if (isWebEmulator) {
                string = Device.getProperty("kvem.webemulator.frame.title");
            }
            this.setTitle(string);
            this.setMenuBar();
            String string2 = ToolkitDirs.LIB + "images" + File.separator;
            ImageIcon imageIcon = new ImageIcon(string2 + "phone.gif");
            this.setIconImage(imageIcon.getImage());
            deviceView = new EMDevice();
            this.addKeyListener(deviceView);
            DeviceFrame.addDeviceToFrame(this, deviceView);
            this.pack();
            if (isWebEmulator) {
                this.setLocation();
            } else {
                WindowUtils.place((Window)this);
            }
            pauseAction.putValue("NAME", (Object)"pause");
            resumeAction.putValue("NAME", (Object)"resume");
        }

        private void setLocation() {
            String string = Device.getProperty("kvem.webemulator.frame.alignment");
            if (string == null || string.trim().length() == 0) {
                return;
            }
            int n = 20;
            int n2 = 20;
            Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
            Dimension dimension2 = this.getSize();
            if (string.equals("bottom_left")) {
                n2 = dimension.height - dimension2.height - 20;
            } else if (string.equals("top_right")) {
                n = dimension.width - dimension2.width - 20;
            } else if (string.equals("bottom_right")) {
                n = dimension.width - dimension2.width - 20;
                n2 = dimension.height - dimension2.height - 20;
            } else if (string.equals("center")) {
                n = (dimension.width - dimension2.width) / 2;
                n2 = (dimension.height - dimension2.height) / 2;
            } else if (string.equals("random")) {
                n = 20 + (int)Math.round(Math.random() * (double)(dimension.width - dimension2.width - 40));
                n2 = 20 + (int)Math.round(Math.random() * (double)(dimension.height - dimension2.height - 40));
            }
            this.setLocation(n, n2);
        }

        static void addDeviceToFrame(JFrame jFrame, EMDevice eMDevice) {
            Dimension dimension = eMDevice.getPreferredSize();
            JPanel jPanel = new JPanel(dimension){
                private final /* synthetic */ Dimension val$size;
                {
                    this.val$size = dimension;
                }

                public Dimension getPreferredSize() {
                    return this.val$size;
                }
            };
            jPanel.setLayout(null);
            jPanel.addKeyListener(eMDevice);
            jFrame.getContentPane().setLayout(new BorderLayout());
            jPanel.add(eMDevice);
            eMDevice.setSize(dimension);
            eMDevice.setLocation(0, 0);
            jFrame.getContentPane().add((Component)jPanel, "Center");
            jFrame.setResizable(false);
        }

        public void pack() {
            if (IS_LINUX && !this.isResizable()) {
                this.packFix();
            } else {
                super.pack();
            }
        }

        public void exit() {
            if (aboutDialog != null) {
                aboutDialog.dispose();
            }
            this.processWindowEvent(new WindowEvent(this, 201));
        }

        private void packFix() {
            this.setResizable(true);
            super.pack();
            this.setResizable(false);
        }

        private void setMenuBar() {
            JMenuBar jMenuBar = new JMenuBar();
            if (!isWebEmulator) {
                eventGenAction.addActionListener((ActionListener)new EventGenListener());
                pauseAction.addActionListener((ActionListener)new pauseListener());
                resumeAction.addActionListener((ActionListener)new resumeListener());
                exitAction.addActionListener((ActionListener)new exitListener());
                this.midletMenu = new JMenu((Action)midletMenuAction);
                this.midletMenu.add((Action)eventGenAction);
                this.midletMenu.add((Action)currentAction);
                this.midletMenu.addSeparator();
                this.midletMenu.add((Action)exitAction);
                jMenuBar.add(this.midletMenu);
            }
            AboutListener aboutListener = new AboutListener();
            aboutAction.addActionListener((ActionListener)aboutListener);
            JMenu jMenu = new JMenu((Action)helpMenuAction);
            jMenu.add((Action)aboutAction);
            jMenu.addMenuListener(aboutListener);
            jMenuBar.add(jMenu);
            boolean bl = Resources.getResources().getBoolean(MIDP.INCOMING_EXLUDE, false);
            if (!bl) {
                this.setJMenuBar(jMenuBar);
            }
        }

        private void updateMenuBar(int n) {
            MIDLET_CURRENT_PAUSE_RESUME_STATE = n;
            String string = (String)currentAction.getValue("NAME");
            if (string.equals("pause")) {
                currentAction = resumeAction;
            } else {
                currentAction = pauseAction;
            }
            this.midletMenu.remove(1);
            this.midletMenu.insert((Action)currentAction, 1);
        }
    }

    static class AboutListener
    implements ActionListener,
    MenuListener,
    Runnable {
        AboutListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            this.loadDialog();
            aboutDialog.setVisible(true);
        }

        public void menuCanceled(MenuEvent menuEvent) {
        }

        public void menuDeselected(MenuEvent menuEvent) {
        }

        public void menuSelected(MenuEvent menuEvent) {
            new Thread((Runnable)this, "About Listener").start();
        }

        private synchronized void loadDialog() {
            if (aboutDialog == null) {
                aboutDialog = (JDialog)new AboutDialog((JFrame)frame, isWebEmulator);
            }
        }

        public void run() {
            this.loadDialog();
        }
    }

    static class exitListener
    implements ActionListener {
        exitListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            frame.exit();
        }
    }

    static class resumeListener
    implements ActionListener {
        resumeListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            MIDP.injectPauseEvent(2);
        }
    }

    static class pauseListener
    implements ActionListener {
        pauseListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            MIDP.injectPauseEvent(1);
        }
    }

    static class EventGenListener
    implements ActionListener {
        EventGenListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            MIDP.openEventGenUI();
        }
    }
}

