/*
 * Decompiled with CFR 0.152.
 */
package com.sun.kvem.midp;

import com.sun.kvem.Device;
import com.sun.kvem.EMFont;
import com.sun.kvem.FontManager;
import com.sun.kvem.KVMBridge;
import com.sun.kvem.Screen;
import com.sun.kvem.environment.Debug;
import com.sun.kvem.environment.Resources;
import com.sun.kvem.environment.ToolkitDirs;
import com.sun.kvem.midp.ColorConversion;
import com.sun.kvem.midp.CommandManager;
import com.sun.kvem.midp.JPEGProcessor;
import com.sun.kvem.midp.PNGProcessor;
import com.sun.kvem.png.PNGImageReaderSpi;
import com.sun.kvem.util.ToolkitResources;
import com.sun.kvem.wbmp.WBMPImageReaderSpi;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.awt.image.ImagingOpException;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.nio.ByteBuffer;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.WeakHashMap;
import javax.imageio.ImageIO;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageReader;
import javax.imageio.spi.ImageReaderSpi;
import javax.imageio.stream.ImageInputStream;

public class GraphicsBridge {
    private static final int SUPPORTS_COLOR = 1;
    private static final int SUPPORTS_POINTER = 2;
    private static final int SUPPORTS_MOTION = 4;
    private static final int SUPPORTS_DOUBLEBUFFER = 16;
    public static final int LEFT = 4;
    public static final int RIGHT = 8;
    public static final int TOP = 16;
    public static final int BOTTOM = 32;
    public static final int BASELINE = 64;
    public static final int VCENTER = 2;
    public static final int HCENTER = 1;
    public static final int _SIZE_SMALL = 8;
    public static final int _SIZE_MEDIUM = 0;
    public static final int _SIZE_LARGE = 16;
    public static final int _STYLE_PLAIN = 0;
    public static final int _STYLE_BOLD = 1;
    public static final int _STYLE_ITALIC = 2;
    public static final int _STYLE_UNDERLINED = 4;
    public static final int _FACE_SYSTEM = 0;
    public static final int _FACE_MONOSPACE = 32;
    public static final int _FACE_PROPORTIONAL = 64;
    private static final int INPUT_MODE_ABC = 1;
    private static final int INPUT_MODE_abc = 2;
    private static final int INPUT_MODE_123 = 3;
    private static final int INPUT_MODE_SYM = 4;
    private static final int INPUT_MODE_HIRA1 = 16;
    private static final int INPUT_MODE_HIRA2 = 32;
    private static final int INPUT_MODE_HIRA3 = 48;
    private static final int INPUT_MODE_KANA = 64;
    public static final int SOLID = 0;
    public static final int DOTTED = 1;
    public static int screenWidth;
    public static int screenHeight;
    public static int adornedHeight;
    public static Screen screen;
    private static Graphics2D graphics;
    private static Graphics2D fullGraphics;
    private static short[] fullScreenClip;
    private static ColorModel faceColorModel;
    private static float[] DASH_ARRAY;
    private static byte[][] gifPrefix;
    private static byte[] wbmpPrefix;
    private static BasicStroke defaultStroke;
    private static AffineTransform[] xformation;
    private static BasicStroke dottedStroke;
    private static MediaTracker tracker;
    private static EMFont[][][] fonts;
    private static String[][][] fontProps;
    private static SortedMap imageTable;
    private static int imageCount;
    private static final Debug debug;
    private static short[] screenClip;
    public static boolean fullScreen;
    private static BufferedImage faceImage;
    private static Rectangle displayBoundsInFace;
    private static PNGProcessor PNGp;
    private static JPEGProcessor JPEGp;
    private static byte[] defaultIcon;
    private static final String JPEG_ALLOW = "jpeg.allow";
    private static final String GIF_ALLOW = "gif.allow";
    private static final String WBMP_ALLOW = "wbmp.allow";
    private static final boolean jpegAllow;
    private static final boolean gifAllow;
    private static final boolean wbmpAllow;
    private static final int PNG_FORMAT = 1;
    private static final int JPEG_FORMAT = 2;
    private static final int GIF_FORMAT = 3;
    private static final int WBMP_FORMAT = 4;
    private static ColorConversion filter;
    private static Map imagePool;
    private static ByteBuffer getBufferCache;

    public static void initialize() {
        if (screen != null) {
            return;
        }
        screen = Screen.getInstance();
        Dimension dimension = screen.getDisplaySize();
        screenWidth = dimension.width;
        adornedHeight = dimension.height;
        displayBoundsInFace = screen.getDisplayBoundsInFace();
        int n = GraphicsBridge.displayBoundsInFace.y;
        screenHeight = GraphicsBridge.screen.getFaceSize().height - n;
        screenClip = new short[]{0, 0, (short)screenWidth, (short)adornedHeight};
        fullScreenClip = new short[]{0, 0, (short)screenWidth, (short)screenHeight};
        tracker = new MediaTracker(screen.getComponent());
        graphics = screen.getDisplayGraphics();
        fullGraphics = screen.getFaceGraphics();
        fullGraphics.translate(0, n);
        faceImage = screen.getFaceImage();
        faceColorModel = faceImage.getColorModel();
        int n2 = screen.getColorCount();
        if (screen.isColor() && n2 >= 8 && n2 < 0x1000000 && (n2 & n2 - 1) == 0) {
            filter = new ColorConversion(screen);
        }
        GraphicsBridge.fillFontNames();
        KVMBridge.getBridge().getKVMDeviceInterface().initializeWindowSystem();
        try {
            Class.forName("com.sun.kvem.mma.VideoScreenBridge");
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }

    public static void grabFullScreen(boolean bl) {
        if (debug.level(2)) {
            debug.println(2, "Grabbed fullscreen mode: {0}", (Object)new Boolean(bl));
        }
        fullScreen = bl;
        screen.setFullScreenMode(bl);
        CommandManager.getInstance().grabFullScreen(bl);
        if (!fullScreen) {
            screen.updateFace();
        }
    }

    public static void drawLine(int n, int n2, short[] sArray, int n3, int n4, int n5, int n6, int n7) {
        Graphics2D graphics2D = GraphicsBridge.getClippedGraphics(n3, sArray);
        if (filter != null) {
            n = filter.filterRGB(0, 0, n);
        }
        graphics2D.setColor(new Color(n));
        if (n2 == 1) {
            graphics2D.setStroke(dottedStroke);
        }
        graphics2D.drawLine(n4, n5, n6, n7);
        graphics2D.setStroke(defaultStroke);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void drawRect(int n, int n2, short[] sArray, int n3, int n4, int n5, int n6, int n7, boolean bl, int n8, int n9) {
        if (!bl && n6 == 0 && n7 == 0) {
            GraphicsBridge.drawLine(n, n2, sArray, n3, n4, n5, n4, n5);
            return;
        }
        Graphics2D graphics2D = GraphicsBridge.getClippedGraphics(n3, sArray);
        n8 = Math.max(n8, 0);
        n9 = Math.max(n9, 0);
        if (filter != null) {
            n = filter.filterRGB(0, 0, n);
        }
        graphics2D.setColor(new Color(n));
        if (n2 == 1) {
            graphics2D.setStroke(dottedStroke);
        }
        Screen screen = GraphicsBridge.screen;
        synchronized (screen) {
            if (bl) {
                graphics2D.fillRoundRect(n4, n5, n6, n7, n8, n9);
            } else {
                graphics2D.drawRoundRect(n4, n5, n6, n7, n8, n9);
            }
        }
        graphics2D.setStroke(defaultStroke);
    }

    public static void fillTriangle(int n, int n2, short[] sArray, int n3, int n4, int n5, int n6, int n7, int n8, int n9) {
        Graphics2D graphics2D = GraphicsBridge.getClippedGraphics(n3, sArray);
        if (filter != null) {
            n = filter.filterRGB(0, 0, n);
        }
        graphics2D.setColor(new Color(n));
        graphics2D.fillPolygon(new int[]{n4, n6, n8}, new int[]{n5, n7, n9}, 3);
    }

    public static void drawTiledRegion(int n, int n2, short[] sArray, int n3, int n4, int[] nArray, int[] nArray2, int n5, int n6, int n7, int[] nArray3, int[] nArray4, int n8) {
        for (int i = 0; i < nArray.length; ++i) {
            GraphicsBridge.drawRegion(n, n2, sArray, n3, n4, nArray[i], nArray2[i], n5, n6, n7, nArray3[i], nArray4[i], n8);
        }
    }

    public static void drawRegion(int n, int n2, short[] sArray, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, int n11, int n12) {
        double d;
        double d2;
        Graphics2D graphics2D = GraphicsBridge.getClippedGraphics(n3, sArray);
        double d3 = n10;
        double d4 = n11;
        double d5 = n7;
        double d6 = n8;
        double d7 = d5 / 2.0;
        double d8 = d6 / 2.0;
        if (n9 < 4) {
            d2 = d7;
            d = d8;
        } else {
            d5 = n8;
            d6 = n7;
            d2 = d8;
            d = d7;
        }
        switch (n12 & 0xD) {
            case 4: {
                break;
            }
            case 8: {
                d3 -= d5;
                break;
            }
            case 1: {
                d3 -= d2;
            }
        }
        switch (n12 & 0x32) {
            case 16: {
                break;
            }
            case 32: {
                d4 -= d6;
                break;
            }
            case 2: {
                d4 -= d;
            }
        }
        BufferedImage bufferedImage = GraphicsBridge.getImage(n4).getSubimage(n5, n6, n7, n8);
        AffineTransform affineTransform = n9 < 4 ? AffineTransform.getTranslateInstance(d3 + d7, d4 + d8) : AffineTransform.getTranslateInstance(d3 + d8, d4 + d7);
        affineTransform.concatenate(xformation[n9]);
        affineTransform.translate(-d7, -d8);
        graphics2D.drawImage(bufferedImage, affineTransform, screen.getComponent());
    }

    public static void copyArea(int n, int n2, short[] sArray, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10) {
        Graphics2D graphics2D = GraphicsBridge.getClippedGraphics(n3, sArray);
        switch (n10 & 0xD) {
            default: {
                break;
            }
            case 8: {
                n8 -= n6;
                break;
            }
            case 1: {
                n8 -= n6 >> 1;
            }
        }
        switch (n10 & 0x32) {
            case 2: {
                n9 -= n7;
                break;
            }
            case 32: {
                n9 -= n7 >> 1;
                break;
            }
        }
        graphics2D.copyArea(n4, n5, n6, n7, n8 - n4, n9 - n5);
    }

    public static void drawRGB(int n, int n2, short[] sArray, int n3, int[] nArray, int n4, int n5, int n6, int n7, int n8, int n9, boolean bl) {
        Graphics2D graphics2D = GraphicsBridge.getClippedGraphics(n3, sArray);
        BufferedImage bufferedImage = new BufferedImage(n8, n9, 2);
        Composite composite = graphics2D.getComposite();
        if (!bl) {
            graphics2D.setComposite(AlphaComposite.Src);
            int n10 = 0;
            while (n10 < nArray.length) {
                int n11 = n10++;
                nArray[n11] = nArray[n11] | 0xFF000000;
            }
        }
        if (filter != null) {
            int[] nArray2 = new int[nArray.length];
            for (int i = 0; i < nArray2.length; ++i) {
                nArray2[i] = filter.filterRGB(0, 0, nArray[i]);
            }
            nArray = nArray2;
        }
        bufferedImage.setRGB(0, 0, n8, n9, nArray, n4, n5);
        graphics2D.drawImage((Image)bufferedImage, n6, n7, screen.getComponent());
        graphics2D.setComposite(composite);
    }

    public static void drawRGB16(int n, int n2, short[] sArray, int n3, ByteBuffer byteBuffer, int n4, int n5, int n6, int n7) {
        Graphics2D graphics2D = GraphicsBridge.getClippedGraphics(n3, sArray);
        Dimension dimension = new Dimension(n6, n7);
        BufferedImage bufferedImage = (BufferedImage)imagePool.get(dimension);
        if (bufferedImage == null) {
            bufferedImage = new BufferedImage(n6, n7, 6);
            imagePool.put(dimension, bufferedImage);
        }
        Composite composite = graphics2D.getComposite();
        graphics2D.setComposite(AlphaComposite.Src);
        byte[][] byArray = ((DataBufferByte)bufferedImage.getRaster().getDataBuffer()).getBankData();
        byte[] byArray2 = byteBuffer.array();
        if (filter != null) {
            filter.filterPixelsToDestination16(byArray2, byArray);
        } else {
            int n8 = 0;
            for (int i = 0; i < byArray.length; ++i) {
                int n9 = 0;
                while (n9 < byArray[i].length) {
                    char c = (char)(byArray2[n8] & 0xFF | byArray2[n8 + 1] << 8);
                    byte by = (byte)((c & 0x1F) << 3);
                    byte by2 = (byte)((c & 0x7E0) >>> 3);
                    byte by3 = (byte)((c & 0xF800) >>> 8);
                    if ((by & 8) != 0) {
                        by = (byte)(by | 7);
                    }
                    if ((by2 & 4) != 0) {
                        by2 = (byte)(by2 | 3);
                    }
                    if ((by3 & 8) != 0) {
                        by3 = (byte)(by3 | 7);
                    }
                    byArray[i][n9++] = -1;
                    byArray[i][n9++] = by;
                    byArray[i][n9++] = by2;
                    byArray[i][n9++] = by3;
                    n8 += 2;
                }
            }
        }
        graphics2D.drawImage((Image)bufferedImage, n4, n5, screen.getComponent());
        graphics2D.setComposite(composite);
    }

    public static ByteBuffer getBufferRGB(int n, short[] sArray) {
        short[] sArray2;
        BufferedImage bufferedImage;
        if (n == 0) {
            bufferedImage = faceImage;
            Rectangle rectangle = displayBoundsInFace;
            sArray2 = fullScreen ? new short[]{0, (short)rectangle.y, fullScreenClip[2], fullScreenClip[3]} : new short[]{(short)rectangle.x, (short)rectangle.y, (short)rectangle.width, (short)rectangle.height};
        } else {
            try {
                bufferedImage = GraphicsBridge.getImage(n);
                sArray2 = new short[]{0, 0, (short)bufferedImage.getWidth(), (short)bufferedImage.getHeight()};
            }
            catch (ClassCastException classCastException) {
                throw new IllegalStateException("Image class unsupported: " + GraphicsBridge.getImage(n).getClass());
            }
        }
        int n2 = sArray[0] + sArray2[0];
        int n3 = sArray[1] + sArray2[1];
        int n4 = sArray[2];
        int n5 = sArray[3];
        if (n2 < sArray2[0]) {
            n2 = sArray2[0];
            n4 += n2 - sArray2[0];
        }
        if (n3 < sArray2[1]) {
            n3 = sArray2[1];
            n5 += n3 - sArray2[1];
        }
        if (n2 + n4 > sArray2[0] + sArray2[2]) {
            n4 = sArray2[0] + sArray2[2] - n2;
        }
        if (n3 + n5 > sArray2[1] + sArray2[3]) {
            n5 = sArray2[1] + sArray2[3] - n3;
        }
        int n6 = n4 * n5 * 4;
        if (getBufferCache == null || getBufferCache.capacity() < n6) {
            getBufferCache = ByteBuffer.allocate(n6);
        }
        getBufferCache.rewind();
        byte[] byArray = getBufferCache.array();
        int n7 = bufferedImage.getRaster().getTransferType();
        if (n7 == 0) {
            byte[][] byArray2 = ((DataBufferByte)bufferedImage.getRaster().getDataBuffer()).getBankData();
            int n8 = bufferedImage.getWidth();
            int n9 = n8 * n3 + n2;
            int n10 = n9 + n4;
            int n11 = 0;
            int n12 = 0;
            for (int i = 0; i < n5; ++i) {
                while (n9 > byArray2[n12].length) {
                    n9 -= byArray2[n12].length;
                    n10 -= byArray2[n12].length;
                    ++n12;
                }
                for (int j = n9; j < n10; j += 4) {
                    byte by = byArray2[n12][j];
                    byte by2 = byArray2[n12][j + 1];
                    byte by3 = byArray2[n12][j + 2];
                    byArray[n11++] = (byte)((by & 0xF8) >>> 3 | (by2 & 0x1C) << 5);
                    byArray[n11++] = (byte)((by2 & 0xE0) >>> 3 | by3 & 0xF8);
                }
                n9 += n8;
                n10 += n8;
            }
        } else if (n7 == 3) {
            int[][] nArray = ((DataBufferInt)bufferedImage.getRaster().getDataBuffer()).getBankData();
            int n13 = bufferedImage.getWidth();
            int n14 = n13 * n3 + n2;
            int n15 = n14 + n4;
            int n16 = 0;
            int n17 = 0;
            for (int i = 0; i < n5; ++i) {
                while (n14 > nArray[n17].length) {
                    n14 -= nArray[n17].length;
                    n15 -= nArray[n17].length;
                    ++n17;
                }
                for (int j = n14; j < n15; ++j) {
                    int n18 = nArray[n17][j];
                    int n19 = n18 >> 3 & 0x1F;
                    int n20 = n18 >> 10 & 0x3F;
                    int n21 = n18 >> 16 & 0xF8;
                    byArray[n16++] = (byte)(n19 | n20 << 5);
                    byArray[n16++] = (byte)(n20 >> 3 | n21);
                }
                n14 += n13;
                n15 += n13;
            }
        }
        getBufferCache.limit(n4 * n5 * 2);
        return getBufferCache;
    }

    public static void drawArc(int n, int n2, short[] sArray, int n3, int n4, int n5, int n6, int n7, boolean bl, int n8, int n9) {
        if (!bl && n6 == 0 && n7 == 0 && n8 == 0 && n9 == 360) {
            GraphicsBridge.drawLine(n, n2, sArray, n3, n4, n5, n4, n5);
            return;
        }
        Graphics2D graphics2D = GraphicsBridge.getClippedGraphics(n3, sArray);
        if (filter != null) {
            n = filter.filterRGB(0, 0, n);
        }
        graphics2D.setColor(new Color(n));
        if (n2 == 1) {
            graphics2D.setStroke(dottedStroke);
        }
        if (bl) {
            graphics2D.fillArc(n4, n5, n6, n7, n8, n9);
        } else {
            graphics2D.drawArc(n4, n5, n6, n7, n8, n9);
        }
        graphics2D.setStroke(defaultStroke);
    }

    public static void drawChars(int n, int n2, short[] sArray, int n3, int n4, int n5, int n6, int n7, int n8, int n9, char[] cArray) {
        int n10;
        CharSequence charSequence;
        boolean bl;
        Graphics2D graphics2D = GraphicsBridge.getClippedGraphics(n3, sArray);
        if (debug.level(3)) {
            debug.println(3, "Draw {0}", (Object)new String(cArray));
        }
        switch (n9 & 0xD) {
            default: {
                break;
            }
            case 8: {
                n7 -= GraphicsBridge.getCharsWidth(n4, n5, n6, cArray);
                break;
            }
            case 1: {
                n7 -= GraphicsBridge.getCharsWidth(n4, n5, n6, cArray) >> 1;
            }
        }
        switch (n9 & 0x70) {
            case 64: {
                n8 -= GraphicsBridge.getAscent(n4, n5, n6);
                break;
            }
            case 32: {
                n8 -= GraphicsBridge.getFontHeight(n4, n5, n6);
                break;
            }
        }
        if (filter != null) {
            n = filter.filterRGB(0, 0, n);
        }
        graphics2D.setColor(new Color(n));
        EMFont eMFont = GraphicsBridge.getFont(n4, n5, n6);
        String string = GraphicsBridge.getFontPropertyKey(n4, n5, n6);
        boolean bl2 = bl = "false".equals(Device.getProperty("font.all.underline.enabled", "true")) || "false".equals(Device.getProperty(string + ".underline.enabled", "true"));
        if ((n5 & 4) == 0 || bl) {
            eMFont.setUnderlineStyle(false);
        } else {
            charSequence = "1";
            if ((n5 & 1) != 0) {
                charSequence = "2";
            }
            n10 = Integer.parseInt(Device.getProperty(string + ".underline.width", (String)charSequence));
            int n11 = Integer.parseInt(Device.getProperty(string + ".underline.offset", "1"));
            eMFont.setUnderlineStyle(true, n10, n11);
        }
        charSequence = new StringBuffer(cArray.length);
        for (n10 = 0; n10 < cArray.length; ++n10) {
            if (Character.isISOControl(cArray[n10])) continue;
            ((StringBuffer)charSequence).append(cArray[n10]);
        }
        ((StringBuffer)charSequence).getChars(0, ((StringBuffer)charSequence).length(), cArray, 0);
        eMFont.drawChars(graphics2D, cArray, 0, ((StringBuffer)charSequence).length(), n7, n8);
    }

    public static void drawImage(int n, int n2, short[] sArray, int n3, int n4, int n5, int n6, int n7) {
        Graphics2D graphics2D = GraphicsBridge.getClippedGraphics(n3, sArray);
        Rectangle rectangle = graphics2D.getClipBounds();
        debug.println(3, "drawImage clip bounds: {0}", (Object)rectangle);
        debug.println(2, "Draw Image, srcdesc = {0}, on dstdesc = {1}", n7, n3);
        debug.println(3, "            at x = {0}, y = {1}", n4, n5);
        BufferedImage bufferedImage = GraphicsBridge.getImage(n7);
        int n8 = bufferedImage.getWidth(null);
        int n9 = bufferedImage.getHeight(null);
        debug.println(3, "Image dimensions: w: {0}, h: {1}", n8, n9);
        switch (n6 & 0xD) {
            default: {
                break;
            }
            case 8: {
                n4 -= n8;
                break;
            }
            case 1: {
                n4 -= n8 >> 1;
            }
        }
        switch (n6 & 0x32) {
            default: {
                break;
            }
            case 32: {
                n5 -= n9;
                break;
            }
            case 2: {
                n5 -= n9 >> 1;
            }
        }
        if (rectangle.isEmpty()) {
            debug.println(3, "Empty clip bounds detected. Skipping drawImage.");
        } else {
            Rectangle rectangle2 = rectangle.intersection(new Rectangle(n4, n5, n8, n9));
            debug.println(3, "Drawable Area: {0}", (Object)rectangle2);
            if (rectangle2.isEmpty()) {
                debug.println(3, "Skipping drawImage with no visible area");
            } else {
                BufferedImage bufferedImage2 = bufferedImage;
                if (rectangle2.width == n8 && rectangle2.height == n9) {
                    debug.println(3, "Skipping subImage call - entire image is visible");
                } else {
                    int n10 = Math.max(rectangle.x - n4, 0);
                    int n11 = Math.max(rectangle.y - n5, 0);
                    debug.println(3, "SubImageAreaX: {0}", n10);
                    debug.println(3, "SubImageAreaY: {0}", n11);
                    bufferedImage2 = bufferedImage.getSubimage(n10, n11, rectangle2.width, rectangle2.height);
                }
                debug.println(3, "calling Graphics.drawImage({0}, {1})", n4, n5);
                try {
                    graphics2D.drawImage((Image)bufferedImage2, rectangle2.x, rectangle2.y, screen.getComponent());
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    debug.exception(1, (Throwable)arrayIndexOutOfBoundsException);
                }
            }
        }
        debug.println(3, "exiting drawImage.");
    }

    public static int[] getRGB(int n, int n2, int n3, int n4, int n5, int n6) {
        BufferedImage bufferedImage = GraphicsBridge.getImage(n);
        return bufferedImage.getRGB(n3, n4, n5, n6, null, 0, n2);
    }

    private static int getFontHeight(int n, int n2, int n3) {
        EMFont eMFont = GraphicsBridge.getFont(n, n2, n3);
        return eMFont.getAscent() + eMFont.getDescent() + eMFont.getLeading();
    }

    public static int[] getFontInfo(int n, int n2, int n3) {
        EMFont eMFont = GraphicsBridge.getFont(n, n2, n3);
        return new int[]{eMFont.getAscent(), eMFont.getDescent(), eMFont.getLeading()};
    }

    public static void incomingCall() {
        String string = ToolkitResources.getString((String)"MIDLET.RESUME_MESSAGE");
        char[] cArray = string.toCharArray();
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = GraphicsBridge.getCharsWidth(0, 1, 16, cArray);
        int[] nArray = GraphicsBridge.getFontInfo(0, 1, 16);
        int n7 = nArray[0] + nArray[1];
        short[] sArray = new short[]{0, 0, (short)screenWidth, (short)screenHeight};
        n3 = n6 + 30;
        n4 = n7 * 2 + 35;
        n = (screenWidth - n3) / 2;
        n2 = (screenHeight - n4) / 2;
        GraphicsBridge.drawRect(Color.white.getRGB(), 0, sArray, 0, n, n2, n3, n4, true, 20, 20);
        GraphicsBridge.drawRect(Color.black.getRGB(), 0, sArray, 0, n - 1, n2 - 1, n3 + 1, n4 + 1, false, 20, 20);
        n5 = n2 + n7;
        GraphicsBridge.drawChars(Color.black.getRGB(), 0, sArray, 0, 0, 1, 16, screenWidth / 2, n5, 17, cArray);
        GraphicsBridge.refresh(0, 0, screenWidth, screenHeight);
    }

    public static int getAscent(int n, int n2, int n3) {
        return GraphicsBridge.getFont(n, n2, n3).getAscent();
    }

    public static int getDescent(int n, int n2, int n3) {
        return GraphicsBridge.getFont(n, n2, n3).getDescent();
    }

    public static int getLeading(int n, int n2, int n3) {
        return GraphicsBridge.getFont(n, n2, n3).getLeading();
    }

    public static int getCharsWidth(int n, int n2, int n3, char[] cArray) {
        return GraphicsBridge.getFont(n, n2, n3).charsWidth(cArray, 0, cArray.length);
    }

    public static int[] getDisplayParams() {
        int n = screen.getColorCount();
        int n2 = (int)Math.floor(Math.log(n) / Math.log(2.0));
        int n3 = screen.isColor() ? 1 : 0;
        int n4 = Device.getBooleanProperty("touch_screen", false) ? 2 : 0;
        int n5 = Device.getBooleanProperty("touch_screen", false) ? 4 : 0;
        int n6 = 0;
        int n7 = Device.getBooleanProperty("screenDoubleBuffer", true) ? 16 : 0;
        return new int[]{screenWidth, adornedHeight, screenHeight, 0xFFFFFF, n2, n3 | n4 | n5 | n6 | n7, 256};
    }

    public static void setHorizontalScroll(int n, int n2) {
        debug.println(3, "Set scroll: x={0}, {1}%", n, n2);
        if (n2 < 100 && n < 100) {
            screen.setIconState("right", "on");
        } else {
            screen.setIconState("right", "off");
        }
        if (n2 < 100 && n > 0) {
            screen.setIconState("left", "on");
        } else {
            screen.setIconState("left", "off");
        }
    }

    public static void setVerticalScroll(int n, int n2) {
        debug.println(3, "Set scroll: y={0}, {1}%", n, n2);
        if (n2 < 100 && n < 100) {
            screen.setIconState("down", "on");
        } else {
            screen.setIconState("down", "off");
        }
        if (n2 < 100 && n > 0) {
            screen.setIconState("up", "on");
        } else {
            screen.setIconState("up", "off");
        }
    }

    public static void setInputMode(int n) {
        String string = "inmode";
        switch (n) {
            case 1: {
                screen.setIconState(string, "ABC");
                break;
            }
            case 2: {
                screen.setIconState(string, "abc");
                break;
            }
            case 3: {
                screen.setIconState(string, "123");
                break;
            }
            case 4: {
                screen.setIconState(string, "sym");
                break;
            }
            case 16: 
            case 32: 
            case 48: {
                screen.setIconState(string, "hira");
                break;
            }
            case 64: {
                screen.setIconState(string, "kana");
                break;
            }
            default: {
                screen.setIconState(string, "off");
            }
        }
    }

    public static void drawTrustedIcon(boolean bl) {
        if (bl) {
            screen.setIconState("domain", "trusted");
        } else {
            screen.setIconState("domain", "off");
        }
    }

    public static int createImage(int n, int n2, int n3) {
        BufferedImage bufferedImage;
        int n4 = 0;
        try {
            if (n3 != 0) {
                debug.println(2, "Create image {0} from descriptor", n3);
                BufferedImage bufferedImage2 = GraphicsBridge.getImage(n3);
                bufferedImage = new BufferedImage(((Image)bufferedImage2).getWidth(null), ((Image)bufferedImage2).getHeight(null), 2);
                bufferedImage.getGraphics().drawImage(bufferedImage2, 0, 0, screen.getComponent());
            } else {
                debug.println(2, "Create image width = {0}, height = {1}", n2, n);
                bufferedImage = new BufferedImage(n2, n, 2);
                Graphics graphics = bufferedImage.getGraphics();
                Color color = filter != null ? new Color(filter.filterRGB(0, 0, -1)) : Color.white;
                graphics.setColor(color);
                graphics.fillRect(0, 0, n2, n);
            }
        }
        catch (Throwable throwable) {
            Debug.warning((String)("Out of memory: " + throwable));
            debug.exception(1, throwable);
            bufferedImage = null;
        }
        if (bufferedImage != null) {
            n4 = GraphicsBridge.storeImage(bufferedImage);
        }
        return n4;
    }

    public static int[] createImageRegion(int n, int n2, int n3, int n4, int n5, int n6) {
        int n7 = 0;
        int n8 = 0;
        int n9 = 0;
        BufferedImage bufferedImage = GraphicsBridge.getImage(n).getSubimage(n2, n3, n4, n5);
        double d = (double)n4 / 2.0;
        double d2 = (double)n5 / 2.0;
        AffineTransform affineTransform = n6 < 4 ? AffineTransform.getTranslateInstance(d, d2) : AffineTransform.getTranslateInstance(d2, d);
        affineTransform.concatenate(xformation[n6]);
        affineTransform.translate(-d, -d2);
        AffineTransformOp affineTransformOp = new AffineTransformOp(affineTransform, null);
        try {
            BufferedImage bufferedImage2 = affineTransformOp.filter(bufferedImage, null);
            n7 = GraphicsBridge.storeImage(bufferedImage2);
            n8 = bufferedImage2.getWidth();
            n9 = bufferedImage2.getHeight();
        }
        catch (ImagingOpException imagingOpException) {
            debug.exception(1, (Throwable)imagingOpException);
            n7 = 0;
        }
        debug.println(1, "createImageRegion from imageID:{0}", n);
        debug.println(1, "\twidth:{0}, height:{1}", n4, n5);
        debug.println(1, "Created imageID:{0}", n7);
        debug.println(1, "\twidth:{0}, height:{1}", n8, n9);
        return new int[]{n7, n8, n9};
    }

    public static int[] loadIcon(byte[] byArray) {
        int[] nArray;
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        String string = new String(byArray);
        Image image = Toolkit.getDefaultToolkit().createImage(ToolkitDirs.API + File.separator + string);
        tracker.addImage(image, 1);
        GraphicsBridge.prepareImage(1);
        if (tracker.isErrorID(1)) {
            nArray = GraphicsBridge.createImageFromData(defaultIcon);
            debug.println(2, "Failed to create icon: {0}, using default. imageID: {1}", (Object)string, nArray[0]);
        } else {
            n3 = image.getHeight(null);
            n2 = image.getWidth(null);
            BufferedImage bufferedImage = new BufferedImage(n2, n3, 2);
            bufferedImage.getGraphics().drawImage(image, 0, 0, screen.getComponent());
            if (filter != null) {
                int[] nArray2 = bufferedImage.getRGB(0, 0, n2, n3, null, 0, n2);
                for (int i = 0; i < nArray2.length; ++i) {
                    nArray2[i] = filter.filterRGB(0, 0, nArray2[i]);
                }
                bufferedImage.setRGB(0, 0, n2, n3, nArray2, 0, n2);
            }
            n = GraphicsBridge.storeImage(bufferedImage);
            nArray = new int[]{n, n2, n3};
            debug.println(1, "Succesfully created icon: {0}, imageID: {1}", (Object)string, n);
            debug.println(1, "\twidth:{0}, height:{1}", n3, n2);
        }
        tracker.removeImage(image, 1);
        return nArray;
    }

    public static void cleanImage(int n) {
        if (n != 0) {
            GraphicsBridge.removeImage(n);
        }
    }

    public static void setSoftButtonLabel(int n, String string) {
        if (n < 0 || n > 1) {
            return;
        }
        if (string == null) {
            string = "";
        }
        screen.setSoftButtonLabel(n, string);
    }

    private static int storeImage(Image image) {
        int n = imageCount++;
        imageTable.put(new Integer(n), image);
        return n;
    }

    private static void removeImage(int n) {
        Integer n2 = new Integer(n);
        imageTable.remove(n2);
        if (debug.level(2)) {
            int n3 = imageTable.size();
            debug.println(2, "Cleaning up image #{0}, {1} images in table", n, n3);
        }
    }

    private static BufferedImage getImage(int n) {
        return (BufferedImage)imageTable.get(new Integer(n));
    }

    /*
     * Unable to fully structure code
     */
    public static int[] createImageFromData(byte[] var0) {
        block5: {
            block6: {
                block4: {
                    var1_1 = new int[]{0, 0, 0};
                    if (!GraphicsBridge.PNGp.isPNGImage(var0) || !GraphicsBridge.PNGp.includesIEND(var0, 0)) break block4;
                    var1_1 = GraphicsBridge.loadImage(var0, GraphicsBridge.PNGp.remove_tRNS(var0), 1);
                    break block5;
                }
                if (!GraphicsBridge.JPEGp.isJPEGImage(var0) || !GraphicsBridge.jpegAllow) break block6;
                var1_1 = GraphicsBridge.loadImage(var0, 0, 2);
                break block5;
            }
            if (!GraphicsBridge.gifAllow) ** GOTO lbl-1000
            if (PNGProcessor.compare(GraphicsBridge.gifPrefix[0], 0, var0, 0, GraphicsBridge.gifPrefix[0].length)) ** GOTO lbl-1000
            if (PNGProcessor.compare(GraphicsBridge.gifPrefix[1], 0, var0, 0, GraphicsBridge.gifPrefix[1].length)) lbl-1000:
            // 2 sources

            {
                var1_1 = GraphicsBridge.loadImage(var0, 0, 3);
            } else if (GraphicsBridge.wbmpAllow) {
                if (PNGProcessor.compare(GraphicsBridge.wbmpPrefix, 0, var0, 0, GraphicsBridge.wbmpPrefix.length)) {
                    var1_1 = GraphicsBridge.loadImage(var0, 0, 4);
                }
            }
        }
        GraphicsBridge.debug.println(2, "Created image {0} from data, {1} images in table", var1_1[0], GraphicsBridge.imageTable.size());
        return var1_1;
    }

    private static int[] loadImage(byte[] byArray, int n, int n2) {
        BufferedImage bufferedImage;
        ImageReadParam imageReadParam;
        ImageInputStream imageInputStream;
        Object object;
        Object object2;
        int[] nArray = new int[]{0, 0, 0};
        if (n2 == 1 && Resources.getResources().getBoolean("useOtherPNGDecoder", true)) {
            try {
                object2 = new PNGImageReaderSpi();
                object = ((ImageReaderSpi)object2).createReaderInstance();
                imageInputStream = ImageIO.createImageInputStream(new ByteArrayInputStream(byArray, n, byArray.length - n));
                imageReadParam = ((ImageReader)object).getDefaultReadParam();
                ((ImageReader)object).setInput(imageInputStream, true, true);
                bufferedImage = ((ImageReader)object).read(0, imageReadParam);
                nArray[1] = bufferedImage.getWidth(null);
                nArray[2] = bufferedImage.getHeight(null);
            }
            catch (Exception exception) {
                bufferedImage = null;
            }
        } else if (n2 == 3) {
            try {
                object2 = ImageIO.getImageReadersByMIMEType("image/gif").next();
                object = ImageIO.createImageInputStream(new ByteArrayInputStream(byArray, 0, byArray.length));
                ((ImageReader)object2).setInput(object, false, true);
                bufferedImage = ((ImageReader)object2).read(0);
                nArray[1] = bufferedImage.getWidth(null);
                nArray[2] = bufferedImage.getHeight(null);
            }
            catch (Exception exception) {
                bufferedImage = null;
            }
        } else if (n2 == 4) {
            try {
                object2 = new WBMPImageReaderSpi();
                object = ((ImageReaderSpi)object2).createReaderInstance();
                imageInputStream = ImageIO.createImageInputStream(new ByteArrayInputStream(byArray, n, byArray.length - n));
                imageReadParam = ((ImageReader)object).getDefaultReadParam();
                ((ImageReader)object).setInput(imageInputStream, true, true);
                bufferedImage = ((ImageReader)object).read(0, imageReadParam);
                nArray[1] = bufferedImage.getWidth(null);
                nArray[2] = bufferedImage.getHeight(null);
            }
            catch (Exception exception) {
                debug.exception(1, (Throwable)exception);
                bufferedImage = null;
            }
        } else {
            object2 = Toolkit.getDefaultToolkit().createImage(byArray, n, byArray.length - n);
            tracker.addImage((Image)object2, 0);
            GraphicsBridge.prepareImage(0);
            if (!tracker.isErrorID(0)) {
                nArray[1] = ((Image)object2).getWidth(null);
                nArray[2] = ((Image)object2).getHeight(null);
                bufferedImage = new BufferedImage(nArray[1], nArray[2], 2);
                bufferedImage.getGraphics().drawImage((Image)object2, 0, 0, screen.getComponent());
            } else {
                bufferedImage = null;
            }
            tracker.removeImage((Image)object2, 0);
        }
        if (bufferedImage != null) {
            if (filter != null) {
                object2 = bufferedImage.getRGB(0, 0, nArray[1], nArray[2], null, 0, nArray[1]);
                for (int i = 0; i < ((Object)object2).length; ++i) {
                    object2[i] = filter.filterRGB(0, 0, (int)object2[i]);
                }
                bufferedImage.setRGB(0, 0, nArray[1], nArray[2], (int[])object2, 0, nArray[1]);
            }
            nArray[0] = GraphicsBridge.storeImage(bufferedImage);
        }
        return nArray;
    }

    public static int createImageFromRGB(int[] nArray, int n, int n2, boolean bl) {
        int n3 = 0;
        try {
            BufferedImage bufferedImage = bl ? new BufferedImage(n, n2, 2) : new BufferedImage(n, n2, 1);
            if (filter != null) {
                int[] nArray2 = new int[nArray.length];
                for (int i = 0; i < nArray2.length; ++i) {
                    nArray2[i] = filter.filterRGB(0, 0, nArray[i]);
                }
                nArray = nArray2;
            }
            bufferedImage.setRGB(0, 0, n, n2, nArray, 0, n);
            n3 = GraphicsBridge.storeImage(bufferedImage);
        }
        catch (VirtualMachineError virtualMachineError) {
            n3 = 0;
        }
        catch (RuntimeException runtimeException) {
            n3 = 0;
        }
        return n3;
    }

    public static int getDisplayColor(int n) {
        int n2;
        if (filter != null) {
            n2 = filter.filterRGB(0, 0, n) & 0xFFFFFF;
        } else {
            int[] nArray = new int[]{n >> 16 & 0xFF, n >> 8 & 0xFF, n & 0xFF, 255};
            try {
                n2 = faceColorModel.getRGB(faceColorModel.getDataElement(nArray, 0)) & 0xFFFFFF;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                debug.println(1, "could not get display color for {0}", n);
                debug.exception(1, (Throwable)illegalArgumentException);
                n2 = 0;
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                n2 = n;
            }
        }
        return n2;
    }

    public static void refresh(int n, int n2, int n3, int n4) {
        if (debug.level(4)) {
            debug.println(4, "refresh() called at x = {0} y = {1}", n, n2);
            debug.println(4, "                    w = {0} h = {1}", n3, n4);
            debug.println(4, "                 time = {0}", (Object)new Long(System.currentTimeMillis()));
        }
        if (fullScreen) {
            screen.updateFace(n, n2, n3, n4);
        } else {
            screen.updateDisplay(n, n2, n3, n4);
        }
    }

    private static void prepareImage(int n) {
        while (!tracker.checkID(n)) {
            try {
                tracker.waitForID(n);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    private static String getFontPropertyKey(int n, int n2, int n3) {
        return fontProps[(n & 0xFF) >> 5][n2 & 0xFF & 0xFFFFFFFB][(n3 & 0xFF) >> 3];
    }

    static EMFont getFont(int n, int n2, int n3) {
        return fonts[(n & 0xFF) >> 5][n2 & 0xFF & 0xFFFFFFFB][(n3 & 0xFF) >> 3];
    }

    private static void fillFontNames() {
        FontManager fontManager = FontManager.getInstance();
        String[] stringArray = new String[]{"system", "monospace", "proportional"};
        int[] nArray = new int[]{0, 32, 64};
        String[] stringArray2 = new String[]{"plain", "bold", "italic", "bold.italic"};
        int[] nArray2 = new int[]{0, 1, 2, 3};
        String[] stringArray3 = new String[]{"small", "medium", "large"};
        int[] nArray3 = new int[]{8, 0, 16};
        fonts = new EMFont[stringArray.length][stringArray2.length][stringArray3.length];
        fontProps = new String[stringArray.length][stringArray2.length][stringArray3.length];
        for (int i = 0; i < stringArray.length; ++i) {
            int n = (nArray[i] & 0xFF) >> 5;
            for (int j = 0; j < stringArray2.length; ++j) {
                int n2 = nArray2[j] & 0xFF & 0xFFFFFFFB;
                for (int k = 0; k < stringArray3.length; ++k) {
                    int n3 = (nArray3[k] & 0xFF) >> 3;
                    GraphicsBridge.fontProps[n][n2][n3] = stringArray[i] + "." + stringArray2[j] + "." + stringArray3[k];
                    GraphicsBridge.fonts[n][n2][n3] = fontManager.getFont(fontManager.getFontID(fontProps[n][n2][n3]));
                }
            }
        }
    }

    public static Graphics2D getClippedGraphics(int n, short[] sArray) {
        short[] sArray2;
        Graphics2D graphics2D;
        if (n != 0) {
            BufferedImage bufferedImage = GraphicsBridge.getImage(n);
            graphics2D = (Graphics2D)((Image)bufferedImage).getGraphics();
            sArray2 = new short[]{0, 0, (short)((Image)bufferedImage).getWidth(null), (short)((Image)bufferedImage).getHeight(null)};
        } else if (fullScreen) {
            graphics2D = fullGraphics;
            sArray2 = fullScreenClip;
        } else {
            graphics2D = graphics;
            sArray2 = screenClip;
        }
        graphics2D.setClip(sArray2[0], sArray2[1], sArray2[2], sArray2[3]);
        if (sArray != null) {
            if (sArray[0] < 0) {
                sArray[2] = (short)(sArray[2] + sArray[0]);
                sArray[0] = 0;
            }
            if (sArray[1] < 0) {
                sArray[3] = (short)(sArray[3] + sArray[1]);
                sArray[1] = 0;
            }
            if (sArray[0] + sArray[2] > sArray2[2]) {
                sArray[2] = (short)(sArray2[2] - sArray[0]);
            }
            if (sArray[1] + sArray[3] > sArray2[3]) {
                sArray[3] = (short)(sArray2[3] - sArray[1]);
            }
            sArray[2] = (short)Math.max(0, sArray[2]);
            sArray[3] = (short)Math.max(0, sArray[3]);
            graphics2D.clipRect(sArray[0], sArray[1], sArray[2], sArray[3]);
        }
        return graphics2D;
    }

    static {
        screen = null;
        DASH_ARRAY = new float[]{2.0f};
        gifPrefix = new byte[][]{{71, 73, 70, 56, 57, 97}, {71, 73, 70, 56, 55, 97}};
        wbmpPrefix = new byte[]{0};
        defaultStroke = new BasicStroke();
        xformation = new AffineTransform[8];
        GraphicsBridge.xformation[0] = new AffineTransform();
        GraphicsBridge.xformation[1] = AffineTransform.getRotateInstance(Math.PI);
        xformation[1].scale(-1.0, 1.0);
        GraphicsBridge.xformation[2] = AffineTransform.getScaleInstance(-1.0, 1.0);
        GraphicsBridge.xformation[3] = AffineTransform.getRotateInstance(Math.PI);
        GraphicsBridge.xformation[4] = AffineTransform.getRotateInstance(-1.5707963267948966);
        xformation[4].scale(-1.0, 1.0);
        GraphicsBridge.xformation[5] = AffineTransform.getRotateInstance(1.5707963267948966);
        GraphicsBridge.xformation[6] = AffineTransform.getRotateInstance(-1.5707963267948966);
        GraphicsBridge.xformation[7] = AffineTransform.getRotateInstance(1.5707963267948966);
        xformation[7].scale(-1.0, 1.0);
        dottedStroke = new BasicStroke(defaultStroke.getLineWidth(), defaultStroke.getEndCap(), defaultStroke.getLineJoin(), defaultStroke.getMiterLimit(), DASH_ARRAY, 0.0f);
        imageTable = new TreeMap();
        imageCount = 1;
        debug = Debug.create((Class)GraphicsBridge.class);
        fullScreen = false;
        PNGp = new PNGProcessor();
        JPEGp = new JPEGProcessor();
        defaultIcon = new byte[]{-119, 80, 78, 71, 13, 10, 26, 10, 0, 0, 0, 13, 73, 72, 68, 82, 0, 0, 0, 10, 0, 0, 0, 11, 2, 3, 0, 0, 0, 59, 0, -12, -117, 0, 0, 0, 6, 80, 76, 84, 69, -1, -1, -1, -69, -69, -69, -57, 75, -33, -8, 0, 0, 0, 30, 73, 68, 65, 84, 120, -38, 99, 96, 96, 96, 96, 12, 101, -8, -51, -32, -64, 32, -64, -60, -64, -64, -128, 11, 51, -122, 50, -4, 6, 0, 63, 116, 3, 1, 53, -108, 39, -26, 0, 0, 0, 0, 73, 69, 78, 68, -82, 66, 96, -126};
        jpegAllow = Device.getBooleanProperty(JPEG_ALLOW, true);
        gifAllow = Device.getBooleanProperty(GIF_ALLOW, true);
        wbmpAllow = Device.getBooleanProperty(WBMP_ALLOW, true);
        imagePool = new WeakHashMap();
    }
}

