/*
 * Decompiled with CFR 0.152.
 */
package com.sun.kvem.midp;

import com.sun.kvem.Device;
import com.sun.kvem.environment.EventGenUI;
import com.sun.kvem.environment.ToolkitDirs;
import com.sun.kvem.midp.EventBridge;
import com.sun.kvem.midp.FileConnEventCodes;
import com.sun.kvem.midp.RootMountName;
import com.sun.kvem.util.ToolkitResources;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Enumeration;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class FileConnEventGenPanel
extends JPanel
implements EventGenUI,
FileConnEventCodes {
    private JList rootsList;
    private static DefaultListModel roots = new DefaultListModel();
    private JButton mountBtn;
    private JButton unmountBtn;
    private JFrame parent;
    private static final String FILESYSTEM = "filesystem";
    private static String superRoot = ToolkitDirs.APPDB + Device.getProperty("storage.root") + File.separator + "filesystem";
    private String newRootName;
    private String nameToRemove;

    public FileConnEventGenPanel() {
        FileConnEventGenPanel.retrieveRoots();
        this.createUI();
        this.enableButtons();
    }

    private static void retrieveRoots() {
        if (roots.size() > 0) {
            return;
        }
        File file = new File(superRoot);
        if (!file.exists()) {
            file.mkdirs();
        }
        File[] fileArray = file.listFiles();
        for (int i = 0; i < fileArray.length; ++i) {
            if (!fileArray[i].isDirectory()) continue;
            roots.addElement(fileArray[i].getName() + '/');
        }
    }

    private void createUI() {
        Box box = new Box(1);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        jPanel.setBorder(BorderFactory.createTitledBorder(ToolkitResources.getString((String)"FILE_CONN.ROOTS")));
        jPanel.setMaximumSize(new Dimension(Short.MAX_VALUE, Short.MAX_VALUE));
        jPanel.setAlignmentX(0.0f);
        this.rootsList = new JList(roots);
        this.rootsList.addListSelectionListener(new RootSelectionListener());
        JScrollPane jScrollPane = new JScrollPane(this.rootsList);
        jPanel.add(jScrollPane);
        box.add(jPanel);
        JPanel jPanel2 = new JPanel();
        jPanel2.setAlignmentX(0.0f);
        this.mountBtn = new JButton(ToolkitResources.getString((String)"FILE_CONN.MOUNT"));
        this.mountBtn.addActionListener(new MountListener());
        this.mountBtn.setActionCommand("6000");
        jPanel2.add(this.mountBtn);
        this.unmountBtn = new JButton(ToolkitResources.getString((String)"FILE_CONN.UNMOUNT"));
        this.unmountBtn.addActionListener(new UnmountListener());
        this.unmountBtn.setActionCommand("6001");
        jPanel2.add(this.unmountBtn);
        box.add(jPanel2);
        this.add(box);
    }

    public void setParent(JFrame jFrame) {
        this.parent = jFrame;
    }

    public JPanel getGUI() {
        return this;
    }

    public String getTitle() {
        return ToolkitResources.getString((String)"FILE_CONN");
    }

    public String getEventData(String string) {
        if (string.equals("6000")) {
            return this.newRootName;
        }
        if (string.equals("6001")) {
            return this.nameToRemove;
        }
        return null;
    }

    private void mountFS() {
        this.newRootName = new RootMountName(this.parent, new File(superRoot)).getNewRootName();
        if (this.newRootName != null && !"".equals(this.newRootName)) {
            if (this.newRootName.charAt(this.newRootName.length() - 1) != '/') {
                this.newRootName = this.newRootName + '/';
            }
            File file = new File(superRoot, this.newRootName);
            file.mkdirs();
            roots.addElement(this.newRootName);
            EventBridge.injectEvent(11, Integer.parseInt("6000"), 0, 0);
        }
    }

    private void unmountFS() {
        int n = this.rootsList.getSelectedIndex();
        this.nameToRemove = (String)roots.elementAt(n);
        roots.removeElementAt(n);
        EventBridge.injectEvent(11, Integer.parseInt("6001"), 0, 0);
    }

    private void enableButtons() {
        this.unmountBtn.setEnabled(this.rootsList.getSelectedIndex() > -1);
    }

    public static String getMountedRoots() {
        FileConnEventGenPanel.retrieveRoots();
        Enumeration enumeration = roots.elements();
        StringBuffer stringBuffer = new StringBuffer();
        while (enumeration.hasMoreElements()) {
            stringBuffer.append(enumeration.nextElement());
        }
        String string = stringBuffer.toString();
        if (string.endsWith("/")) {
            string = string.substring(0, string.length() - 1);
        }
        return string;
    }

    public static boolean isMountedRoot(String string) {
        if (!string.endsWith("/")) {
            string = string + "/";
        }
        return roots.contains(string);
    }

    class RootSelectionListener
    implements ListSelectionListener {
        RootSelectionListener() {
        }

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            FileConnEventGenPanel.this.enableButtons();
        }
    }

    class UnmountListener
    implements ActionListener {
        UnmountListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            FileConnEventGenPanel.this.unmountFS();
        }
    }

    class MountListener
    implements ActionListener {
        MountListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            FileConnEventGenPanel.this.mountFS();
        }
    }
}

