/*
 * Decompiled with CFR 0.152.
 */
package com.sun.kvem.midp;

import com.sun.kvem.environment.Debug;
import com.sun.kvem.environment.EventGenUI;
import com.sun.kvem.environment.Resources;
import com.sun.kvem.util.ToolkitResources;
import java.awt.Insets;
import java.lang.reflect.Constructor;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JFrame;
import javax.swing.JTabbedPane;
import javax.swing.UIManager;

public class ExternalEventGeneratorWin
extends JFrame {
    private static Debug debug = Debug.create((Class)ExternalEventGeneratorWin.class);
    private static final String UI_PROPERTY = "com.sun.kvem.event_ui_";
    private static ExternalEventGeneratorWin win;
    private JTabbedPane tabbedPane;
    private Vector ui = new Vector();
    private boolean phoneNumSet;

    public static synchronized ExternalEventGeneratorWin getWindow() {
        if (win == null) {
            win = new ExternalEventGeneratorWin();
        }
        return win;
    }

    public static void terminate() {
        if (win != null) {
            win.dispose();
        }
    }

    private ExternalEventGeneratorWin() {
        super(ToolkitResources.getString((String)"EVENT_GEN_WIN.TITLE"));
        this.createUI();
    }

    private void createUI() {
        UIManager.put("TabbedPane.tabInsets", new Insets(2, 1, 2, 1));
        String string = "";
        EventGenUI eventGenUI = null;
        int n = 1;
        while (string != null) {
            string = Resources.getResources().getProperty(UI_PROPERTY + n);
            if (string != null) {
                try {
                    Class<?> clazz = Class.forName(string);
                    Constructor<?>[] constructorArray = clazz.getConstructors();
                    eventGenUI = (EventGenUI)constructorArray[0].newInstance(new Object[0]);
                    eventGenUI.setParent((JFrame)this);
                    this.ui.add(eventGenUI);
                }
                catch (Exception exception) {
                    debug.exception(1, (Throwable)exception);
                    Debug.warning((String)exception.toString());
                }
            }
            ++n;
        }
        if (this.ui.size() == 1) {
            this.getContentPane().add(eventGenUI.getGUI());
        } else {
            this.tabbedPane = new JTabbedPane();
            Enumeration enumeration = this.ui.elements();
            while (enumeration.hasMoreElements()) {
                eventGenUI = (EventGenUI)enumeration.nextElement();
                this.tabbedPane.add(eventGenUI.getTitle(), eventGenUI.getGUI());
            }
            this.getContentPane().add(this.tabbedPane);
        }
        this.pack();
    }

    public String getEventData(String string) {
        String string2 = null;
        EventGenUI eventGenUI = null;
        Enumeration enumeration = this.ui.elements();
        while (enumeration.hasMoreElements() && string2 == null) {
            eventGenUI = (EventGenUI)enumeration.nextElement();
            string2 = eventGenUI.getEventData(string);
        }
        return string2;
    }

    public void setTitle(String string) {
        String string2 = string.substring(0, string.indexOf("-") + 2);
        if (string2 != null && !this.phoneNumSet) {
            this.phoneNumSet = true;
            super.setTitle(string2 + this.getTitle());
        }
    }
}

