/*
 * Decompiled with CFR 0.152.
 */
package com.sun.kvem.midp;

import com.sun.kvem.Device;
import com.sun.kvem.DeviceEventListener;
import com.sun.kvem.DeviceEventManager;
import com.sun.kvem.KeyboardManager;
import com.sun.kvem.environment.Debug;
import com.sun.kvem.midp.CommandManager;
import com.sun.kvem.midp.ExternalEventGeneratorWin;
import com.sun.kvem.midp.MIDPKeyboardHandler;
import com.sun.kvem.midp.PopupChoiceGroupManager;
import com.sun.kvem.midp.TextManager;
import java.awt.event.InputEvent;

public class EventBridge
implements DeviceEventListener {
    static final int UI_EVENT_INVALID = -2;
    static final int UI_EVENT_STOP = -1;
    static final int UI_EVENT_KEYDOWN = 0;
    static final int UI_EVENT_KEYUP = 1;
    static final int UI_EVENT_KEYREPEAT = 2;
    static final int UI_EVENT_PENDOWN = 3;
    static final int UI_EVENT_PENUP = 4;
    static final int UI_EVENT_PENMOVE = 5;
    static final int UI_EVENT_TIMER = 6;
    static final int UI_EVENT_COMMAND = 7;
    static final int UI_EVENT_REPAINT = 8;
    static final int UI_EVENT_KEYTYPED = 9;
    static final int UI_EVENT_MMEOM = 10;
    static final int UI_EVENT_SYSTEM = 11;
    static final int EVENT_SIZE = 4;
    static final int DEFOULT_EVENT_BUFFER_SIZE = 8;
    static final int SUSPEND_ALL = 1;
    static final int RESUME_ALL = 2;
    static final int SHUTDOWN = 3;
    static final int SUSPEND_CURRENT = 4;
    static final int RESUME_PREVIOUS = 5;
    static final int KILL_CURRENT = 6;
    public static final int PROFILING_EVENT_RUN_GC = -1000;
    public static final int PROFILING_EVENT_STOP_MONITOR_MEMORY = -1001;
    private static final Debug debug = Debug.create((Class)EventBridge.class);
    private static EventBridge instance = new EventBridge();
    private static int[] events = new int[32];
    public static final int TEXT_CONSTRAINTS_ANY = 0;
    public static final int TEXT_CONSTRAINTS_EMAILADDR = 1;
    public static final int TEXT_CONSTRAINTS_NUMERIC = 2;
    public static final int TEXT_CONSTRAINTS_PHONENUMBER = 3;
    public static final int TEXT_CONSTRAINTS_URL = 4;
    public static final int TEXT_CONSTRAINTS_PASSWORD = 65536;

    private EventBridge() {
    }

    public static void initialize() {
        DeviceEventManager.getInstance().addListener(instance);
    }

    public static EventBridge getInstance() {
        return instance;
    }

    public void keyPressed(int n, InputEvent inputEvent) {
        debug.println(2, "Key {0} pressed", n);
        if (PopupChoiceGroupManager.getPopupHandler().keyPressed(n, inputEvent)) {
            return;
        }
        if (TextManager.getInstance().keyPressed(n, inputEvent)) {
            return;
        }
        if (CommandManager.getInstance().keyPressed(n, inputEvent)) {
            return;
        }
        KeyboardManager.getInstance().keyPressed(n, inputEvent);
    }

    public void keyReleased(int n, InputEvent inputEvent) {
        debug.println(2, "Key {0} released", n);
        if (PopupChoiceGroupManager.getPopupHandler().keyReleased(n, inputEvent)) {
            return;
        }
        if (TextManager.getInstance().keyReleased(n, inputEvent)) {
            return;
        }
        if (CommandManager.getInstance().keyReleased(n, inputEvent)) {
            return;
        }
        KeyboardManager.getInstance().keyReleased(n, inputEvent);
    }

    public void keyTyped(char c, InputEvent inputEvent) {
        debug.println(2, "Key {0} typed", (int)c);
        if (PopupChoiceGroupManager.getPopupHandler().keyTyped(c, inputEvent)) {
            return;
        }
        if (CommandManager.getInstance().keyTyped(c, inputEvent)) {
            return;
        }
        if (TextManager.getInstance().keyTyped(c, inputEvent)) {
            return;
        }
        KeyboardManager.getInstance().keyTyped(c, inputEvent);
    }

    public void penDown(int n, int n2) {
        debug.println(2, "Mouse click at ({0},{1})", n, n2);
        int[] nArray = new int[]{3, 0, n, n2};
        DeviceEventManager.getInstance().queueEvent(nArray);
    }

    public void penUp(int n, int n2) {
        debug.println(2, "Mouse release at ({0},{1})", n, n2);
        int[] nArray = new int[]{4, 0, n, n2};
        DeviceEventManager.getInstance().queueEvent(nArray);
    }

    public void penMove(int n, int n2) {
        debug.println(2, "Mouse move at ({0},{1})", n, n2);
        int[] nArray = new int[]{5, 0, n, n2};
        DeviceEventManager.getInstance().queueEvent(nArray);
    }

    public static int[] getEvent(boolean bl, long l) {
        if (debug.level(5)) {
            debug.println(5, "Get Event: forever = {0}, waitFor = {1}", (Object)String.valueOf(bl), (Object)String.valueOf(l));
        }
        long l2 = System.currentTimeMillis();
        long l3 = l2 + l;
        if (bl) {
            l3 = 0L;
        } else if (l < 0L) {
            l3 = l2;
        }
        int[] nArray = (int[])DeviceEventManager.getInstance().dequeueEvent(l3);
        return nArray;
    }

    public static synchronized int[] getEvents(int n, boolean bl, long l) {
        if (events.length < (n *= 4)) {
            events = new int[n];
        }
        int[] nArray = null;
        int n2 = 0;
        if (n <= 0) {
            return null;
        }
        if (debug.level(5)) {
            debug.println(5, "Get Event: forever = {0}, waitFor = {1}", (Object)String.valueOf(bl), (Object)String.valueOf(l));
        }
        long l2 = System.currentTimeMillis();
        long l3 = l2 + l;
        if (bl) {
            l3 = 0L;
        } else if (l < 0L) {
            l3 = l2;
        }
        int[] nArray2 = null;
        do {
            if ((nArray2 = (int[])DeviceEventManager.getInstance().dequeueEvent(l3)) == null) continue;
            EventBridge.events[n2] = nArray2[0];
            EventBridge.events[n2 + 1] = nArray2[1];
            EventBridge.events[n2 + 2] = nArray2[2];
            EventBridge.events[n2 + 3] = nArray2[3];
            l3 = l2;
            n2 += 4;
        } while (nArray2 != null && n2 < n);
        if (n2 > 0) {
            nArray = new int[n2];
            System.arraycopy(events, 0, nArray, 0, n2);
        }
        return nArray;
    }

    private static MIDPKeyboardHandler getKeyboardHandler() {
        return (MIDPKeyboardHandler)KeyboardManager.getInstance().getKeyboardHandler();
    }

    public static int getKeyCodeForGameAction(int n) {
        debug.println(3, "getKeyCodeForGameAction {0}", n);
        MIDPKeyboardHandler mIDPKeyboardHandler = EventBridge.getKeyboardHandler();
        try {
            int n2 = mIDPKeyboardHandler.getKeyCodeForGameAction(n);
            return mIDPKeyboardHandler.getMIDPCodeForHandlerCode(n2);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return 0;
        }
    }

    private static boolean isStandardMIDPKey(int n) {
        return Character.isDigit((char)n) || n == 42 || n == 35;
    }

    public static int getGameActionForKeyCode(int n) {
        debug.println(3, "getGameActionForKeyCode {0}", n);
        MIDPKeyboardHandler mIDPKeyboardHandler = EventBridge.getKeyboardHandler();
        try {
            int n2 = mIDPKeyboardHandler.getHandlerCodeForMIDPCode(n);
            return mIDPKeyboardHandler.getGameActionForKeyCode(n2);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            if (EventBridge.isStandardMIDPKey(n)) {
                return 0;
            }
            return -1;
        }
    }

    public static int getSystemKeyForKeyCode(int n) {
        debug.println(3, "getSystemKeyForKeyCode {0}", n);
        MIDPKeyboardHandler mIDPKeyboardHandler = EventBridge.getKeyboardHandler();
        try {
            int n2 = mIDPKeyboardHandler.getHandlerCodeForMIDPCode(n);
            return mIDPKeyboardHandler.getSystemKeyForKeyCode(n2);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            if (EventBridge.isStandardMIDPKey(n)) {
                return 0;
            }
            return -1;
        }
    }

    public static String getKeyNameForKeyCode(int n) {
        debug.println(3, "getKeyNameForKeyCode {0}", n);
        MIDPKeyboardHandler mIDPKeyboardHandler = EventBridge.getKeyboardHandler();
        try {
            int n2 = mIDPKeyboardHandler.getHandlerCodeForMIDPCode(n);
            return mIDPKeyboardHandler.getKeyName(n2);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return null;
        }
    }

    public static void setConstraints(int n) {
    }

    public static void startTextInput() {
    }

    public static void endTextInput() {
    }

    public static int[] getSpeedParams() {
        int n;
        int[] nArray = new int[]{0, 0, 0, 0};
        if (Device.getBooleanProperty("vmspeed.enableEmulation", false)) {
            n = Device.getIntegerProperty("vmspeed.bytecodespermilli", 0);
            nArray[1] = 50;
            nArray[0] = n * nArray[1];
            debug.println(1, "Setting VM speed to be {0}/{1} (bytecode/milli", nArray[0], nArray[1]);
        }
        if (Device.getBooleanProperty("netspeed.enableSpeedEmulation", false)) {
            String string = Device.getProperty("netspeed.bitpersecond");
            for (n = 0; n < Device.netSpeedList.length; ++n) {
                if (!Device.netSpeedList[n].equals(string)) continue;
                nArray[2] = n;
                break;
            }
            if (n == Device.netSpeedList.length) {
                nArray[2] = -1;
                Debug.warning((String)("Unknown netwotk speed value: " + string + ", disabling network speed emulation."));
            }
        } else {
            nArray[2] = -1;
        }
        if (Device.getBooleanProperty("rmsspeed.enableEmulation", false)) {
            nArray[3] = Device.getIntegerProperty("rmsspeed.bytecodespermilli", 0);
        }
        return nArray;
    }

    public static boolean isNetworkMonitorActive() {
        return Device.getBooleanProperty("kvem.netmon.enable", false);
    }

    public static void injectEvent(int n, int n2, int n3, int n4) {
        if (debug.level(2)) {
            debug.println(2, "Sending event  {0}, {1}", n, n2);
            debug.println(2, "               {0}, {1}", n3, n4);
        }
        int[] nArray = new int[]{n, n2, n3, n4};
        DeviceEventManager.getInstance().queueEvent(nArray);
    }

    public static String getExternalEventData(String string) {
        ExternalEventGeneratorWin externalEventGeneratorWin = ExternalEventGeneratorWin.getWindow();
        return externalEventGeneratorWin.getEventData(string);
    }
}

