/*
 * Decompiled with CFR 0.152.
 */
package com.sun.kvem.midp;

import com.sun.kvem.Device;
import com.sun.kvem.KeyboardManager;
import com.sun.kvem.environment.Debug;
import com.sun.kvem.midp.EventBridge;
import com.sun.kvem.midp.GraphicsBridge;
import com.sun.kvem.midp.MIDPKeyboardHandler;
import com.sun.kvem.midp.MenuKeys;
import com.sun.kvem.midp.PopupChoiceGroup;
import java.awt.event.InputEvent;
import java.util.List;

public class DefaultPopupChoiceGroup
implements PopupChoiceGroup {
    private static final Debug debug = Debug.create((Class)DefaultPopupChoiceGroup.class);
    private static final String POPUP_CANCEL_DEFAULT = "Cancel";
    private static final String CANCEL_LABEL = Device.getProperty("popup.text.cancel", "Cancel");
    private boolean inPopup = false;
    private List strings;
    private List images;
    private int popupLength;
    private int currentSelection;
    private int origSelection;
    private int screenHeight;
    private int screenWidth;
    private int menuWidth;
    private int menuHeight;
    private int xPos;
    private int yPos;
    private int scrollPosition;
    private int scrollY;
    private int itemSpace;
    private int visibleHeight;
    private int visibleCount;
    private int topYOffset;
    private int bottomYOffset;
    private boolean SCROLL_ENABLED = false;
    private boolean SCROLL_UP = false;
    private boolean SCROLL_DOWN = false;
    private static int blackPixel = 0;
    private static int whitePixel = 0xFFFFFF;
    private static int IMG_MAX_W = 12;
    private static int IMG_MAX_H = 12;
    private static int MENU_PAD = 2;
    private static int ARROW_WIDTH = 11;
    private static int itemHeight;
    private static MenuKeys menuKeys;
    private static int midpSelectCode;

    public void showPopupChoiceGroup(List list, List list2, int n, int n2, int n3, int n4, int n5, int n6, boolean bl, boolean bl2) {
        debug.println(3, "The maxItemWidth is: {0}", n6);
        this.strings = list;
        this.images = list2;
        this.xPos = n2;
        this.yPos = n3;
        this.origSelection = this.currentSelection = n;
        this.popupLength = list.size();
        this.screenWidth = n4;
        this.screenHeight = n5;
        int n7 = this.screenWidth * 4 / 5;
        this.menuWidth = n6 + 2 * MENU_PAD + ARROW_WIDTH;
        this.menuWidth = this.menuWidth <= n7 ? this.menuWidth : n7;
        GraphicsBridge.grabFullScreen(false);
        this.inPopup = true;
        this.itemSpace = this.popupLength * itemHeight;
        this.menuHeight = this.screenHeight - 3 * MENU_PAD;
        if (this.itemSpace < this.menuHeight) {
            this.menuHeight = this.itemSpace;
            this.visibleHeight = this.itemSpace;
            GraphicsBridge.setVerticalScroll(0, 100);
        } else {
            this.visibleCount = this.menuHeight / itemHeight - 1;
            this.menuHeight = (this.visibleCount + 1) * itemHeight;
            this.visibleHeight = this.menuHeight - itemHeight;
            this.scrollPosition = this.currentSelection + 1 - this.visibleCount;
            if (this.scrollPosition > 0) {
                this.scrollY = this.scrollPosition * itemHeight;
            } else {
                this.scrollY = 0;
                this.scrollPosition = 0;
            }
        }
        this.topYOffset = bl && !bl2 || !bl && bl2 ? 17 : (bl && bl2 ? 34 : 0);
        this.bottomYOffset = this.topYOffset + this.screenHeight;
        if (this.yPos + 2 * MENU_PAD + this.menuHeight >= this.bottomYOffset) {
            this.yPos -= this.yPos + this.menuHeight + 3 * MENU_PAD - this.bottomYOffset;
        }
        if (this.xPos + 2 * MENU_PAD + this.menuWidth > this.screenWidth) {
            this.xPos -= this.xPos + this.menuWidth + 3 * MENU_PAD - this.screenWidth;
        }
        GraphicsBridge.setSoftButtonLabel(0, CANCEL_LABEL);
        GraphicsBridge.setSoftButtonLabel(1, null);
        this.paintPopupMenu();
    }

    public int getPopupSelectionIndex() {
        return this.currentSelection;
    }

    public boolean keyPressed(int n, InputEvent inputEvent) {
        if (!this.inPopup) {
            return false;
        }
        if (n == DefaultPopupChoiceGroup.menuKeys.select) {
            this.hidePopup();
        } else {
            if (n == DefaultPopupChoiceGroup.menuKeys.up) {
                if (this.currentSelection > 0 || this.scrollY > 0) {
                    if (this.currentSelection > 0) {
                        --this.currentSelection;
                        if (this.currentSelection >= this.scrollPosition) {
                            this.paintPopupMenu();
                        } else {
                            --this.scrollPosition;
                            this.scrollY -= itemHeight;
                            this.paintPopupMenu();
                        }
                    } else {
                        this.scrollY = 0;
                        this.paintPopupMenu();
                    }
                }
                return true;
            }
            if (n == DefaultPopupChoiceGroup.menuKeys.down) {
                if (this.currentSelection < this.popupLength - 1 || this.scrollY + this.yPos < this.itemSpace) {
                    if (this.currentSelection < this.popupLength - 1) {
                        ++this.currentSelection;
                        int n2 = (this.currentSelection - this.scrollPosition + 1) * itemHeight;
                        if (n2 <= this.visibleHeight) {
                            this.paintPopupMenu();
                        } else {
                            ++this.scrollPosition;
                            this.scrollY += itemHeight;
                            this.paintPopupMenu();
                        }
                    } else {
                        this.paintPopupMenu();
                    }
                }
                return true;
            }
            if (n == DefaultPopupChoiceGroup.menuKeys.right || n == DefaultPopupChoiceGroup.menuKeys.left || MenuKeys.isSoftButton(n)) {
                this.currentSelection = this.origSelection;
                this.hidePopup();
                EventBridge.injectEvent(0, midpSelectCode, 0, 0);
                return true;
            }
        }
        return false;
    }

    public boolean keyReleased(int n, InputEvent inputEvent) {
        if (n == DefaultPopupChoiceGroup.menuKeys.end) {
            this.currentSelection = this.origSelection;
            this.hidePopup();
        }
        return false;
    }

    public boolean keyTyped(char c, InputEvent inputEvent) {
        return false;
    }

    private void paintPopupMenu() {
        int n = this.xPos;
        int n2 = this.yPos;
        short[] sArray = new short[4];
        boolean bl = false;
        sArray[0] = (short)this.xPos;
        sArray[1] = (short)this.yPos;
        sArray[2] = (short)(this.menuWidth + 2 * MENU_PAD);
        sArray[3] = (short)(this.menuHeight + 2 * MENU_PAD);
        GraphicsBridge.drawRect(whitePixel, 0, sArray, 0, this.xPos, this.yPos, this.menuWidth + 2 * MENU_PAD, this.menuHeight + 2 * MENU_PAD, true, 0, 0);
        GraphicsBridge.drawLine(blackPixel, 0, sArray, 0, this.xPos, this.yPos, this.xPos + this.menuWidth + 2 * MENU_PAD, this.yPos);
        GraphicsBridge.drawLine(blackPixel, 0, sArray, 0, this.xPos, this.yPos + this.menuHeight + 2 * MENU_PAD - 1, this.xPos + this.menuWidth + 2 * MENU_PAD, this.yPos + this.menuHeight + 2 * MENU_PAD - 1);
        GraphicsBridge.drawLine(blackPixel, 0, sArray, 0, this.xPos, this.yPos, this.xPos, this.yPos + this.menuHeight + 2 * MENU_PAD);
        GraphicsBridge.drawLine(blackPixel, 0, sArray, 0, this.xPos + this.menuWidth + 2 * MENU_PAD - 1, this.yPos, this.xPos + this.menuWidth + 2 * MENU_PAD - 1, this.yPos + this.menuHeight + 2 * MENU_PAD);
        sArray[0] = (short)(n += MENU_PAD);
        sArray[1] = (short)(n2 += MENU_PAD);
        sArray[2] = (short)this.menuWidth;
        sArray[3] = (short)this.menuHeight;
        if (this.itemSpace > this.visibleHeight) {
            this.setVerticalScroll(this.scrollY * 100 / (this.itemSpace - this.visibleHeight), this.visibleHeight * 100 / this.itemSpace);
        }
        if (this.SCROLL_ENABLED) {
            this.drawUpArrow(n += this.menuWidth - 10, n2, this.SCROLL_UP);
            n2 += itemHeight / 2;
            n -= this.menuWidth - 10;
        }
        int n3 = this.scrollPosition;
        while (n2 - this.yPos < this.visibleHeight && n3 < this.popupLength) {
            PopupChoiceGroup.ImageInfo imageInfo = (PopupChoiceGroup.ImageInfo)this.images.get(n3);
            if (imageInfo != null) {
                int n4 = imageInfo.width;
                int n5 = imageInfo.height;
                GraphicsBridge.drawRegion(0, 0, sArray, 0, imageInfo.imageID, 0, 0, n4 <= IMG_MAX_W ? n4 : IMG_MAX_W, n5 <= IMG_MAX_H ? n5 : IMG_MAX_H, 0, n, n2, 0);
                n += IMG_MAX_W;
                bl = true;
            }
            if (n3 == this.currentSelection) {
                GraphicsBridge.drawRect(blackPixel, 0, sArray, 0, n, n2, this.menuWidth, itemHeight, true, 0, 0);
                GraphicsBridge.drawChars(whitePixel, 0, sArray, 0, 0, 0, 0, n += 2, n2, 20, ((String)this.strings.get(n3)).toCharArray());
                n -= 2;
            } else {
                GraphicsBridge.drawChars(blackPixel, 0, sArray, 0, 0, 0, 0, n += 2, n2, 20, ((String)this.strings.get(n3)).toCharArray());
                n -= 2;
            }
            if (bl) {
                bl = false;
                n -= IMG_MAX_W;
            }
            ++n3;
            n2 += itemHeight;
        }
        if (this.SCROLL_ENABLED) {
            this.drawDownArrow(n += this.menuWidth - 10, n2, this.SCROLL_DOWN);
            n2 += itemHeight / 2;
            n -= this.menuWidth - 10;
        }
        GraphicsBridge.refresh(this.xPos, this.yPos, this.xPos + this.menuWidth + 2 * MENU_PAD, this.yPos + this.menuHeight + 2 * MENU_PAD);
    }

    private void hidePopup() {
        this.inPopup = false;
    }

    private void setVerticalScroll(int n, int n2) {
        debug.println(3, "Set scroll: y={0}, {1}%", n, n2);
        this.SCROLL_ENABLED = true;
        if (n2 >= 100 || n2 == 0) {
            this.SCROLL_ENABLED = false;
            return;
        }
        if (n > 0 && n < 100) {
            this.SCROLL_UP = true;
            this.SCROLL_DOWN = true;
        } else if (n == 0) {
            this.SCROLL_UP = false;
            this.SCROLL_DOWN = true;
        } else {
            this.SCROLL_UP = true;
            this.SCROLL_DOWN = false;
        }
    }

    public void drawDownArrow(int n, int n2, boolean bl) {
        short[] sArray = new short[]{(short)n, (short)n2, 8, 8};
        GraphicsBridge.drawRect(whitePixel, 0, sArray, 0, n, n2, 8, 8, true, 0, 0);
        if (bl) {
            GraphicsBridge.drawRect(blackPixel, 0, sArray, 0, n + 2, n2 + 1, 3, 2, true, 0, 0);
            GraphicsBridge.fillTriangle(blackPixel, 0, sArray, 0, n, n2 + 3, n + 3, n2 + 7, n + 7, n2 + 3);
        }
    }

    public void drawUpArrow(int n, int n2, boolean bl) {
        short[] sArray = new short[]{(short)n, (short)n2, 8, 8};
        GraphicsBridge.drawRect(whitePixel, 0, sArray, 0, n, n2, 8, 8, true, 0, 0);
        if (bl) {
            GraphicsBridge.fillTriangle(blackPixel, 0, sArray, 0, n - 1, n2 + 4, n + 3, n2 - 1, n + 7, n2 + 4);
            GraphicsBridge.drawRect(blackPixel, 0, sArray, 0, n + 2, n2 + 4, 3, 2, true, 0, 0);
        }
    }

    static {
        int[] nArray = GraphicsBridge.getFontInfo(0, 0, 0);
        itemHeight = nArray[0] + nArray[1] + nArray[2];
        itemHeight = itemHeight > IMG_MAX_H + MENU_PAD ? itemHeight : IMG_MAX_H + MENU_PAD;
        menuKeys = new MenuKeys();
        midpSelectCode = ((MIDPKeyboardHandler)KeyboardManager.getInstance().getKeyboardHandler()).getMIDPCodeForHandlerCode(DefaultPopupChoiceGroup.menuKeys.select);
    }
}

