/*
 * Decompiled with CFR 0.152.
 */
package com.sun.kvem.midp;

import com.sun.kvem.DeviceEventManager;
import com.sun.kvem.environment.Debug;
import com.sun.kvem.midp.MIDP;
import com.sun.kvem.midp.MIDPKeyboardHandler;
import java.awt.event.InputEvent;

public class DefaultKeyboardHandler
implements MIDPKeyboardHandler {
    private static final Debug debug = Debug.create((Class)DefaultKeyboardHandler.class);
    private static Key[] keys = new Key[]{new Key("0", 48), new Key("1", 49), new Key("2", 50), new Key("3", 51), new Key("4", 52), new Key("5", 53), new Key("6", 54), new Key("7", 55), new Key("8", 56), new Key("9", 57), new Key("POUND", 35), new Key("ASTERISK", 42), new Key("SEND", -10), new Key("END", -11), new Key("UP", -1), new Key("DOWN", -2), new Key("DOWN", -2), new Key("LEFT", -3), new Key("RIGHT", -4), new Key("SELECT", -5), new Key("POWER", -12), new Key("SOFT1", -6), new Key("SOFT2", -7), new Key("SOFT3", -20), new Key("SOFT4", -21), new Key("CLEAR", -8), new Key("USER1", -32), new Key("USER2", -33), new Key("USER3", -34), new Key("USER4", -35), new Key("USER5", -36), new Key("USER6", -37), new Key("USER7", -38), new Key("USER8", -39), new Key("USER9", -40), new Key("USER10", -41), new Key("SUSPEND", -42), new Key("RESUME", -43)};

    public String getInputMethodHandlerClassName() {
        return "com.sun.midp.lcdui.DefaultInputMethodHandler";
    }

    public int getHandlerCodeForMIDPCode(int n) throws IllegalArgumentException {
        for (int i = 0; i < keys.length; ++i) {
            if (DefaultKeyboardHandler.keys[i].keyCode != n) continue;
            debug.println(3, "MIDP key code {0} maps to emulator code {1}", n, i);
            return i;
        }
        debug.println(1, "No emulator code for MIDP key code {0}", n);
        throw new IllegalArgumentException("MIDP key code " + n + " is not valid");
    }

    public int getMIDPCodeForHandlerCode(int n) throws IllegalArgumentException {
        try {
            int n2 = DefaultKeyboardHandler.keys[n].keyCode;
            debug.println(3, "Emulator key code {0} maps to MIDP code {1}", n, n2);
            return n2;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            debug.println(1, "No MIDP key code for emulator code {0}", n);
            throw new IllegalArgumentException("Handler key code " + n + " is not valid");
        }
    }

    public int getKeyCodeForGameAction(int n) {
        int n2;
        switch (n) {
            case 1: {
                n2 = -1;
                break;
            }
            case 6: {
                n2 = -2;
                break;
            }
            case 2: {
                n2 = -3;
                break;
            }
            case 5: {
                n2 = -4;
                break;
            }
            case 8: {
                n2 = -5;
                break;
            }
            case 9: {
                n2 = 49;
                break;
            }
            case 10: {
                n2 = 51;
                break;
            }
            case 11: {
                n2 = 55;
                break;
            }
            case 12: {
                n2 = 57;
                break;
            }
            default: {
                debug.println(3, "No key for game action {0}", n);
                throw new IllegalArgumentException("No key for game action " + n);
            }
        }
        n2 = this.getHandlerCodeForMIDPCode(n2);
        debug.println(3, "Game action {0} maps to key code {1}", n, n2);
        return n2;
    }

    public int getGameActionForKeyCode(int n) {
        int n2;
        switch (this.getMIDPCodeForHandlerCode(n)) {
            case -1: 
            case 50: {
                n2 = 1;
                break;
            }
            case -2: 
            case 56: {
                n2 = 6;
                break;
            }
            case -3: 
            case 52: {
                n2 = 2;
                break;
            }
            case -4: 
            case 54: {
                n2 = 5;
                break;
            }
            case -5: 
            case 53: {
                n2 = 8;
                break;
            }
            case 49: {
                n2 = 9;
                break;
            }
            case 51: {
                n2 = 10;
                break;
            }
            case 55: {
                n2 = 11;
                break;
            }
            case 57: {
                n2 = 12;
                break;
            }
            default: {
                n2 = 0;
            }
        }
        debug.println(3, "Key code {0} maps to game action {1}", n, n2);
        return n2;
    }

    public int getSystemKeyForKeyCode(int n) {
        int n2;
        switch (this.getMIDPCodeForHandlerCode(n)) {
            case -12: {
                n2 = 1;
                break;
            }
            case -10: {
                n2 = 2;
                break;
            }
            case -11: {
                n2 = 3;
                break;
            }
            case -8: {
                n2 = 4;
                break;
            }
            default: {
                n2 = 0;
            }
        }
        debug.println(3, "Key code {0} maps to system key {1}", n, n2);
        return n2;
    }

    public boolean keyPressed(int n, InputEvent inputEvent) {
        Key key = keys[n];
        debug.println(3, "{0} pressed", (Object)key);
        int n2 = key.keyCode;
        if (this.getKeyName(n).equals("POWER")) {
            debug.println(3, "Sending power-off event");
            int[] nArray = new int[]{11, 3, 0, 0};
            DeviceEventManager.getInstance().queueEvent(nArray);
        } else if (this.getKeyName(n).equals("SUSPEND")) {
            debug.println(3, "Sending suspend event");
            MIDP.injectPauseEvent(1);
        } else if (this.getKeyName(n).equals("RESUME")) {
            debug.println(3, "Sending resume event");
            MIDP.injectPauseEvent(2);
        } else {
            debug.println(3, "Sending key-down event for {0}", (Object)key);
            int[] nArray = new int[]{0, n2, 0, 0};
            DeviceEventManager.getInstance().queueEvent(nArray);
        }
        return true;
    }

    public boolean keyReleased(int n, InputEvent inputEvent) {
        Key key = keys[n];
        debug.println(3, "{0} released", (Object)key);
        debug.println(3, "Sending key-up event for {0}", (Object)key);
        int n2 = key.keyCode;
        int[] nArray = new int[]{1, n2, 0, 0};
        DeviceEventManager.getInstance().queueEvent(nArray);
        return true;
    }

    public boolean keyTyped(char c, InputEvent inputEvent) {
        return false;
    }

    public String[] getKeyNames() {
        String[] stringArray = new String[keys.length];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = DefaultKeyboardHandler.keys[i].name;
        }
        return stringArray;
    }

    public int getKeyCode(String string) {
        string = string.intern();
        for (int i = 0; i < keys.length; ++i) {
            Key key = keys[i];
            if (key.name != string) continue;
            debug.println(3, "Key name {0} maps to {1}", (Object)string, (Object)key);
            return i;
        }
        return -1;
    }

    public String getKeyName(int n) {
        Key key = keys[n];
        debug.println(3, "Key code {0} maps to {1}", n, (Object)key);
        return key.name;
    }

    private static class Key {
        final String name;
        final int keyCode;

        Key(String string, int n) {
            this.name = string;
            this.keyCode = n;
        }

        public String toString() {
            String string = "Key[\"" + this.name + "\",code=" + this.keyCode;
            if (this.keyCode > 32 && this.keyCode != 127) {
                string = string + " ('" + (char)this.keyCode + "')";
            }
            string = string + "]";
            return string;
        }
    }
}

