/*
 * Decompiled with CFR 0.152.
 */
package com.sun.kvem.midp;

import com.sun.kvem.Device;
import com.sun.kvem.KeyboardManager;
import com.sun.kvem.Screen;
import com.sun.kvem.environment.Debug;
import com.sun.kvem.midp.Command;
import com.sun.kvem.midp.CommandHandler;
import com.sun.kvem.midp.CommandManager;
import com.sun.kvem.midp.GraphicsBridge;
import com.sun.kvem.midp.MenuKeys;
import com.sun.kvem.util.ToolkitResources;
import java.awt.event.InputEvent;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;

public class DefaultCommandHandler
implements CommandHandler {
    private static final Debug debug = Debug.create((Class)DefaultCommandHandler.class);
    private static final String[] commandNames = new String[]{null, "SCREEN", "BACK", "CANCEL", "OK", "HELP", "STOP", "EXIT", "ITEM"};
    private static final String COMMAND_EXCLUSIVE_PREFIX = "command.exclusive.";
    private static final String MENU_LABEL = ToolkitResources.getString((String)"EMULATOR_MENU_LABEL");
    private final Command[] softButtonCommands = new Command[Screen.getInstance().getSoftButtonCount()];
    private int menuSoftButtonIndex;
    private Command[] menuCommands;
    private int[] menuCommandsLLWidth;
    private Map keyCommands = new HashMap();
    private Menu menu = new Menu();
    private MenuKeys menuKeys = new MenuKeys();
    private boolean fullScreenMode = false;
    private boolean lastScreenMode;
    boolean ignoreNextKeyTyped;
    private static Comparator commandComparator = new Comparator(){
        private int[] typePrecedences = new int[]{127, 102, 105, 107, 103, 104, 108, 106, 101};

        private int typePrecedence(Command command) {
            int n = command.isitem ? 100 : 0;
            try {
                return this.typePrecedences[command.type] - n;
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                return this.typePrecedences[0];
            }
        }

        public int compare(Object object, Object object2) {
            Command command = (Command)object;
            Command command2 = (Command)object2;
            if (command.type == command2.type) {
                return command.priority - command2.priority;
            }
            int n = this.typePrecedence(command);
            int n2 = this.typePrecedence(command2);
            return n - n2;
        }
    };

    public synchronized void grabFullScreen(boolean bl) {
        this.fullScreenMode = bl;
        if (debug.level(3)) {
            debug.println(3, "Change menu screen mode to {0}", (Object)bl);
        }
    }

    public synchronized void setCommands(Command[] commandArray) {
        int n;
        debug.println(2, "Set commands to: {0}", (Object)commandArray);
        for (n = 0; n < this.softButtonCommands.length; ++n) {
            this.softButtonCommands[n] = null;
        }
        this.menuSoftButtonIndex = -1;
        this.menuCommands = null;
        this.menuCommandsLLWidth = null;
        this.keyCommands.clear();
        Arrays.sort(commandArray, commandComparator);
        if (commandArray.length > 0) {
            int n2;
            int n3;
            int n4;
            int n5;
            class FullScreenAllocator
            extends CommandAllocator {
                private final /* synthetic */ Command[] val$commands;

                FullScreenAllocator(Command[] commandArray) {
                    this.val$commands = commandArray;
                    class CommandAllocator {
                        Set allocatedKeys = new HashSet();
                        boolean[] commandAllocated = new boolean[this.val$commands.length];
                        int unallocatedCommands = this.val$commands.length;
                        int unallocatedSoftButtons = DefaultCommandHandler.access$100(DefaultCommandHandler.this).length;
                        private final /* synthetic */ Command[] val$commands;

                        CommandAllocator(Command[] commandArray) {
                            this.val$commands = commandArray;
                        }

                        void allocateToKey(int n, int n2) {
                            boolean bl = MenuKeys.isSoftButton(n2);
                            if (bl) {
                                int n3 = MenuKeys.getSoftButtonIndexFromKeyCode(n2);
                                ((DefaultCommandHandler)DefaultCommandHandler.this).softButtonCommands[n3] = this.val$commands[n];
                                debug.println(3, "  {0} assigned to soft button {1}  (key " + n2 + ")", (Object)this.val$commands[n], n3 + 1);
                            } else {
                                debug.println(3, "  {0} assigned to key {1}", (Object)this.val$commands[n], n2);
                            }
                            Integer n4 = new Integer(n2);
                            this.reserveKey(n4);
                            DefaultCommandHandler.this.keyCommands.put(n4, this.val$commands[n]);
                            this.commandAllocated[n] = true;
                            --this.unallocatedCommands;
                        }

                        boolean isCommandAllocated(int n) {
                            return this.commandAllocated[n];
                        }

                        void reserveKey(Integer n) {
                            this.allocatedKeys.add(n);
                            if (MenuKeys.isSoftButton(n)) {
                                --this.unallocatedSoftButtons;
                            }
                        }

                        void reserveKey(int n) {
                            this.reserveKey(new Integer(n));
                        }

                        int findCommandKey(int n, int n2) {
                            return DefaultCommandHandler.this.getCommandKey(this.val$commands[n], this.allocatedKeys, n2);
                        }

                        int findMenuKey(String string, int n) {
                            return DefaultCommandHandler.this.menuKeys.getMenuKey(string, this.allocatedKeys, n);
                        }

                        int nextSoftButtonKeyCode(int n) {
                            for (int i = 0; i < DefaultCommandHandler.this.softButtonCommands.length; ++i) {
                                if (DefaultCommandHandler.this.softButtonCommands[i] != null) continue;
                                int n2 = MenuKeys.getSoftButtonKeyCodeFromIndex(i);
                                if (n != -1 && this.commandForbidenForKey(n, n2) || this.keyReserved(n2)) continue;
                                return n2;
                            }
                            return -1;
                        }

                        int freeSoftButtonCount() {
                            return this.unallocatedSoftButtons;
                        }

                        int unallocatedCommandCount() {
                            return this.unallocatedCommands;
                        }

                        boolean keyReserved(int n) {
                            Integer n2 = new Integer(n);
                            return this.allocatedKeys.contains(n2);
                        }

                        boolean commandForbidenForKey(int n, int n2) {
                            String string = this.val$commands[n].getTypeAsString();
                            int n3 = MenuKeys.getSoftButtonIndexFromKeyCode(n2);
                            String string2 = Device.getProperty("command.exclusive.SOFT" + (n3 + 1));
                            if (string2 == null) {
                                return false;
                            }
                            StringTokenizer stringTokenizer = new StringTokenizer(string2, " \t,;:");
                            while (stringTokenizer.hasMoreTokens()) {
                                String string3 = stringTokenizer.nextToken();
                                if (!string.equals(string3)) continue;
                                return false;
                            }
                            return true;
                        }
                    }
                    super(commandArray);
                }

                int freeSoftButtonCount() {
                    return 0;
                }
            }
            CommandAllocator commandAllocator = this.fullScreenMode ? new FullScreenAllocator(commandArray) : new CommandAllocator(commandArray);
            for (n5 = 0; n5 < commandArray.length; ++n5) {
                n4 = commandAllocator.findCommandKey(n5, -1);
                if (n4 == -1 || MenuKeys.isSoftButton(n4)) continue;
                commandAllocator.allocateToKey(n5, n4);
            }
            n5 = commandAllocator.findMenuKey("activate", -1);
            if (n5 == -1) {
                n5 = commandAllocator.nextSoftButtonKeyCode(-1);
            }
            if (MenuKeys.isSoftButton(n5)) {
                this.menuSoftButtonIndex = MenuKeys.getSoftButtonIndexFromKeyCode(n5);
                debug.println(3, "Reserving soft button {0} (key {1}) for the menu", this.menuSoftButtonIndex + 1, n5);
            } else {
                debug.println(3, "Using key {0} for the menu", n5);
            }
            commandAllocator.reserveKey(n5);
            this.menuKeys.activate = n5;
            for (n4 = 0; n4 < commandArray.length && commandAllocator.freeSoftButtonCount() > 0; ++n4) {
                if (commandAllocator.isCommandAllocated(n4) || (n3 = commandAllocator.nextSoftButtonKeyCode(n4)) == -1) continue;
                n2 = commandAllocator.findCommandKey(n4, n3);
                commandAllocator.allocateToKey(n4, n2);
            }
            n4 = commandAllocator.unallocatedCommandCount();
            if (n4 > 1) {
                this.menuCommands = new Command[n4];
                this.menuCommandsLLWidth = new int[n4];
                n2 = 0;
                for (n3 = 0; n3 < commandArray.length; ++n3) {
                    if (commandAllocator.isCommandAllocated(n3)) continue;
                    this.menuCommands[n2] = commandArray[n3];
                    this.menuCommandsLLWidth[n2] = commandArray[n3].longLabel != null ? GraphicsBridge.getCharsWidth(0, 0, 0, commandArray[n3].longLabel.toCharArray()) : Integer.MAX_VALUE;
                    ++n2;
                }
            } else if (commandAllocator.unallocatedCommandCount() == 1) {
                for (n3 = 0; n3 < commandArray.length; ++n3) {
                    if (commandAllocator.isCommandAllocated(n3)) continue;
                    commandAllocator.allocateToKey(n3, n5);
                }
                this.menuSoftButtonIndex = -1;
            } else {
                this.menuSoftButtonIndex = -1;
            }
        }
        if (!this.fullScreenMode) {
            for (n = 0; n < this.softButtonCommands.length; ++n) {
                String string;
                Command command = this.softButtonCommands[n];
                String string2 = null;
                if (n == this.menuSoftButtonIndex) {
                    string = MENU_LABEL;
                } else if (command == null) {
                    string = "";
                } else {
                    string = command.label;
                    string2 = command.longLabel;
                }
                Screen.getInstance().setSoftButtonLabel(n, string, string2);
            }
        }
    }

    private int getCommandKey(Command command, Set set, int n) {
        String string;
        if (command.type >= 0 && command.type < commandNames.length && (string = command.getTypeAsString()) != null) {
            return this.menuKeys.getPreferredKey(string, set, n);
        }
        return n;
    }

    private Command commandForKey(int n) {
        Integer n2 = new Integer(n);
        Command command = (Command)this.keyCommands.get(n2);
        return command;
    }

    public synchronized boolean keyPressed(int n, InputEvent inputEvent) {
        boolean bl;
        debug.println(3, "Key pressed: {0}", n);
        debug.println(3, "Menu commands are: {0}", (Object)this.menuCommands);
        if (this.menuCommands != null && (n == this.menuKeys.activate || this.fullScreenMode && MenuKeys.isSoftButton(n))) {
            this.menuKeyPressed();
            bl = true;
        } else if (this.menu.isVisible() && this.keyPressedInMenu(n)) {
            bl = true;
        } else {
            Command command = this.commandForKey(n);
            if (command != null) {
                this.menu.setVisible(false);
                command.sendEvent();
                bl = true;
            } else {
                bl = false;
            }
        }
        return bl;
    }

    public synchronized boolean keyReleased(int n, InputEvent inputEvent) {
        debug.println(3, "Key released: {0}", n);
        if (this.menu.isVisible() && n == this.menuKeys.end) {
            this.menu.setVisible(false);
            CommandManager.getInstance().signalDismiss();
            return false;
        }
        return this.menu.ignoreKeyRelease(n);
    }

    public synchronized boolean keyTyped(char c, InputEvent inputEvent) {
        if (this.menu.isVisible()) {
            return true;
        }
        boolean bl = this.ignoreNextKeyTyped;
        this.ignoreNextKeyTyped = false;
        return bl;
    }

    public synchronized boolean isUsingScreen() {
        if (this.menu.isVisible()) {
            if (this.menuCommands == null) {
                this.menu.setVisible(false);
                return false;
            }
            debug.println(3, "Menu is using the screen");
            return true;
        }
        return false;
    }

    private boolean keyPressedInMenu(int n) {
        debug.println(3, "Key pressed in menu: {0}", n);
        if (n == this.menuKeys.up) {
            this.menu.up();
            return true;
        }
        if (n == this.menuKeys.down) {
            this.menu.down();
            return true;
        }
        if (n == this.menuKeys.select) {
            this.menu.setVisible(false);
            this.menu.setIgnoreKeyRelease(n);
            this.menu.getCommand().sendEvent();
            return true;
        }
        String string = KeyboardManager.getInstance().getKeyboardHandler().getKeyName(n);
        try {
            int n2;
            int n3 = Integer.parseInt(string);
            int n4 = n2 = n3 == 0 ? 9 : n3 - 1;
            if (n2 < this.menuCommands.length) {
                debug.println(3, "Selected command #{0} from the menu", n2);
                this.ignoreNextKeyTyped = true;
                this.menu.setVisible(false);
                this.menu.setIgnoreKeyRelease(n);
                this.menuCommands[n2].sendEvent();
                return true;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        debug.println(3, "Key press not used by the command menu");
        return false;
    }

    private void menuKeyPressed() {
        debug.println(3, "Menu activation key pressed");
        if (this.menuCommands != null) {
            if (this.menu.isVisible()) {
                this.menu.setVisible(false);
                this.menu.setIgnoreKeyRelease(this.menuKeys.activate);
                CommandManager.getInstance().signalDismiss();
            } else {
                CommandManager.getInstance().signalInvoke();
            }
        }
    }

    public synchronized void showMenu() {
        if (!this.menu.isVisible() && this.menuCommands != null) {
            debug.println(3, "Showing the menu");
            this.menu.setVisible(true);
            this.lastScreenMode = this.fullScreenMode;
            if (this.lastScreenMode) {
                GraphicsBridge.grabFullScreen(false);
            }
            this.menu.scrollPosition = 0;
            this.menu.menuCurrent = 0;
            this.menu.draw();
        }
    }

    public void hideMenu() {
        if (this.menu.isVisible()) {
            debug.println(3, "Hiding the menu");
            this.menu.setVisible(false);
            if (this.lastScreenMode) {
                GraphicsBridge.grabFullScreen(true);
            }
        }
    }

    private class Menu {
        private char[] MENU_SCREEN_TITLE = ToolkitResources.getString((String)"EMULATOR_MENU_TITLE").toCharArray();
        char[] digits = "1234567890".toCharArray();
        boolean visible;
        int scrollPosition;
        int menuCurrent;
        int menuWidth;
        int menuHeight;
        int lineHeight;
        int lineStart;
        int listSpace;
        boolean ignoreKeyRelease;
        int ignoredReleasedKey;

        private Menu() {
        }

        boolean ignoreKeyRelease(int n) {
            if (this.ignoreKeyRelease && n == this.ignoredReleasedKey) {
                this.ignoreKeyRelease = false;
                debug.println(3, "Ignoring key release {0}", n);
                return true;
            }
            return false;
        }

        void setIgnoreKeyRelease(int n) {
            this.ignoreKeyRelease = true;
            this.ignoredReleasedKey = n;
        }

        synchronized boolean isVisible() {
            return this.visible;
        }

        synchronized void setVisible(boolean bl) {
            debug.println(3, "menu.visible = {0}", (Object)String.valueOf(bl));
            this.visible = bl;
        }

        Command getCommand() {
            return DefaultCommandHandler.this.menuCommands[this.menuCurrent];
        }

        void down() {
            debug.println(3, "Move down in menu");
            this.calculateOffset();
            if (this.menuCurrent < DefaultCommandHandler.this.menuCommands.length - 1) {
                ++this.menuCurrent;
                if (this.menuCurrent >= this.scrollPosition + this.listSpace) {
                    ++this.scrollPosition;
                }
                this.draw();
            }
        }

        void up() {
            debug.println(3, "Move up in menu");
            this.calculateOffset();
            if (this.menuCurrent > 0) {
                --this.menuCurrent;
                if (this.menuCurrent < this.scrollPosition) {
                    --this.scrollPosition;
                }
                this.draw();
            }
        }

        private void calculateOffset() {
            if (this.lineHeight == 0) {
                this.lineHeight = GraphicsBridge.getAscent(0, 1, 0) + GraphicsBridge.getDescent(0, 1, 0) + GraphicsBridge.getLeading(0, 1, 0);
                this.lineStart = 8 + GraphicsBridge.getCharsWidth(0, 1, 0, new char[]{'1'});
                this.listSpace = (this.menuHeight - this.lineHeight - 3) / this.lineHeight;
            }
        }

        void draw() {
            short[] sArray = new short[4];
            this.menuWidth = GraphicsBridge.screenWidth < 150 ? GraphicsBridge.screenWidth : 150;
            this.menuHeight = GraphicsBridge.adornedHeight < 120 ? GraphicsBridge.adornedHeight : 120;
            sArray[0] = (short)(GraphicsBridge.screenWidth - this.menuWidth);
            sArray[1] = (short)(GraphicsBridge.adornedHeight - this.menuHeight);
            sArray[2] = (short)this.menuWidth;
            sArray[3] = (short)this.menuHeight;
            int n = sArray[1];
            int n2 = 20;
            int n3 = 17;
            this.calculateOffset();
            GraphicsBridge.drawLine(0x6A6A6A, 0, sArray, 0, sArray[0], sArray[1], sArray[0], GraphicsBridge.adornedHeight);
            GraphicsBridge.drawLine(0x6A6A6A, 0, sArray, 0, sArray[0], sArray[1], GraphicsBridge.screenWidth, sArray[1]);
            GraphicsBridge.drawLine(0xFFFFFF, 0, sArray, 0, sArray[0] + 1, sArray[1] + 1, sArray[0] + 1, GraphicsBridge.adornedHeight);
            GraphicsBridge.drawLine(0xFFFFFF, 0, sArray, 0, sArray[0] + 1, sArray[1] + 1, GraphicsBridge.screenWidth, sArray[1] + 1);
            GraphicsBridge.drawRect(0xDBDBFF, 0, sArray, 0, sArray[0] + 2, sArray[1] + 2, this.menuWidth, this.menuHeight, true, 0, 0);
            GraphicsBridge.drawChars(0, 0, sArray, 0, 0, 1, 0, sArray[0] + this.menuWidth / 2, sArray[1], n3, this.MENU_SCREEN_TITLE);
            GraphicsBridge.drawLine(0x6A6A6A, 0, sArray, 0, sArray[0] + 2, n += this.lineHeight, GraphicsBridge.screenWidth, n);
            GraphicsBridge.drawLine(0xFFFFFF, 0, sArray, 0, sArray[0] + 2, n + 1, GraphicsBridge.screenWidth, n + 1);
            n += 3;
            for (int i = this.scrollPosition; i < DefaultCommandHandler.this.menuCommands.length; ++i) {
                Command command = DefaultCommandHandler.this.menuCommands[i];
                String string = sArray[2] - this.lineStart + 2 > DefaultCommandHandler.this.menuCommandsLLWidth[i] ? command.longLabel : command.label;
                if (DefaultCommandHandler.this.menuCommands.length <= 10) {
                    GraphicsBridge.drawChars(0, 0, sArray, 0, 0, 1, 0, sArray[0] + 2, n, n2, new char[]{this.digits[i]});
                }
                if (i == this.menuCurrent) {
                    GraphicsBridge.drawRect(0, 0, sArray, 0, sArray[0] + this.lineStart, n, GraphicsBridge.screenWidth, this.lineHeight, true, 0, 0);
                    GraphicsBridge.drawChars(0xFFFFFF, 0, sArray, 0, 0, 1, 0, sArray[0] + this.lineStart + 2, n, n2, string.toCharArray());
                } else {
                    GraphicsBridge.drawChars(0, 0, sArray, 0, 0, 0, 0, sArray[0] + this.lineStart, n, n2, string.toCharArray());
                }
                n += this.lineHeight;
            }
            int n4 = DefaultCommandHandler.this.menuCommands.length <= this.listSpace ? 100 : this.listSpace * 100 / DefaultCommandHandler.this.menuCommands.length;
            int n5 = DefaultCommandHandler.this.menuCommands.length <= this.listSpace ? 100 : this.scrollPosition * 100 / (DefaultCommandHandler.this.menuCommands.length - this.listSpace);
            GraphicsBridge.setVerticalScroll(n5, n4);
            GraphicsBridge.refresh(sArray[0], sArray[1], GraphicsBridge.screenWidth, GraphicsBridge.adornedHeight);
        }
    }
}

