/*
 * Decompiled with CFR 0.152.
 */
package com.sun.kvem.midp;

import com.sun.kvem.KeyboardManager;
import com.sun.kvem.SoftButtonManager;
import com.sun.kvem.environment.Debug;
import com.sun.kvem.midp.Command;
import java.util.HashMap;
import java.util.Map;

class CommandMapping {
    private static final Debug debug = Debug.create((Class)CommandMapping.class);
    private Command[] menuCommands;
    private final Map keyCommands = new HashMap();

    CommandMapping() {
    }

    Command[] getMenuCommands() {
        try {
            return (Command[])this.menuCommands.clone();
        }
        catch (NullPointerException nullPointerException) {
            return new Command[0];
        }
    }

    void setMenuCommands(Command[] commandArray) {
        this.menuCommands = (Command[])commandArray.clone();
        debug.println(3, "Menu commands are {0}", (Object)commandArray);
    }

    Command getCommandForSoftButton(int n) {
        int n2 = SoftButtonManager.getInstance().getKeyForIndex(n);
        return this.getCommandForKey(n2);
    }

    Command getCommandForKey(int n) {
        Integer n2 = new Integer(n);
        Command command = (Command)this.keyCommands.get(n2);
        return command;
    }

    boolean isCommandMapped(Command command) {
        return this.keyCommands.containsValue(command);
    }

    boolean isKeyMapped(int n) {
        Integer n2 = new Integer(n);
        return this.keyCommands.containsKey(n2);
    }

    void setCommandForKey(int n, Command command) {
        Object object;
        if (debug.level(3)) {
            object = KeyboardManager.getInstance().getKeyboardHandler().getKeyName(n);
            debug.println(3, "{0} assigned to key " + (String)object, (Object)command);
        }
        object = new Integer(n);
        this.keyCommands.put(object, command);
    }

    void setCommandForSoftButton(int n, Command command) {
        int n2 = SoftButtonManager.getInstance().getKeyForIndex(n);
        this.setCommandForKey(n2, command);
    }
}

