/*
 * Decompiled with CFR 0.152.
 */
package com.sun.kvem.midp;

import com.sun.kvem.Device;
import com.sun.kvem.KeyEventHandler;
import com.sun.kvem.environment.Debug;
import com.sun.kvem.midp.Command;
import com.sun.kvem.midp.CommandHandler;
import java.awt.event.InputEvent;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;

public class CommandManager
implements KeyEventHandler {
    private static final Debug debug;
    private static CommandManager instance;
    private static final Command invokeCommand;
    private static final Command dismissCommand;
    private static final Command[] emptyCommandArray;
    private static Method showMenuMethod;
    private static Object[] zeroLengthArray;
    private CommandHandler commandHandler;
    private List commandList = new ArrayList();

    protected CommandManager() {
    }

    public static CommandManager getInstance() {
        return instance;
    }

    public static void addCommand(String string, String string2, int n, int n2, int n3, boolean bl) {
        if (debug.level(3)) {
            debug.println(3, "addCommand: labels=({0}), type={1}, priority=" + n2 + ", id=" + n3, (Object)(string + ", " + string2), n);
        }
        if (instance != null) {
            Command command = new Command(string, string2, n, n2, n3, bl);
            instance.addCommand(command);
        }
    }

    public static void closeCommandSet() {
        debug.trace(3);
        if (instance != null) {
            instance.closeCommandSet_();
        }
    }

    public static void showMenu() {
        if (instance != null && CommandManager.instance.commandHandler != null) {
            try {
                if (showMenuMethod != null) {
                    showMenuMethod.invoke(null, zeroLengthArray);
                }
            }
            catch (Throwable throwable) {
                debug.exception(1, throwable);
            }
            CommandManager.instance.commandHandler.showMenu();
        }
    }

    public static void hideMenu() {
        if (instance != null && CommandManager.instance.commandHandler != null) {
            CommandManager.instance.commandHandler.hideMenu();
        }
    }

    public static boolean canUseScreen() {
        if (instance != null && CommandManager.instance.commandHandler != null) {
            return !CommandManager.instance.commandHandler.isUsingScreen();
        }
        return true;
    }

    public void setCommandHandler(CommandHandler commandHandler) {
        this.commandHandler = commandHandler;
    }

    public CommandHandler getCommandHandler() {
        return this.commandHandler;
    }

    public boolean keyPressed(int n, InputEvent inputEvent) {
        debug.println(3, "Key {0} pressed", n);
        if (this.commandHandler != null && n != Short.MIN_VALUE) {
            boolean bl = this.commandHandler.keyPressed(n, inputEvent);
            if (bl) {
                debug.println(3, "Key {0} was handled by the command handler", n);
            }
            return bl;
        }
        return false;
    }

    public boolean keyReleased(int n, InputEvent inputEvent) {
        if (this.commandHandler != null && n != Short.MIN_VALUE) {
            boolean bl = this.commandHandler.keyReleased(n, inputEvent);
            if (bl) {
                debug.println(3, "Key {0} was handled by the command handler", n);
            }
            return bl;
        }
        return false;
    }

    public boolean keyTyped(char c, InputEvent inputEvent) {
        if (this.commandHandler != null) {
            boolean bl = this.commandHandler.keyTyped(c, inputEvent);
            if (bl) {
                debug.println(3, "KeyTyped {0} was handled by the command handler", (int)c);
            }
            return bl;
        }
        return false;
    }

    private void addCommand(Command command) {
        this.commandList.add(command);
    }

    private void closeCommandSet_() {
        if (this.commandHandler != null) {
            Command[] commandArray = this.commandList.size() == 0 ? emptyCommandArray : this.commandList.toArray(emptyCommandArray);
            this.commandHandler.setCommands(commandArray);
            this.commandList.clear();
        }
    }

    public void grabFullScreen(boolean bl) {
        this.commandHandler.grabFullScreen(bl);
    }

    public void signalInvoke() {
        debug.println(3, "Signal MIDP");
        invokeCommand.sendEvent();
    }

    public void signalDismiss() {
        debug.println(3, "Signal MIDP");
        dismissCommand.sendEvent();
    }

    static {
        Object object;
        debug = Debug.create((Class)CommandManager.class);
        instance = new CommandManager();
        invokeCommand = new Command("INVOKE", null, 0, 0, -1, false);
        dismissCommand = new Command("DISMISS", null, 0, 0, -2, false);
        emptyCommandArray = new Command[0];
        showMenuMethod = null;
        zeroLengthArray = new Object[0];
        try {
            object = Class.forName("com.sun.kvem.mma.VideoScreenBridge");
            showMenuMethod = ((Class)object).getMethod("showMenu", new Class[0]);
            debug.println(1, "Loaded MMA method {0}", (Object)showMenuMethod);
        }
        catch (Exception exception) {
            debug.exception(1, (Throwable)exception);
        }
        object = Device.getProperty("command.handler", "com.sun.kvem.midp.DefaultCommandHandler");
        try {
            debug.println(1, "Loading command handler\n  {0}", object);
            Class<?> clazz = Class.forName((String)object);
            Object obj = clazz.newInstance();
            CommandHandler commandHandler = (CommandHandler)obj;
            CommandManager.getInstance().setCommandHandler(commandHandler);
        }
        catch (ClassNotFoundException classNotFoundException) {
            System.err.println("Command handler class '" + (String)object + "' not found");
        }
        catch (IllegalAccessException illegalAccessException) {
            System.err.println("Cannot access no-argument constructorfor command handler class '" + (String)object + "'");
        }
        catch (InstantiationException instantiationException) {
            System.err.println("Cannot instantiate command handler class '" + (String)object + "'");
        }
        catch (ClassCastException classCastException) {
            System.err.println("Class '" + (String)object + "' does not implement " + CommandHandler.class);
        }
    }
}

