/*
 * Decompiled with CFR 0.152.
 */
package com.sun.kvem.midp;

import com.sun.kvem.DeviceEventManager;
import com.sun.kvem.environment.Debug;
import java.util.Comparator;

public class Command {
    private static final Debug debug = Debug.create((Class)Command.class);
    public static final int COMMAND_TYPE_SCREEN = 1;
    public static final int COMMAND_TYPE_BACK = 2;
    public static final int COMMAND_TYPE_CANCEL = 3;
    public static final int COMMAND_TYPE_OK = 4;
    public static final int COMMAND_TYPE_HELP = 5;
    public static final int COMMAND_TYPE_STOP = 6;
    public static final int COMMAND_TYPE_EXIT = 7;
    public static final int COMMAND_TYPE_ITEM = 8;
    private static final String[] typeNames = new String[]{"<unknown: 0>", "SCREEN", "BACK", "CANCEL", "OK", "HELP", "STOP", "EXIT", "ITEM"};
    public final String label;
    public final String longLabel;
    public final int type;
    public final int priority;
    private final int index;
    public final boolean isitem;

    public Command(String string, String string2, int n, int n2, int n3, boolean bl) {
        this.label = string;
        this.longLabel = string2 == null ? string : string2;
        this.type = n;
        this.priority = n2;
        this.index = n3;
        this.isitem = bl;
    }

    public void sendEvent() {
        debug.println(2, "Triggered {0}", (Object)this);
        int[] nArray = new int[]{7, this.index, 0, 0};
        DeviceEventManager.getInstance().queueEvent(nArray);
    }

    public String getTypeAsString() {
        try {
            return typeNames[this.type];
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return "<unknown: " + this.type + ">";
        }
    }

    public boolean isValidType() {
        return this.type >= 0 && this.type < typeNames.length;
    }

    public String toString() {
        return "Command[" + this.getTypeAsString() + ", (\"" + this.label + "\", \"" + this.longLabel + "\"), " + this.priority + "]";
    }

    public static Comparator getPriorityComparator() {
        return new PriorityComparator();
    }

    public static Comparator getPrecedenceComparator() {
        return new PrecedenceComparator();
    }

    private static class PrecedenceComparator
    extends CommandComparator {
        private int[] typePrecedences = new int[]{127, 6, 1, 3, 5, 8, 4, 2, 7};

        private PrecedenceComparator() {
        }

        private int typePrecedence(int n) {
            try {
                return this.typePrecedences[n];
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                return this.typePrecedences[0];
            }
        }

        int compare(Command command, Command command2) {
            return this.typePrecedence(command.type) - this.typePrecedence(command2.type);
        }
    }

    private static class PriorityComparator
    extends CommandComparator {
        private PriorityComparator() {
        }

        int compare(Command command, Command command2) {
            return command.priority - command2.priority;
        }
    }

    private static abstract class CommandComparator
    implements Comparator {
        private CommandComparator() {
        }

        public int compare(Object object, Object object2) {
            return this.compare((Command)object, (Command)object2);
        }

        abstract int compare(Command var1, Command var2);
    }
}

