/*
 * Decompiled with CFR 0.152.
 */
package com.sun.kvem.midp;

import com.sun.kvem.Screen;
import java.awt.image.RGBImageFilter;

class ColorConversion
extends RGBImageFilter {
    private int rm;
    private int gm;
    private int bm;
    private int ro;
    private int go;
    private int bo;

    public ColorConversion(Screen screen) {
        this.canFilterIndexColorModel = true;
        int n = screen.getColorCount();
        int n2 = (int)Math.ceil(Math.log(n) / Math.log(2.0));
        int n3 = n2 / 3;
        int n4 = n3 + (n2 % 3 > 0 ? 1 : 0);
        int n5 = n3 + (n2 % 3 > 1 ? 1 : 0);
        this.rm = 255 / ((1 << n4) - 1);
        this.gm = 255 / ((1 << n5) - 1);
        this.bm = 255 / ((1 << n3) - 1);
        this.ro = this.rm / 2;
        this.go = this.gm / 2;
        this.bo = this.bm / 2;
        while ((255 + this.ro) % this.rm < this.ro) {
            --this.ro;
        }
        while ((255 + this.go) % this.gm < this.go) {
            --this.go;
        }
        while ((255 + this.bo) % this.bm < this.bo) {
            --this.bo;
        }
    }

    public int filterRGB(int n, int n2, int n3) {
        int n4 = n3 & 0xFF000000;
        int n5 = (n3 & 0xFF0000) >> 16;
        int n6 = (n3 & 0xFF00) >> 8;
        int n7 = n3 & 0xFF;
        int n8 = n5 + this.ro - (n5 + this.ro) % this.rm;
        int n9 = n6 + this.go - (n6 + this.go) % this.gm;
        int n10 = n7 + this.bo - (n7 + this.bo) % this.bm;
        return n8 << 16 | n9 << 8 | n10 | n4;
    }

    public void filterPixelsToDestination16(byte[] byArray, byte[][] byArray2) {
        int n = 0;
        for (int i = 0; i < byArray2.length; ++i) {
            int n2 = 0;
            while (n2 < byArray2[i].length) {
                char c = (char)(byArray[n] & 0xFF | byArray[n + 1] << 8);
                int n3 = (c & 0x1F) << 3 & 0xFF;
                int n4 = (c & 0x7E0) >>> 3 & 0xFF;
                int n5 = (c & 0xF800) >>> 8 & 0xFF;
                if ((n3 & 8) != 0) {
                    n3 |= 7;
                }
                if ((n4 & 4) != 0) {
                    n4 |= 3;
                }
                if ((n5 & 8) != 0) {
                    n5 |= 7;
                }
                byArray2[i][n2++] = -1;
                byArray2[i][n2++] = (byte)(n3 + this.bo - (n3 + this.bo) % this.bm & 0xFF);
                byArray2[i][n2++] = (byte)(n4 + this.go - (n4 + this.go) % this.gm & 0xFF);
                byArray2[i][n2++] = (byte)(n5 + this.ro - (n5 + this.ro) % this.rm & 0xFF);
                n += 2;
            }
        }
    }
}

