/*
 * Decompiled with CFR 0.152.
 */
package com.sun.kvem.memorymon;

import com.sun.kvem.environment.ToolkitDirs;
import com.sun.kvem.memorymon.ObjectNode;
import com.sun.kvem.memorymon.ObjectsMonitor;
import com.sun.kvem.util.ToolkitResources;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;

class ObjectsTable
extends JTable
implements Comparator,
ActionListener {
    private MyTableModel model;
    private ObjectsMonitor monitor;
    protected int sortColumn = -1;
    protected boolean sortAscending = false;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Float;

    public ObjectsTable(ObjectsMonitor objectsMonitor) {
        this.monitor = objectsMonitor;
        this.model = new MyTableModel();
        this.setModel(this.model);
        this.setColumnSelectionAllowed(false);
        ListSelectionModel listSelectionModel = this.getSelectionModel();
        listSelectionModel.addListSelectionListener(objectsMonitor);
        this.addMouseListenerToHeaderInTable();
        this.setTableColumnWidths();
        JTableHeader jTableHeader = this.getTableHeader();
        DefaultTableCellRenderer defaultTableCellRenderer = (DefaultTableCellRenderer)jTableHeader.getDefaultRenderer();
        jTableHeader.setDefaultRenderer(new HeaderCellRenderer(defaultTableCellRenderer));
        this.addMouseListenerToTable();
    }

    public boolean isCellEditable(int n, int n2) {
        return false;
    }

    void addMouseListenerToHeaderInTable() {
        MouseAdapter mouseAdapter = new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                TableColumnModel tableColumnModel = ObjectsTable.this.getColumnModel();
                int n = tableColumnModel.getColumnIndexAtX(mouseEvent.getX());
                int n2 = ObjectsTable.this.convertColumnIndexToModel(n);
                if (mouseEvent.getClickCount() == 1 && n2 != -1) {
                    ObjectsTable.this.sortBy(n2);
                }
            }
        };
        JTableHeader jTableHeader = this.getTableHeader();
        jTableHeader.addMouseListener(mouseAdapter);
    }

    void addMouseListenerToTable() {
        MouseAdapter mouseAdapter = new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                this.maybeShowPopup(mouseEvent);
            }

            public void mouseReleased(MouseEvent mouseEvent) {
                this.maybeShowPopup(mouseEvent);
            }

            private void maybeShowPopup(MouseEvent mouseEvent) {
                if (mouseEvent.isPopupTrigger()) {
                    ObjectsTable.this.monitor.getTablePopup().show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
                }
            }
        };
        this.addMouseListener(mouseAdapter);
    }

    public void addRow(Object[] objectArray) {
        this.model.addRow(objectArray);
    }

    public void setValueAt(Object object, int n, int n2) {
        this.model.setValueAt(object, n, n2);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals("sort_by_name")) {
            this.sortBy(0);
        } else if (string.equals("sort_by_live")) {
            this.sortBy(1);
        } else if (string.equals("sort_by_total")) {
            this.sortBy(2);
        } else if (string.equals("sort_by_size")) {
            this.sortBy(3);
        } else if (string.equals("sort_by_average")) {
            this.sortBy(4);
        }
    }

    public void sortBy(int n) {
        int n2 = this.getSelectedRow();
        ObjectNode objectNode = null;
        if (n2 >= 0) {
            objectNode = (ObjectNode)this.monitor.rowToObject.get(new Integer(n2));
        }
        this.setSortColumn(n);
        this.sort();
        if (objectNode != null) {
            int n3 = objectNode.getClassId();
            int n4 = (Integer)this.monitor.idToRow.get(new Integer(n3));
            this.setRowSelectionInterval(n4, n4);
            this.scrollRectToVisible(this.getCellRect(n4, 0, true));
        }
    }

    public void setSortColumn(int n) {
        this.sortAscending = this.sortColumn != n ? false : !this.sortAscending;
        this.sortColumn = n;
    }

    public int compare(Object object, Object object2) {
        int n = ((ObjectNode)object).compareTo((ObjectNode)object2, this.sortColumn);
        return this.sortAscending ? n : -n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sort() {
        ObjectsMonitor objectsMonitor = this.monitor;
        synchronized (objectsMonitor) {
            ObjectNode[] objectNodeArray = this.monitor.idToObject.values().toArray(new ObjectNode[0]);
            List<ObjectNode> list = Arrays.asList(objectNodeArray);
            Collections.sort(list, this);
            this.monitor.idToRow.clear();
            this.monitor.rowToObject.clear();
            int n = 0;
            Iterator<ObjectNode> iterator = list.iterator();
            while (iterator.hasNext()) {
                ObjectNode objectNode = iterator.next();
                Integer n2 = new Integer(n);
                this.monitor.idToRow.put(new Integer(objectNode.getClassId()), n2);
                this.monitor.rowToObject.put(n2, objectNode);
                ++n;
            }
        }
        this.updateUI();
    }

    void setTableColumnWidths() {
        TableColumnModel tableColumnModel = this.getColumnModel();
        int n = this.model.getColumnCount();
        for (int i = 0; i < n; ++i) {
            int n2;
            switch (i) {
                case 0: {
                    n2 = 350;
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    n2 = 70;
                    break;
                }
                default: {
                    n2 = 40;
                }
            }
            tableColumnModel.getColumn(i).setPreferredWidth(n2);
        }
    }

    class HeaderCellRenderer
    implements TableCellRenderer {
        DefaultTableCellRenderer defaultRenderer;
        ImageIcon upIcon;
        ImageIcon downIcon;

        public HeaderCellRenderer(DefaultTableCellRenderer defaultTableCellRenderer) {
            this.defaultRenderer = defaultTableCellRenderer;
            defaultTableCellRenderer.setHorizontalTextPosition(2);
            this.upIcon = new ImageIcon(ToolkitDirs.LIB + "images" + File.separator + "up.gif");
            this.downIcon = new ImageIcon(ToolkitDirs.LIB + "images" + File.separator + "down.gif");
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            Component component = this.defaultRenderer.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            if (ObjectsTable.this.convertColumnIndexToModel(n2) == ObjectsTable.this.sortColumn) {
                component.setFont(component.getFont().deriveFont(1));
                if (ObjectsTable.this.sortAscending) {
                    this.defaultRenderer.setIcon(this.upIcon);
                } else {
                    this.defaultRenderer.setIcon(this.downIcon);
                }
            } else {
                this.defaultRenderer.setIcon(null);
            }
            return component;
        }
    }

    class MyTableModel
    extends DefaultTableModel {
        final String[] columnNames = new String[]{ToolkitResources.getString((String)"MEMORY_EXT.TABLE.CLASS_NAME"), ToolkitResources.getString((String)"MEMORY_EXT.TABLE.LIVE_OBJECTS"), ToolkitResources.getString((String)"MEMORY_EXT.TABLE.TOTAL_OBJECTS"), ToolkitResources.getString((String)"MEMORY_EXT.TABLE.TOTAL_SIZE"), ToolkitResources.getString((String)"MEMORY_EXT.TABLE.AVERAGE_SIZE")};

        MyTableModel() {
        }

        public int getColumnCount() {
            return this.columnNames.length;
        }

        public String getColumnName(int n) {
            return this.columnNames[n];
        }

        public Class getColumnClass(int n) {
            switch (n) {
                case 0: {
                    return class$java$lang$String == null ? (class$java$lang$String = ObjectsTable.class$("java.lang.String")) : class$java$lang$String;
                }
                case 1: 
                case 2: 
                case 3: {
                    return class$java$lang$Integer == null ? (class$java$lang$Integer = ObjectsTable.class$("java.lang.Integer")) : class$java$lang$Integer;
                }
                case 4: {
                    return class$java$lang$Float == null ? (class$java$lang$Float = ObjectsTable.class$("java.lang.Float")) : class$java$lang$Float;
                }
            }
            return null;
        }

        public Object getValueAt(int n, int n2) {
            ObjectNode objectNode = (ObjectNode)((ObjectsTable)ObjectsTable.this).monitor.rowToObject.get(new Integer(n));
            switch (n2) {
                case 0: {
                    return objectNode.getClassName();
                }
                case 1: {
                    return new Integer(objectNode.getLive());
                }
                case 2: {
                    return new Integer(objectNode.getTotal());
                }
                case 3: {
                    return new Integer(objectNode.getTotalSize());
                }
                case 4: {
                    return new Float(objectNode.getAverageSize());
                }
            }
            return null;
        }
    }
}

