/*
 * Decompiled with CFR 0.152.
 */
package com.sun.kvem.memorymon;

import com.sun.kvem.memorymon.AllocationTree;
import com.sun.kvem.memorymon.MemoryMonitor;
import com.sun.kvem.memorymon.MyTreeNode;
import com.sun.kvem.memorymon.ObjectNode;
import com.sun.kvem.memorymon.ObjectsTable;
import com.sun.kvem.util.ToolkitResources;
import java.awt.Dimension;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.StringTokenizer;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

class ObjectsMonitor
extends JSplitPane
implements ListSelectionListener {
    Map rowToObject;
    Map idToRow;
    Map idToObject;
    private ObjectsTable objTable;
    private AllocationTree allocTree;
    MemoryMonitor memoryMonitor;
    private static final String DELIM = "\t";

    public ObjectsMonitor(MemoryMonitor memoryMonitor, boolean bl) {
        this.memoryMonitor = memoryMonitor;
        this.idToRow = new HashMap();
        this.rowToObject = new HashMap();
        this.idToObject = new HashMap();
        this.objTable = new ObjectsTable(this);
        JScrollPane jScrollPane = new JScrollPane(this.objTable);
        jScrollPane.setPreferredSize(new Dimension(400, 0));
        this.setLeftComponent(jScrollPane);
        this.allocTree = new AllocationTree(bl);
        this.allocTree.setPreferredSize(new Dimension(300, 0));
        this.setRightComponent(this.allocTree);
    }

    public ObjectsTable getObjectsTable() {
        return this.objTable;
    }

    public AllocationTree getAllocationTree() {
        return this.allocTree;
    }

    public synchronized void allocateObject(int n, String string, int n2, int n3) {
        Integer n4 = new Integer(n);
        ObjectNode objectNode = (ObjectNode)this.idToObject.get(n4);
        if (objectNode == null) {
            string = n == 0 ? ToolkitResources.getString((String)"MEMORY_EXT.INTERNAL_METHOD") : ObjectsMonitor.getReadableClassName(string);
            objectNode = new ObjectNode(n, string, n2, this.allocTree.getCurrentMethodNode(n3));
            Integer n5 = new Integer(this.idToRow.size());
            this.idToRow.put(n4, n5);
            this.rowToObject.put(n5, objectNode);
            this.idToObject.put(n4, objectNode);
            this.addClassToTable(objectNode);
        } else {
            objectNode.allocate(n2, this.allocTree.getCurrentMethodNode(n3));
            int n6 = (Integer)this.idToRow.get(n4);
            this.updateRow(n6, objectNode);
        }
    }

    public synchronized void freeObject(int n, int n2, int n3) {
        Integer n4 = new Integer(n2);
        ObjectNode objectNode = (ObjectNode)this.idToObject.get(n4);
        if (objectNode == null) {
            throw new RuntimeException("Inconsistent classes map (unknown class id " + n2 + ")");
        }
        objectNode.free(n3);
        int n5 = (Integer)this.idToRow.get(n4);
        this.updateRow(n5, objectNode);
    }

    private void addClassToTable(final ObjectNode objectNode) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                ObjectsMonitor.this.objTable.addRow(objectNode.toRowData());
            }
        });
    }

    private void updateRow(final int n, final ObjectNode objectNode) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                ObjectsMonitor.this.objTable.setValueAt(new Integer(objectNode.getLive()), n, 1);
                ObjectsMonitor.this.objTable.setValueAt(new Integer(objectNode.getTotal()), n, 2);
                ObjectsMonitor.this.objTable.setValueAt(new Integer(objectNode.getTotalSize()), n, 3);
                ObjectsMonitor.this.objTable.setValueAt(new Float(objectNode.getAverageSize()), n, 4);
            }
        });
    }

    static String getReadableClassName(String string) {
        string = string.replace('/', '.');
        int n = 0;
        while (string.charAt(n) == '[') {
            ++n;
        }
        StringBuffer stringBuffer = new StringBuffer();
        switch (string.charAt(n)) {
            case 'C': {
                stringBuffer.append("char");
                break;
            }
            case 'B': {
                stringBuffer.append("byte");
                break;
            }
            case 'Z': {
                stringBuffer.append("boolean");
                break;
            }
            case 'F': {
                stringBuffer.append("float");
                break;
            }
            case 'D': {
                stringBuffer.append("double");
                break;
            }
            case 'S': {
                stringBuffer.append("short");
                break;
            }
            case 'I': {
                stringBuffer.append("int");
                break;
            }
            case 'J': {
                stringBuffer.append("long");
                break;
            }
            case 'V': {
                stringBuffer.append("void");
                break;
            }
            case 'L': {
                stringBuffer.append(string.substring(n + 1, string.length() - 1));
                break;
            }
            default: {
                stringBuffer.append(string);
            }
        }
        for (int i = 0; i < n; ++i) {
            stringBuffer.append("[ ]");
        }
        return stringBuffer.toString();
    }

    static String getReadableMethodName(String string) {
        Object object;
        int n = string.indexOf(40);
        String string2 = string.substring(0, n);
        string2 = string2.replace('/', '.');
        int n2 = string.indexOf(41, n + 1);
        String string3 = string.substring(n + 1, n2);
        LinkedList<String> linkedList = new LinkedList<String>();
        for (int i = 0; i < string3.length(); i += ((String)object).length()) {
            int n3 = 0;
            while (string3.charAt(i + n3) == '[') {
                ++n3;
            }
            if (string3.charAt(i + n3) == 'L') {
                int n4 = string3.indexOf(59, i + n3 + 1);
                object = string3.substring(i, n4 + 1);
            } else {
                object = string3.substring(i, i + n3 + 1);
            }
            linkedList.add(ObjectsMonitor.getReadableClassName((String)object));
        }
        StringBuffer stringBuffer = new StringBuffer();
        object = linkedList.iterator();
        while (object.hasNext()) {
            stringBuffer.append((String)object.next());
            if (!object.hasNext()) continue;
            stringBuffer.append(", ");
        }
        return string2 + '(' + stringBuffer.toString() + ')';
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        if (listSelectionEvent.getValueIsAdjusting()) {
            return;
        }
        ListSelectionModel listSelectionModel = (ListSelectionModel)listSelectionEvent.getSource();
        if (!listSelectionModel.isSelectionEmpty()) {
            int n = listSelectionModel.getMinSelectionIndex();
            ObjectNode objectNode = (ObjectNode)this.rowToObject.get(new Integer(n));
            this.allocTree.viewObjectMethods(objectNode);
            this.memoryMonitor.setSelectedItemsEnabled(true);
        } else {
            this.memoryMonitor.setSelectedItemsEnabled(false);
        }
    }

    JPopupMenu getTablePopup() {
        return this.memoryMonitor.getTablePopup();
    }

    public void dispose() {
        this.allocTree.dispose();
    }

    public void writeAllTo(PrintWriter printWriter) {
        this.allocTree.writeAllTo(printWriter);
        printWriter.println();
        Iterator iterator = this.rowToObject.values().iterator();
        while (iterator.hasNext()) {
            ObjectNode objectNode = (ObjectNode)iterator.next();
            Object[] objectArray = objectNode.toRowData();
            for (int i = 0; i < objectArray.length; ++i) {
                printWriter.print(objectArray[i] + DELIM);
            }
            Iterator iterator2 = objectNode.methods.keySet().iterator();
            while (iterator2.hasNext()) {
                MyTreeNode myTreeNode = (MyTreeNode)iterator2.next();
                int n = (Integer)objectNode.methods.get(myTreeNode);
                printWriter.print(myTreeNode.hashCode() + DELIM + n + DELIM);
            }
            printWriter.println();
        }
    }

    public void readAllFrom(BufferedReader bufferedReader) throws IOException {
        String string;
        Map map = this.allocTree.readAllFrom(bufferedReader);
        this.rowToObject.clear();
        int n = 0;
        while ((string = bufferedReader.readLine()) != null && !string.equals("")) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, DELIM);
            String string2 = stringTokenizer.nextToken();
            int n2 = Integer.parseInt(stringTokenizer.nextToken());
            int n3 = Integer.parseInt(stringTokenizer.nextToken());
            int n4 = Integer.parseInt(stringTokenizer.nextToken());
            float f = Float.parseFloat(stringTokenizer.nextToken());
            ObjectNode objectNode = ObjectNode.load(n, string2, n2, n3, n4);
            while (stringTokenizer.hasMoreTokens()) {
                Integer n5 = new Integer(stringTokenizer.nextToken());
                MyTreeNode myTreeNode = (MyTreeNode)map.get(n5);
                int n6 = Integer.parseInt(stringTokenizer.nextToken());
                objectNode.addMethod(myTreeNode, n6);
            }
            this.addClassToTable(objectNode);
            this.rowToObject.put(new Integer(n), objectNode);
            ++n;
        }
        this.idToObject = this.rowToObject;
    }
}

