/*
 * Decompiled with CFR 0.152.
 */
package com.sun.kvem.memorymon;

import com.sun.kvem.memorymon.MyTreeNode;
import java.util.HashMap;
import java.util.Map;

class ObjectNode {
    public static final int NO_SELECTION = -1;
    public static final int NAME = 0;
    public static final int LIVE = 1;
    public static final int TOTAL = 2;
    public static final int TOTAL_SIZE = 3;
    public static final int AVR_SIZE = 4;
    private int classId;
    private String className;
    private int live;
    private int total;
    private int totalSize;
    Map methods;

    public ObjectNode(int n, String string, int n2, MyTreeNode myTreeNode) {
        this.classId = n;
        this.className = string;
        this.total = 1;
        this.live = 1;
        this.totalSize = n2;
        this.methods = new HashMap();
        this.methods.put(myTreeNode, new Integer(1));
    }

    private ObjectNode(int n, String string) {
        this.classId = n;
        this.className = string;
        this.methods = new HashMap();
    }

    public int getClassId() {
        return this.classId;
    }

    public String getClassName() {
        return this.className;
    }

    public int getLive() {
        return this.live;
    }

    public int getTotal() {
        return this.total;
    }

    public int getTotalSize() {
        return this.totalSize;
    }

    public float getAverageSize() {
        if (this.live == 0) {
            return 0.0f;
        }
        int n = 10 * (this.totalSize / this.live);
        return (float)n / 10.0f;
    }

    public void allocate(int n, MyTreeNode myTreeNode) {
        ++this.live;
        ++this.total;
        this.totalSize += n;
        Integer n2 = (Integer)this.methods.get(myTreeNode);
        if (n2 == null) {
            this.methods.put(myTreeNode, new Integer(1));
        } else {
            n2 = new Integer(n2 + 1);
            this.methods.put(myTreeNode, n2);
        }
    }

    public void free(int n) {
        if (this.live <= 0) {
            throw new RuntimeException("Inconsistent classes map");
        }
        --this.live;
        this.totalSize -= n;
        if (this.live == 0 && this.totalSize != 0 || this.live < 0 || this.totalSize < 0) {
            this.live = 0;
            this.totalSize = 0;
        }
    }

    public Object[] toRowData() {
        return new Object[]{this.className, new Integer(this.live), new Integer(this.total), new Integer(this.totalSize), new Float(this.getAverageSize())};
    }

    public int compareTo(ObjectNode objectNode, int n) {
        switch (n) {
            case 0: {
                return -this.className.compareTo(objectNode.className);
            }
            case 1: {
                return this.live - objectNode.live;
            }
            case 2: {
                return this.total - objectNode.total;
            }
            case 3: {
                return this.totalSize - objectNode.totalSize;
            }
            case 4: {
                return (int)(this.getAverageSize() - objectNode.getAverageSize());
            }
        }
        throw new IllegalArgumentException();
    }

    public static ObjectNode load(int n, String string, int n2, int n3, int n4) {
        ObjectNode objectNode = new ObjectNode(n, string);
        objectNode.live = n2;
        objectNode.total = n3;
        objectNode.totalSize = n4;
        return objectNode;
    }

    public void addMethod(MyTreeNode myTreeNode, int n) {
        this.methods.put(myTreeNode, new Integer(n));
    }
}

