/*
 * Decompiled with CFR 0.152.
 */
package com.sun.kvem.memorymon;

import com.sun.kvem.environment.Debug;
import com.sun.kvem.environment.ModulesRegistry;
import com.sun.kvem.environment.ToolkitDirs;
import com.sun.kvem.memorymon.Graph;
import com.sun.kvem.memorymon.ObjectsMonitor;
import com.sun.kvem.memorymon.ObjectsTable;
import com.sun.kvem.midp.EventBridge;
import com.sun.kvem.util.SmartFileChooser;
import com.sun.kvem.util.ToolkitResources;
import com.sun.kvem.util.WindowUtils;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.MessageFormat;
import javax.accessibility.AccessibleContext;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTabbedPane;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class MemoryMonitor
extends JFrame
implements ActionListener {
    private static Debug debug = Debug.create((Class)MemoryMonitor.class);
    private static String currentFormat;
    private static String maxFormat;
    private static String usedFormat;
    private static String freeFormat;
    private static String totalFormat;
    private static String objectsFormat;
    private Object[] freeFormatObjs;
    private Object[] totalFormatObjs;
    private Object[] objectsFormatObjs;
    private long heapSize;
    private long objects = 0L;
    private long used = 0L;
    private long maxUsed = 0L;
    private JLabel objsLabel;
    private JLabel usedLabel;
    private JLabel usedLabel2;
    private Object[] usedFormatObjs;
    private JLabel freeLabel;
    private JLabel totalLabel;
    private JLabel maxLabel;
    private JPanel controlPanel;
    private Object[] maxFormatObjs;
    private JButton gcButton;
    private JButton saveButton;
    private JMenuItem saveAsItem;
    private JMenuItem saveItem;
    private int currentThread;
    private File currentFile = null;
    private File defaultDir = new File(ToolkitDirs.SESSION);
    public static final String MEMORY_SESSION_FILE_EXT;
    private static final String TEXT_FILE_EXT = "txt";
    private static final String TEXT_FILTER_DESC = "Text file";
    private Graph graph;
    private ObjectsMonitor objsMonitor;
    private JMenuItem sortByName;
    private JMenuItem sortByLive;
    private JMenuItem sortByTotal;
    private JMenuItem sortByTotalSize;
    private JMenuItem sortByTotalAverageSize;
    private JMenu viewMenu;
    public static final String CMD_OPEN = "open";
    public static final String CMD_SAVE = "save";
    public static final String CMD_SAVE_AS = "saveAs";
    public static final String CMD_SAVE_SELECTED = "saveSelected";
    public static final String CMD_CLOSE = "close";
    public static final String CMD_SORT_BY_NAME = "sort_by_name";
    public static final String CMD_SORT_BY_LIVE = "sort_by_live";
    public static final String CMD_SORT_BY_TOTAL = "sort_by_total";
    public static final String CMD_SORT_BY_SIZE = "sort_by_size";
    public static final String CMD_SORT_BY_AVERAGE = "sort_by_average";
    private Action runGCAction = new RunGCAction();
    private JButton openButton;
    private JMenuItem openItem;
    private JMenuItem saveSelectedItem;
    JPopupMenu tablePopup;
    private JMenuItem popupSelectedItem;
    private JTabbedPane tabbedPane;
    private String deviceTitle = null;

    public MemoryMonitor() throws Exception {
        this((File)null);
    }

    public MemoryMonitor(File file) throws Exception {
        this.updateTitle();
        objectsFormat = ToolkitResources.getString((String)"MEMORY_EXT.OBJECTS");
        usedFormat = ToolkitResources.getString((String)"MEMORY_EXT.USED");
        freeFormat = ToolkitResources.getString((String)"MEMORY_EXT.FREE");
        totalFormat = ToolkitResources.getString((String)"MEMORY_EXT.TOTAL");
        WindowUtils.setLookAndFeel();
        AccessibleContext accessibleContext = this.getAccessibleContext();
        accessibleContext.setAccessibleName("Memory Monitor");
        accessibleContext.setAccessibleDescription("Wireless Toolkit's memory monitor");
        this.runGCAction.putValue("MnemonicKey", new Integer(71));
        this.tabbedPane = new JTabbedPane();
        this.graph = new Graph(this);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        currentFormat = ToolkitResources.getString((String)"MEMORY_EXT.CURRENT");
        maxFormat = ToolkitResources.getString((String)"MEMORY_EXT.MAXIMUM");
        this.usedFormatObjs = new Object[]{Long.toString(this.used)};
        this.usedLabel2 = new JLabel(MessageFormat.format(currentFormat, this.usedFormatObjs));
        this.maxFormatObjs = new Object[]{Long.toString(this.maxUsed)};
        this.maxLabel = new JLabel(MessageFormat.format(maxFormat, this.maxFormatObjs));
        jPanel.add(this.usedLabel2);
        jPanel.add(this.maxLabel);
        jPanel.setPreferredSize(new Dimension(150, 50));
        JPanel jPanel2 = new JPanel();
        jPanel2.add(jPanel);
        jPanel2.add(this.graph);
        JPanel jPanel3 = this.createControlPanel();
        JToolBar jToolBar = this.createToolBar();
        this.setJMenuBar(this.createMenuBar());
        this.tabbedPane.addTab(ToolkitResources.getString((String)"MEMORY_EXT.GRAPH_TAB"), jPanel2);
        if (file != null) {
            this.readInputFile(file);
        } else {
            this.objsMonitor = new ObjectsMonitor(this, false);
            this.addItemsToViewMenu();
            this.tabbedPane.addTab(ToolkitResources.getString((String)"MEMORY_EXT.OBJECTS_TAB"), this.objsMonitor);
        }
        this.viewMenu.setEnabled(false);
        this.tabbedPane.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                JTabbedPane jTabbedPane = (JTabbedPane)changeEvent.getSource();
                MemoryMonitor.this.viewMenu.setEnabled(jTabbedPane.getSelectedIndex() == 1);
            }
        });
        Container container = this.getContentPane();
        container.add((Component)jToolBar, "North");
        container.add((Component)this.tabbedPane, "Center");
        container.add((Component)jPanel3, "South");
        this.setDefaultCloseOperation(2);
        this.addWindowListener(new WindowAdapter(){

            public void windowOpened(WindowEvent windowEvent) {
                ModulesRegistry.registerModule((Object)this);
            }

            public void windowClosed(WindowEvent windowEvent) {
                MemoryMonitor.this.objsMonitor.dispose();
                EventBridge.injectEvent(-1001, 0, 0, 0);
                ModulesRegistry.deregisterModule((Object)this);
            }
        });
        String string = ToolkitDirs.LIB + "images" + File.separator + "MemoryMonitor.gif";
        WindowUtils.setFrameIcon((JFrame)this, (String)string);
        this.pack();
    }

    private JMenuBar createMenuBar() {
        JMenuBar jMenuBar = new JMenuBar();
        JMenu jMenu = new JMenu(ToolkitResources.getString((String)"FILE"));
        jMenu.setMnemonic(70);
        jMenuBar.add(jMenu);
        this.openItem = new JMenuItem(ToolkitResources.getString((String)"MONITORS.OPEN"), 79);
        this.openItem.setActionCommand(CMD_OPEN);
        this.openItem.addActionListener(this);
        this.openItem.setEnabled(false);
        jMenu.add(this.openItem);
        this.saveItem = new JMenuItem(ToolkitResources.getString((String)"SAVE"), 83);
        this.saveItem.setActionCommand(CMD_SAVE);
        this.saveItem.addActionListener(this);
        jMenu.add(this.saveItem);
        this.saveAsItem = new JMenuItem(ToolkitResources.getString((String)"SAVE_AS"), 65);
        this.saveAsItem.setActionCommand(CMD_SAVE_AS);
        this.saveAsItem.addActionListener(this);
        jMenu.add(this.saveAsItem);
        this.saveSelectedItem = this.createSelectedMenuItem();
        jMenu.add(this.saveSelectedItem);
        jMenu.addSeparator();
        JMenuItem jMenuItem = new JMenuItem(ToolkitResources.getString((String)"CLOSE"), 67);
        jMenuItem.setActionCommand(CMD_CLOSE);
        jMenuItem.addActionListener(this);
        jMenu.add(jMenuItem);
        jMenu = new JMenu(ToolkitResources.getString((String)"UTILITIES"));
        jMenu.setMnemonic(85);
        jMenuBar.add(jMenu);
        jMenuItem = new JMenuItem(this.runGCAction);
        jMenuItem.setMnemonic(71);
        jMenu.add(jMenuItem);
        this.viewMenu = new JMenu(ToolkitResources.getString((String)"VIEW"));
        this.viewMenu.setMnemonic(86);
        jMenuBar.add(this.viewMenu);
        this.tablePopup = new JPopupMenu();
        this.popupSelectedItem = this.createSelectedMenuItem();
        this.tablePopup.add(this.popupSelectedItem);
        return jMenuBar;
    }

    private JMenuItem createSelectedMenuItem() {
        JMenuItem jMenuItem = new JMenuItem(ToolkitResources.getString((String)"PROFILER_EXT.SAVE_SELECTED"), ToolkitResources.getString((String)"PROFILER_EXT.SAVE_SELECTED_SHORTCUT").charAt(0));
        jMenuItem.setToolTipText(ToolkitResources.getString((String)"PROFILER_EXT.SAVE_SELECTED_HELP"));
        jMenuItem.setActionCommand(CMD_SAVE_SELECTED);
        jMenuItem.addActionListener(this);
        jMenuItem.setEnabled(false);
        return jMenuItem;
    }

    private void addItemsToViewMenu() {
        ObjectsTable objectsTable = this.objsMonitor.getObjectsTable();
        this.viewMenu.removeAll();
        JMenuItem jMenuItem = new JMenuItem(ToolkitResources.getString((String)"FIND"), 114);
        jMenuItem.setActionCommand("find");
        jMenuItem.addActionListener(this.objsMonitor.getAllocationTree());
        jMenuItem.setMnemonic(ToolkitResources.getString((String)"FIND_SHORTCUT").charAt(0));
        this.viewMenu.add(jMenuItem);
        JMenu jMenu = new JMenu(ToolkitResources.getString((String)"MEMORY_EXT.SORT_BY"));
        jMenu.setMnemonic(83);
        this.viewMenu.add(jMenu);
        this.sortByName = new JMenuItem(ToolkitResources.getString((String)"MEMORY_EXT.CLASS_NAME"), 78);
        this.sortByName.setActionCommand(CMD_SORT_BY_NAME);
        this.sortByName.addActionListener(objectsTable);
        jMenu.add(this.sortByName);
        this.sortByLive = new JMenuItem(ToolkitResources.getString((String)"MEMORY_EXT.LIVE_OBJECTS"), 76);
        this.sortByLive.setActionCommand(CMD_SORT_BY_LIVE);
        this.sortByLive.addActionListener(objectsTable);
        jMenu.add(this.sortByLive);
        this.sortByTotal = new JMenuItem(ToolkitResources.getString((String)"MEMORY_EXT.TOTAL_OBJECTS"), 84);
        this.sortByTotal.setActionCommand(CMD_SORT_BY_TOTAL);
        this.sortByTotal.addActionListener(objectsTable);
        jMenu.add(this.sortByTotal);
        this.sortByTotalSize = new JMenuItem(ToolkitResources.getString((String)"MEMORY_EXT.TOTAL_SIZE"), 83);
        this.sortByTotalSize.setActionCommand(CMD_SORT_BY_SIZE);
        this.sortByTotalSize.addActionListener(objectsTable);
        jMenu.add(this.sortByTotalSize);
        this.sortByTotalAverageSize = new JMenuItem(ToolkitResources.getString((String)"MEMORY_EXT.AVERAGE_SIZE"), 65);
        this.sortByTotalAverageSize.setActionCommand(CMD_SORT_BY_AVERAGE);
        this.sortByTotalAverageSize.addActionListener(objectsTable);
        jMenu.add(this.sortByTotalAverageSize);
    }

    private JToolBar createToolBar() {
        JToolBar jToolBar = new JToolBar();
        this.openButton = new JButton(ToolkitResources.getString((String)"MEMORY_EXT.OPEN_SESSION"));
        this.openButton.setEnabled(false);
        this.openButton.setMnemonic(ToolkitResources.getString((String)"MEMORY_EXT.OPEN_SESSION_SHORTCUT").charAt(0));
        this.openButton.setActionCommand(CMD_OPEN);
        this.openButton.addActionListener(this);
        jToolBar.add(this.openButton);
        this.saveButton = new JButton(ToolkitResources.getString((String)"SAVE"));
        this.saveButton.setMnemonic(ToolkitResources.getString((String)"SAVE_SHORTCUT").charAt(0));
        this.saveButton.setToolTipText(ToolkitResources.getString((String)"MEMORY_EXT.SAVE_HELP"));
        this.saveButton.setActionCommand(CMD_SAVE);
        this.saveButton.addActionListener(this);
        jToolBar.add(this.saveButton);
        jToolBar.addSeparator();
        String string = ToolkitDirs.LIB + "images" + File.separator;
        ImageIcon imageIcon = new ImageIcon(string + "gc.gif");
        this.gcButton = new JButton(this.runGCAction);
        this.gcButton.setMnemonic(71);
        this.gcButton.setIcon(imageIcon);
        jToolBar.add(this.gcButton);
        return jToolBar;
    }

    public void corruptedFile(Exception exception) {
        int n;
        JOptionPane jOptionPane = new JOptionPane(ToolkitResources.getString((String)"CORRUPTED_FILE"), 0);
        JDialog jDialog = jOptionPane.createDialog(this, ToolkitResources.getString((String)"MEMORY_EXT.TITLE_ERROR"));
        FontMetrics fontMetrics = jDialog.getFontMetrics(jDialog.getFont());
        int n2 = fontMetrics.stringWidth(ToolkitResources.getString((String)"MEMORY_EXT.TITLE_ERROR"));
        int n3 = n2 > (n = fontMetrics.stringWidth(ToolkitResources.getString((String)"CORRUPTED_FILE"))) ? 2 * n2 : 2 * n;
        Dimension dimension = new Dimension(n3, 140);
        jDialog.setSize(dimension);
        jDialog.setVisible(true);
    }

    private JPanel createControlPanel() {
        this.objectsFormatObjs = new Object[]{Long.toString(this.objects)};
        if (this.objsLabel == null) {
            this.objsLabel = new JLabel(MessageFormat.format(objectsFormat, this.objectsFormatObjs));
        }
        this.usedFormatObjs[0] = Long.toString(this.used);
        this.usedLabel = new JLabel(MessageFormat.format(usedFormat, this.usedFormatObjs));
        this.freeFormatObjs = new Object[]{Long.toString(this.heapSize - this.used)};
        this.freeLabel = new JLabel(MessageFormat.format(freeFormat, this.freeFormatObjs));
        this.totalFormatObjs = new Object[]{Long.toString(this.heapSize)};
        this.totalLabel = new JLabel();
        this.controlPanel = new JPanel();
        this.controlPanel.setLayout(new BoxLayout(this.controlPanel, 0));
        this.controlPanel.add(this.objsLabel);
        this.controlPanel.add(Box.createHorizontalGlue());
        this.controlPanel.add(this.usedLabel);
        this.controlPanel.add(Box.createHorizontalGlue());
        this.controlPanel.add(this.freeLabel);
        this.controlPanel.add(Box.createHorizontalGlue());
        this.controlPanel.add(this.totalLabel);
        return this.controlPanel;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals(CMD_SAVE)) {
            if (this.currentFile == null) {
                this.actionPerformed(new ActionEvent(CMD_SAVE_AS, 0, CMD_SAVE_AS));
                return;
            }
            try {
                this.writeOutputFile(this.currentFile);
            }
            catch (IOException iOException) {
                JOptionPane.showMessageDialog(this, ToolkitResources.getString((String)"SAVING_ERROR_MESSAGE") + this.currentFile, ToolkitResources.getString((String)"NETMON_ERROR_TITLE"), 0);
            }
        } else if (string.equals(CMD_SAVE_SELECTED)) {
            SmartFileChooser smartFileChooser = new SmartFileChooser(this.defaultDir);
            smartFileChooser.setAcceptAllFileFilterUsed(false);
            smartFileChooser.addExtFilter(TEXT_FILE_EXT, TEXT_FILTER_DESC);
            int n = smartFileChooser.showSaveDialog((Component)this);
            if (n == 0) {
                this.saveSelected(smartFileChooser.getSelectedFile());
            }
        } else if (string.equals(CMD_OPEN)) {
            try {
                SmartFileChooser smartFileChooser = new SmartFileChooser(this.currentFile, this.defaultDir);
                smartFileChooser.setAcceptAllFileFilterUsed(false);
                smartFileChooser.addExtFilter(MEMORY_SESSION_FILE_EXT, ToolkitResources.getString((String)"MEMORY_FILE_FILTER_DESC"));
                int n = smartFileChooser.showOpenDialog((Component)this);
                if (n == 0) {
                    this.readInputFile(smartFileChooser.getSelectedFile());
                    this.updateTitle();
                }
            }
            catch (Exception exception) {
                this.corruptedFile(exception);
            }
        } else if (string.equals(CMD_SAVE_AS)) {
            try {
                SmartFileChooser smartFileChooser = new SmartFileChooser(this.currentFile, this.defaultDir);
                smartFileChooser.setAcceptAllFileFilterUsed(false);
                smartFileChooser.addExtFilter(MEMORY_SESSION_FILE_EXT, ToolkitResources.getString((String)"MEMORY_FILE_FILTER_DESC"));
                int n = smartFileChooser.showSaveDialog((Component)this);
                if (n == 0) {
                    this.writeOutputFile(smartFileChooser.getSelectedFile());
                    this.currentFile = smartFileChooser.getSelectedFile();
                    this.updateTitle();
                }
            }
            catch (IOException iOException) {
                JOptionPane.showMessageDialog(this, ToolkitResources.getString((String)"SAVING_ERROR_MESSAGE") + this.currentFile, ToolkitResources.getString((String)"NETMON_ERROR_TITLE"), 0);
            }
        } else if (string.equals(CMD_CLOSE)) {
            this.dispose();
        }
    }

    void setSelectedItemsEnabled(boolean bl) {
        this.saveSelectedItem.setEnabled(bl);
        this.popupSelectedItem.setEnabled(bl);
    }

    JPopupMenu getTablePopup() {
        return this.tablePopup;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void saveSelected(File file) {
        int n;
        FileOutputStream fileOutputStream = null;
        ObjectsTable objectsTable = this.objsMonitor.getObjectsTable();
        fileOutputStream = new FileOutputStream(file);
        int[] nArray = objectsTable.getSelectedRows();
        for (n = 0; n < objectsTable.getColumnCount(); ++n) {
            String string = objectsTable.getColumnName(n);
            if (n < objectsTable.getColumnCount() - 1) {
                string = string.concat("\t");
            }
            fileOutputStream.write(string.getBytes());
        }
        fileOutputStream.write("\n".getBytes());
        for (n = nArray[0]; n <= nArray[nArray.length - 1]; ++n) {
            int n2 = objectsTable.getColumnCount();
            for (int i = 0; i < n2; ++i) {
                String string = objectsTable.getValueAt(n, i).toString();
                if (i < objectsTable.getColumnCount() - 1) {
                    string = string.concat("\t");
                }
                fileOutputStream.write(string.getBytes());
            }
            fileOutputStream.write("\n".getBytes());
        }
        Object var10_12 = null;
        if (fileOutputStream == null) return;
        try {
            fileOutputStream.close();
            return;
        }
        catch (IOException iOException) {
            debug.exception(1, (Throwable)iOException);
            Debug.warning((String)iOException.toString());
        }
        return;
        {
            catch (IOException iOException) {
                debug.exception(1, (Throwable)iOException);
                Debug.warning((String)iOException.toString());
                Object var10_13 = null;
                if (fileOutputStream == null) return;
                try {
                    fileOutputStream.close();
                    return;
                }
                catch (IOException iOException2) {
                    debug.exception(1, (Throwable)iOException2);
                    Debug.warning((String)iOException2.toString());
                }
                return;
            }
        }
        catch (Throwable throwable) {
            Object var10_14 = null;
            if (fileOutputStream == null) throw throwable;
            try {
                fileOutputStream.close();
                throw throwable;
            }
            catch (IOException iOException) {
                debug.exception(1, (Throwable)iOException);
                Debug.warning((String)iOException.toString());
            }
            throw throwable;
        }
    }

    public void setEmuTitle(String string) {
        this.deviceTitle = string;
        this.updateTitle();
    }

    private void updateTitle() {
        StringBuffer stringBuffer = new StringBuffer(ToolkitResources.getString((String)"MEMORY_EXT.NAME"));
        if (this.deviceTitle != null) {
            stringBuffer.append("-").append(this.deviceTitle);
        }
        if (this.currentFile != null) {
            stringBuffer.append(" [").append(this.currentFile.getName()).append("]");
        }
        stringBuffer.append(" - ").append(ToolkitResources.getString((String)"MONITOR_TITLE_SUFF"));
        this.setTitle(stringBuffer.toString());
    }

    public void init(final int n) {
        debug.println(1, "Heap Allocated: {0} bytes", n);
        this.heapSize = n;
        this.graph.setHeapSize(n);
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                ((MemoryMonitor)MemoryMonitor.this).totalFormatObjs[0] = Long.toString(n);
                MemoryMonitor.this.totalLabel.setText(MessageFormat.format(totalFormat, MemoryMonitor.this.totalFormatObjs));
            }
        });
    }

    public void allocateObject(int n, int n2, String string, int n3, int n4) {
        debug.println(1, "Object Allocated: class: {0}(id=0x{1})", (Object)string, (Object)Integer.toHexString(n2));
        debug.println(1, "                  thread: {0}", (Object)Integer.toHexString(n4));
        this.objsMonitor.allocateObject(n2, string, n3, n4);
        this.used += (long)n3;
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                if (MemoryMonitor.this.used > MemoryMonitor.this.maxUsed) {
                    MemoryMonitor.this.maxUsed = MemoryMonitor.this.used;
                    ((MemoryMonitor)MemoryMonitor.this).maxFormatObjs[0] = Long.toString(MemoryMonitor.this.maxUsed);
                    MemoryMonitor.this.maxLabel.setText(MessageFormat.format(maxFormat, MemoryMonitor.this.maxFormatObjs));
                }
                MemoryMonitor.this.objects++;
                ((MemoryMonitor)MemoryMonitor.this).objectsFormatObjs[0] = Long.toString(MemoryMonitor.this.objects);
                MemoryMonitor.this.objsLabel.setText(MessageFormat.format(objectsFormat, MemoryMonitor.this.objectsFormatObjs));
                ((MemoryMonitor)MemoryMonitor.this).usedFormatObjs[0] = Long.toString(MemoryMonitor.this.used);
                MemoryMonitor.this.usedLabel.setText(MessageFormat.format(usedFormat, MemoryMonitor.this.usedFormatObjs));
                MemoryMonitor.this.usedLabel2.setText(MessageFormat.format(currentFormat, MemoryMonitor.this.usedFormatObjs));
                ((MemoryMonitor)MemoryMonitor.this).freeFormatObjs[0] = Long.toString(MemoryMonitor.this.heapSize - MemoryMonitor.this.used);
                MemoryMonitor.this.freeLabel.setText(MessageFormat.format(freeFormat, MemoryMonitor.this.freeFormatObjs));
            }
        });
    }

    public void freeObject(int n, int n2, int n3) {
        debug.println(1, "Object Freed: class id = 0x{0}", (Object)Integer.toHexString(n2));
        this.objsMonitor.freeObject(n, n2, n3);
        this.used -= (long)n3;
        --this.objects;
        this.objectsFormatObjs[0] = Long.toString(this.objects);
        this.objsLabel.setText(MessageFormat.format(objectsFormat, this.objectsFormatObjs));
        this.usedFormatObjs[0] = Long.toString(this.used);
        this.usedLabel.setText(MessageFormat.format(usedFormat, this.usedFormatObjs));
        this.usedLabel2.setText(MessageFormat.format(currentFormat, this.usedFormatObjs));
        this.freeFormatObjs[0] = Long.toString(this.heapSize - this.used);
        this.freeLabel.setText(MessageFormat.format(freeFormat, this.freeFormatObjs));
    }

    public void enterMethod(int n, String string, int n2) {
        debug.println(1, "Entering Method: {0} (id=0x{1})", (Object)string, (Object)Integer.toHexString(n));
        debug.println(1, "\t\tThread 0x{0}", (Object)Integer.toHexString(n2));
        if (n2 == 0) {
            n2 = this.currentThread;
        } else {
            this.currentThread = n2;
        }
        this.objsMonitor.getAllocationTree().enter(n2, n, ObjectsMonitor.getReadableMethodName(string));
    }

    public void exitMethod(int n, int n2) {
        debug.println(1, "Exiting Method: id=0x{0}", (Object)Integer.toHexString(n));
        debug.println(1, "\t\tThread 0x{0}", (Object)Integer.toHexString(n2));
        if (n2 == 0) {
            n2 = this.currentThread;
        } else {
            this.currentThread = n2;
        }
        this.objsMonitor.getAllocationTree().exit(n2, n);
    }

    public long getUsed() {
        return this.used;
    }

    public void stop() {
        this.graph.stop();
        this.runGCAction.setEnabled(false);
        this.objsMonitor.getAllocationTree().setRefreshButtonDisable();
        this.openButton.setEnabled(true);
        this.openItem.setEnabled(true);
    }

    void writeOutputFile(File file) throws IOException {
        PrintWriter printWriter = new PrintWriter(new BufferedWriter(new FileWriter(file)));
        String string = this.objsLabel.getText();
        int n = string.indexOf(" ") + 1;
        printWriter.println(string.substring(n));
        string = this.usedLabel.getText();
        n = string.indexOf(" ") + 1;
        int n2 = string.indexOf(" ", n);
        printWriter.println(string.substring(n, n2));
        string = this.usedLabel2.getText();
        n = string.indexOf(" ") + 1;
        n2 = string.indexOf(" ", n);
        printWriter.println(string.substring(n, n2));
        string = this.freeLabel.getText();
        n = string.indexOf(" ") + 1;
        n2 = string.indexOf(" ", n);
        printWriter.println(string.substring(n, n2));
        string = this.totalLabel.getText();
        n = string.indexOf(" ") + 1;
        n2 = string.indexOf(" ", n);
        printWriter.println(string.substring(n, n2));
        string = this.maxLabel.getText();
        n = string.indexOf(" ") + 1;
        n2 = string.indexOf(" ", n);
        printWriter.println(string.substring(n, n2));
        printWriter.println();
        this.graph.writeAllTo(printWriter);
        this.objsMonitor.writeAllTo(printWriter);
        printWriter.close();
    }

    public void readInputFile(File file) throws IOException {
        this.currentFile = file;
        BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
        Object[] objectArray = new Object[]{bufferedReader.readLine()};
        this.objsLabel.setText(MessageFormat.format(objectsFormat, objectArray));
        objectArray[0] = bufferedReader.readLine();
        this.usedLabel.setText(MessageFormat.format(usedFormat, objectArray));
        objectArray[0] = bufferedReader.readLine();
        this.usedLabel2.setText(MessageFormat.format(currentFormat, objectArray));
        objectArray[0] = bufferedReader.readLine();
        this.freeLabel.setText(MessageFormat.format(freeFormat, objectArray));
        objectArray[0] = bufferedReader.readLine();
        this.totalLabel.setText(MessageFormat.format(totalFormat, objectArray));
        objectArray[0] = bufferedReader.readLine();
        this.maxLabel.setText(MessageFormat.format(maxFormat, objectArray));
        bufferedReader.readLine();
        this.graph.readAllFrom(bufferedReader);
        this.objsMonitor = new ObjectsMonitor(this, true);
        this.addItemsToViewMenu();
        if (this.tabbedPane.getTabCount() == 2) {
            this.tabbedPane.removeTabAt(1);
        }
        this.tabbedPane.addTab(ToolkitResources.getString((String)"MEMORY_EXT.OBJECTS_TAB"), this.objsMonitor);
        this.objsMonitor.readAllFrom(bufferedReader);
        this.runGCAction.setEnabled(false);
        this.openButton.setEnabled(true);
        this.openItem.setEnabled(true);
        this.saveButton.setEnabled(false);
        this.saveItem.setEnabled(false);
        this.saveAsItem.setEnabled(false);
        bufferedReader.close();
        this.setTitle(ToolkitResources.getString((String)"MEMORY_EXT.NAME") + " [" + file.getName() + "] - " + ToolkitResources.getString((String)"MONITOR_TITLE_SUFF"));
        this.setVisible(true);
    }

    static {
        MEMORY_SESSION_FILE_EXT = ToolkitResources.getString((String)"MEMORY_EXT.SESSION_FILE_EXT");
    }

    private static class RunGCAction
    extends AbstractAction {
        public RunGCAction() {
            this.putValue("Name", ToolkitResources.getString((String)"MEMORY_EXT.RUN_GC"));
            this.putValue("ShortDescription", ToolkitResources.getString((String)"MEMORY_EXT.RUN_GC_DESCRIPTION"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            EventBridge.injectEvent(-1000, 0, 0, 0);
        }
    }
}

