/*
 * Decompiled with CFR 0.152.
 */
package com.sun.kvem.memorymon;

import com.sun.kvem.Screen;
import com.sun.kvem.memorymon.MemoryMonitor;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import javax.swing.SwingUtilities;

public class MemoryListener
extends Thread {
    private static MemoryListener instance = new MemoryListener();
    private static final int INIT = 0;
    private static final int ALLOCATE_OBJECT = 1;
    private static final int FREE_OBJECT = 2;
    private static final int ENTER_METHOD = 3;
    private static final int EXIT_METHOD = 4;
    private MemoryMonitor monitor;
    private ServerSocket serverSocket = null;
    private Socket clientSocket = null;
    private DataInputStream in = null;
    private String deviceTitle = null;
    private boolean done = false;

    public int getLocalPort() {
        return this.serverSocket.getLocalPort();
    }

    public void run() {
        try {
            this.monitor = new MemoryMonitor();
        }
        catch (Exception exception) {
            System.err.println("Failed to open Memory Monitor");
        }
        this.monitor.setVisible(true);
        SwingUtilities.windowForComponent(Screen.getInstance().getComponent()).toFront();
        try {
            this.clientSocket = this.serverSocket.accept();
            this.in = new DataInputStream(new BufferedInputStream(this.clientSocket.getInputStream()));
            byte[] byArray = new byte[512];
            String string = null;
            String string2 = null;
            block11: while (!this.done) {
                int n = this.in.readInt();
                switch (n) {
                    case 0: {
                        int n2 = this.in.readInt();
                        this.monitor.init(n2);
                        this.monitor.setEmuTitle(this.deviceTitle);
                        continue block11;
                    }
                    case 1: {
                        int n3;
                        int n4 = this.in.readInt();
                        int n5 = this.in.readInt();
                        int n6 = this.in.readInt();
                        for (n3 = 0; n3 < n6; n3 += this.in.read(byArray, n3, n6 - n3)) {
                        }
                        string = new String(byArray, 0, n6, "UTF8");
                        int n7 = this.in.readInt();
                        int n8 = this.in.readInt();
                        this.monitor.allocateObject(n4, n5, string, n7, n8);
                        continue block11;
                    }
                    case 2: {
                        int n4 = this.in.readInt();
                        int n5 = this.in.readInt();
                        int n7 = this.in.readInt();
                        this.monitor.freeObject(n4, n5, n7);
                        continue block11;
                    }
                    case 3: {
                        int n3;
                        int n9 = this.in.readInt();
                        int n6 = this.in.readInt();
                        for (n3 = 0; n3 < n6; n3 += this.in.read(byArray, n3, n6 - n3)) {
                        }
                        string2 = new String(byArray, 0, n6, "UTF8");
                        int n8 = this.in.readInt();
                        this.monitor.enterMethod(n9, string2, n8);
                        continue block11;
                    }
                    case 4: {
                        int n9 = this.in.readInt();
                        int n8 = this.in.readInt();
                        this.monitor.exitMethod(n9, n8);
                        continue block11;
                    }
                }
                System.err.println("ERROR: Memory Monitor reads command " + n);
            }
        }
        catch (IOException iOException) {
            MemoryListener.stopListening();
        }
    }

    public static void setAssociatedEmuTitle(String string) {
        MemoryListener.instance.deviceTitle = string;
    }

    public static int startListening() {
        if (instance.isAlive()) {
            throw new IllegalStateException();
        }
        try {
            MemoryListener.instance.serverSocket = new ServerSocket(0);
            instance.start();
            return instance.getLocalPort();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return -1;
        }
    }

    public static void stopListening() {
        if (instance.isAlive()) {
            MemoryListener.instance.done = true;
            MemoryListener.instance.monitor.stop();
            try {
                MemoryListener.instance.in.close();
                MemoryListener.instance.clientSocket.close();
                MemoryListener.instance.serverSocket.close();
            }
            catch (IOException iOException) {
                System.err.println("Failed to close sockets");
            }
        }
    }
}

