/*
 * Decompiled with CFR 0.152.
 */
package com.sun.kvem.memorymon;

import com.sun.kvem.memorymon.MemoryMonitor;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Stroke;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.StringTokenizer;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.JPanel;

class Graph
extends JPanel {
    MemoryMonitor monitor;
    Dimension size;
    private long[] history;
    private int index;
    private long hwm;
    private long heapSize;
    private Timer timer;
    private static final int HISTORY_LENGTH = 200;
    private static final int UPDATE_PERIOD = 1000;
    private static final String DELIM = " ";

    public Graph(MemoryMonitor memoryMonitor) {
        this.monitor = memoryMonitor;
        this.history = new long[200];
        this.index = 0;
        this.hwm = 0L;
        this.size = new Dimension(this.history.length * 2, (int)((double)this.history.length * 1.5));
        this.setSize(this.size);
        this.setBackground(Color.black);
        this.timer = new Timer();
        this.timer.schedule((TimerTask)new GraphTimerTask(), 0L, 1000L);
    }

    public void setHeapSize(long l) {
        this.heapSize = l;
    }

    public Dimension getPreferredSize() {
        return (Dimension)this.size.clone();
    }

    public Dimension getMaximumSize() {
        return (Dimension)this.size.clone();
    }

    public Dimension getMinimumSize() {
        return (Dimension)this.size.clone();
    }

    public void paint(Graphics graphics) {
        super.paint(graphics);
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setColor(Color.darkGray);
        graphics2D.fillRect(0, (int)((double)this.size.height * 0.25), this.size.width, 1);
        graphics2D.fillRect(0, (int)((double)this.size.height * 0.5), this.size.width, 1);
        graphics2D.fillRect(0, (int)((double)this.size.height * 0.75), this.size.width, 1);
        if (this.heapSize > 0L) {
            int n;
            int n2;
            int n3;
            graphics2D.setColor(Color.red);
            int n4 = (int)((long)this.size.height - (long)this.size.height * this.hwm / this.heapSize);
            Stroke stroke = graphics2D.getStroke();
            float[] fArray = new float[]{10.0f};
            BasicStroke basicStroke = new BasicStroke(1.0f, 2, 0, 10.0f, fArray, 0.0f);
            graphics2D.setStroke(basicStroke);
            graphics2D.drawLine(0, n4, this.size.width, n4);
            graphics2D.setStroke(stroke);
            int n5 = 0;
            int n6 = this.size.height;
            graphics2D.setColor(Color.green);
            for (n3 = this.index + 1; n3 < this.history.length; ++n3) {
                n2 = (n3 - this.index) * 2;
                n = (int)((long)this.size.height - (long)this.size.height * this.history[n3] / this.heapSize);
                graphics2D.drawLine(n5, n6, n2, n);
                n5 = n2;
                n6 = n;
            }
            for (n3 = 0; n3 <= this.index; ++n3) {
                n2 = (n3 + (this.history.length - this.index)) * 2;
                n = (int)((long)this.size.height - (long)this.size.height * this.history[n3] / this.heapSize);
                graphics2D.drawLine(n5, n6, n2, n);
                n5 = n2;
                n6 = n;
            }
        }
    }

    public void stop() {
        this.timer.cancel();
    }

    void updateData() {
        long l = this.monitor.getUsed();
        this.hwm = Math.max(l, this.hwm);
        this.index = (this.index + 1) % this.history.length;
        this.history[this.index] = l;
        this.repaint();
    }

    void writeAllTo(PrintWriter printWriter) {
        int n;
        printWriter.print(this.history.length);
        printWriter.print(DELIM + this.heapSize);
        printWriter.print(DELIM + this.hwm);
        for (n = this.index; n < this.history.length; ++n) {
            printWriter.print(DELIM + this.history[n]);
        }
        for (n = 0; n < this.index; ++n) {
            printWriter.print(DELIM + this.history[n]);
        }
        printWriter.println();
    }

    void readAllFrom(BufferedReader bufferedReader) throws IOException {
        this.stop();
        String string = bufferedReader.readLine();
        StringTokenizer stringTokenizer = new StringTokenizer(string, DELIM);
        int n = Integer.parseInt(stringTokenizer.nextToken());
        this.history = new long[n];
        this.setHeapSize(Long.parseLong(stringTokenizer.nextToken()));
        this.hwm = Integer.parseInt(stringTokenizer.nextToken());
        this.index = n - 1;
        for (int i = 0; i < n; ++i) {
            this.history[i] = Long.parseLong(stringTokenizer.nextToken());
        }
        this.updateData();
    }

    private class GraphTimerTask
    extends TimerTask {
        private GraphTimerTask() {
        }

        public void run() {
            Graph.this.updateData();
        }
    }
}

