/*
 * Decompiled with CFR 0.152.
 */
package com.sun.kvem.memorymon;

import com.sun.kvem.environment.Debug;
import com.sun.kvem.memorymon.MyRenderer;
import com.sun.kvem.memorymon.MyTreeModel;
import com.sun.kvem.memorymon.MyTreeNode;
import com.sun.kvem.memorymon.ObjectNode;
import com.sun.kvem.memorymon.Thread;
import com.sun.kvem.util.FindDialog;
import com.sun.kvem.util.FinderListener;
import com.sun.kvem.util.ToolkitResources;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class AllocationTree
extends JPanel
implements ActionListener {
    private static final Debug debug = Debug.create((Class)AllocationTree.class);
    Map threadToRow = new HashMap();
    JTree tree;
    JLabel objLabel = new JLabel(" ");
    int passesCounter = 0;
    private ObjectNode currentNode;
    private FindDialog findDialog;
    private JButton refreshButton;
    public static final String CMD_FIND = "find";
    public static final String CMD_REFRESH = "refresh";

    public AllocationTree(boolean bl) {
        this();
        if (bl) {
            this.refreshButton.setEnabled(false);
        }
    }

    public AllocationTree() {
        super(new BorderLayout());
        MyTreeNode myTreeNode = new MyTreeNode(0, ToolkitResources.getString((String)"MEMORY_EXT.ROOT"));
        this.tree = new JTree(new MyTreeModel(myTreeNode));
        this.tree.setCellRenderer(new MyRenderer());
        this.tree.setRootVisible(false);
        this.tree.getSelectionModel().setSelectionMode(1);
        this.enter(0, 0, ToolkitResources.getString((String)"MEMORY_EXT.INTERNAL_METHOD"));
        this.refreshButton = new JButton(ToolkitResources.getString((String)"MEMORY_EXT.REFRESH"));
        this.refreshButton.setMnemonic(ToolkitResources.getString((String)"MEMORY_EXT.REFRESH_SHORTCUT").charAt(0));
        this.refreshButton.setToolTipText(ToolkitResources.getString((String)"MEMORY_EXT.REFRESH_HELP"));
        this.refreshButton.setActionCommand(CMD_REFRESH);
        this.refreshButton.addActionListener(this);
    }

    public void setRefreshButtonDisable() {
        this.refreshButton.setEnabled(false);
    }

    public void setRatio(MyTreeNode myTreeNode) {
        MyTreeNode myTreeNode2 = (MyTreeNode)myTreeNode.getParent();
        myTreeNode.ratio = myTreeNode2 == null ? 1.0f : myTreeNode2.ratio * (float)myTreeNode.count / (float)myTreeNode2.count;
        MyTreeModel myTreeModel = (MyTreeModel)this.tree.getModel();
        int n = myTreeModel.getChildCount(myTreeNode);
        for (int i = 0; i < n; ++i) {
            this.setRatio((MyTreeNode)myTreeModel.getChild(myTreeNode, i));
        }
    }

    public MyTreeNode getCurrentMethodNode(int n) {
        Integer n2 = new Integer(n);
        Thread thread = (Thread)this.threadToRow.get(n2);
        return thread.getCurrent();
    }

    public void enter(int n, int n2, String string) {
        Integer n3 = new Integer(n);
        Thread thread = (Thread)this.threadToRow.get(n3);
        if (thread != null) {
            MyTreeNode myTreeNode = thread.getChild(n2);
            if (myTreeNode == null) {
                myTreeNode = new MyTreeNode(n2, string);
                thread.getCurrent().add(myTreeNode);
            }
            thread.setCurrent(myTreeNode);
        } else {
            MyTreeNode myTreeNode = new MyTreeNode(n2, string);
            thread = new Thread(myTreeNode);
            ((MyTreeNode)this.tree.getModel().getRoot()).add(myTreeNode);
            this.threadToRow.put(n3, thread);
        }
    }

    public void exit(int n, int n2) {
        Integer n3 = new Integer(n);
        Thread thread = (Thread)this.threadToRow.get(n3);
        if (thread == null) {
            debug.println(1, "Error: could not find matching row for ID {0}, method {1}", n, n2);
        } else {
            MyTreeNode myTreeNode = (MyTreeNode)thread.getCurrent().getParent();
            thread.setCurrent(myTreeNode);
        }
    }

    public void viewObjectMethods(ObjectNode objectNode) {
        Serializable serializable;
        this.currentNode = objectNode;
        ++this.passesCounter;
        ++((MyTreeModel)this.tree.getModel()).passesCounter;
        Iterator iterator = objectNode.methods.keySet().iterator();
        while (iterator.hasNext()) {
            serializable = (MyTreeNode)iterator.next();
            this.markPathTo((MyTreeNode)serializable, (Integer)objectNode.methods.get(serializable));
            serializable.allocating = this.passesCounter;
        }
        this.setRatio((MyTreeNode)this.tree.getModel().getRoot());
        if (this.passesCounter == 1) {
            this.add((Component)this.objLabel, "North");
            serializable = new JScrollPane(this.tree);
            this.objLabel.setLabelFor((Component)serializable);
            this.add((Component)serializable, "Center");
            JPanel jPanel = new JPanel();
            jPanel.add(Box.createHorizontalGlue());
            JButton jButton = new JButton(ToolkitResources.getString((String)"FIND"));
            jButton.setMnemonic(ToolkitResources.getString((String)"FIND_SHORTCUT").charAt(0));
            jButton.setToolTipText(ToolkitResources.getString((String)"MEMORY_EXT.FIND_HELP"));
            jButton.setActionCommand(CMD_FIND);
            jButton.addActionListener(this);
            jPanel.add(jButton);
            jPanel.add(this.refreshButton);
            jPanel.add(Box.createHorizontalGlue());
            this.add((Component)jPanel, "South");
        }
        this.objLabel.setText(ToolkitResources.getString((String)"MEMORY_EXT.CLASS_NAME_LABEL") + ": " + objectNode.getClassName());
        ((MyTreeModel)this.tree.getModel()).update();
    }

    private void markPathTo(MyTreeNode myTreeNode, int n) {
        while (myTreeNode != null) {
            if (myTreeNode.pass == this.passesCounter) {
                myTreeNode.count += n;
            } else {
                myTreeNode.count = n;
                myTreeNode.pass = this.passesCounter;
            }
            myTreeNode = (MyTreeNode)myTreeNode.getParent();
        }
    }

    private void findNextNode(String string, boolean bl, boolean bl2) {
        Object object;
        MyTreeNode myTreeNode = (MyTreeNode)this.tree.getLastSelectedPathComponent();
        myTreeNode = ((MyTreeModel)this.tree.getModel()).getNextMatchingNode(myTreeNode, string, bl);
        if (myTreeNode == null && bl2) {
            object = (MyTreeModel)this.tree.getModel();
            myTreeNode = ((MyTreeModel)object).getNextMatchingNode((MyTreeNode)((MyTreeModel)object).getRoot(), string, bl);
        }
        if (myTreeNode == null) {
            this.findDialog.showNotFoundMessageDialog();
            this.findDialog.requestTextFocus();
        } else {
            object = new TreePath(myTreeNode.getPath());
            this.tree.setSelectionPath((TreePath)object);
            this.tree.scrollPathToVisible((TreePath)object);
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals(CMD_FIND)) {
            if (this.findDialog == null) {
                this.findDialog = new FindDialog((JFrame)SwingUtilities.getAncestorOfClass(JFrame.class, this));
                this.findDialog.setFinderListener(new FinderListener(){

                    public void find(String string, boolean bl, boolean bl2) {
                        AllocationTree.this.findNextNode(string, bl, bl2);
                    }
                });
            }
            this.findDialog.showDialog();
        } else if (string.equals(CMD_REFRESH)) {
            MyTreeNode myTreeNode = (MyTreeNode)this.tree.getLastSelectedPathComponent();
            this.viewObjectMethods(this.currentNode);
            if (myTreeNode != null) {
                TreePath treePath = new TreePath(myTreeNode.getPath());
                this.tree.setSelectionPath(treePath);
                this.tree.scrollPathToVisible(treePath);
            }
        }
    }

    public void dispose() {
        if (this.findDialog != null) {
            this.findDialog.dispose();
        }
    }

    public void writeAllTo(PrintWriter printWriter) {
        Enumeration<TreeNode> enumeration = ((DefaultMutableTreeNode)this.tree.getModel().getRoot()).preorderEnumeration();
        while (enumeration.hasMoreElements()) {
            MyTreeNode myTreeNode = (MyTreeNode)enumeration.nextElement();
            printWriter.print("" + myTreeNode.hashCode() + "\t" + myTreeNode.methodName);
            MyTreeNode myTreeNode2 = (MyTreeNode)myTreeNode.getParent();
            if (myTreeNode2 == null) {
                printWriter.println("\t-1");
                continue;
            }
            printWriter.println("\t" + myTreeNode2.hashCode());
        }
    }

    public Map readAllFrom(BufferedReader bufferedReader) throws IOException {
        String string;
        HashMap<Integer, MyTreeNode> hashMap = new HashMap<Integer, MyTreeNode>();
        MyTreeNode myTreeNode = null;
        while (!(string = bufferedReader.readLine()).equals("")) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, "\t");
            int n = Integer.parseInt(stringTokenizer.nextToken());
            String string2 = stringTokenizer.nextToken();
            int n2 = Integer.parseInt(stringTokenizer.nextToken());
            MyTreeNode myTreeNode2 = new MyTreeNode(n, string2);
            hashMap.put(new Integer(n), myTreeNode2);
            if (n2 == -1) {
                myTreeNode = myTreeNode2;
                continue;
            }
            MyTreeNode myTreeNode3 = (MyTreeNode)hashMap.get(new Integer(n2));
            myTreeNode3.add(myTreeNode2);
        }
        this.tree.setModel(new MyTreeModel(myTreeNode));
        return hashMap;
    }
}

