/*
 * Decompiled with CFR 0.152.
 */
package com.sun.kvem.jsr082.obex;

import com.sun.kvem.jsr082.obex.HeaderSetImpl;
import com.sun.kvem.jsr082.obex.ServerConnectionImpl;
import com.sun.kvem.obex.HeaderSet;
import com.sun.kvem.obex.Operation;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

final class ServerOperation
implements Operation {
    private static final boolean DEBUG = false;
    private Object lock = new Object();
    private HeaderSetImpl recvHeaders;
    private ServerConnectionImpl stream;
    private int opcode;
    private boolean isGet;
    private boolean isAborted;
    private boolean requestEnd;
    private boolean inputStreamEof;
    private boolean inputStreamOpened;
    private boolean inputStreamClosed;
    private boolean outputStreamOpened;
    private boolean outputStreamClosed;
    private OperationInputStream is = new OperationInputStream();
    private OperationOutputStream os = new OperationOutputStream();
    private byte[] head = new byte[]{-112, 0, 0};
    private int openObjects = 1;

    ServerOperation(ServerConnectionImpl serverConnectionImpl) throws IOException {
        this.stream = serverConnectionImpl;
        this.opcode = 3;
        this.isGet = true;
        this.recvHeaders = new HeaderSetImpl(1);
        int n = ServerOperation.waitForData(serverConnectionImpl, this.recvHeaders, 3);
        switch (n) {
            case 0: {
                this.isAborted = true;
                serverConnectionImpl.operationClosed = true;
                break;
            }
            case 2: {
                this.requestEnd = true;
                this.inputStreamEof = true;
                serverConnectionImpl.packetBegin(this.head);
                serverConnectionImpl.packetAddConnectionID(serverConnectionImpl.getConnectionID(), null);
                serverConnectionImpl.packetAddAuthResponses();
                serverConnectionImpl.packetAddHeaders(null);
            }
        }
    }

    ServerOperation(ServerConnectionImpl serverConnectionImpl, HeaderSetImpl headerSetImpl) {
        this.stream = serverConnectionImpl;
        this.opcode = 2;
        this.isGet = false;
        this.recvHeaders = headerSetImpl;
    }

    public DataOutputStream openDataOutputStream() throws IOException {
        return new DataOutputStream(this.openOutputStream());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OutputStream openOutputStream() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.stream.operationClosed) {
                throw new IOException("operation closed");
            }
            if (this.outputStreamOpened) {
                throw new IOException("no more output streams available");
            }
            if (!this.requestEnd) {
                throw new IOException("input data not read out");
            }
            this.outputStreamOpened = true;
            ++this.openObjects;
            return this.os;
        }
    }

    public DataInputStream openDataInputStream() throws IOException {
        return new DataInputStream(this.openInputStream());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InputStream openInputStream() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.stream.operationClosed) {
                throw new IOException("operation closed");
            }
            if (this.inputStreamOpened) {
                throw new IOException("no more input streams available");
            }
            this.inputStreamOpened = true;
            ++this.openObjects;
            return this.is;
        }
    }

    public void abort() throws IOException {
        throw new IOException("not permitted");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HeaderSet getReceivedHeaders() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.stream.operationClosed) {
                throw new IOException("operation closed");
            }
            return new HeaderSetImpl(this.recvHeaders);
        }
    }

    public int getResponseCode() throws IOException {
        throw new IOException("not permitted");
    }

    public String getEncoding() {
        return null;
    }

    public long getLength() {
        Long l = (Long)this.recvHeaders.getHeader(195);
        if (l == null) {
            return -1L;
        }
        return l;
    }

    public String getType() {
        return (String)this.recvHeaders.getHeader(66);
    }

    public void close() {
        this.stream.operationClosed = true;
    }

    void destroy(int n) {
        try {
            this.outputStreamClosed = true;
            if (!this.requestEnd) {
                this.stream.packetBegin(this.head);
                this.stream.packetAddConnectionID(this.stream.getConnectionID(), null);
                this.stream.packetAddAuthResponses();
            }
            this.stream.packetAddHeaders(null);
            this.close();
            if (this.isAborted) {
                n = 160;
            }
            this.stream.setPacketType(n);
            this.stream.packetEnd();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.stream.queuedHeaders.removeAllElements();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendHeaders(HeaderSet headerSet) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.stream.operationClosed) {
                throw new IOException("operation closed");
            }
            if (headerSet == null) {
                throw new NullPointerException("null headerset");
            }
            if (!(headerSet instanceof HeaderSetImpl)) {
                throw new IllegalArgumentException("wrong headerset class");
            }
            HeaderSetImpl headerSetImpl = (HeaderSetImpl)headerSet;
            if (!headerSetImpl.isSendable()) {
                throw new IllegalArgumentException("not created with createHeaderSet");
            }
            this.stream.packetAddHeaders(headerSetImpl);
            if (this.requestEnd && this.isGet) {
                while (!this.stream.queuedHeaders.isEmpty()) {
                    this.packetExchange();
                }
            }
        }
    }

    private void packetExchange() throws IOException {
        if (this.stream.operationHeadersOverflow) {
            throw new IOException("operation terminated, too long headers");
        }
        if (!this.requestEnd) {
            boolean bl = this.requestEnd = this.stream.packetType == (this.opcode | 0x80);
            if (this.stream.isEof && !this.requestEnd) {
                while (this.recvHeaders.packetType == 2) {
                    this.stream.sendPacket(this.head, this.stream.getConnectionID(), null, false);
                    this.stream.recvPacket();
                    this.stream.parsePacketHeaders(this.recvHeaders, 3);
                }
                if (this.recvHeaders.packetType == 255) {
                    this.stream.operationClosed = true;
                    this.isAborted = true;
                    throw new IOException("operation aborted");
                }
                if (this.stream.packetType != (this.opcode | 0x80)) {
                    this.stream.operationClosed = true;
                    this.stream.brokenLink();
                    throw new IOException("protocol error");
                }
            }
            if (this.requestEnd) {
                this.stream.packetBegin(this.head);
                this.stream.packetAddConnectionID(this.stream.getConnectionID(), null);
                this.stream.packetAddAuthResponses();
                this.stream.packetAddHeaders(null);
                return;
            }
            this.stream.sendPacket(ServerConnectionImpl.PACKET_CONTINUE, this.stream.getConnectionID(), null, false);
            this.stream.recvPacket();
            if (this.stream.packetType == 255) {
                this.stream.parsePacketHeaders(this.recvHeaders, 3);
                this.isAborted = true;
                this.stream.operationClosed = true;
                throw new IOException("operation aborted");
            }
            if ((this.stream.packetType & ~128) != this.opcode) {
                this.stream.operationClosed = true;
                this.stream.brokenLink();
                throw new IOException("protocol error");
            }
            this.stream.parsePacketDataBegin(this.recvHeaders, 3);
            return;
        }
        this.stream.packetEnd();
        this.stream.recvPacket();
        this.stream.parsePacketHeaders(this.recvHeaders, 3);
        if (this.stream.packetType == 255) {
            this.isAborted = true;
            this.stream.operationClosed = true;
            throw new IOException("operation aborted");
        }
        if (this.stream.packetType != (this.opcode | 0x80)) {
            this.stream.operationClosed = true;
            this.stream.brokenLink();
            throw new IOException("protocol error");
        }
        this.stream.packetBegin(this.head);
        this.stream.packetAddConnectionID(this.stream.getConnectionID(), null);
        this.stream.packetAddAuthResponses();
        this.stream.packetAddHeaders(null);
    }

    static int waitForData(ServerConnectionImpl serverConnectionImpl, HeaderSetImpl headerSetImpl, int n) throws IOException {
        serverConnectionImpl.parsePacketDataBegin(headerSetImpl, 3);
        int n2 = serverConnectionImpl.parsePacketData(headerSetImpl, null, 0, 0);
        while (true) {
            if (serverConnectionImpl.packetType == 255) {
                return 0;
            }
            if (n2 == 1 || serverConnectionImpl.isEof) {
                return 1;
            }
            if (serverConnectionImpl.packetType == (n | 0x80)) {
                return 2;
            }
            if (serverConnectionImpl.packetType != n) {
                serverConnectionImpl.brokenLink();
                throw new IOException("protocol error");
            }
            serverConnectionImpl.sendPacket(ServerConnectionImpl.PACKET_CONTINUE, serverConnectionImpl.getConnectionID(), null, false);
            serverConnectionImpl.recvPacket();
            serverConnectionImpl.parsePacketDataBegin(headerSetImpl, 3);
            n2 = serverConnectionImpl.parsePacketData(headerSetImpl, null, 0, 0);
        }
    }

    private class OperationOutputStream
    extends OutputStream {
        OperationOutputStream() {
        }

        public void write(int n) throws IOException {
            this.write(new byte[]{(byte)n}, 0, 1);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void write(byte[] byArray, int n, int n2) throws IOException {
            Object object = ServerOperation.this.lock;
            synchronized (object) {
                if (ServerOperation.this.outputStreamClosed) {
                    throw new IOException("operation finished");
                }
                if (n2 < 0 || n < 0 || n + n2 > byArray.length) {
                    throw new ArrayIndexOutOfBoundsException();
                }
                while (n2 > 0) {
                    int n3 = ServerOperation.this.stream.packetAddData(byArray, n, n2);
                    if (n3 != n2) {
                        ServerOperation.this.packetExchange();
                    }
                    n2 -= n3;
                    n += n3;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void flush() throws IOException {
            Object object = ServerOperation.this.lock;
            synchronized (object) {
                if (ServerOperation.this.outputStreamClosed) {
                    throw new IOException("operation finished");
                }
                ServerOperation.this.packetExchange();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close() throws IOException {
            Object object = ServerOperation.this.lock;
            synchronized (object) {
                boolean bl;
                if (ServerOperation.this.outputStreamClosed) {
                    return;
                }
                ServerOperation.this.outputStreamClosed = true;
                if (ServerOperation.this.outputStreamOpened && !(bl = ServerOperation.this.stream.packetEOFBody())) {
                    ServerOperation.this.packetExchange();
                    ServerOperation.this.stream.packetEOFBody();
                }
            }
        }
    }

    private class OperationInputStream
    extends InputStream {
        OperationInputStream() {
        }

        public int read() throws IOException {
            byte[] byArray = new byte[1];
            int n = this.read(byArray, 0, 1);
            if (n == -1) {
                return -1;
            }
            return byArray[0] & 0xFF;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int read(byte[] byArray, int n, int n2) throws IOException {
            Object object = ServerOperation.this.lock;
            synchronized (object) {
                if (ServerOperation.this.inputStreamClosed) {
                    throw new IOException("operation finished");
                }
                if (n2 < 0 || n < 0 || n + n2 > byArray.length) {
                    throw new ArrayIndexOutOfBoundsException();
                }
                if (n2 == 0) {
                    return 0;
                }
                if (ServerOperation.this.inputStreamEof) {
                    return -1;
                }
                int n3 = 0;
                do {
                    int n4;
                    if ((n4 = ServerOperation.this.stream.parsePacketData(ServerOperation.this.recvHeaders, byArray, n, n2)) != 0) {
                        n += n4;
                        n3 += n4;
                        if ((n2 -= n4) == 0) {
                            return n3;
                        }
                    }
                    ServerOperation.this.packetExchange();
                } while (!((ServerOperation)ServerOperation.this).stream.isEof);
                ServerOperation.this.inputStreamEof = true;
                return n3 == 0 ? -1 : n3;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close() throws IOException {
            Object object = ServerOperation.this.lock;
            synchronized (object) {
                ServerOperation.this.inputStreamClosed = true;
                ServerOperation.this.inputStreamEof = false;
            }
        }
    }
}

